/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.appledouble;

import com.documentum.fc.impl.util.appledouble.DfEntryDescriptor;
import glguerin.io.MacRoman;
import java.awt.Point;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DfFinderInfo {
    private int m_fileType;
    private int m_creator;
    private short m_flags = 0;
    private Point m_location = new Point(0, 0);
    private short m_folder = 0;

    public DfFinderInfo() {
    }

    public DfFinderInfo(RandomAccessFile raf, DfEntryDescriptor descriptor) throws IOException {
        raf.seek(0L);
        raf.seek(descriptor.getOffset());
        this.m_fileType = raf.readInt();
        this.m_creator = raf.readInt();
        this.m_flags = raf.readShort();
        this.m_location = new Point(raf.readShort(), raf.readShort());
        this.m_folder = raf.readShort();
    }

    public void write(RandomAccessFile raf) throws IOException {
        raf.writeInt(this.m_fileType);
        raf.writeInt(this.m_creator);
        raf.writeShort(this.m_flags);
        raf.writeShort(this.m_location.x);
        raf.writeShort(this.m_location.y);
        raf.writeShort(this.m_folder);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.m_fileType);
        dos.writeInt(this.m_creator);
        dos.writeShort(this.m_flags);
        dos.writeShort(this.m_location.x);
        dos.writeShort(this.m_location.y);
        dos.writeShort(this.m_folder);
    }

    public String getOSFileTypeString() {
        if (this.m_fileType == 0) {
            return "????";
        }
        return MacRoman.getOSTypeString((int)this.m_fileType);
    }

    public int getFileType() {
        return this.m_fileType;
    }

    public void setFileType(String type) {
        if (type == null) {
            type = "????";
        }
        this.m_fileType = DfFinderInfo.getMacRoman(type);
    }

    public void setFileType(int type) {
        this.m_fileType = type;
    }

    public String getOSCreatorString() {
        if (this.m_creator == 0) {
            return "????";
        }
        return MacRoman.getOSTypeString((int)this.m_creator);
    }

    public int getCreator() {
        return this.m_creator;
    }

    public void setCreator(String type) {
        if (type == null) {
            type = "????";
        }
        this.m_creator = DfFinderInfo.getMacRoman(type);
    }

    public void setCreator(int type) {
        this.m_creator = type;
    }

    public short getFlags() {
        return this.m_flags;
    }

    public void setFlags(short f) {
        this.m_flags = f;
    }

    public Point getLocation() {
        return this.m_location;
    }

    public void setLocation(Point location) {
        this.m_location = location;
    }

    public short getFolder() {
        return this.m_folder;
    }

    public void setFolder(short s) {
        this.m_folder = s;
    }

    public static int getMacRoman(String type) {
        byte[] bytes = type.getBytes();
        byte[] abyte0 = new byte[4];
        int i = type.length();
        if (i > 0) {
            if (i > 4) {
                i = 4;
            }
            type.getBytes(0, i, abyte0, 4 - i);
        }
        return DfFinderInfo.bytesToInt(abyte0);
    }

    private static int bytesToInt(byte[] abyte0) {
        int i = 0;
        int j = abyte0.length;
        if (j > 4) {
            j = 4;
        }
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                i <<= 8;
            }
            i |= abyte0[k] & 0xFF;
        }
        return i;
    }
}

