/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.appledouble;

import com.documentum.fc.impl.util.appledouble.DfEntryDescriptor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DfAppleDoubleHeaderData {
    private int m_magicNumber;
    private int m_version;
    private int[] m_filler;
    private DfEntryDescriptor[] m_descriptors;
    private boolean m_OS9;

    DfAppleDoubleHeaderData(boolean os9) {
        int offset;
        this.m_OS9 = os9;
        this.m_magicNumber = 333319;
        this.m_version = 131072;
        this.m_filler = new int[4];
        for (int i = 0; i < this.m_filler.length; ++i) {
            this.m_filler[i] = 0;
        }
        if (this.m_OS9) {
            this.m_descriptors = new DfEntryDescriptor[6];
            offset = 26 + 12 * this.m_descriptors.length;
            this.m_descriptors[0] = new DfEntryDescriptor(3, offset, 32);
            this.m_descriptors[1] = new DfEntryDescriptor(4, offset += 32, 201);
            offset += 201;
            this.m_descriptors[2] = new DfEntryDescriptor(8, ++offset, 16);
            this.m_descriptors[3] = new DfEntryDescriptor(9, offset += 16, 32);
            this.m_descriptors[4] = new DfEntryDescriptor(10, offset += 32, 4);
            this.m_descriptors[5] = new DfEntryDescriptor(2, offset += 4, 0);
        } else {
            this.m_descriptors = new DfEntryDescriptor[2];
            offset = 26 + 12 * this.m_descriptors.length;
            this.m_descriptors[0] = new DfEntryDescriptor(9, offset, 32);
            this.m_descriptors[1] = new DfEntryDescriptor(2, offset += 32, 0);
        }
    }

    DfAppleDoubleHeaderData(RandomAccessFile raf) throws IOException {
        this.m_magicNumber = raf.readInt();
        this.m_version = raf.readInt();
        this.m_filler = new int[4];
        for (int i = 0; i < this.m_filler.length; ++i) {
            this.m_filler[i] = raf.readInt();
        }
        int numberOfEntries = raf.readShort();
        this.m_descriptors = new DfEntryDescriptor[numberOfEntries];
        for (int i = 0; i < numberOfEntries; ++i) {
            this.m_descriptors[i] = new DfEntryDescriptor(raf);
        }
    }

    public void write(RandomAccessFile raf) throws IOException {
        int i;
        raf.writeInt(this.m_magicNumber);
        raf.writeInt(this.m_version);
        for (i = 0; i < this.m_filler.length; ++i) {
            raf.writeInt(this.m_filler[i]);
        }
        raf.writeShort(this.m_descriptors.length);
        for (i = 0; i < this.m_descriptors.length; ++i) {
            this.m_descriptors[i].write(raf);
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        int i;
        dos.writeInt(this.m_magicNumber);
        dos.writeInt(this.m_version);
        for (i = 0; i < this.m_filler.length; ++i) {
            dos.writeInt(this.m_filler[i]);
        }
        dos.writeShort(this.m_descriptors.length);
        for (i = 0; i < this.m_descriptors.length; ++i) {
            this.m_descriptors[i].write(dos);
        }
    }

    public int getMagicNumber() {
        return this.m_magicNumber;
    }

    public int getVersion() {
        return this.m_version;
    }

    public DfEntryDescriptor[] getDescriptors() {
        return this.m_descriptors;
    }

    public void updateResourceForkDescriptor(byte[] resFork) {
        if (this.m_OS9) {
            this.m_descriptors[5].setDataLength(resFork.length);
        } else {
            this.m_descriptors[1].setDataLength(resFork.length);
        }
    }
}

