/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util.appledouble;

import com.documentum.fc.impl.util.appledouble.DfAppleDoubleHeaderData;
import com.documentum.fc.impl.util.appledouble.DfExtendedFinderInfo;
import com.documentum.fc.impl.util.appledouble.DfFileAttributes;
import com.documentum.fc.impl.util.appledouble.DfFinderInfo;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class DfAppleDoubleHeader {
    private DfFinderInfo m_finderInfo = null;
    private DfExtendedFinderInfo m_extendedFinderInfo = null;
    private String m_filename = "";
    private String m_comment = "";
    private Calendar m_creationDate = null;
    private Calendar m_modificationDate = null;
    private Calendar m_backupDate = null;
    private Calendar m_accessDate = null;
    private byte[] m_resourceFork = new byte[0];
    private DfAppleDoubleHeaderData m_headerData = null;
    private boolean m_OS9;
    private DfFileAttributes m_fileAttributes = new DfFileAttributes(0, 0);

    public DfAppleDoubleHeader(boolean os9) {
        this.m_OS9 = os9;
        this.m_headerData = new DfAppleDoubleHeaderData(os9);
    }

    public DfAppleDoubleHeaderData getHeaderData() {
        return this.m_headerData;
    }

    public void setHeaderData(DfAppleDoubleHeaderData headerData) {
        this.m_headerData = headerData;
    }

    public DfFinderInfo getFinderInfo() {
        return this.m_finderInfo;
    }

    public void setFinderInfo(DfFinderInfo fInfo) {
        this.m_finderInfo = fInfo;
    }

    public DfExtendedFinderInfo getExtendedFinderInfo() {
        return this.m_extendedFinderInfo;
    }

    public void setExtendedFinderInfo(DfExtendedFinderInfo xFInfo) {
        this.m_extendedFinderInfo = xFInfo;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public Calendar getCreationDate() {
        return this.m_creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.m_creationDate = creationDate;
    }

    public Calendar getModificationDate() {
        return this.m_modificationDate;
    }

    public void setModificationDate(Calendar modificationDate) {
        this.m_modificationDate = modificationDate;
    }

    public Calendar getBackupDate() {
        return this.m_backupDate;
    }

    public void setBackupDate(Calendar backupDate) {
        this.m_backupDate = backupDate;
    }

    public Calendar getAccessDate() {
        return this.m_accessDate;
    }

    public void setAccessDate(Calendar accessDate) {
        this.m_accessDate = accessDate;
    }

    public void setResourceFork(byte[] resFork) {
        this.m_resourceFork = resFork;
        this.m_headerData.updateResourceForkDescriptor(resFork);
    }

    public byte[] getResourceFork() {
        return this.m_resourceFork;
    }

    public DfFileAttributes getFileAttributes() {
        return this.m_fileAttributes;
    }

    public void setFileAttributes(DfFileAttributes fileAttributes) {
        this.m_fileAttributes = fileAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RandomAccessFile raf) throws IOException {
        try {
            this.m_headerData.write(raf);
            if (this.m_OS9) {
                this.writeString(raf, this.getFilename(), 32);
                this.writeString(raf, this.getComment(), 201);
                raf.write(0);
                this.writeDate(raf, this.getCreationDate());
                this.writeDate(raf, this.getModificationDate());
                this.writeDate(raf, this.getBackupDate());
                this.writeDate(raf, this.getAccessDate());
                if (this.getFinderInfo() != null) {
                    this.getFinderInfo().write(raf);
                }
                if (this.getExtendedFinderInfo() != null) {
                    this.getExtendedFinderInfo().write(raf);
                }
                if (this.getFileAttributes() != null) {
                    this.getFileAttributes().write(raf);
                }
                raf.write(this.getResourceFork());
                long curPos = raf.getFilePointer();
                int numKBytes = Math.round((float)curPos / 1024.0f);
                int padKByes = numKBytes % 4;
                int padding = (numKBytes + padKByes) * 1024;
                for (long i = curPos; i < (long)padding; ++i) {
                    raf.write(0);
                }
            } else {
                if (this.getFinderInfo() != null) {
                    this.getFinderInfo().write(raf);
                }
                if (this.getExtendedFinderInfo() != null) {
                    this.getExtendedFinderInfo().write(raf);
                }
                raf.write(this.getResourceFork());
            }
        }
        finally {
            raf.close();
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        this.m_headerData.write(dos);
        if (this.m_OS9) {
            this.writeString(dos, this.getFilename(), 32);
            this.writeString(dos, this.getComment(), 201);
            dos.write(0);
            this.writeDate(dos, this.getCreationDate());
            this.writeDate(dos, this.getModificationDate());
            this.writeDate(dos, this.getBackupDate());
            this.writeDate(dos, this.getAccessDate());
            if (this.getFinderInfo() != null) {
                this.getFinderInfo().write(dos);
            }
            if (this.getExtendedFinderInfo() != null) {
                this.getExtendedFinderInfo().write(dos);
            }
            if (this.getFileAttributes() != null) {
                this.getFileAttributes().write(dos);
            }
            dos.write(this.getResourceFork());
            long curPos = dos.size();
            if (curPos < 0L) {
                throw new IOException("AppleDouble Header exceeds Maximum size for DataOutputStream");
            }
            int numKBytes = Math.round((float)curPos / 1024.0f);
            int padKByes = numKBytes % 4;
            int padding = (numKBytes + padKByes) * 1024;
            for (long i = curPos; i < (long)padding; ++i) {
                dos.write(0);
            }
        } else {
            if (this.getFinderInfo() != null) {
                this.getFinderInfo().write(dos);
            }
            if (this.getExtendedFinderInfo() != null) {
                this.getExtendedFinderInfo().write(dos);
            }
            dos.write(this.getResourceFork());
        }
    }

    public boolean isOS9() {
        return this.m_OS9;
    }

    private void writeString(RandomAccessFile raf, String str, int totalLength) throws IOException {
        raf.write(str.getBytes());
        for (int i = str.getBytes().length; i < totalLength; ++i) {
            raf.write(0);
        }
    }

    private void writeString(DataOutputStream dos, String str, int totalLength) throws IOException {
        dos.write(str.getBytes());
        for (int i = str.getBytes().length; i < totalLength; ++i) {
            dos.write(0);
        }
    }

    private void writeDate(RandomAccessFile raf, Calendar date) throws IOException {
        if (date == null) {
            raf.writeInt(Integer.MIN_VALUE);
        } else {
            Calendar jan12000 = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
            jan12000.set(1, 2000);
            jan12000.set(2, 0);
            jan12000.set(5, 1);
            jan12000.set(10, 0);
            jan12000.set(12, 0);
            jan12000.set(13, 0);
            long jan12000msec = jan12000.getTime().getTime();
            long datemsec = date.getTime().getTime();
            long offsetmsec = datemsec - jan12000msec;
            int seconds = Math.round((float)offsetmsec / 1000.0f);
            raf.writeInt(seconds);
        }
    }

    private void writeDate(DataOutputStream dos, Calendar date) throws IOException {
        if (date == null) {
            dos.writeInt(Integer.MIN_VALUE);
        } else {
            Calendar jan12000 = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
            jan12000.set(1, 2000);
            jan12000.set(2, 0);
            jan12000.set(5, 1);
            jan12000.set(10, 0);
            jan12000.set(12, 0);
            jan12000.set(13, 0);
            long jan12000msec = jan12000.getTime().getTime();
            long datemsec = date.getTime().getTime();
            long offsetmsec = datemsec - jan12000msec;
            int seconds = Math.round((float)offsetmsec / 1000.0f);
            dos.writeInt(seconds);
        }
    }
}

