/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class WeakValueMap
implements Map {
    private final Map m_map;
    private final ReferenceQueue m_queue;

    public WeakValueMap() {
        this.m_map = new WeakHashMap();
        this.m_queue = new ReferenceQueue();
    }

    public WeakValueMap(int initialCapacity) {
        this.m_map = new WeakHashMap(initialCapacity);
        this.m_queue = new ReferenceQueue();
    }

    public WeakValueMap(int initialCapacity, float loadFactor) {
        this.m_map = new WeakHashMap(initialCapacity, loadFactor);
        this.m_queue = new ReferenceQueue();
    }

    public int hashCode() {
        return ((Object)this.m_map).hashCode();
    }

    public int size() {
        this.cleanup();
        return this.m_map.size();
    }

    public void clear() {
        this.m_map.clear();
    }

    public boolean isEmpty() {
        this.cleanup();
        return this.m_map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.cleanup();
        return this.m_map.get(key) != null;
    }

    public boolean containsValue(Object value) {
        throw new RuntimeException("Feature is not implemented");
    }

    public boolean equals(Object o) {
        return ((Object)this.m_map).equals(o);
    }

    public Collection values() {
        ArrayList<Object> c = new ArrayList<Object>();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Object refrt = this.get(iter.next());
            if (refrt == null) continue;
            c.add(refrt);
        }
        return c;
    }

    public void putAll(Map t) {
        throw new RuntimeException("Feature is not implemented");
    }

    public Set entrySet() {
        throw new RuntimeException("Feature is not implemented");
    }

    public Set keySet() {
        this.cleanup();
        return this.m_map.keySet();
    }

    public Object get(Object key) {
        Entry ref = (Entry)this.m_map.get(key);
        this.cleanup();
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public Object remove(Object key) {
        return this.m_map.remove(key);
    }

    public Object put(Object key, Object value) {
        this.cleanup();
        return this.m_map.put(key, new Entry(key, value, this.m_queue));
    }

    public void cleanup() {
        Entry entry;
        while ((entry = (Entry)this.m_queue.poll()) != null) {
            Object key = entry.getKey();
            if (key == null) continue;
            this.m_map.remove(key);
        }
    }

    private static final class Entry
    extends WeakReference {
        private final Reference m_key;

        Entry(Object key, Object ref, ReferenceQueue refQueue) {
            super(ref, refQueue);
            this.m_key = new WeakReference<Object>(key);
        }

        Object getKey() {
            return this.m_key.get();
        }
    }
}

