/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.impl.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

public class UrlUtil {
    public static URL extractCodeSource(URL url, String resourceName) {
        try {
            return new URL(UrlUtil.extractCodeSource(UrlUtil.resolveURL(url).toString(), resourceName));
        }
        catch (MalformedURLException e) {
            throw new DfCriticalException("Failed to extract codesource for {0}", new Object[]{url.toString()}, e);
        }
    }

    public static URL resolveURL(URL url) {
        if (url.getProtocol().equals("bundleresource")) {
            return UrlUtil.resolveBundleResourceURL(url);
        }
        return url;
    }

    private static URL resolveBundleResourceURL(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            Method method = urlConnection.getClass().getMethod("getLocalURL", null);
            return (URL)method.invoke((Object)urlConnection, (Object[])null);
        }
        catch (InvocationTargetException e) {
            DfLogger.error(UrlUtil.class, "DFC_UTIL_URL_CONVERSION_FAILED", new Object[]{url}, e.getTargetException());
            return url;
        }
        catch (Exception e) {
            DfLogger.error(UrlUtil.class, "DFC_UTIL_URL_CONVERSION_FAILED", new Object[]{url}, (Throwable)e);
            return url;
        }
    }

    static String extractCodeSource(String urlString, String resourceName) {
        String result = urlString;
        if (UrlUtil.hasMemberSuffix(result)) {
            result = UrlUtil.removeProtocol(result);
            if (!UrlUtil.hasProtocol(result = UrlUtil.removeMemberSuffix(result))) {
                result = UrlUtil.addFileProtocol(result);
            }
        } else {
            int i = result.indexOf(resourceName);
            if (i >= 0) {
                result = result.substring(0, i);
            }
        }
        return result;
    }

    private static boolean hasMemberSuffix(String urlString) {
        return urlString.indexOf(33) >= 0;
    }

    private static String removeMemberSuffix(String urlString) {
        int i = urlString.lastIndexOf(33);
        if (i >= 0) {
            return urlString.substring(0, i);
        }
        return urlString;
    }

    private static String removeProtocol(String urlString) {
        String[] parts = urlString.split(":", 2);
        if (parts.length == 0) {
            return urlString;
        }
        return parts[parts.length - 1];
    }

    private static boolean hasProtocol(String urlString) {
        if (urlString.charAt(0) == '/') {
            return false;
        }
        return urlString.indexOf(58) > 1;
    }

    private static String addFileProtocol(String urlString) {
        if (urlString.startsWith("/")) {
            return "file:" + urlString;
        }
        return "file:/" + urlString;
    }

    public static String extractFilePath(URL url) {
        return UrlUtil.extractFilePath(UrlUtil.resolveURL(url).toString());
    }

    static String extractFilePath(String urlString) {
        if (UrlUtil.canExtractFilePath(urlString)) {
            String temp = UrlUtil.removeProtocol(urlString);
            if (temp.startsWith("file:")) {
                temp = temp.substring(5);
            }
            if (!(temp = UrlUtil.removeMemberSuffix(temp)).startsWith("/")) {
                temp = "/" + temp;
            }
            return UrlUtil.decode(temp);
        }
        return null;
    }

    private static boolean canExtractFilePath(String urlString) {
        return urlString.startsWith("file:") || urlString.startsWith("jar:file:") || urlString.startsWith("wsjar:file:") || urlString.startsWith("zip:") || urlString.startsWith("code-source:");
    }

    public static String decode(String input) {
        if (StringUtil.isEmptyOrNull(input)) {
            return input;
        }
        if (input.indexOf(37) < 0) {
            return input;
        }
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException("UTF-8 encoding is not supported by the JVM", e);
        }
    }
}

