/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import java.util.TimeZone;

public class TimeZoneUtil {
    private static final String[] AVAILABLE_IDS = TimeZone.getAvailableIDs();

    public static boolean isValidTimeZone(String id) {
        if (TimeZoneUtil.isAvailableId(id)) {
            return true;
        }
        return TimeZoneUtil.isCustomId(id);
    }

    private static boolean isAvailableId(String id) {
        for (String validId : AVAILABLE_IDS) {
            if (!validId.equals(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomId(String id) {
        if (id.startsWith("GMT+") || id.startsWith("GMT-")) {
            String[] numberParts = id.substring(4).split(":");
            try {
                if (numberParts.length > 0) {
                    Integer.parseInt(numberParts[0]);
                }
                if (numberParts.length > 1) {
                    Integer.parseInt(numberParts[1]);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

