/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

public class ThrowableStack
extends Throwable {
    public ThrowableStack() {
    }

    public ThrowableStack(Throwable cause) {
        super(cause);
    }

    public ThrowableStack(String message) {
        super(message);
    }

    public ThrowableStack(String message, Throwable cause) {
        super(message, cause);
    }

    public ThrowableStack(int numberOfFramesToPop) {
        this.adjustStackTrace(this.getStackTrace(), numberOfFramesToPop);
    }

    public ThrowableStack(int numberOfFramesToPop, Throwable cause) {
        super(cause);
        this.adjustStackTrace(this.getStackTrace(), numberOfFramesToPop);
    }

    public ThrowableStack(String message, int numberOfFramesToPop) {
        super(message);
        this.adjustStackTrace(this.getStackTrace(), numberOfFramesToPop);
    }

    public ThrowableStack(String message, int numberOfFramesToPop, Throwable cause) {
        super(message, cause);
        this.adjustStackTrace(this.getStackTrace(), numberOfFramesToPop);
    }

    private void adjustStackTrace(StackTraceElement[] stackTrace, int numberOfFramesToPop) {
        if (numberOfFramesToPop > 0) {
            StackTraceElement[] adjustedStackTrace = new StackTraceElement[stackTrace.length - numberOfFramesToPop];
            System.arraycopy(stackTrace, numberOfFramesToPop, adjustedStackTrace, 0, adjustedStackTrace.length);
            this.setStackTrace(adjustedStackTrace);
        }
    }

    public ThrowableStack(Class stopClass) {
        this(null, stopClass);
    }

    public ThrowableStack(String message, Class stopClass) {
        super(message);
        StackTraceElement[] stackTrace = this.getStackTrace();
        this.adjustStackTrace(stackTrace, this.calculateNumberOfFramesToPop(stackTrace, stopClass.getName()));
    }

    private int calculateNumberOfFramesToPop(StackTraceElement[] stackTrace, String stopClassName) {
        int numberOfFramesToPop = 0;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (stackTrace[i].getClassName().equals(stopClassName)) {
                numberOfFramesToPop = i + 1;
                continue;
            }
            if (numberOfFramesToPop > 0) break;
        }
        return numberOfFramesToPop;
    }
}

