/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.impl.util.holders.IntHolder;
import com.documentum.fc.impl.util.holders.StringHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesWithArrays
extends Properties {
    public PropertiesWithArrays() {
    }

    public PropertiesWithArrays(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        super.load(inStream);
        this.convertArrayProperties();
    }

    private void convertArrayProperties() {
        ArrayList<String> elementEntries = new ArrayList<String>();
        Hashtable<String, List<String>> arrayEntries = new Hashtable<String, List<String>>();
        for (Object o : this.keySet()) {
            IntHolder index;
            StringHolder arrayKey;
            String originalKey = (String)o;
            if (!this.parseArrayKey(originalKey, arrayKey = new StringHolder(), index = new IntHolder())) continue;
            String value = (String)this.get(originalKey);
            List<String> values = arrayEntries.get(arrayKey.value);
            if (values == null) {
                values = new ArrayList<String>();
                arrayEntries.put(arrayKey.value, values);
            }
            while (values.size() <= index.value) {
                values.add(null);
            }
            values.set(index.value, value);
            elementEntries.add(originalKey);
        }
        this.removeElementEntries(elementEntries);
        this.addArrayEntries(arrayEntries);
    }

    private boolean parseArrayKey(String candidateKey, StringHolder arrayKey, IntHolder index) {
        int i = candidateKey.lastIndexOf(91);
        if (i >= 0 && candidateKey.endsWith("]")) {
            String indexString = candidateKey.substring(i + 1, candidateKey.length() - 1);
            try {
                index.value = Integer.parseInt(indexString);
                arrayKey.value = candidateKey.substring(0, i);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        i = candidateKey.lastIndexOf(".");
        if (i >= 0) {
            String indexString = candidateKey.substring(i + 1, candidateKey.length());
            try {
                index.value = Integer.parseInt(indexString);
                arrayKey.value = candidateKey.substring(0, i);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    private void addArrayEntries(Map<String, List<String>> arrayEntries) {
        for (String key : arrayEntries.keySet()) {
            List<String> valueList = arrayEntries.get(key);
            String[] valueArray = new String[valueList.size()];
            this.put(key, valueList.toArray(valueArray));
        }
    }

    private void removeElementEntries(List<String> elementEntries) {
        for (String key : elementEntries) {
            this.remove(key);
        }
    }
}

