/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEUtils {
    private static final String transformation = "PBEWithMD5AndDES";
    private int count = 100;
    private byte[] salt = new byte[]{-40, -124, 50, -99, -113, -39, -1, 17};

    public static PBEUtils getInstance() {
        return new PBEUtils();
    }

    public byte[] encrypt(char[] password, byte[] input) throws DfException {
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.count);
            Cipher c = Cipher.getInstance(transformation);
            c.init(1, this.makeKey(password), pbeParamSpec);
            return c.doFinal(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (NoSuchPaddingException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeyException e) {
            throw this.handleException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeySpecException e) {
            throw this.handleException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw this.handleException(e);
        }
        catch (BadPaddingException e) {
            throw this.handleException(e);
        }
    }

    public byte[] decrypt(char[] password, byte[] input) throws DfException {
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(this.salt, this.count);
            Cipher c = Cipher.getInstance(transformation);
            c.init(2, this.makeKey(password), pbeParamSpec);
            return c.doFinal(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (NoSuchPaddingException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeyException e) {
            throw this.handleException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeySpecException e) {
            throw this.handleException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw this.handleException(e);
        }
        catch (BadPaddingException e) {
            throw this.handleException(e);
        }
    }

    private Key makeKey(char[] password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password, this.salt, this.count);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(transformation);
        return keyFac.generateSecret(pbeKeySpec);
    }

    private PBEUtils() {
    }

    private DfException handleException(Throwable t) throws DfException {
        throw new DfException("DFC_CORE_CRYPTO_ERROR", t);
    }
}

