/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfException;
import com.documentum.registry.IDfRegistryHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class DfRegistryParser {
    public static final char KEY_DELIMITER = '\\';
    public static final char ENTRY_DELIMITER = '=';
    public static final char SECTION_START = '[';
    public static final char SECTION_END = ']';
    IDfRegistryHandler m_handler;

    public DfRegistryParser(IDfRegistryHandler handler) {
        this.m_handler = handler;
    }

    public void process(BufferedReader reader) throws IOException, DfException {
        String processingLine = reader.readLine();
        while (processingLine != null) {
            if ((processingLine = processingLine.trim()).length() != 0) {
                if (processingLine.charAt(0) == '[') {
                    this.processKeysLine(processingLine.substring(1));
                } else {
                    this.processEntryLine(processingLine);
                }
            }
            processingLine = reader.readLine();
        }
    }

    private void processEntryLine(String line) throws DfException {
        int indOfDelim = line.indexOf(61);
        if (indOfDelim == -1) {
            throw new DfException(0, "Invalid entry format in registry file. Symbol '=' is absent. String is " + line);
        }
        String name = line.substring(0, indOfDelim);
        String value = line.substring(indOfDelim + 1);
        this.m_handler.processEntry(name.trim(), value.trim());
    }

    private void processKeysLine(String line) throws DfException {
        int endOfContent = line.indexOf(93);
        if (endOfContent == -1) {
            throw new DfException(0, "Invalid section format in registry file. Symbol ']' is absent. String is " + line);
        }
        line = line.substring(0, endOfContent);
        ArrayList<String> sections = new ArrayList<String>();
        int delimPosition = 0;
        int initPosition = 0;
        do {
            if ((delimPosition = line.indexOf(92, initPosition)) == -1) {
                sections.add(line.substring(initPosition));
                continue;
            }
            sections.add(line.substring(initPosition, delimPosition));
            initPosition = delimPosition + 1;
        } while (delimPosition != -1);
        this.m_handler.processKeys(sections.toArray(new String[0]));
    }
}

