/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.impl.util;

import com.documentum.fc.common.DfException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class DESedeUtils {
    private static final String transformation = "DESede/CBC/PKCS5Padding";
    private static final String alg = "DESede";

    public static DESedeUtils getInstance() {
        return new DESedeUtils();
    }

    public byte[] encrypt(byte[] input, Key key) throws DfException {
        try {
            Cipher c = Cipher.getInstance(transformation);
            c.init(1, key);
            int blockSize = c.getBlockSize();
            byte[] encrypted = c.doFinal(input);
            byte[] iv = c.getIV();
            byte[] payload = new byte[encrypted.length + blockSize];
            System.arraycopy(iv, 0, payload, 0, blockSize);
            System.arraycopy(encrypted, 0, payload, blockSize, encrypted.length);
            return payload;
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (NoSuchPaddingException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeyException e) {
            throw this.handleException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw this.handleException(e);
        }
        catch (BadPaddingException e) {
            throw this.handleException(e);
        }
    }

    public byte[] decrypt(byte[] payload, Key key) throws DfException {
        try {
            Cipher c = Cipher.getInstance(transformation);
            int blockSize = c.getBlockSize();
            IvParameterSpec dps = new IvParameterSpec(payload, 0, blockSize);
            c.init(2, key, dps);
            return c.doFinal(payload, blockSize, payload.length - blockSize);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (NoSuchPaddingException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeyException e) {
            throw this.handleException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw this.handleException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw this.handleException(e);
        }
        catch (BadPaddingException e) {
            throw this.handleException(e);
        }
    }

    public byte[] generateNewKey() throws DfException {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(alg);
            kg.init(new SecureRandom());
            SecretKey key = kg.generateKey();
            SecretKeyFactory skf = SecretKeyFactory.getInstance(alg);
            DESedeKeySpec ks = (DESedeKeySpec)skf.getKeySpec(key, DESedeKeySpec.class);
            return ks.getKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeySpecException e) {
            throw this.handleException(e);
        }
    }

    public SecretKey restoreKey(byte[] key) throws DfException {
        try {
            DESedeKeySpec ks = new DESedeKeySpec(key);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(alg);
            return skf.generateSecret(ks);
        }
        catch (InvalidKeyException e) {
            throw this.handleException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.handleException(e);
        }
        catch (InvalidKeySpecException e) {
            throw this.handleException(e);
        }
    }

    private DfException handleException(Throwable t) throws DfException {
        throw new DfException("DFC_CORE_CRYPTO_ERROR", t);
    }

    private DESedeUtils() {
    }
}

