/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common.impl.preferences;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfFileWatcher;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfFileObserver;
import com.documentum.fc.common.impl.preferences.DfJMXInitializer;
import com.documentum.fc.common.impl.preferences.PreferencesMBean;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.CompareUtil;
import com.documentum.fc.impl.util.FilenameUtil;
import com.documentum.fc.impl.util.ObjectNameUtil;
import com.documentum.fc.impl.util.PropertiesWithArrays;
import com.documentum.fc.impl.util.RegistryPasswordUtils;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.impl.util.UrlUtil;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesManager {
    private static final String SYSTEM_PROPERTY_NAME = "dfc.properties.file";
    private static final String RESOURCE_NAME = "dfc.properties";
    protected static final String INCLUDE_TOKEN = "#include";
    protected static final String COMMENT_TOKEN = "#";
    private URL m_mainPersistentURL;
    private String m_mainPersistentDir;
    private final Set<URL> m_fileChangeMonitorSet;
    private Properties m_persistentProperties;
    private final TypedPreferences m_persistentPreferences;
    private final TypedPreferences m_activePreferences;
    private final Map<String, URL> m_attributeSourceMap;
    private static List<String> s_preferencesPasswords;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;

    public PreferencesManager(TypedPreferences activePreferences, TypedPreferences persistentPreferences) {
        TypedPreferences typedPreferences = activePreferences;
        TypedPreferences typedPreferences2 = persistentPreferences;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)typedPreferences, (Object)typedPreferences2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_attributeSourceMap = new HashMap<String, URL>();
            this.m_mainPersistentURL = null;
            this.m_fileChangeMonitorSet = new HashSet<URL>();
            this.m_activePreferences = activePreferences;
            this.m_persistentPreferences = persistentPreferences;
            this.m_persistentProperties = this.readPersistentProperties();
            this.m_activePreferences.loadProperties(this.m_persistentProperties, true);
            this.m_persistentPreferences.loadProperties(this.m_persistentProperties, true);
            try {
                DfJMXInitializer jmxInitializer = DfJMXInitializer.getInstance();
                jmxInitializer.setPreferencesManager(this);
                jmxInitializer.startJMXInitialization(persistentPreferences, activePreferences);
            }
            catch (DfException dfEx) {
                DfLogger.error((Object)this, "DFC_JMX_INITIALIZATION_FAILED" + dfEx.getMessage(), null, (Throwable)dfEx);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)typedPreferences, (Object)typedPreferences2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)typedPreferences, (Object)typedPreferences2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void initializeJMX() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
                {
                    PreferencesManager preferencesManager2 = PreferencesManager.this;
                    JoinPoint joinPoint = null;
                    try {
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                            }
                            tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                        }
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                            }
                            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                            }
                            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                        }
                        throw throwable;
                    }
                }

                @Override
                public Void run() {
                    JoinPoint joinPoint = null;
                    try {
                        Void void_;
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                            }
                            tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                        }
                        try {
                            String domain;
                            MBeanServer server;
                            try {
                                server = ManagementFactory.getPlatformMBeanServer();
                                domain = PreferencesManager.access$000(server, "com.documentum.dfc");
                            }
                            catch (SecurityException e) {
                                server = MBeanServerFactory.createMBeanServer();
                                domain = server.getDefaultDomain();
                            }
                            server.registerMBean(new PreferencesMBean(PreferencesManager.this, PreferencesManager.access$100(PreferencesManager.this), "Preferences currently in use"), ObjectNameUtil.newObjectName(domain, "Preferences", "Active"));
                            server.registerMBean(new PreferencesMBean(PreferencesManager.this, PreferencesManager.access$200(PreferencesManager.this), "Preferences stored persistently"), ObjectNameUtil.newObjectName(domain, "Preferences", "Persistent"));
                        }
                        catch (Exception e) {
                            DfLogger.warn((Object)this, "DFC_JMX_CANT_FIND_PLATFORM_SERVER", null, (Throwable)e);
                        }
                        Void void_2 = null;
                        Void void_3 = void_ = null;
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                            }
                            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(void_, joinPoint);
                        }
                        return void_2;
                    }
                    catch (Throwable throwable) {
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                            }
                            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                        }
                        throw throwable;
                    }
                }

                static {
                    Factory factory = new Factory("PreferencesManager.java", Class.forName("com.documentum.fc.common.impl.preferences.PreferencesManager$1"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.documentum.fc.common.impl.preferences.PreferencesManager$1", "", "", "", "java.lang.Void"), 73);
                    ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.common.impl.preferences.PreferencesManager$1", "com.documentum.fc.common.impl.preferences.PreferencesManager:", "arg0:", ""), 62);
                }
            });
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void dumpMBeanServers() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            System.out.println("MBean Servers:");
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer server : servers) {
                System.out.println(server);
            }
            System.out.println();
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String determineUniqueDomain(MBeanServer mBeanServer, String string) {
        MBeanServer mBeanServer2 = mBeanServer;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void var9_9;
            void requestedDomain;
            MBeanServer server;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            List<String> registeredDomains = Arrays.asList(server.getDomains());
            String candidateDomain = requestedDomain;
            int i = 1;
            while (true) {
                if (!registeredDomains.contains(candidateDomain)) break;
                candidateDomain = (String)requestedDomain + ++i;
            }
            void var8_8 = candidateDomain;
            void v1 = var9_9 = var8_8;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_9, joinPoint);
            }
            return var8_8;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final synchronized void persistChanges(Properties var1_1) {
        var15_2 = var1_1;
        var14_3 = null;
        try {
            block37: {
                if (BaseTracingAspect.ajc$if_0()) {
                    v0 = TracingAspect.aspectOf();
                    if (var14_3 == null) {
                        var14_3 = Factory.makeJP((JoinPoint.StaticPart)PreferencesManager.ajc$tjp_3, (Object)this, (Object)this, (Object)var15_2);
                    }
                    v0.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(var14_3);
                }
                if (!PreferencesManager.$assertionsDisabled && modifiedAttributes == null) {
                    throw new AssertionError((Object)"modifiedAttributes parameter cannot be null");
                }
                if (modifiedAttributes.size() == 0 || this.m_mainPersistentURL == null) break block37;
                attributesThatNeedToBeWritten = new HashSet<Object>();
                attributesThatNeedToBeWritten.addAll(modifiedAttributes.keySet());
                out = new ByteArrayOutputStream(1000);
                writer = new BufferedWriter(new OutputStreamWriter(out));
                preferencesOutputStream = null;
                try {
                    in = new FileInputStream(this.m_mainPersistentURL.getPath());
                    reader = new BufferedReader(new InputStreamReader(in));
                    line = reader.readLine();
                    while (line != null) {
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.charAt(0) == '\r' || line.charAt(0) == '\n') ** GOTO lbl-1000
                        key = PreferencesManager.extractPreferenceName(line);
                        aliasedKey = PreferencesManager.getPreferenceNameFromAlias(this.m_persistentPreferences, key);
                        if (aliasedKey != null) {
                            key = aliasedKey;
                        }
                        if (modifiedAttributes.containsKey(key)) {
                            if (attributesThatNeedToBeWritten.contains(key)) {
                                updatedValue = modifiedAttributes.get(key);
                                if (!this.isDefaultPreferenceValue(key, updatedValue)) {
                                    if (PreferencesManager.isPasswordAttribute(key)) {
                                        this.writePreference(key, RegistryPasswordUtils.encrypt(updatedValue.toString()), writer);
                                    } else {
                                        this.writePreference(key, updatedValue, writer);
                                    }
                                }
                                this.m_persistentProperties.put(key, updatedValue);
                                attributesThatNeedToBeWritten.remove(key);
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            writer.write(line);
                            writer.newLine();
                        }
                        line = reader.readLine();
                    }
                    for (E o : attributesThatNeedToBeWritten) {
                        key = (String)o;
                        if (!this.isDefaultPreferenceValue(key, value = modifiedAttributes.get(key))) {
                            if (PreferencesManager.isPasswordAttribute(key)) {
                                this.writePreference(key, RegistryPasswordUtils.encrypt(value.toString()), writer);
                            } else {
                                this.writePreference(key, value, writer);
                            }
                        }
                        this.m_persistentProperties.put(key, value);
                        attributesThatNeedToBeWritten.remove(key);
                    }
                    if (!PreferencesManager.$assertionsDisabled && !attributesThatNeedToBeWritten.isEmpty()) {
                        throw new AssertionError((Object)"Not all modified attributes were written during persist");
                    }
                    reader.close();
                    in.close();
                    writer.flush();
                    writer.close();
                    preferencesFile = new File(this.m_mainPersistentURL.getPath());
                    preferencesOutputStream = new FileOutputStream(preferencesFile, false);
                    preferencesOutputStream.write(out.toByteArray());
                    preferencesOutputStream.flush();
                }
                catch (IOException e) {
                    DfLogger.error((Object)this, "DFC_PREFERENCE_PERSIST_FAILED", new Object[]{this.m_mainPersistentURL}, (Throwable)e);
                }
                catch (DfException e) {
                    DfLogger.error((Object)this, "DFC_PREFERENCE_PERSIST_FAILED", new Object[]{this.m_mainPersistentURL}, (Throwable)e);
                }
                finally {
                    try {
                        preferencesOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            var16_21 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                v1 = TracingAspect.aspectOf();
                if (var14_3 == null) {
                    var14_3 = Factory.makeJP((JoinPoint.StaticPart)PreferencesManager.ajc$tjp_3, (Object)this, (Object)this, (Object)var15_2);
                }
                v1.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var16_21, var14_3);
            }
            return;
        }
        catch (Throwable var17_22) {
            if (BaseTracingAspect.ajc$if_0()) {
                v2 = TracingAspect.aspectOf();
                if (var14_3 == null) {
                    var14_3 = Factory.makeJP((JoinPoint.StaticPart)PreferencesManager.ajc$tjp_3, (Object)this, (Object)this, (Object)var15_2);
                }
                v2.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(var17_22, var14_3);
            }
            throw var17_22;
        }
    }

    private static String extractPreferenceName(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            String string5;
            block12: {
                String candidate;
                block13: {
                    int i;
                    block11: {
                        if (BaseTracingAspect.ajc$if_0()) {
                            TracingAspect tracingAspect = TracingAspect.aspectOf();
                            if (joinPoint == null) {
                                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string2);
                            }
                            tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                        }
                        if ((i = candidate.indexOf(61)) >= 0) {
                            candidate = candidate.substring(0, i).trim();
                        }
                        if ((i = candidate.lastIndexOf(91)) < 0 || !candidate.endsWith("]")) break block11;
                        string4 = string5 = candidate.substring(0, i);
                        break block12;
                    }
                    i = candidate.lastIndexOf(".");
                    if (i < 0) break block13;
                    String indexString = candidate.substring(i + 1, candidate.length());
                    try {
                        Integer.parseInt(indexString);
                        string4 = string5 = candidate.substring(0, i);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    break block12;
                }
                string4 = string5 = candidate;
            }
            String string6 = string3 = string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string3, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getPreferenceNameFromAlias(TypedPreferences typedPreferences, String string) {
        TypedPreferences typedPreferences2 = typedPreferences;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void aliasName;
            TypedPreferences preferences;
            String string3;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)typedPreferences2, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string5 = string4 = (string3 = preferences.getPreference((String)aliasName, true).getName());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)typedPreferences2, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)typedPreferences2, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDefaultPreferenceValue(String string, Object object) throws DfException {
        String string2 = string;
        Object object2 = object;
        JoinPoint joinPoint = null;
        try {
            void key;
            boolean bl;
            boolean bl2;
            void updatedValue;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (updatedValue != null) : "New preference value was unexpectedly null";
            boolean bl3 = bl2 = (bl = updatedValue.toString().equals(this.m_persistentPreferences.getPreference((String)key).getDefaultValue()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object3 = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object3, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2, (Object)object2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writePreference(String string, Object object, BufferedWriter bufferedWriter) throws DfException, IOException {
        String string2 = string;
        Object object2 = object;
        BufferedWriter bufferedWriter2 = bufferedWriter;
        JoinPoint joinPoint = null;
        try {
            void key;
            void writer;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, object2, bufferedWriter2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != this.m_persistentPreferences) : "Persistent preferences instance was null";
            assert (null != writer) : "Writer unexpectedly null";
            assert (null != key) : "Key cannot be null";
            int valueCount = this.m_persistentPreferences.getValueCount((String)key);
            if (valueCount == 1) {
                void value;
                writer.write((String)key);
                writer.write(61);
                writer.write(value.toString());
                writer.newLine();
            }
            Object var11_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, object2, bufferedWriter2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var11_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string2, object2, bufferedWriter2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Properties readPersistentProperties() {
        JoinPoint joinPoint = null;
        try {
            PropertiesWithArrays propertiesWithArrays;
            PropertiesWithArrays propertiesWithArrays2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_attributeSourceMap.clear();
            PropertiesWithArrays properties = new PropertiesWithArrays();
            try {
                this.locateMainPersistentStore();
                if (PreferencesManager.isDiagnosingConfig()) {
                    System.out.println("Reading DFC configuration from \"" + this.m_mainPersistentURL.toString() + "\"");
                }
                InputStream is = this.aggregatePropertyStreams(this.m_mainPersistentURL);
                try {
                    ((Properties)properties).load(is);
                    properties.put("dfc.config.file", this.m_mainPersistentURL);
                    properties.put("dfc.config.dir", this.m_mainPersistentDir);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                DfLogger.error((Object)this, "DFC_PREFERENCE_LOAD_FAILED", new Object[]{this.m_mainPersistentURL}, (Throwable)e);
            }
            PropertiesWithArrays propertiesWithArrays3 = propertiesWithArrays2 = (propertiesWithArrays = properties);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(propertiesWithArrays2, joinPoint);
            }
            return propertiesWithArrays;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void locateMainPersistentStore() throws IOException {
        JoinPoint joinPoint = null;
        try {
            String location;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((location = System.getProperty(SYSTEM_PROPERTY_NAME)) != null) {
                File file = new File(location);
                this.m_mainPersistentURL = file.toURL();
                this.m_mainPersistentDir = file.getParentFile().getCanonicalPath();
            } else {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.m_mainPersistentURL = loader.getResource(RESOURCE_NAME);
                if (this.m_mainPersistentURL == null) {
                    throw new FileNotFoundException(RESOURCE_NAME);
                }
                String filePath = UrlUtil.extractFilePath(UrlUtil.extractCodeSource(this.m_mainPersistentURL, RESOURCE_NAME));
                if (filePath != null) {
                    File file = new File(filePath);
                    if (!file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    this.m_mainPersistentDir = file.isDirectory() ? file.getCanonicalPath() : System.getProperty("user.dir");
                }
            }
            Object var6_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private URL locateIncludedPersistentStore(String string, URL uRL) throws IOException {
        String string2 = string;
        URL uRL2 = uRL;
        JoinPoint joinPoint = null;
        try {
            URL uRL3;
            URL uRL4;
            URL uRL5;
            ClassLoader loader;
            URL url;
            void includeName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2, (Object)uRL2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.isRelativeName((String)includeName) && (url = (loader = Thread.currentThread().getContextClassLoader()).getResource((String)includeName)) != null) {
                uRL4 = uRL5 = url;
            } else {
                void parentURL;
                File parentFile;
                File includeFile = new File((String)includeName);
                if (!includeFile.isAbsolute() && (parentFile = new File(parentURL.getFile())).exists()) {
                    includeFile = new File(parentFile.getParent(), (String)includeName);
                }
                if (!includeFile.exists()) {
                    throw new FileNotFoundException(includeFile.toString());
                }
                uRL4 = uRL5 = includeFile.toURL();
            }
            URL uRL6 = uRL3 = uRL4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2, (Object)uRL2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(uRL3, joinPoint);
            }
            return uRL5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2, (Object)uRL2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRelativeName(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void name;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl2 = !name.contains(":") && !new File((String)name).isAbsolute();
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private InputStream aggregatePropertyStreams(URL uRL) throws IOException {
        URL uRL2 = uRL;
        JoinPoint joinPoint = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2;
            void url;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)uRL2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            this.insertPropertyStream(writer, (URL)url, new ArrayList<URL>());
            writer.close();
            ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream2 = (byteArrayInputStream = new ByteArrayInputStream(os.toByteArray()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)uRL2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byteArrayInputStream2, joinPoint);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)uRL2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void insertPropertyStream(BufferedWriter bufferedWriter, URL uRL, List<URL> list) throws IOException {
        BufferedWriter bufferedWriter2 = bufferedWriter;
        URL uRL2 = uRL;
        List<URL> list2 = list;
        JoinPoint joinPoint = null;
        try {
            void url;
            ArrayList<URL> includePath;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{bufferedWriter2, uRL2, list2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (includePath.contains(url)) {
                DfLogger.error((Object)this, "DFC_PREFERENCE_CIRCULAR_INCLUDE", new Object[]{url, includePath.get(includePath.size() - 1)}, null);
            } else {
                includePath = new ArrayList<URL>(includePath);
                includePath.add((URL)url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        void writer;
                        if ((line = line.trim()).startsWith(INCLUDE_TOKEN)) {
                            String includeName = FilenameUtil.unquote(line.substring(INCLUDE_TOKEN.length()).trim());
                            try {
                                URL includedUrl = this.locateIncludedPersistentStore(includeName, (URL)url);
                                this.insertPropertyStream((BufferedWriter)writer, includedUrl, includePath);
                            }
                            catch (IOException e) {
                                DfLogger.error((Object)this, "DFC_PREFERENCE_INCLUDE_FAILED", new Object[]{includeName}, (Throwable)e);
                            }
                        } else {
                            String[] pieces;
                            if (!line.startsWith(COMMENT_TOKEN) && (pieces = line.split("=|:", 2)).length > 0) {
                                String key = pieces[0].trim();
                                this.m_attributeSourceMap.put(key, (URL)url);
                            }
                            writer.write(line);
                            writer.newLine();
                        }
                        line = reader.readLine();
                    }
                    if (!this.m_fileChangeMonitorSet.contains(url)) {
                        File file = DfUtil.getFileFromUrl((URL)url);
                        if (file != null) {
                            DfFileWatcher.access().register(file, new FileObserver(this, null));
                        }
                        this.m_fileChangeMonitorSet.add((URL)url);
                    }
                }
                finally {
                    reader.close();
                }
            }
            Object var15_15 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{bufferedWriter2, uRL2, list2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var15_15, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{bufferedWriter2, uRL2, list2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static boolean isDiagnosingConfig() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            String property;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (StringUtil.isEmptyOrNull(property = System.getProperty("dfc.diagnose_config", "false"))) {
                property = "true";
            }
            boolean bl3 = bl2 = (bl = Boolean.valueOf(property).booleanValue());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void persistAndApplyChanges(Properties properties) {
        Properties properties2 = properties;
        JoinPoint joinPoint = null;
        try {
            void modifiedProperties;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)properties2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.persistChanges((Properties)modifiedProperties);
            this.applyChanges(this.m_activePreferences, (Properties)modifiedProperties);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)properties2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)properties2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void applyChanges(TypedPreferences typedPreferences, Properties properties) {
        TypedPreferences typedPreferences2 = typedPreferences;
        Properties properties2 = properties;
        JoinPoint joinPoint = null;
        try {
            void modifiedProperties;
            void preferences;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)typedPreferences2, (Object)properties2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            preferences.loadProperties((Properties)modifiedProperties, false);
            Object var6_6 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)typedPreferences2, (Object)properties2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_6, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)typedPreferences2, (Object)properties2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean allowsPersistence(TypedPreferences typedPreferences) {
        TypedPreferences typedPreferences2 = typedPreferences;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void preferences;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)typedPreferences2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl2 = preferences == this.m_persistentPreferences;
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)typedPreferences2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)typedPreferences2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final URL getPreferenceOrigin(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void name;
            URL uRL;
            URL uRL2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            URL uRL3 = uRL2 = (uRL = this.m_attributeSourceMap.get(name));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(uRL2, joinPoint);
            }
            return uRL;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public final void rereadPersistentProperties() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Properties oldProperties = this.m_persistentProperties;
            Properties newProperties = this.readPersistentProperties();
            Properties modifiedProperties = this.detectModifiedProperties(newProperties, oldProperties);
            this.applyChanges(this.m_activePreferences, modifiedProperties);
            this.applyChanges(this.m_persistentPreferences, modifiedProperties);
            this.m_persistentProperties = newProperties;
            this.m_activePreferences.notifyObservers(null);
            Object var5_5 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var5_5, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static boolean isPasswordAttribute(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String attributeName;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = s_preferencesPasswords.contains(attributeName));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Properties detectModifiedProperties(Properties properties, Properties properties2) {
        Properties properties3 = properties;
        Properties properties4 = properties2;
        JoinPoint joinPoint = null;
        try {
            Properties properties5;
            Properties properties6;
            void newProperties;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)properties3, (Object)properties4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Properties changedProperties = new Properties();
            for (Object o : newProperties.keySet()) {
                Object newValue;
                void oldProperties;
                String key = (String)o;
                Object oldValue = oldProperties.get(key);
                if (CompareUtil.isEqual(oldValue, newValue = newProperties.get(key))) continue;
                changedProperties.put(key, newValue);
            }
            Properties properties7 = properties6 = (properties5 = changedProperties);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)properties3, (Object)properties4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(properties6, joinPoint);
            }
            return properties5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)properties3, (Object)properties4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(MBeanServer mBeanServer, String string) {
        MBeanServer mBeanServer2 = mBeanServer;
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void x1;
            MBeanServer x0;
            String string3;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string5 = string4 = (string3 = PreferencesManager.determineUniqueDomain(x0, (String)x1));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, null, null, (Object)mBeanServer2, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static /* synthetic */ TypedPreferences access$100(PreferencesManager preferencesManager) {
        PreferencesManager preferencesManager2 = preferencesManager;
        JoinPoint joinPoint = null;
        try {
            PreferencesManager x0;
            TypedPreferences typedPreferences;
            TypedPreferences typedPreferences2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            TypedPreferences typedPreferences3 = typedPreferences2 = (typedPreferences = x0.m_activePreferences);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(typedPreferences2, joinPoint);
            }
            return typedPreferences;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static /* synthetic */ TypedPreferences access$200(PreferencesManager preferencesManager) {
        PreferencesManager preferencesManager2 = preferencesManager;
        JoinPoint joinPoint = null;
        try {
            PreferencesManager x0;
            TypedPreferences typedPreferences;
            TypedPreferences typedPreferences2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            TypedPreferences typedPreferences3 = typedPreferences2 = (typedPreferences = x0.m_persistentPreferences);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(typedPreferences2, joinPoint);
            }
            return typedPreferences;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null, (Object)preferencesManager2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PreferencesManager.java", Class.forName("com.documentum.fc.common.impl.preferences.PreferencesManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeJMX", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "", "void"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "dumpMBeanServers", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "", "void"), 105);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "locateIncludedPersistentStore", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:java.net.URL:", "includeName:parentURL:", "java.io.IOException:", "java.net.URL"), 404);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRelativeName", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:", "name:", "", "boolean"), 427);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "aggregatePropertyStreams", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.net.URL:", "url:", "java.io.IOException:", "java.io.InputStream"), 439);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertPropertyStream", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.io.BufferedWriter:java.net.URL:java.util.List:", "writer:url:includePath:", "java.io.IOException:", "void"), 457);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "isDiagnosingConfig", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "", "boolean"), 519);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "persistAndApplyChanges", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.util.Properties:", "modifiedProperties:", "", "void"), 528);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "applyChanges", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.TypedPreferences:java.util.Properties:", "preferences:modifiedProperties:", "", "void"), 534);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "allowsPersistence", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.TypedPreferences:", "preferences:", "", "boolean"), 545);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getPreferenceOrigin", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:", "name:", "", "java.net.URL"), 557);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "rereadPersistentProperties", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "", "void"), 562);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "determineUniqueDomain", "com.documentum.fc.common.impl.preferences.PreferencesManager", "javax.management.MBeanServer:java.lang.String:", "server:requestedDomain:", "", "java.lang.String"), 118);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "isPasswordAttribute", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:", "attributeName:", "", "boolean"), 576);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "detectModifiedProperties", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.util.Properties:java.util.Properties:", "newProperties:oldProperties:", "", "java.util.Properties"), 581);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$000", "com.documentum.fc.common.impl.preferences.PreferencesManager", "javax.management.MBeanServer:java.lang.String:", "x0:x1:", "", "java.lang.String"), 27);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$100", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.PreferencesManager:", "x0:", "", "com.documentum.fc.common.impl.preferences.TypedPreferences"), 27);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$200", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.PreferencesManager:", "x0:", "", "com.documentum.fc.common.impl.preferences.TypedPreferences"), 27);
        ajc$tjp_25 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.TypedPreferences:com.documentum.fc.common.impl.preferences.TypedPreferences:", "activePreferences:persistentPreferences:", ""), 616);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("31", "persistChanges", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.util.Properties:", "modifiedAttributes:", "", "void"), 135);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "extractPreferenceName", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:", "candidate:", "", "java.lang.String"), 260);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getPreferenceNameFromAlias", "com.documentum.fc.common.impl.preferences.PreferencesManager", "com.documentum.fc.common.impl.preferences.TypedPreferences:java.lang.String:", "preferences:aliasName:", "", "java.lang.String"), 288);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isDefaultPreferenceValue", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:java.lang.Object:", "key:updatedValue:", "com.documentum.fc.common.DfException:", "boolean"), 293);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "writePreference", "com.documentum.fc.common.impl.preferences.PreferencesManager", "java.lang.String:java.lang.Object:java.io.BufferedWriter:", "key:value:writer:", "com.documentum.fc.common.DfException:java.io.IOException:", "void"), 306);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("31", "readPersistentProperties", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "", "java.util.Properties"), 327);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "locateMainPersistentStore", "com.documentum.fc.common.impl.preferences.PreferencesManager", "", "", "java.io.IOException:", "void"), 366);
        s_preferencesPasswords = new ArrayList<String>(5);
        s_preferencesPasswords.add("dfc.globalregistry.password");
        s_preferencesPasswords.add("dfc.search.external_sources.password");
        s_preferencesPasswords.add("dfc.search.external_sources.ssl.keystore_password");
        s_preferencesPasswords.add("dfc.security.keystore.password");
        s_preferencesPasswords.add("dfc.security.keystore.privatekey.password");
        s_preferencesPasswords.add("dfc.jmx.connector.readonly.password");
        s_preferencesPasswords.add("dfc.jmx.connector.readwrite.password");
    }

    private class FileObserver
    implements IDfFileObserver {
        final /* synthetic */ PreferencesManager this$0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private FileObserver(PreferencesManager preferencesManager) {
            this.this$0 = preferencesManager;
            PreferencesManager preferencesManager2 = preferencesManager;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)preferencesManager2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        public void update(File file) {
            File file2 = file;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.this$0.rereadPersistentProperties();
                Object var4_4 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ FileObserver(PreferencesManager x0, 1 x1) {
            PreferencesManager preferencesManager = x0;
            FileObserver fileObserver = this;
            fileObserver.this$0 = preferencesManager;
            PreferencesManager preferencesManager2 = x0;
            1 var7_6 = x1;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)preferencesManager2, (Object)var7_6);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)preferencesManager2, (Object)var7_6);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)preferencesManager2, (Object)var7_6);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PreferencesManager.java", Class.forName("com.documentum.fc.common.impl.preferences.PreferencesManager$FileObserver"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.documentum.fc.common.impl.preferences.PreferencesManager$FileObserver", "java.io.File:", "file:", "", "void"), 601);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.common.impl.preferences.PreferencesManager$FileObserver", "com.documentum.fc.common.impl.preferences.PreferencesManager:", "arg0:", ""), 597);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.common.impl.preferences.PreferencesManager$FileObserver", "com.documentum.fc.common.impl.preferences.PreferencesManager:com.documentum.fc.common.impl.preferences.PreferencesManager$1:", "x0:x1:", ""), 597);
        }
    }
}

