/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common.impl.logging;

import com.documentum.fc.common.DfFileWatcher;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfFileObserver;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.impl.util.UrlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggingConfigurator {
    private static URL s_log4jConfiguration = null;
    private static Level s_levelToForceStack = Level.OFF;
    private static IPreferencesObserver s_preferenceObserver;

    public static Level getLevelToForceStack() {
        return s_levelToForceStack;
    }

    public static void performInitialConfiguration() {
        Exception exception1 = null;
        try {
            s_log4jConfiguration = LoggingConfigurator.findLog4jConfiguration();
            if (s_log4jConfiguration != null) {
                LoggingConfigurator.configureLog4j(s_log4jConfiguration);
            }
        }
        catch (Exception e) {
            exception1 = e;
        }
        Exception exception2 = null;
        boolean useDefaultConfiguration = !LoggingConfigurator.isLog4jInitialized();
        try {
            if (useDefaultConfiguration) {
                LoggingConfigurator.configureLog4jWithSimpleDefault();
            }
        }
        catch (Exception e) {
            exception2 = e;
        }
        Logger logger = Logger.getLogger(LoggingConfigurator.class);
        if (s_log4jConfiguration == null) {
            logger.l7dlog((Priority)Level.ERROR, "Problem locating log4j configuration", null, (Throwable)exception1);
        } else if (exception1 != null) {
            logger.l7dlog((Priority)Level.ERROR, "Problem with log4j configuration '" + s_log4jConfiguration + "'. No appenders were configured.", null, (Throwable)exception1);
        }
        if (useDefaultConfiguration) {
            logger.l7dlog((Priority)Level.WARN, "Using default log4j configuration", null, null);
        }
        if (exception2 != null) {
            logger.l7dlog((Priority)Level.ERROR, "Failed to initialize default log4j configuration", null, (Throwable)exception2);
        }
    }

    private static URL findLog4jConfiguration() {
        URL url;
        block8: {
            url = null;
            String configuration = System.getProperty("log4j.configuration");
            if (configuration != null) {
                try {
                    url = new URL(configuration);
                }
                catch (MalformedURLException ex) {
                    try {
                        url = new File(configuration).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        url = LoggingConfigurator.getResource(configuration);
                        if (url != null) break block8;
                        System.out.println("Configuration '" + configuration + "' given by log4j.configuration was not found");
                    }
                }
            }
        }
        if (url == null) {
            url = LoggingConfigurator.getResource("log4j.xml");
        }
        if (url == null) {
            url = LoggingConfigurator.getResource("log4j.properties");
        }
        if (url != null && LoggingConfigurator.isDiagnosingConfig()) {
            System.out.println("Reading log4j configuration from \"" + UrlUtil.decode(url.toString()) + "\"");
        }
        return url;
    }

    private static URL getResource(String resource) {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        classLoader = LoggingConfigurator.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    private static boolean isDiagnosingConfig() {
        String value = System.getProperty("dfc.diagnose_config", "false");
        if (StringUtil.isEmptyOrNull(value)) {
            value = "true";
        }
        return Boolean.valueOf(value);
    }

    private static void configureLog4j(URL configuration) {
        if (configuration.toString().contains(".xml")) {
            DOMConfigurator.configure((URL)configuration);
        } else {
            PropertyConfigurator.configure((URL)configuration);
        }
    }

    private static boolean isLog4jInitialized() {
        return Logger.getRootLogger().getAllAppenders().hasMoreElements();
    }

    private static void configureLog4jWithSimpleDefault() throws IOException {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.WARN);
        PatternLayout layout = new PatternLayout("%r [%t] %p %c %x - %m%n");
        rootLogger.addAppender((Appender)new ConsoleAppender((Layout)layout));
        rootLogger.addAppender((Appender)new FileAppender((Layout)layout, "log4j.log"));
        Logger traceLogger = Logger.getLogger((String)"tracing");
        traceLogger.setLevel(Level.DEBUG);
        traceLogger.setAdditivity(false);
        traceLogger.addAppender((Appender)new FileAppender((Layout)layout, "trace.log"));
    }

    public static synchronized void onPreferencesInitialized() {
        if (s_preferenceObserver == null) {
            File file;
            s_preferenceObserver = new PreferencesObserver();
            DfLogger.isInfoEnabled(LoggingConfigurator.class);
            if (s_log4jConfiguration != null && (file = DfUtil.getFileFromUrl(s_log4jConfiguration)) != null) {
                DfFileWatcher.access().register(file, new FileObserver());
            }
        }
    }

    private static class FileObserver
    implements IDfFileObserver {
        private FileObserver() {
        }

        public void update(File f) {
            LoggingConfigurator.configureLog4j(s_log4jConfiguration);
        }
    }

    private static class PreferencesObserver
    implements IPreferencesObserver {
        public PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            s_levelToForceStack = Level.toLevel((String)DfPreferences.getInstance().getLoggingLevelToForceStack(), (Level)Level.OFF);
        }
    }
}

