/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class UnifiedLoginHelper {
    private static String s_DctmSid;
    private static Boolean s_isULSupported;
    private static Class s_sidImplClass;
    private static String s_loginModuleName;
    private static final String OS_NAME = "os.name";
    private static final String OS_WINDOWS = "Windows";
    private static final String SUN_JVM = "Sun";
    private static final String IBM_JVM = "IBM";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String UL_USR_SID_COMMON = "DM-UL-S-1";
    private static final String JAVA_AUTH_CONFIG = "java.security.auth.login.config";
    private static final String ULSUN_JRE_CONFIG = "ULSunJRE.config";
    private static final String SUN_NTSID_IMPL_CONFIG;
    private static final String ULIBM_JRE_CONFIG = "ULIBMJRE.config";
    private static final String IBM_NTSID_IMPL_CONFIG;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    private UnifiedLoginHelper() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized boolean isULSupportedByClient() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_isULSupported != null) {
                bl2 = bl3 = s_isULSupported.booleanValue();
            } else if (!System.getProperty(OS_NAME).contains(OS_WINDOWS)) {
                s_isULSupported = false;
                bl2 = bl3 = s_isULSupported.booleanValue();
            } else {
                String jvmVendor = UnifiedLoginHelper.getJVMVendor();
                if (jvmVendor.contains(SUN_JVM) || jvmVendor.contains(IBM_JVM)) {
                    s_isULSupported = true;
                }
                bl2 = bl3 = s_isULSupported.booleanValue();
            }
            boolean bl4 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized String getULUserSid() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_DctmSid == null) {
                UnifiedLoginHelper.buildDctmSid();
            }
            String string3 = string2 = (string = s_DctmSid);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized String getJVMVendor() {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = System.getProperty(JAVA_VENDOR));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void buildDctmSid() {
        JoinPoint joinPoint = null;
        try {
            block13: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                String ntUserSid = null;
                UnifiedLoginHelper.loadNTLoginModuleAndSidClass();
                if (s_sidImplClass != null) {
                    Principal[] principals;
                    LoginContext lContext;
                    try {
                        lContext = new LoginContext(s_loginModuleName);
                        lContext.login();
                    }
                    catch (LoginException e) {
                        DfLogger.warn(UnifiedLoginHelper.class, "DFC_UNIFIED_LOGON_LOGIN_MODULE_FAIL", null, (Throwable)e);
                        break block13;
                    }
                    Subject loginSubject = lContext.getSubject();
                    for (Principal principal : principals = loginSubject.getPrincipals().toArray(new Principal[1])) {
                        if (!principal.getClass().equals(s_sidImplClass)) continue;
                        ntUserSid = principal.getName();
                        break;
                    }
                    StringBuffer strBuff = new StringBuffer();
                    if (ntUserSid != null) {
                        strBuff.append(UL_USR_SID_COMMON);
                        strBuff.append(ntUserSid.substring(1));
                        s_DctmSid = strBuff.toString();
                    }
                }
            }
            Object var10_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static void loadNTLoginModuleAndSidClass() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String loginModuleResource = null;
            String sidImplClass = null;
            String authConfigPropertyValue = System.getProperty(JAVA_AUTH_CONFIG);
            ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
            String jvmVendor = UnifiedLoginHelper.getJVMVendor();
            if (jvmVendor.contains(SUN_JVM)) {
                loginModuleResource = ULSUN_JRE_CONFIG;
                sidImplClass = SUN_NTSID_IMPL_CONFIG;
            } else if (jvmVendor.contains(IBM_JVM)) {
                loginModuleResource = ULIBM_JRE_CONFIG;
                sidImplClass = IBM_NTSID_IMPL_CONFIG;
            }
            if (authConfigPropertyValue == null) {
                URL authResourceURL = currentThreadClassLoader.getResource(loginModuleResource);
                if (authResourceURL != null) {
                    System.setProperty(JAVA_AUTH_CONFIG, authResourceURL.toExternalForm());
                }
            } else {
                URL authResourceURL = currentThreadClassLoader.getResource(authConfigPropertyValue);
                if (authResourceURL != null) {
                    System.setProperty(JAVA_AUTH_CONFIG, authResourceURL.toExternalForm());
                    String resourceContent = UnifiedLoginHelper.getResourceContents(authResourceURL);
                    s_loginModuleName = resourceContent.substring(0, resourceContent.indexOf("{")).trim();
                }
            }
            try {
                s_sidImplClass = Class.forName(sidImplClass, true, currentThreadClassLoader);
            }
            catch (ClassNotFoundException e) {
                DfLogger.warn(UnifiedLoginHelper.class, "DFC_UNIFIED_LOGON_SID_CLASS_LOAD_FAIL", null, (Throwable)e);
                s_sidImplClass = null;
            }
            Object var9_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceContents(URL uRL) {
        URL uRL2 = uRL;
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)uRL2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String content = null;
            BufferedReader buffReader = null;
            try {
                URL urlToRead;
                buffReader = new BufferedReader(new InputStreamReader(urlToRead.openStream()));
                content = buffReader.readLine();
            }
            catch (IOException e) {
                DfLogger.warn(UnifiedLoginHelper.class, "DFC_UNIFIED_LOGON_RESOURCE_READ_FAIL", null, (Throwable)e);
            }
            finally {
                if (buffReader != null) {
                    try {
                        buffReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string3 = string2 = (string = content);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)uRL2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)uRL2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("UnifiedLoginHelper.java", Class.forName("com.documentum.fc.common.UnifiedLoginHelper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "isULSupportedByClient", "com.documentum.fc.common.UnifiedLoginHelper", "", "", "", "boolean"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getULUserSid", "com.documentum.fc.common.UnifiedLoginHelper", "", "", "", "java.lang.String"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getJVMVendor", "com.documentum.fc.common.UnifiedLoginHelper", "", "", "", "java.lang.String"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "buildDctmSid", "com.documentum.fc.common.UnifiedLoginHelper", "", "", "", "void"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "loadNTLoginModuleAndSidClass", "com.documentum.fc.common.UnifiedLoginHelper", "", "", "", "void"), 132);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getResourceContents", "com.documentum.fc.common.UnifiedLoginHelper", "java.net.URL:", "urlToRead:", "", "java.lang.String"), 194);
        ajc$tjp_6 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.common.UnifiedLoginHelper", "", "", ""), 25);
        s_DctmSid = null;
        s_isULSupported = null;
        s_loginModuleName = "DctmULSupportModuleNT";
        SUN_NTSID_IMPL_CONFIG = "com.sun.security.auth.NTSidUserPrincipal".intern();
        IBM_NTSID_IMPL_CONFIG = "com.ibm.security.auth.NTSidUserPrincipal".intern();
    }
}

