/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.client.DfAttributeValueException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.impl.MessageHelper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;

public class DfRuntimeException
extends RuntimeException {
    private MessageHelper m_messageHelper;
    private boolean m_insidePrintStackTrace;

    public static RuntimeException convertToRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof DfAttributeValueException) {
            IllegalArgumentException e2 = new IllegalArgumentException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            return e2;
        }
        if (e instanceof DfException && e.getCause() instanceof RuntimeException) {
            return (RuntimeException)e.getCause();
        }
        if (e instanceof DfException) {
            return new DfRuntimeException(((DfException)e).getMessageId(), ((DfException)e).getArguments(), e);
        }
        return new DfRuntimeException(e.getMessage(), e);
    }

    public static DfRuntimeException newUnexpectedException(Exception cause) {
        return new DfRuntimeException("DFC_CORE_UNEXPECTED_EXCEPTION", cause);
    }

    public static DfRuntimeException newNotInitializedException() {
        return new DfRuntimeException("DFC_CORE_NOT_INITIALIZED");
    }

    public static DfRuntimeException newFailedBofTransformationException(String name, Exception cause) {
        return new DfRuntimeException("DFC_BOF_FAILED_TRANSFORMATION", new Object[]{name}, cause);
    }

    public static DfRuntimeException newDefineClassFailedException(String name, URL url, Exception cause) {
        return new DfRuntimeException("DFC_BOF_DEFINE_CLASS_FAILED", new Object[]{name, url}, cause);
    }

    public static DfRuntimeException newPrivilegeIllegalForSBOException(String sboName) {
        return new DfRuntimeException("DFC_PRIVILEGE_ILLEGAL_FOR_SBO", new Object[]{sboName});
    }

    public static DfRuntimeException newInvalidPrivilegeMetadataException(String moduleName) {
        return new DfRuntimeException("DFC_PRIVILEGE_INVALID_METADATA", new Object[]{moduleName});
    }

    public DfRuntimeException() {
        this((String)null);
    }

    public DfRuntimeException(Throwable cause) {
        this(null, cause);
    }

    public DfRuntimeException(String message) {
        this(message, new Object[0]);
    }

    public DfRuntimeException(String message, Throwable cause) {
        this(message, new Object[0], cause);
    }

    public DfRuntimeException(String message, Object[] arguments) {
        this.doCommonConstruction(message, arguments);
    }

    public DfRuntimeException(String message, Object[] arguments, Throwable cause) {
        super(cause);
        this.doCommonConstruction(message, arguments);
    }

    private void doCommonConstruction(String message, Object[] arguments) {
        this.m_insidePrintStackTrace = false;
        this.m_messageHelper = new MessageHelper(message, arguments);
    }

    public synchronized String getMessage() {
        if (MessageHelper.shouldIncludeStackInMessage() && !this.m_insidePrintStackTrace) {
            return this.m_messageHelper.getMessageWithStack(this);
        }
        return this.m_messageHelper.getMessageWithoutStack();
    }

    public String getMessageId() {
        return this.m_messageHelper.getMessageId();
    }

    public Object[] getArguments() {
        return this.m_messageHelper.getArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintStream s) {
        boolean oldFlag = this.m_insidePrintStackTrace;
        try {
            this.m_insidePrintStackTrace = true;
            super.printStackTrace(s);
        }
        finally {
            this.m_insidePrintStackTrace = oldFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintWriter s) {
        boolean oldFlag = this.m_insidePrintStackTrace;
        try {
            this.m_insidePrintStackTrace = true;
            super.printStackTrace(s);
        }
        finally {
            this.m_insidePrintStackTrace = oldFlag;
        }
    }
}

