/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfLoginInfo;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.tracing.impl.Verbosity;
import com.documentum.fc.tracing.impl.annotation.TracingVerbosity;
import java.util.Date;

@TracingVerbosity(verbosity=Verbosity.NEVER)
public class DfPasswordEncoder {
    private static final String MAGIC_PREFACE = "_DCTM";
    private static final int CHECKSUM_LENGTH = 2;
    private static final int CHECKSUM_MASK = 255;
    private static final String CURRENT_VERSION = "01";
    private static final int ENCODING_RADIX = 16;
    private static final int PASSWORD_CHAR_LENGTH = 4;
    private static final int TIMEOUT_MS = 300000;
    private static final int TIMESTAMP_LENGTH = 8;
    private static final int XOR_KEY_LENGTH = 4;
    private static final int minimumEncodedLength = "_DCTM".length() + "01".length() + 4 + 2 + 8;

    public static IDfLoginInfo decode(IDfLoginInfo loginInfo) {
        String password = loginInfo.getPassword();
        String decodedPassword = DfPasswordEncoder.decode(password);
        if (!DfPasswordEncoder.isSameObject(password, password)) {
            loginInfo = new DfLoginInfo(loginInfo);
            loginInfo.setPassword(decodedPassword);
        }
        return loginInfo;
    }

    private static boolean isSameObject(Object o1, Object o2) {
        return o1 == o2;
    }

    public static String decode(String password) {
        try {
            if (password.length() < minimumEncodedLength) {
                return password;
            }
            if (!password.startsWith(MAGIC_PREFACE)) {
                return password;
            }
            String workingValue = password.substring(MAGIC_PREFACE.length());
            workingValue = new StringBuffer(workingValue).reverse().toString();
            int cursor = 0;
            if (!workingValue.startsWith(CURRENT_VERSION)) {
                return password;
            }
            String s = workingValue.substring(cursor += CURRENT_VERSION.length(), cursor + 4);
            int xorKey = Integer.parseInt(s, 16) ^ 0xBEEF;
            s = workingValue.substring(cursor += 4, cursor + 2);
            int checksum = Integer.parseInt(s, 16);
            s = workingValue.substring(cursor += 2, cursor + 8);
            long timeStamp = Long.parseLong(s, 16) * 1000L;
            cursor += 8;
            long currentTime = new Date().getTime();
            if (currentTime < timeStamp) {
                return password;
            }
            long earliestValidTimeStamp = currentTime - 300000L;
            if (timeStamp < earliestValidTimeStamp) {
                return password;
            }
            int calculatedChecksum = 0;
            int limit = workingValue.length();
            StringBuffer decodedValue = new StringBuffer();
            for (int i = cursor; i < limit; i += 4) {
                s = workingValue.substring(i, i + 4);
                int charValue = Integer.parseInt(s, 16);
                decodedValue.append((char)(charValue ^= xorKey));
                calculatedChecksum += charValue;
            }
            if (checksum != (calculatedChecksum & 0xFF)) {
                return password;
            }
            return decodedValue.toString();
        }
        catch (NumberFormatException e) {
            return password;
        }
    }
}

