/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfObject;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.IDfValue;
import java.util.Vector;

public final class DfList
extends DfObject
implements IDfList {
    private static int INITIAL_CAPACITY = 10;
    private Vector m_list;
    private int m_type;

    public DfList() {
        this(1024);
    }

    public DfList(int type) {
        this(type, INITIAL_CAPACITY);
    }

    public DfList(int type, int size) {
        this.m_list = new Vector(size);
        this.m_type = type;
    }

    public DfList(boolean[] list) throws DfException {
        this(0, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendBoolean(list[i]);
        }
    }

    public DfList(double[] list) throws DfException {
        this(5, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendDouble(list[i]);
        }
    }

    public DfList(int[] list) throws DfException {
        this(1, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendInt(list[i]);
        }
    }

    public DfList(IDfId[] list) throws DfException {
        this(3, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendId(list[i]);
        }
    }

    public DfList(IDfList list) throws DfException {
        DfList dfList = (DfList)list;
        this.m_list = (Vector)dfList.m_list.clone();
        this.m_type = dfList.m_type;
    }

    public DfList(IDfList[] list) throws DfException {
        this(4096, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendList(list[i]);
        }
    }

    public DfList(IDfTime[] list) throws DfException {
        this(4, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendTime(list[i]);
        }
    }

    public DfList(IDfValue[] list) throws DfException {
        this(1025, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendValue(list[i]);
        }
    }

    public DfList(Object[] list) throws DfException {
        this(1024, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.append(list[i]);
        }
    }

    public DfList(String[] list) throws DfException {
        this(2, list.length + INITIAL_CAPACITY);
        int limit = list.length;
        for (int i = 0; i < limit; ++i) {
            this.appendString(list[i]);
        }
    }

    public DfList(Vector v) {
        this.m_list = (Vector)v.clone();
        this.m_type = 1024;
    }

    public int append(Object value) throws DfException {
        return this.append(value, value == null ? this.m_type : DfList.getValueType(value));
    }

    private int append(Object value, int type) throws DfException {
        if (this.m_type != type && this.m_type != 1024) {
            throw new TypeMismatchForAddException(type);
        }
        this.m_list.addElement(value);
        return this.m_list.size();
    }

    public int appendBoolean(boolean value) throws DfException {
        return this.append(value ? Boolean.TRUE : Boolean.FALSE, 0);
    }

    public int appendDouble(double value) throws DfException {
        return this.append(new Double(value), 5);
    }

    public int appendId(IDfId value) throws DfException {
        return this.append(value, 3);
    }

    public int appendInt(int value) throws DfException {
        return this.append(new Integer(value), 1);
    }

    public int appendList(IDfList value) throws DfException {
        return this.append(value, 4096);
    }

    public int appendString(String value) throws DfException {
        return this.append(value, 2);
    }

    public int appendTime(IDfTime value) throws DfException {
        return this.append(value, 4);
    }

    public int appendValue(IDfValue value) throws DfException {
        return this.append(value, 1025);
    }

    public int findIndex(Object value) throws DfException {
        return this.m_list.indexOf(value);
    }

    public int findBooleanIndex(boolean value) throws DfException {
        return this.findIndex(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public int findDoubleIndex(double value) throws DfException {
        return this.findIndex(new Double(value));
    }

    public int findIdIndex(IDfId value) throws DfException {
        return this.findIndex(value);
    }

    public int findIntIndex(int value) throws DfException {
        return this.findIndex(new Integer(value));
    }

    public int findListIndex(IDfList value) throws DfException {
        return this.findIndex(value);
    }

    public int findStringIndex(String value) throws DfException {
        return this.findIndex(value);
    }

    public int findTimeIndex(IDfTime value) throws DfException {
        return this.findIndex(value);
    }

    public int findValueIndex(IDfValue value) throws DfException {
        return this.findIndex(value);
    }

    public Object get(int index) {
        return this.m_list.elementAt(index);
    }

    public boolean getBoolean(int index) throws DfException {
        try {
            return (Boolean)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(0);
        }
    }

    public int getCount() {
        return this.m_list.size();
    }

    public double getDouble(int index) throws DfException {
        try {
            return (Double)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(5);
        }
    }

    public int getElementType() {
        return this.m_type;
    }

    public int getElementTypeAt(int index) throws DfException {
        return DfList.getValueType(this.get(index));
    }

    public IDfId getId(int index) throws DfException {
        try {
            return (IDfId)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(3);
        }
    }

    public int getInt(int index) throws DfException {
        try {
            return (Integer)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(1);
        }
    }

    public IDfList getList(int index) throws DfException {
        try {
            return (IDfList)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(4096);
        }
    }

    public String getString(int index) throws DfException {
        try {
            return (String)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(2);
        }
    }

    public IDfTime getTime(int index) throws DfException {
        try {
            return (IDfTime)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(4);
        }
    }

    public IDfValue getValue(int index) throws DfException {
        try {
            return (IDfValue)this.get(index);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchForGetException(1025);
        }
    }

    private static int getValueType(Object value) {
        Class<?> klass = value.getClass();
        if (klass.equals(String.class)) {
            return 2;
        }
        if (klass.equals(Integer.class)) {
            return 1;
        }
        if (klass.equals(Boolean.class)) {
            return 0;
        }
        if (klass.equals(DfId.class)) {
            return 3;
        }
        if (klass.equals(DfTime.class)) {
            return 4;
        }
        if (klass.equals(DfList.class)) {
            return 4096;
        }
        if (klass.equals(DfValue.class)) {
            return 1025;
        }
        if (klass.equals(Double.class)) {
            return 5;
        }
        return 1024;
    }

    public void insert(int index, Object value) throws DfException {
        this.insert(index, value, DfList.getValueType(value));
    }

    private void insert(int index, Object value, int type) throws DfException {
        if (this.m_type != type && this.m_type != 1024) {
            throw new TypeMismatchForAddException(type);
        }
        this.m_list.insertElementAt(value, index);
    }

    public void insertAll(int index, IDfList list) throws DfException {
        int type = list.getElementType();
        int limit = list.getCount();
        for (int i = 0; i < limit; ++i) {
            this.insert(index + i, list.get(i), type);
        }
    }

    public void insertBoolean(int index, boolean value) throws DfException {
        this.insert(index, value ? Boolean.TRUE : Boolean.FALSE, 0);
    }

    public void insertDouble(int index, double value) throws DfException {
        this.insert(index, new Double(value), 5);
    }

    public void insertId(int index, IDfId value) throws DfException {
        this.insert(index, value, 3);
    }

    public void insertInt(int index, int value) throws DfException {
        this.insert(index, new Integer(value), 1);
    }

    public void insertList(int index, IDfList value) throws DfException {
        this.insert(index, value, 4096);
    }

    public void insertString(int index, String value) throws DfException {
        this.insert(index, value, 2);
    }

    public void insertTime(int index, IDfTime value) throws DfException {
        this.insert(index, value, 4);
    }

    public void insertValue(int index, IDfValue value) throws DfException {
        this.insert(index, value, 1025);
    }

    public void remove(int index) throws DfException {
        this.m_list.removeElementAt(index);
    }

    public void removeAll() {
        this.m_list.removeAllElements();
    }

    public void set(int index, Object value) throws DfException {
        this.set(index, value, DfList.getValueType(value));
    }

    private void set(int index, Object value, int type) throws DfException {
        if (this.m_type != type && this.m_type != 1024) {
            throw new TypeMismatchForAddException(type);
        }
        this.m_list.setElementAt(value, index);
    }

    public void setBoolean(int index, boolean value) throws DfException {
        this.set(index, value ? Boolean.TRUE : Boolean.FALSE, 0);
    }

    public void setDouble(int index, double value) throws DfException {
        this.set(index, new Double(value), 5);
    }

    public void setElementType(int type) {
        if (type != this.m_type) {
            this.removeAll();
        }
        this.m_type = type;
    }

    public void setId(int index, IDfId value) throws DfException {
        this.set(index, value, 3);
    }

    public void setInt(int index, int value) throws DfException {
        this.set(index, new Integer(value), 1);
    }

    public void setList(int index, IDfList value) throws DfException {
        this.set(index, value, 4096);
    }

    public void setString(int index, String value) throws DfException {
        this.set(index, value, 2);
    }

    public void setTime(int index, IDfTime value) throws DfException {
        this.set(index, value, 4);
    }

    public void setValue(int index, IDfValue value) throws DfException {
        this.set(index, value, 1025);
    }

    private class TypeMismatchForGetException
    extends DfException {
        TypeMismatchForGetException(int type) {
            super(546, DfUtil.getTypeString(type), DfUtil.getTypeString(DfList.this.m_type), null);
        }
    }

    private class TypeMismatchForAddException
    extends DfException {
        TypeMismatchForAddException(int type) {
            super(545, DfUtil.getTypeString(DfList.this.m_type), DfUtil.getTypeString(type), null);
        }
    }
}

