/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.common;

import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfProperties;
import com.documentum.fc.common.DfcMessages;
import com.documentum.fc.common.IDfException;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfProperties;
import com.documentum.fc.common.impl.ExceptionCompatability;
import com.documentum.fc.common.impl.MessageHelper;
import com.documentum.fc.common.impl.documentation.Visibility;
import com.documentum.fc.common.impl.documentation.VisibilityType;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Visibility(visibility=VisibilityType.PUBLIC)
public class DfException
extends Exception
implements IDfException {
    private int m_errorCode;
    private String m_threadName;
    private DfException m_nextException;
    private DfProperties m_properties;
    private MessageHelper m_messageHelper;
    private boolean m_insidePrintStackTrace;
    private static final String THREAD = ":: THREAD: ";
    private static final String ERRORCODE = "; ERRORCODE: ";
    private static final String MSG = "; MSG: ";
    private static final String NEXT = "; NEXT: ";
    private static final Map<String, DfException> s_savedExceptions = Collections.synchronizedMap(new HashMap());

    public static DfException newNoIdException(String api) {
        return new DfException("DM_API_E_NOID", new Object[]{api});
    }

    public static DfException newBadIdException(IDfId id) {
        return new DfException("DM_API_E_BADID", new Object[]{id});
    }

    public static DfException newBadDateException(String value, String pattern) {
        return new DfException("DM_API_E_BADDATE", new Object[]{value, pattern});
    }

    public static DfException newBadDocbaseScopeIdException(long docbaseId) {
        String docbaseIdStr = String.valueOf(docbaseId).replace(",", "");
        return new DfException("DM_API_E_DOCBASE_SCOPE_ID", new Object[]{docbaseIdStr});
    }

    public static DfException newBadTypeException(String typeName) {
        return new DfException("DM_API_E_NOTYPE", new Object[]{typeName});
    }

    public static DfException newBadDataTypeException(int dataType) {
        return new DfException("DM_DFC_E_BAD_DATATYPE", new Object[]{dataType});
    }

    public static DfException newApiBadType(IDfId componentId, String typeName) {
        return new DfException("DM_API_E_BAD_TYPE", new Object[]{componentId, typeName});
    }

    public static DfException newBadClassException(String className, String baseClassName, Throwable cause) {
        return new DfException("DM_DFC_E_BAD_CLASS", new Object[]{className, baseClassName}, cause);
    }

    public static DfException newClassNotFoundException(String className, Throwable cause) {
        return new DfException("DM_DFC_E_CLASS_NOT_FOUND", new Object[]{className}, cause);
    }

    public static DfException newProxyInstantiateFailedException(String className, Throwable cause) {
        return new DfException("DFC_BOF_PROXY_INSTANTIATE_FAILED", new Object[]{className}, cause);
    }

    public static DfException newReplicaAspectGenerationFailed(String className, Throwable cause) {
        return new DfException("DFC_BOF_REPLICA_ASPECT_GENERATION_FAILED", new Object[]{className}, cause);
    }

    public static DfException newIllegalSBOAccessException(String sboName) {
        return new DfException("DFC_BOF_ILLEGAL_SBO_ACCESS", new Object[]{sboName});
    }

    public static DfException newCantApplyException(String methodName) {
        return new DfException("DFC_SESSION_CANT_APPLY", new Object[]{methodName});
    }

    public static DfException newCantFetchInvalidId(String objectId) {
        return new DfException("DM_SYSOBJECT_E_CANT_FETCH_INVALID_ID", new Object[]{objectId});
    }

    public static DfException newSerializeFailedException(Object object, Throwable cause) {
        return new DfException("DFC_CORE_SERIALIZE_FAILED", new Object[]{object}, cause);
    }

    public static DfException newDeserializeFailedException(String serializedValue, Throwable cause) {
        return new DfException("DFC_CORE_DESERIALIZE_FAILED", new Object[]{serializedValue}, cause);
    }

    public static DfException newMultipleObjectsQualify(String predicate, String docbaseName) {
        return new DfException("DFC_SESSION_MULTIPLE_OBJECTS_QUALIFY", new Object[]{predicate, docbaseName});
    }

    public static DfException newIllegalDateFormatException(String value) {
        return new DfException("DM_LOCALE_W_ILLEGAL_DATE_FORMAT", new Object[]{value});
    }

    public static DfException newMaterializationOptionMismatchException(IDfId objectId) {
        return new DfException("DFC_LITEOBJ_MAT_OPTION_MISMATCH", new Object[]{objectId.getId()});
    }

    public static DfException newTransactionActiveException() {
        return new DfException("DFC_SESSION_TRANSACTION_ACTIVE", new Object[0]);
    }

    public static DfException newTransactionLostException() {
        return new DfException("DFC_SESSION_TRANSACTION_LOST", new Object[0]);
    }

    public static DfException newDynamicGroupUpdateException() {
        return new DfException("DM_API_E_DYNAMIC_GROUP_UPDATE", new Object[0]);
    }

    public static DfException newCantWithOpenTranException(String operationName) {
        return new DfException("DM_API_E_CANT_WITH_OPEN_TRAN", new Object[]{operationName});
    }

    public static DfException newBadFlushArgException(String flushType) {
        return new DfException("DM_API_E_FLUSH_BAD_ARG", new Object[]{flushType});
    }

    public static DfException newFlushDDCacheNoKeyException() {
        return new DfException("DM_API_E_FLUSH_DD_CACHE_NO_KEY", new Object[0]);
    }

    public static DfException newFlushDDCacheBadKeyException(String cacheKey) {
        return new DfException("DM_API_E_FLUSH_DD_CACHE_BAD_KEY", new Object[]{cacheKey});
    }

    public static DfException newFlushRegistryCacheNoKeyException() {
        return new DfException("DM_API_E_FLUSH_REGISTRY_CACHE_NO_KEY", new Object[0]);
    }

    public static DfException newInvalidTypeException(String typeName, IDfId objectId, String requiredTypeName) {
        return new DfException("DM_SYSOBJECT_E_INVALID_TYPE", new Object[]{typeName, objectId, requiredTypeName});
    }

    public static DfException newInvalidNewObjectException(String typeName) {
        return new DfException("DM_API_E_INVALID_TYPE_CREATE", new Object[]{typeName});
    }

    public static DfException newInvalidAspectName(String aspectName) {
        return new DfException("DFC_BOF_INVALID_ASPECT_NAME", new Object[]{aspectName});
    }

    public static DfException newCannotDestroyAspect(String aspectName) {
        return new DfException("DFC_BOF_CANNOT_DESTROY_ASPECT", new Object[]{aspectName});
    }

    public static DfException newAlreadyMaterializedException(IDfId objectId) {
        return new DfException("DFC_LITEOBJ_MAT_BEFORE", new String[]{objectId.getId()});
    }

    public static DfException newQueryFailException(String dql, Throwable cause) {
        return new DfException("DM_API_E_QUERY_FAIL", new Object[]{dql}, cause);
    }

    public static DfException newQuerySessionClosedException() {
        return new DfException("DFC_QUERY_SESSION_CLOSED", new Object[0]);
    }

    public static DfException newAspectMissingPropertyBag(String aspectName, IDfId objId, String typeName) {
        return new DfException("DFC_BOF_ASPECT_NO_PROPBAG", new Object[]{aspectName, typeName, objId.getId()}, null);
    }

    public static DfException newInvalidDefaultValue(String typeName, String attrName, String defaultValue) {
        return new DfException("DFC_TYPE_INVALID_DEFAULT_VALUE");
    }

    public static DfException newRetentionOnParkedContentDisabled() {
        return new DfException("DM_CONT_RETENTION_ON_PARKED_CONTENT_DISABLED");
    }

    public static DfException newAuditTrailOutOfRangeException(int valueIndex, String attributeName, int count) {
        return new DfException("DM_AUDITTRAIL_E_OUT_OF_RANGE", new String[]{String.valueOf(valueIndex), attributeName, "0", String.valueOf(count - 1)});
    }

    public static DfException newNoEventNameException(String commandName) {
        return new DfException("DM_API_E_NO_EVENT_NAME", new String[]{commandName});
    }

    public static DfException newDecodingFailedException(String tokenName, String tokenValue, Throwable cause) {
        return new DfException("DM_API_E_DECODING_FAILED", new String[]{tokenName, tokenValue}, cause);
    }

    public static DfException newUnsupportedLoginTicketObjectVersionException(int version) {
        return new DfException("DFC_SECURITY_UNSUPPORTED_LOGIN_TICKET_OBJECT_VERSION", new String[]{Integer.toString(version)});
    }

    public static DfException newNoCacheNameException() {
        return new DfException("DM_API_E_NO_CACHE_NAME", new Object[0]);
    }

    public static DfException newWrongCacheNameException(String cacheName) {
        return new DfException("DM_API_E_WRONG_CACHE_NAME", new Object[]{cacheName});
    }

    public static DfException newUpdateBadAttrException(String attributeName) {
        return new DfException("DM_API_E_UPDATE_BAD_ATTR", new Object[]{attributeName});
    }

    public static DfException newFailedPolicyUpdateException(Throwable cause) {
        return new DfException("DFC_SECURITY_FAILED_POLICY_UPDATE", new Object[0], cause);
    }

    public static DfException newCantExportDirtyObjectException(IDfId id) {
        return new DfException("DFC_FULLTEXT_CANT_EXPORT_DIRTY_OBJECT", new Object[]{id});
    }

    public static DfException newNoCacheTypeNameException() {
        return new DfException("DM_API_E_ISCACHED_NO_CACHE_NAME");
    }

    public static DfException newBadCacheTypeNameException(String cacheTypeName) {
        return new DfException("DM_API_E_ISCACHED_BAD_CACHE_NAME", new Object[]{cacheTypeName});
    }

    public static DfException newNoCacheKeyException() {
        return new DfException("DM_API_E_ISCACHED_NO_CACHE_KEY");
    }

    public static DfException newCannotChangeSharedParentException() {
        return new DfException("DFC_LWO_CANT_CHANGE_SHARED_PARENT");
    }

    public static DfException noLightweightParentTypeException(String lwTypeName) {
        return new DfException("DFC_LWO_NO_SHARED_PARENT_TYPE", new Object[]{lwTypeName});
    }

    public static DfException notShareableParentTypeException(String lwTypeName) {
        return new DfException("DFC_LWO_NOT_SHAREABLE_PARENT_TYPE", new Object[]{lwTypeName});
    }

    public static DfException materializedLightObjectException(IDfId id) {
        return new DfException("DFC_LWO_MATERIALIZED_LIGHT_OBJECT", new Object[]{id});
    }

    public DfException() {
        this("");
    }

    public DfException(Throwable cause) {
        this("", cause);
    }

    public DfException(String message) {
        this(message, new Object[0]);
    }

    public DfException(String message, Throwable cause) {
        this(message, new Object[0], cause);
    }

    public DfException(String message, Object[] arguments) {
        this(new MessageHelper(message, arguments));
    }

    public DfException(String message, Object[] arguments, Throwable cause) {
        this(new MessageHelper(message, arguments), cause);
    }

    public DfException(MessageHelper messageHelper) {
        this.doCommonConstruction(messageHelper);
    }

    public DfException(MessageHelper messageHelper, Throwable cause) {
        super(cause);
        this.doCommonConstruction(messageHelper);
    }

    protected DfException(DfException originalException) {
        this(originalException.getMessageHelper());
        this.setStackTrace(originalException.getStackTrace());
    }

    private void doCommonConstruction(MessageHelper messageHelper) {
        this.m_insidePrintStackTrace = false;
        this.m_messageHelper = messageHelper;
        this.m_properties = null;
        this.m_nextException = null;
        this.m_threadName = Thread.currentThread().getName();
        this.m_errorCode = ExceptionCompatability.mapMessageIdToErrorCode(this.m_messageHelper.getMessageId());
    }

    public DfException(int errorCode) {
        this(ExceptionCompatability.mapErrorCodeToMessageId(errorCode), new Object[0]);
        this.m_errorCode = errorCode;
    }

    public DfException(int errorCode, String message) {
        this(message);
        this.m_errorCode = errorCode;
    }

    public DfException(int errorCode, String arg1, String arg2, String arg3) {
        this(ExceptionCompatability.mapErrorCodeToMessageId(errorCode), new Object[]{arg1, arg2, arg3});
        this.m_errorCode = errorCode;
    }

    public DfException(ResourceBundle bundle, int errorCode) {
        this(new MessageHelper(ExceptionCompatability.mapErrorCodeToMessageId(errorCode), new Object[0], bundle));
        this.m_errorCode = errorCode;
    }

    public DfException(ResourceBundle bundle, int errorCode, String arg1, String arg2, String arg3) {
        this(new MessageHelper(ExceptionCompatability.mapErrorCodeToMessageId(errorCode), new Object[]{arg1, arg2, arg3}, bundle));
        this.m_errorCode = errorCode;
    }

    protected final MessageHelper getMessageHelper() {
        return this.m_messageHelper;
    }

    public synchronized String getMessage() {
        if (MessageHelper.shouldIncludeStackInMessage() && !this.m_insidePrintStackTrace) {
            return this.m_messageHelper.getMessageWithStack(this);
        }
        return this.m_messageHelper.getMessageWithoutStack();
    }

    public String getMessageId() {
        return this.m_messageHelper.getMessageId();
    }

    public Object[] getArguments() {
        return this.m_messageHelper.getArguments();
    }

    public final void setMessage(String message) {
        this.m_messageHelper.setMessage(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintStream s) {
        boolean oldFlag = this.m_insidePrintStackTrace;
        try {
            this.m_insidePrintStackTrace = true;
            super.printStackTrace(s);
            if (this.m_nextException != null) {
                s.print("Followed by: ");
                this.m_nextException.printStackTrace(s);
            }
        }
        finally {
            this.m_insidePrintStackTrace = oldFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintWriter s) {
        boolean oldFlag = this.m_insidePrintStackTrace;
        try {
            this.m_insidePrintStackTrace = true;
            super.printStackTrace(s);
            if (this.m_nextException != null) {
                s.print("Followed by: ");
                this.m_nextException.printStackTrace(s);
            }
        }
        finally {
            this.m_insidePrintStackTrace = oldFlag;
        }
    }

    public final int getErrorCode() {
        return this.m_errorCode;
    }

    public final void setErrorCode(int errorCode) {
        this.setMessage(ExceptionCompatability.mapErrorCodeToMessageId(errorCode));
        this.m_errorCode = errorCode;
    }

    protected final void setErrorCodeRaw(int errorCode) {
        this.m_errorCode = errorCode;
    }

    public final String getThreadInfo() {
        return this.m_threadName;
    }

    public final int getCount() {
        int count = 0;
        for (IDfException e = this; e != null; e = e.getNextException()) {
            ++count;
        }
        return count;
    }

    public final IDfException getNextException() {
        return this.m_nextException;
    }

    public final void setNextException(DfException nextException) {
        if (nextException == this) {
            throw new IllegalArgumentException("Can't reference self as next exception");
        }
        this.m_nextException = nextException;
    }

    public final synchronized IDfException getTailException() {
        IDfException candidate = this;
        while (candidate.getNextException() != null) {
            candidate = candidate.getNextException();
        }
        return candidate;
    }

    public synchronized IDfProperties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new DfProperties();
        }
        return this.m_properties;
    }

    public String getStackTraceAsString() {
        return MessageHelper.getStackTraceAsString(this);
    }

    public String toString() {
        if (MessageHelper.shouldIncludeDecorationInToString()) {
            return this.toStringForCOM();
        }
        return super.toString();
    }

    public String toStringForCOM() {
        String result = this.getSimpleClassName() + THREAD + this.getThreadInfo() + MSG + this.getMessage() + ERRORCODE + Integer.toHexString(this.m_errorCode) + NEXT + (this.getNextException() != null ? this.getNextException().toString() : "null");
        s_savedExceptions.put(this.getThreadInfo(), this);
        return result;
    }

    private String getSimpleClassName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static void registerResourceBundle(ResourceBundle bundle) {
        MessageHelper.registerResourceBundle(bundle);
    }

    public static DfException appendException(DfException exptHead, DfException e, int stopAfterNumOfErrors) throws DfException {
        if (exptHead == null) {
            return e;
        }
        if (e != exptHead) {
            ((DfException)exptHead.getTailException()).setNextException(e);
        }
        if (stopAfterNumOfErrors > 0 && stopAfterNumOfErrors <= exptHead.getCount()) {
            throw exptHead;
        }
        return exptHead;
    }

    public static IDfException parseException(String exceptionString) {
        DfException candidate;
        String threadName = Thread.currentThread().getName();
        if (exceptionString.indexOf(THREAD) >= 0) {
            int start = exceptionString.indexOf(THREAD) + THREAD.length();
            int end = exceptionString.indexOf(MSG);
            threadName = exceptionString.substring(start, end);
        }
        if ((candidate = s_savedExceptions.get(threadName)) != null && exceptionString.startsWith(candidate.toStringForCOM())) {
            return candidate;
        }
        return new DfException(exceptionString);
    }

    public static synchronized void setIncludeStackTraceInMsg(boolean value) {
        DfPreferences.getInstance().setIncludeExceptionStack(value);
    }

    public static DfException convert(Exception e) {
        if (e instanceof DfException) {
            return (DfException)e;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof DfException && e.getMessage().equals(cause.getMessage())) {
            return (DfException)cause;
        }
        return new DfException(e.getMessage(), (Throwable)e);
    }

    static {
        try {
            DfException.registerResourceBundle(DfcMessages.getResourceBundle());
        }
        catch (MissingResourceException e) {
            DfLogger.error(DfException.class, e.getMessage(), null, (Throwable)e);
        }
    }
}

