/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.internal;

import com.documentum.fc.client.security.IDfAuthenticationInfo;
import com.documentum.fc.client.security.internal.AuthenticationInfo;
import com.documentum.fc.client.security.internal.IAuthenticationMgr;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import com.documentum.operations.common.DfBase64Decoder;
import com.documentum.operations.common.DfBase64Encoder;
import com.documentum.operations.common.DfBase64FormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class AuthenticationMgr
implements IAuthenticationMgr {
    public static final String NOT_B64_DIGIT_REGEX = "[^A-Za-z0-9+/=]";
    public static final String NOT_HEX_DIGIT_REGEX = "[^a-fA-F0-9]";
    public static final String NOT_SIGNED_DIGIT_REGEX = "[^\\-\\+0-9]";
    protected static final String FQDN_HOSTNAME_REGEX = "(([a-zA-Z0-9][a-zA-Z0-9\\_\\-]*)(\\.[a-zA-Z0-9][a-zA-Z0-9\\_\\-]*)+)";
    protected static final String HOSTNAME_REGEX = "(([a-zA-Z0-9][a-zA-Z0-9\\_\\-]*)([\\.]?[a-zA-Z0-9][a-zA-Z0-9\\_\\-]*)+)";
    public static final Pattern m_hostnameRegex;
    public static final boolean IS_TIMESTAMP_HEX_ENCODED = false;
    private String m_identity;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    public AuthenticationMgr(String identity) throws DfException {
        String string = identity;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_identity = "";
            AuthenticationMgr.vetIdentity(identity);
            DfLogger.info((Object)this, "identity for authentication is {0}", new Object[]{identity}, null);
            this.m_identity = identity;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String createIdentityBundle(String string, String string2) throws DfException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            String string5;
            String string6;
            void customData;
            void hostName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == hostName || 0 == hostName.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"empty hostname field"});
            }
            Matcher m_matcher = m_hostnameRegex.matcher((CharSequence)hostName);
            String matched = null;
            String unmatched = null;
            if (m_matcher.matches()) {
                matched = m_matcher.group(1);
                unmatched = hostName.replace(matched, "");
            }
            if (null == matched || 0 != unmatched.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"bad hostname field"});
            }
            if (null != customData && 0 < customData.length() && customData.matches(NOT_B64_DIGIT_REGEX)) {
                throw new DfException("DFC_SECURITY_BASE64", new Object[]{"custom data"});
            }
            AuthenticationMgr.vetIdentity(this.m_identity);
            GregorianCalendar gmtCalendar = new GregorianCalendar();
            Long timeStamp = gmtCalendar.getTimeInMillis();
            timeStamp = timeStamp / 1000L;
            String raw = null;
            raw = AuthenticationMgr.buildRaw((String)hostName, this.m_identity, (String)customData, Long.toString(timeStamp));
            String mda = "SHA1withRSA";
            byte[] ds = AuthenticationMgr.digitallySign(raw, mda, this.getPrivateKey());
            ByteArrayInputStream bais = new ByteArrayInputStream(ds);
            ByteArrayOutputStream baos = AuthenticationMgr.encodeBase64(bais);
            String aux = baos.toString();
            String digitalSignature = aux.replaceAll("\n", "");
            if (digitalSignature.matches(NOT_B64_DIGIT_REGEX)) {
                throw new DfCriticalException("DFC_SECURITY_BASE64", new Object[]{"RFC4648 encoder compliance"});
            }
            String string7 = string6 = (string5 = AuthenticationMgr.buildBundle((String)hostName, this.m_identity, (String)customData, Long.toString(timeStamp), digitalSignature));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string6, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean verifyDigitalSignature(IDfAuthenticationInfo iDfAuthenticationInfo) throws DfException {
        IDfAuthenticationInfo iDfAuthenticationInfo2 = iDfAuthenticationInfo;
        JoinPoint joinPoint = null;
        try {
            void info;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = AuthenticationMgr.sVerifyDigitalSignature((IDfAuthenticationInfo)info, this.getPublicCertificate()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iDfAuthenticationInfo2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sVerifyDigitalSignature(IDfAuthenticationInfo iDfAuthenticationInfo, Certificate certificate) throws DfException {
        IDfAuthenticationInfo iDfAuthenticationInfo2 = iDfAuthenticationInfo;
        Certificate certificate2 = certificate;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            void cert;
            IDfAuthenticationInfo info;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)iDfAuthenticationInfo2, (Object)certificate2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String mda = "SHA1withRSA";
            DfLogger.debug(AuthenticationMgr.class, "verifying signature <{0}> on raw <{1}> with algo {2}", new Object[]{info.getDigitalSignature(), info.getRaw(), mda}, null);
            ByteArrayInputStream bais = new ByteArrayInputStream(info.getDigitalSignature().getBytes());
            ByteArrayOutputStream underTest = AuthenticationMgr.decodeBase64(bais);
            boolean retVal = AuthenticationMgr.verifySignature(info.getRaw(), mda, (Certificate)cert, underTest.toByteArray());
            DfLogger.debug(AuthenticationMgr.class, "signature is OK: {0}", new Object[]{retVal}, null);
            boolean bl3 = bl2 = (bl = retVal);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)iDfAuthenticationInfo2, (Object)certificate2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)iDfAuthenticationInfo2, (Object)certificate2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IDfAuthenticationInfo createAuthenticationInfo(String string, String string2) throws DfException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            void customData;
            void hostName;
            IDfAuthenticationInfo iDfAuthenticationInfo;
            IDfAuthenticationInfo iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfAuthenticationInfo iDfAuthenticationInfo3 = iDfAuthenticationInfo2 = (iDfAuthenticationInfo = this.createAuthenticationInfo(this.createIdentityBundle((String)hostName, (String)customData)));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo2, joinPoint);
            }
            return iDfAuthenticationInfo;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IDfAuthenticationInfo createAuthenticationInfo(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void identityBundle;
            IDfAuthenticationInfo iDfAuthenticationInfo;
            IDfAuthenticationInfo iDfAuthenticationInfo2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IDfAuthenticationInfo iDfAuthenticationInfo3 = iDfAuthenticationInfo2 = (iDfAuthenticationInfo = AuthenticationMgr.sCreateAuthenticationInfo((String)identityBundle));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iDfAuthenticationInfo2, joinPoint);
            }
            return iDfAuthenticationInfo;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static IDfAuthenticationInfo sCreateAuthenticationInfo(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            AuthenticationInfo authenticationInfo;
            AuthenticationInfo authenticationInfo2;
            String identityBundle;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == identityBundle || 0 == identityBundle.length()) {
                throw new IllegalArgumentException();
            }
            String[] bundleField = identityBundle.split("\t");
            if (5 != bundleField.length) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"missing field(s)"});
            }
            String typedIdentityHash = bundleField[0];
            IDfAuthenticationInfo.AuthenticationType t = AuthenticationMgr.vetIdentity(typedIdentityHash);
            long ts = 0L;
            try {
                ts = Long.parseLong(bundleField[1]);
            }
            catch (NumberFormatException e) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"timestamp format"}, e);
            }
            if (ts > 6148914691236517L) {
                throw new IllegalArgumentException("invalid timestamp -- too large");
            }
            Long timeStamp = new Long(ts *= 1000L);
            String hostName = bundleField[2];
            if (null == hostName || 0 == hostName.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"empty hostname field"});
            }
            Matcher m_matcher = m_hostnameRegex.matcher(hostName);
            String matched = null;
            String unmatched = null;
            if (m_matcher.matches()) {
                matched = m_matcher.group(1);
                unmatched = hostName.replace(matched, "");
            }
            if (null == matched || 0 != unmatched.length()) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"bad hostname field"});
            }
            String customData = bundleField[3];
            if (null != customData && 0 < customData.length() && customData.matches(NOT_B64_DIGIT_REGEX)) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"custom data encoding"});
            }
            String digitalSignature = bundleField[4];
            if (null == digitalSignature || 0 == digitalSignature.length() || digitalSignature.matches(NOT_B64_DIGIT_REGEX)) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY_BUNDLE", new Object[]{"digital signature encoding"});
            }
            String raw = AuthenticationMgr.buildRaw(hostName, typedIdentityHash, customData, bundleField[1]);
            AuthenticationInfo authenticationInfo3 = authenticationInfo2 = (authenticationInfo = new AuthenticationInfo(hostName, typedIdentityHash, customData, digitalSignature, timeStamp, raw, t));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(authenticationInfo2, joinPoint);
            }
            return authenticationInfo;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static IDfAuthenticationInfo.AuthenticationType vetIdentity(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            IDfAuthenticationInfo.AuthenticationType authenticationType;
            IDfAuthenticationInfo.AuthenticationType authenticationType2;
            IDfAuthenticationInfo.AuthenticationType t;
            String typedIdentityHash;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == typedIdentityHash) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY", new Object[]{"null identity"});
            }
            int sepIx = typedIdentityHash.indexOf(95);
            if (-1 == sepIx) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY", new Object[]{"untyped identity"});
            }
            String identityHash = typedIdentityHash.substring(sepIx + 1).trim();
            String typePrefix = typedIdentityHash.substring(0, sepIx + 1).trim();
            if (null == identityHash || 0 == identityHash.length() || identityHash.matches(NOT_SIGNED_DIGIT_REGEX)) {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY", new Object[]{"bad m_identity field"});
            }
            if ("acs_".equals(typePrefix)) {
                t = IDfAuthenticationInfo.AuthenticationType.ACS;
            } else if ("dfc_".equals(typePrefix)) {
                t = IDfAuthenticationInfo.AuthenticationType.DFC;
            } else if ("bocs_".equals(typePrefix)) {
                t = IDfAuthenticationInfo.AuthenticationType.BOCS;
            } else {
                throw new DfException("DFC_SECURITY_MALFORMED_IDENTITY", new Object[]{"unrecognized type in identity field"});
            }
            IDfAuthenticationInfo.AuthenticationType authenticationType3 = authenticationType2 = (authenticationType = t);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1((Object)authenticationType2, joinPoint);
            }
            return authenticationType;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String buildRaw(String string, String string2, String string3, String string4) {
        String string5 = string;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        JoinPoint joinPoint = null;
        try {
            String string9;
            String string10;
            void timeStamp;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string5, string6, string7, string8};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (!timeStamp.matches(NOT_SIGNED_DIGIT_REGEX));
            StringBuffer rawBuf = new StringBuffer(200);
            block8: for (int i = 0; i < 4; ++i) {
                if (4 < i) {
                    throw new IllegalStateException("guard - should never get here");
                }
                switch (i) {
                    case 0: {
                        void identityHash;
                        rawBuf.append((String)identityHash);
                        rawBuf.append('\t');
                        continue block8;
                    }
                    case 1: {
                        rawBuf.append((String)timeStamp);
                        rawBuf.append('\t');
                        continue block8;
                    }
                    case 2: {
                        String hostName;
                        rawBuf.append(hostName);
                        rawBuf.append('\t');
                        continue block8;
                    }
                    case 3: {
                        void customData;
                        if (null != customData && 0 < customData.length()) {
                            rawBuf.append((String)customData);
                        }
                        rawBuf.append('\t');
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("guard - should never get here");
                    }
                }
            }
            rawBuf.setLength(rawBuf.length() - 1);
            String string11 = string10 = (string9 = rawBuf.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string5, string6, string7, string8};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string10, joinPoint);
            }
            return string9;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string5, string6, string7, string8};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String buildBundle(String string, String string2, String string3, String string4, String string5) {
        String string6 = string;
        String string7 = string2;
        String string8 = string3;
        String string9 = string4;
        String string10 = string5;
        JoinPoint joinPoint = null;
        try {
            String string11;
            String string12;
            void digitalSignature;
            void customData;
            void identityHash;
            String hostName;
            void timeStamp;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string6, string7, string8, string9, string10};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (!timeStamp.matches(NOT_SIGNED_DIGIT_REGEX));
            String raw = AuthenticationMgr.buildRaw(hostName, (String)identityHash, (String)customData, (String)timeStamp);
            StringBuffer bundle = new StringBuffer(raw.length() + digitalSignature.length() + 50);
            bundle.append(raw);
            bundle.append('\t');
            bundle.append((String)digitalSignature);
            String retVal = bundle.toString();
            DfLogger.info(AuthenticationMgr.class, "new identity bundle <{0}>", new Object[]{retVal}, null);
            String string13 = string12 = (string11 = retVal);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string6, string7, string8, string9, string10};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string12, joinPoint);
            }
            return string11;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string6, string7, string8, string9, string10};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] digitallySign(String string, String string2, PrivateKey privateKey) throws DfException {
        String string3 = string;
        String string4 = string2;
        PrivateKey privateKey2 = privateKey;
        JoinPoint joinPoint = null;
        try {
            byte[] byArray;
            byte[] byArray2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, privateKey2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            java.security.Signature sig = null;
            try {
                String raw;
                void key;
                void mda;
                sig = java.security.Signature.getInstance((String)mda);
                sig.initSign((PrivateKey)key);
                sig.update(raw.getBytes());
                byArray2 = sig.sign();
            }
            catch (NoSuchAlgorithmException e) {
                throw new DfException(e);
            }
            catch (InvalidKeyException e) {
                throw new DfException(e);
            }
            catch (SignatureException e) {
                throw new DfException(e);
            }
            byte[] byArray3 = byArray = byArray2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, privateKey2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byArray, joinPoint);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, privateKey2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean verifySignature(String string, String string2, Certificate certificate, byte[] byArray) throws DfException {
        String string3 = string;
        String string4 = string2;
        Certificate certificate2 = certificate;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, certificate2, byArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            java.security.Signature sig = null;
            try {
                void signature;
                String raw;
                void cert;
                void mda;
                sig = java.security.Signature.getInstance((String)mda);
                sig.initVerify((Certificate)cert);
                sig.update(raw.getBytes());
                bl2 = sig.verify((byte[])signature);
            }
            catch (NoSuchAlgorithmException e) {
                throw new DfException(e);
            }
            catch (InvalidKeyException e) {
                throw new DfException(e);
            }
            catch (SignatureException e) {
                throw new DfException(e);
            }
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, certificate2, byArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, string4, certificate2, byArray2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected abstract PrivateKey getPrivateKey() throws DfException;

    public abstract Certificate getPublicCertificate() throws DfException;

    public static ByteArrayOutputStream encodeBase64(ByteArrayInputStream byteArrayInputStream) throws DfException {
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        JoinPoint joinPoint = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2;
            ByteArrayInputStream in;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DfBase64Encoder encoder = new DfBase64Encoder(in, baos);
            try {
                encoder.process();
            }
            catch (IOException e) {
                throw new DfException(e);
            }
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2 = (byteArrayOutputStream = baos);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byteArrayOutputStream2, joinPoint);
            }
            return byteArrayOutputStream;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static ByteArrayOutputStream decodeBase64(ByteArrayInputStream byteArrayInputStream) throws DfException {
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        JoinPoint joinPoint = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2;
            ByteArrayInputStream in;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DfBase64Decoder decoder = new DfBase64Decoder(in, baos);
            try {
                decoder.process();
            }
            catch (DfBase64FormatException e) {
                throw new DfException(e);
            }
            catch (IOException e) {
                throw new DfException(e);
            }
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2 = (byteArrayOutputStream = baos);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(byteArrayOutputStream2, joinPoint);
            }
            return byteArrayOutputStream;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)byteArrayInputStream2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected AuthenticationMgr() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_identity = "";
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("AuthenticationMgr.java", Class.forName("com.documentum.fc.client.security.internal.AuthenticationMgr"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createIdentityBundle", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:", "hostName:customData:", "com.documentum.fc.common.DfException:", "java.lang.String"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "verifyDigitalSignature", "com.documentum.fc.client.security.internal.AuthenticationMgr", "com.documentum.fc.client.security.IDfAuthenticationInfo:", "info:", "com.documentum.fc.common.DfException:", "boolean"), 158);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "verifySignature", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:java.security.cert.Certificate:[B:", "raw:mda:cert:signature:", "com.documentum.fc.common.DfException:", "boolean"), 495);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "encodeBase64", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.io.ByteArrayInputStream:", "in:", "com.documentum.fc.common.DfException:", "java.io.ByteArrayOutputStream"), 542);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "decodeBase64", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.io.ByteArrayInputStream:", "in:", "com.documentum.fc.common.DfException:", "java.io.ByteArrayOutputStream"), 568);
        ajc$tjp_13 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:", "identity:", "com.documentum.fc.common.DfException:"), 599);
        ajc$tjp_14 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("4", "com.documentum.fc.client.security.internal.AuthenticationMgr", "", "", ""), 599);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "sVerifyDigitalSignature", "com.documentum.fc.client.security.internal.AuthenticationMgr", "com.documentum.fc.client.security.IDfAuthenticationInfo:java.security.cert.Certificate:", "info:cert:", "com.documentum.fc.common.DfException:", "boolean"), 172);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAuthenticationInfo", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:", "hostName:customData:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 194);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAuthenticationInfo", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:", "identityBundle:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 203);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "sCreateAuthenticationInfo", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:", "identityBundle:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo"), 251);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "vetIdentity", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:", "typedIdentityHash:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.IDfAuthenticationInfo$AuthenticationType"), 337);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "buildRaw", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "hostName:identityHash:customData:timeStamp:", "", "java.lang.String"), 398);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "buildBundle", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "hostName:identityHash:customData:timeStamp:digitalSignature:", "", "java.lang.String"), 439);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "digitallySign", "com.documentum.fc.client.security.internal.AuthenticationMgr", "java.lang.String:java.lang.String:java.security.PrivateKey:", "raw:mda:key:", "com.documentum.fc.common.DfException:", "[B"), 463);
        m_hostnameRegex = Pattern.compile(HOSTNAME_REGEX);
    }
}

