/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.IDfACL;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.impl.bof.classmgmt.ModuleManager;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.client.privilege.internal.IClientRegistration;
import com.documentum.fc.client.privilege.internal.IClientRights;
import com.documentum.fc.client.privilege.internal.IPublicKeyCertificate;
import com.documentum.fc.client.security.impl.DfcIdentityPublisher;
import com.documentum.fc.client.security.impl.IIdentityManager;
import com.documentum.fc.client.security.impl.IpAndRcHelper;
import com.documentum.fc.client.security.impl.RightsAndItsAcl;
import com.documentum.fc.client.security.internal.IPublicIdentity;
import com.documentum.fc.client.security.internal.KeystoreMgr;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfInterProcessLockFactory;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.IDfInterProcessLock;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public final class DfcRightsCreator {
    final IPublicIdentity m_publicIdentity;
    final IDfSession m_session;
    private final boolean m_isDocbaseAlsoTheGlobalRegistry;
    private final boolean m_isGlobalRegistryUsable;
    private final boolean m_isGlobalRegistryConfigured;
    private final DfcIdentityPublisher m_idPublisher;
    private static final Object m_registrationMutex;
    private final String m_docbaseVer;
    private final String m_docbaseName;
    private final boolean m_isRightsSupported;
    private final IDfInterProcessLock m_ipLock;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    public DfcRightsCreator(IDfSession sysadminSession) throws DfException {
        IDfSession iDfSession = sysadminSession;
        JoinPoint joinPoint = null;
        try {
            boolean isDocbaseAlsoTheGlobalRegistry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfSession);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_ipLock = DfInterProcessLockFactory.getInstance().getNewLock(IIdentityManager.ipLockName);
            assert (null != sysadminSession);
            this.m_session = sysadminSession;
            this.m_docbaseVer = IpAndRcHelper.getDocbaseVer(this.m_session);
            this.m_isRightsSupported = IpAndRcHelper.initIsPrivilegeRightsSupportedFlag(this.m_session);
            if (this.m_isRightsSupported) {
                this.m_docbaseName = this.m_session.getDocbaseName();
                this.m_publicIdentity = KeystoreMgr.getDfcPublicIdentity();
                assert (null != this.m_publicIdentity);
                this.m_isGlobalRegistryConfigured = DfPreferences.getInstance().getGlobalRegistryRepository() != null && DfPreferences.getInstance().getGlobalRegistryRepository().length() > 0;
                boolean isGlobalRegistryUsable = false;
                DfcIdentityPublisher idPublisher = null;
                if (this.m_isGlobalRegistryConfigured) {
                    DfLogger.debug((Object)this, "a global registry is configured", null, null);
                    try {
                        idPublisher = new DfcIdentityPublisher();
                        idPublisher.publish();
                        isGlobalRegistryUsable = true;
                        DfLogger.debug((Object)this, "and the global registry is available", null, null);
                    }
                    catch (DfException e) {
                        DfLogger.debug((Object)this, "but the global registry is NOT available", null, (Throwable)e);
                    }
                }
                this.m_idPublisher = idPublisher;
                this.m_isGlobalRegistryUsable = isGlobalRegistryUsable;
                isDocbaseAlsoTheGlobalRegistry = false;
                if (isGlobalRegistryUsable) {
                    try {
                        isDocbaseAlsoTheGlobalRegistry = DfcRightsCreator.isDocbaseAlsoTheGlobalRegistry(this.m_session);
                    }
                    catch (DfException e) {
                        DfLogger.info((Object)this, "the current docbase {0} is not the global registry", new Object[]{this.m_session.getDocbaseName()}, (Throwable)e);
                    }
                }
            } else {
                throw new DfException("DFC_SECURITY_GR_UNSUPPORTED", new Object[]{this.m_docbaseVer, "session"}, null);
            }
            this.m_isDocbaseAlsoTheGlobalRegistry = isDocbaseAlsoTheGlobalRegistry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfSession);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)iDfSession);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean isAllRoles() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            DfLogger.debug((Object)this, "start isAllRoles() at {0}", new Object[]{new Date()}, null);
            boolean predicate = this.isRights(true);
            DfLogger.info((Object)this, "isAllRoles() at {0}: ->> result: {1}", new Object[]{new Date(), predicate}, null);
            boolean bl3 = bl2 = (bl = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isAllRoles(IPublicIdentity iPublicIdentity) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            void iks;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            DfLogger.debug((Object)this, "start isAllRoles(IPublicIdentity) at {0}", new Object[]{new Date()}, null);
            IClientRights rights = this.getRights((IPublicIdentity)iks);
            boolean predicate = this.isRights(rights, true);
            DfLogger.debug((Object)this, "finish isAllRoles(IPublicIdentity) at {0}, result: {1}", new Object[]{new Date(), predicate}, null);
            DfLogger.info((Object)this, "found client rights: {0}, all roles", new Object[]{predicate}, null);
            boolean bl3 = bl2 = (bl = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public boolean isAnyRoles() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            DfLogger.debug((Object)this, "start isAnyRoles() at {0}", new Object[]{new Date()}, null);
            boolean predicate = this.isRights(false);
            DfLogger.info((Object)this, "found client rights: {0}, any roles", new Object[]{predicate}, null);
            boolean bl3 = bl2 = (bl = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isAnyRoles(IPublicIdentity iPublicIdentity) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            void iks;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            DfLogger.debug((Object)this, "start isAnyRoles(IPublicIdentity) at {0}", new Object[]{new Date()}, null);
            IClientRights rights = this.getRights((IPublicIdentity)iks);
            boolean predicate = this.isRights(rights, false);
            DfLogger.debug((Object)this, "finish isAnyRoles(IPublicIdentity) at {0}, result: {1}", new Object[]{new Date(), predicate}, null);
            boolean bl3 = bl2 = (bl = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean isRights(boolean bl) throws DfException {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            boolean bl3;
            boolean bl4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            Object object = m_registrationMutex;
            synchronized (object) {
                boolean bl5;
                try {
                    boolean isCert;
                    void trueOnlyIfAll;
                    this.m_ipLock.acquire();
                    boolean predicate = false;
                    DfLogger.debug((Object)this, "test if right to {0} roles is registered on docbase {1}", new Object[]{trueOnlyIfAll != false ? "all" : "some", this.m_docbaseName}, null);
                    IClientRights rights = this.getRights(this.m_publicIdentity);
                    predicate = this.isRights(rights, (boolean)trueOnlyIfAll);
                    if (predicate && !(isCert = this.isCertificate(rights))) {
                        DfLogger.warn((Object)this, "DFC_SECURITY_DOCBASE_NOCERT", new Object[]{"(purged)", this.m_docbaseName}, null);
                        DfLogger.warn((Object)this, "DFC_SECURITY_DOCBASE_RIGHTS_NONE", null, null);
                    }
                    DfLogger.debug((Object)this, "right to {0} roles {1} registered on docbase {2}", new Object[]{trueOnlyIfAll != false ? "all" : "some", predicate ? "is" : "is not", this.m_docbaseName}, null);
                    bl5 = predicate;
                    this.m_ipLock.release();
                }
                catch (Throwable throwable) {
                    this.m_ipLock.release();
                    throw throwable;
                }
                bl4 = bl5;
            }
            boolean bl6 = bl3 = bl4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object2 = Conversions.booleanObject((boolean)bl3);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object2, joinPoint);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public void registerRightsToAllRoles() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            this.registerRightsToAllRoles(true);
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerRightsToAllRoles(boolean bl) throws DfException {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            boolean tih = false;
            Object object = m_registrationMutex;
            synchronized (object) {
                try {
                    void selfHeal;
                    this.m_ipLock.acquire();
                    DfLogger.info((Object)this, "assigning rights to all roles for this client on {0}", new Object[]{this.m_docbaseName}, null);
                    boolean allowAllRights = true;
                    boolean allowAllModules = false;
                    if (!this.m_session.isTransactionActive()) {
                        this.m_session.beginTrans();
                        tih = true;
                    }
                    IClientRights rights = this.getRights(this.m_publicIdentity);
                    boolean mustBeForAllRoles = true;
                    boolean forSomeRolesOnly = false;
                    if (this.isRights(rights, mustBeForAllRoles)) {
                        DfLogger.debug((Object)this, "all rights found for dfc {0}, verify existence of matching certificate on docbase {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                        assert (null != rights);
                        IPublicKeyCertificate cert = this.getCertificate(rights);
                        if (null == cert) {
                            if (selfHeal == false) throw new DfException("DFC_SECURITY_DOCBASE_NOCERT", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                            this.healUnwholeRights(allowAllRights, allowAllModules, rights, true);
                        }
                    } else if (null == rights) {
                        DfLogger.debug((Object)this, "no rights object found for dfc {0}, verify existence of matching certificate on {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                        IPublicKeyCertificate cert = IpAndRcHelper.getCertificate(this.m_publicIdentity, this.m_session);
                        if (null == cert) {
                            DfLogger.debug((Object)this, "no certificate either, create all with rights to all roles", new Object[]{this.m_docbaseName}, null);
                            this.createCertificateAndRightsRecords(this.m_isGlobalRegistryUsable, this.m_isDocbaseAlsoTheGlobalRegistry, allowAllRights, allowAllModules);
                        } else if (this.m_isDocbaseAlsoTheGlobalRegistry) {
                            DfLogger.debug((Object)this, "found certificate (we're on GR), create rights to all roles", new Object[]{this.m_docbaseName}, null);
                            this.createCertificateAndRightsRecords(this.m_isGlobalRegistryUsable, this.m_isDocbaseAlsoTheGlobalRegistry, allowAllRights, allowAllModules);
                        } else {
                            if (selfHeal == false) throw new DfException("DFC_SECURITY_ILLEGAL_STATE", new Object[]{"certificate without rights"}, null);
                            this.healCertificateWithoutRights(cert, allowAllRights, allowAllModules);
                        }
                    } else if (this.isRights(rights, forSomeRolesOnly)) {
                        DfLogger.debug((Object)this, "some (insufficient) rights found for dfc {0}, verify existence of matching certificate on docbase {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                        this.healUnwholeRights(allowAllRights, allowAllModules, rights, (boolean)selfHeal);
                    } else {
                        if (selfHeal == false) throw new DfException("DFC_SECURITY_ILLEGAL_STATE", new Object[]{"dm_client_rights roles count is zero"}, null);
                        DfLogger.debug((Object)this, "rights object with no rights found for dfc {0}, recovering, verify existence of matching certificate on docbase {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                        this.healUnwholeRights(allowAllRights, allowAllModules, rights, (boolean)selfHeal);
                    }
                    if (tih) {
                        this.m_session.commitTrans();
                    }
                }
                catch (DfException e) {
                    if (!this.m_session.isTransactionActive() || !tih) throw e;
                    ((ISession)this.m_session).abortTransWithoutException();
                    throw e;
                }
                catch (RuntimeException e) {
                    if (!this.m_session.isTransactionActive() || !tih) throw e;
                    ((ISession)this.m_session).abortTransWithoutException();
                    throw e;
                }
                finally {
                    this.m_ipLock.release();
                }
            }
            Object var14_17 = null;
            if (!BaseTracingAspect.ajc$if_0()) return;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
            }
            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var14_17, joinPoint);
            return;
        }
        catch (Throwable throwable) {
            if (!BaseTracingAspect.ajc$if_0()) throw throwable;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
            }
            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            boolean tih = false;
            Object object = m_registrationMutex;
            synchronized (object) {
                try {
                    boolean forSomeRolesAtLeast;
                    IClientRights rights;
                    this.m_ipLock.acquire();
                    DfLogger.info((Object)this, "revoking rights from docbase {0}", new Object[]{this.m_docbaseName}, null);
                    if (!this.m_session.isTransactionActive()) {
                        this.m_session.beginTrans();
                        tih = true;
                    }
                    if (this.isRights(rights = this.getRights(this.m_publicIdentity), forSomeRolesAtLeast = false)) {
                        if (this.m_isDocbaseAlsoTheGlobalRegistry) {
                            DfLogger.debug((Object)this, "revoking rights for dfc {0} from {1}, which is also the global registry docbase", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                            rights.destroy();
                        } else {
                            DfLogger.debug((Object)this, "revoking rights for dfc {0} from {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                            IPublicKeyCertificate cert = this.getCertificate(rights);
                            if (null != cert) {
                                cert.destroy();
                                DfLogger.debug((Object)this, "certificate now destroyed", null, null);
                            } else {
                                DfLogger.warn((Object)this, "DFC_SECURITY_DOCBASE_NOCERT", new Object[]{"(now recalled)"}, null);
                            }
                            rights.destroy();
                        }
                        DfLogger.warn((Object)this, "DFC_SECURITY_DOCBASE_RIGHTS_REVOKE", null, null);
                    } else if (null != rights) {
                        IPublicKeyCertificate cert;
                        DfLogger.warn((Object)this, "DFC_SECURITY_ILLEGAL_STATE", new Object[]{"dm_client_rights with no rights will be purged"}, null);
                        if (!this.m_isDocbaseAlsoTheGlobalRegistry && null != (cert = this.getCertificate(rights))) {
                            cert.destroy();
                            DfLogger.warn((Object)this, "DFC_SECURITY_ILLEGAL_STATE", new Object[]{"certificate for no rights will be purged"}, null);
                        }
                        rights.destroy();
                    } else {
                        DfLogger.info((Object)this, "DFC_SECURITY_DOCBASE_RIGHTS_NONE", null, null);
                    }
                    if (tih) {
                        this.m_session.commitTrans();
                    }
                }
                catch (DfException e) {
                    if (this.m_session.isTransactionActive() && tih) {
                        ((ISession)this.m_session).abortTransWithoutException();
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (this.m_session.isTransactionActive() && tih) {
                        ((ISession)this.m_session).abortTransWithoutException();
                    }
                    throw e;
                }
                finally {
                    this.m_ipLock.release();
                }
            }
            Object var9_12 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_12, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IClientRights getRights(IPublicIdentity iPublicIdentity) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        JoinPoint joinPoint = null;
        try {
            IClientRights iClientRights;
            IClientRights iClientRights2;
            void iks;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            assert (null != this.m_session);
            assert (null != iks);
            DfLogger.debug((Object)this, "looking for client rights", null, null);
            IClientRights rights = IpAndRcHelper.getRights((IPublicIdentity)iks, this.m_session);
            DfLogger.info((Object)this, "found client rights: " + (null != rights), null, null);
            IClientRights iClientRights3 = iClientRights2 = (iClientRights = rights);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iClientRights2, joinPoint);
            }
            return iClientRights;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iPublicIdentity2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IPublicKeyCertificate getCertificate(IClientRights iClientRights) throws DfException {
        IClientRights iClientRights2 = iClientRights;
        JoinPoint joinPoint = null;
        try {
            void rights;
            IPublicKeyCertificate iPublicKeyCertificate;
            IPublicKeyCertificate iPublicKeyCertificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            IPublicKeyCertificate iPublicKeyCertificate3 = iPublicKeyCertificate2 = (iPublicKeyCertificate = IpAndRcHelper.getCertificate((IClientRights)rights, this.m_session));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iPublicKeyCertificate2, joinPoint);
            }
            return iPublicKeyCertificate;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isCertificate(IClientRights iClientRights) throws DfException {
        IClientRights iClientRights2 = iClientRights;
        JoinPoint joinPoint = null;
        try {
            void rights;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isRightsSupported) {
                throw new DfCriticalException("should never get here");
            }
            boolean bl3 = bl2 = (bl = IpAndRcHelper.isCertificate((IClientRegistration)rights, this.m_session));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iClientRights2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static boolean isDocbaseAlsoTheGlobalRegistry(IDfSession iDfSession) throws DfException {
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            IDfSession sysadminSession;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ISession grSession = ModuleManager.getInstance().getGlobalRegistrySession();
            String grDocId = grSession.getDocbaseConfig().getObjectId().getDocbaseId();
            String csDocId = sysadminSession.getDocbaseConfig().getObjectId().getDocbaseId();
            boolean bl3 = bl2 = (bl = csDocId.equals(grDocId));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createCertificateAndRightsRecords(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DfException {
        boolean bl5 = bl;
        boolean bl6 = bl2;
        boolean bl7 = bl3;
        boolean bl8 = bl4;
        JoinPoint joinPoint = null;
        try {
            void isGlobalRegistryUsable;
            void allowAllModules;
            void allowAllRoles;
            void isDocbaseAlsoTheGlobalRegistry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6), Conversions.booleanObject((boolean)bl7), Conversions.booleanObject((boolean)bl8)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (isDocbaseAlsoTheGlobalRegistry != false) {
                DfLogger.debug((Object)this, "creating rights for dfc {0} on {1}, which is also the global registry docbase, all roles {2}, all modules {3}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName, (boolean)allowAllRoles, (boolean)allowAllModules}, null);
                this.createRightsRecordsWithCertificateOnGR((boolean)allowAllRoles, (boolean)allowAllModules);
            } else if (isGlobalRegistryUsable != false) {
                DfLogger.debug((Object)this, "creating rights for dfc {0} on {1}; a global registry is available, and is on a different docbase, all roles {2}, all modules {3}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName, (boolean)allowAllRoles, (boolean)allowAllModules}, null);
                this.createRightsRecordsWithCertificateFromGR((boolean)allowAllRoles, (boolean)allowAllModules);
            } else {
                DfLogger.debug((Object)this, "creating rights for dfc {0} on {1}; a global registry is NOT available, all roles {2}, all modules {3}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName, (boolean)allowAllRoles, (boolean)allowAllModules}, null);
                this.createRightsRecordsWithCertificateFromScratch((boolean)allowAllRoles, (boolean)allowAllModules);
            }
            DfLogger.info((Object)this, "DFC_SECURITY_DOCBASE_RIGHTS_REGISTER", new Object[]{this.m_docbaseName}, null);
            Object var12_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6), Conversions.booleanObject((boolean)bl7), Conversions.booleanObject((boolean)bl8)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6), Conversions.booleanObject((boolean)bl7), Conversions.booleanObject((boolean)bl8)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createRightsRecordsWithCertificateOnGR(boolean bl, boolean bl2) throws DfException {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            void allowAllModules;
            void allowAllRoles;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ISession grSession = ModuleManager.getInstance().getGlobalRegistrySession();
            IClientRegistration reg = this.m_idPublisher.getRegistration(this.m_publicIdentity, grSession);
            IPublicKeyCertificate cert = IpAndRcHelper.getCertificate(reg.getPublicKeyIdentifier(), (IDfSession)grSession);
            String publicKeyIdentifier = cert.getKeyIdentifier();
            RightsAndItsAcl dbData = this.createNewRightsObjectButCleanItUpFirst();
            IpAndRcHelper.fillAndSaveClientRights(dbData.rights, this.m_publicIdentity, publicKeyIdentifier, dbData.acl, (boolean)allowAllRoles, (boolean)allowAllModules);
            Object var11_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var11_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createRightsRecordsWithCertificateFromGR(boolean bl, boolean bl2) throws DfException {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            void allowAllModules;
            void allowAllRoles;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String pkIdentifier = IpAndRcHelper.createNewCertificateObjectIfNeeded(this.m_publicIdentity, this.m_session);
            ISession grSession = ModuleManager.getInstance().getGlobalRegistrySession();
            IClientRegistration reg = this.m_idPublisher.getRegistration(this.m_publicIdentity, grSession);
            if (null == reg) {
                throw new DfCriticalException("DFC_SECURITY_GR_REGISTRATION_NONE", (Object[])null);
            }
            IPublicKeyCertificate certFromGR = IpAndRcHelper.getCertificate(reg.getPublicKeyIdentifier(), (IDfSession)grSession);
            IPublicKeyCertificate certForDocbase = IpAndRcHelper.getCertificate(pkIdentifier, this.m_session);
            if (!certFromGR.getCertificate().equals(certForDocbase.getCertificate())) {
                throw new DfCriticalException("DFC_SECURITY_CERTIFICATE_MISMATCH", new Object[]{grSession.getDocbaseName(), this.m_publicIdentity.getIdentity()});
            }
            RightsAndItsAcl dbData = this.createNewRightsObjectButCleanItUpFirst();
            IpAndRcHelper.fillAndSaveClientRights(dbData.rights, this.m_publicIdentity, pkIdentifier, dbData.acl, (boolean)allowAllRoles, (boolean)allowAllModules);
            Object var12_12 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_12, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createRightsRecordsWithCertificateFromScratch(boolean bl, boolean bl2) throws DfException {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            void allowAllModules;
            void allowAllRoles;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_isGlobalRegistryConfigured) {
                DfLogger.warn((Object)this, "DFC_BOF_GLOBAL_REGISTRY_UNAVAILABLE", new Object[]{"(null identity publisher)"}, null);
            } else {
                DfLogger.warn((Object)this, "DFC_BOF_GLOBAL_REGISTRY_NOT_CONFIGURED", null, null);
            }
            DfLogger.warn((Object)this, "DFC_SECURITY_RIGHTS_WITHOUT_GR", new Object[]{this.m_docbaseName}, null);
            String pkIdentifier = IpAndRcHelper.createNewCertificateObjectIfNeeded(this.m_publicIdentity, this.m_session);
            RightsAndItsAcl dbData = this.createNewRightsObjectButCleanItUpFirst();
            IpAndRcHelper.fillAndSaveClientRights(dbData.rights, this.m_publicIdentity, pkIdentifier, dbData.acl, (boolean)allowAllRoles, (boolean)allowAllModules);
            Object var8_8 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var8_8, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl3), (Object)Conversions.booleanObject((boolean)bl4));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRights(IClientRights iClientRights, boolean bl) throws DfException {
        IClientRights iClientRights2 = iClientRights;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            boolean bl3;
            boolean bl4;
            void trueOnlyIfRightsIsToAllRoles;
            void rights;
            boolean predicate;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)iClientRights2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl5 = predicate = null != rights;
            if (DfLogger.isDebugEnabled(this)) {
                if (predicate) {
                    DfLogger.debug((Object)this, "check rights on {0} {1} for cert {2}", new Object[]{rights.getObjectId(), rights.getObjectName(), rights.getPublicKeyIdentifier()}, null);
                } else {
                    DfLogger.debug((Object)this, "checking rights, found no rights object", null, null);
                }
            }
            if (predicate && trueOnlyIfRightsIsToAllRoles != false) {
                predicate = rights.isAllowAllRoles();
                if (predicate) {
                    DfLogger.debug((Object)this, "found rights object with rights to all roles", null, null);
                }
            } else if (predicate) {
                int num = rights.getAllowedRolesCount();
                boolean bl6 = predicate = num > 0 || rights.isAllowAllRoles();
                if (predicate) {
                    DfLogger.debug((Object)this, "found rights object with rights to {0} roles", new Object[]{num}, null);
                }
            }
            boolean bl7 = bl4 = (bl3 = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl4);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)iClientRights2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)iClientRights2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private RightsAndItsAcl createNewRightsObjectButCleanItUpFirst() throws DfException {
        JoinPoint joinPoint = null;
        try {
            RightsAndItsAcl rightsAndItsAcl;
            RightsAndItsAcl rightsAndItsAcl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            RightsAndItsAcl dbData = new RightsAndItsAcl();
            dbData.rights = this.getRights(this.m_publicIdentity);
            if (null != dbData.rights) {
                dbData.rights.destroy();
            }
            dbData.rights = (IClientRights)this.m_session.newObject("dm_client_rights");
            dbData.acl = (IDfACL)this.m_session.newObject("dm_acl");
            dbData.acl = IpAndRcHelper.fillAndSaveACLForClientRights(dbData.acl);
            RightsAndItsAcl rightsAndItsAcl3 = rightsAndItsAcl2 = (rightsAndItsAcl = dbData);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rightsAndItsAcl2, joinPoint);
            }
            return rightsAndItsAcl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void healUnwholeRights(boolean bl, boolean bl2, IClientRights iClientRights, boolean bl3) throws DfException {
        boolean bl4 = bl;
        boolean bl5 = bl2;
        IClientRights iClientRights2 = iClientRights;
        boolean bl6 = bl3;
        JoinPoint joinPoint = null;
        try {
            void rights;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl4), Conversions.booleanObject((boolean)bl5), iClientRights2, Conversions.booleanObject((boolean)bl6)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != rights);
            IPublicKeyCertificate cert = this.getCertificate((IClientRights)rights);
            if (null == cert) {
                void allowAllModules;
                void allowAllRights;
                void fixIfNoCertificace;
                if (fixIfNoCertificace == false) throw new DfException("DFC_SECURITY_DOCBASE_NOCERT", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                DfLogger.warn((Object)this, "DFC_SECURITY_DOCBASE_NOCERT", new Object[]{this.m_publicIdentity.getIdentity(), this.m_docbaseName}, null);
                DfLogger.debug((Object)this, "destroy stranded partial right object, then recreate right to all roles", new Object[]{this.m_docbaseName}, null);
                rights.destroy();
                this.createCertificateAndRightsRecords(this.m_isGlobalRegistryUsable, this.m_isDocbaseAlsoTheGlobalRegistry, (boolean)allowAllRights, (boolean)allowAllModules);
            } else {
                DfLogger.debug((Object)this, "enhance partial right object to rights to all roles", new Object[]{this.m_docbaseName}, null);
                rights.removeAllAllowedRoles();
                rights.setAllowAllRoles(true);
                rights.save();
            }
            Object var13_12 = null;
            if (!BaseTracingAspect.ajc$if_0()) return;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl4), Conversions.booleanObject((boolean)bl5), iClientRights2, Conversions.booleanObject((boolean)bl6)};
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray);
            }
            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var13_12, joinPoint);
            return;
        }
        catch (Throwable throwable) {
            if (!BaseTracingAspect.ajc$if_0()) throw throwable;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl4), Conversions.booleanObject((boolean)bl5), iClientRights2, Conversions.booleanObject((boolean)bl6)};
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray);
            }
            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void healCertificateWithoutRights(IPublicKeyCertificate iPublicKeyCertificate, boolean bl, boolean bl2) throws DfException {
        IPublicKeyCertificate iPublicKeyCertificate2 = iPublicKeyCertificate;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        JoinPoint joinPoint = null;
        try {
            void allowAllModules;
            void allowAllRights;
            void cert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iPublicKeyCertificate2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfLogger.debug((Object)this, "have certificate, create only rights to all roles", new Object[]{this.m_docbaseName}, null);
            assert (null != cert);
            String publicKeyIdentifier = cert.getKeyIdentifier();
            RightsAndItsAcl dbData = this.createNewRightsObjectButCleanItUpFirst();
            IpAndRcHelper.fillAndSaveClientRights(dbData.rights, this.m_publicIdentity, publicKeyIdentifier, dbData.acl, (boolean)allowAllRights, (boolean)allowAllModules);
            Object var12_11 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iPublicKeyCertificate2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iPublicKeyCertificate2, Conversions.booleanObject((boolean)bl3), Conversions.booleanObject((boolean)bl4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfcRightsCreator.java", Class.forName("com.documentum.fc.client.security.impl.DfcRightsCreator"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAllRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "", "", "com.documentum.fc.common.DfException:", "boolean"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isAllRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.security.internal.IPublicIdentity:", "iks:", "com.documentum.fc.common.DfException:", "boolean"), 143);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isCertificate", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.privilege.internal.IClientRights:", "rights:", "com.documentum.fc.common.DfException:", "boolean"), 619);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "isDocbaseAlsoTheGlobalRegistry", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.IDfSession:", "sysadminSession:", "com.documentum.fc.common.DfException:", "boolean"), 629);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCertificateAndRightsRecords", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:boolean:boolean:boolean:", "isGlobalRegistryUsable:isDocbaseAlsoTheGlobalRegistry:allowAllRoles:allowAllModules:", "com.documentum.fc.common.DfException:", "void"), 644);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRightsRecordsWithCertificateOnGR", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:boolean:", "allowAllRoles:allowAllModules:", "com.documentum.fc.common.DfException:", "void"), 697);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRightsRecordsWithCertificateFromGR", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:boolean:", "allowAllRoles:allowAllModules:", "com.documentum.fc.common.DfException:", "void"), 736);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRightsRecordsWithCertificateFromScratch", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:boolean:", "allowAllRoles:allowAllModules:", "com.documentum.fc.common.DfException:", "void"), 777);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRights", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.privilege.internal.IClientRights:boolean:", "rights:trueOnlyIfRightsIsToAllRoles:", "com.documentum.fc.common.DfException:", "boolean"), 811);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createNewRightsObjectButCleanItUpFirst", "com.documentum.fc.client.security.impl.DfcRightsCreator", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.impl.RightsAndItsAcl"), 847);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "healUnwholeRights", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:boolean:com.documentum.fc.client.privilege.internal.IClientRights:boolean:", "allowAllRights:allowAllModules:rights:fixIfNoCertificace:", "com.documentum.fc.common.DfException:", "void"), 865);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "healCertificateWithoutRights", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.privilege.internal.IPublicKeyCertificate:boolean:boolean:", "cert:allowAllRights:allowAllModules:", "com.documentum.fc.common.DfException:", "void"), 917);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAnyRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "", "", "com.documentum.fc.common.DfException:", "boolean"), 171);
        ajc$tjp_20 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.IDfSession:", "sysadminSession:", "com.documentum.fc.common.DfException:"), 948);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isAnyRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.security.internal.IPublicIdentity:", "iks:", "com.documentum.fc.common.DfException:", "boolean"), 196);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRights", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:", "trueOnlyIfAll:", "com.documentum.fc.common.DfException:", "boolean"), 214);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerRightsToAllRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "", "", "com.documentum.fc.common.DfException:", "void"), 264);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerRightsToAllRoles", "com.documentum.fc.client.security.impl.DfcRightsCreator", "boolean:", "selfHeal:", "com.documentum.fc.common.DfException:", "void"), 273);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "revoke", "com.documentum.fc.client.security.impl.DfcRightsCreator", "", "", "com.documentum.fc.common.DfException:", "void"), 470);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getRights", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.security.internal.IPublicIdentity:", "iks:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.privilege.internal.IClientRights"), 590);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCertificate", "com.documentum.fc.client.security.impl.DfcRightsCreator", "com.documentum.fc.client.privilege.internal.IClientRights:", "rights:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.privilege.internal.IPublicKeyCertificate"), 609);
        m_registrationMutex = new Object();
    }
}

