/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security.impl;

import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfACL;
import com.documentum.fc.client.IDfCollection;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.impl.bof.classmgmt.ModuleManager;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.client.privilege.internal.IClientRegistration;
import com.documentum.fc.client.privilege.internal.IPublicKeyCertificate;
import com.documentum.fc.client.security.impl.IIdentityManager;
import com.documentum.fc.client.security.impl.IpAndRcHelper;
import com.documentum.fc.client.security.impl.RegAndItsAcl;
import com.documentum.fc.client.security.internal.IPublicIdentity;
import com.documentum.fc.client.security.internal.KeystoreMgr;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfInterProcessLockFactory;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfInterProcessLock;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Date;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public final class DfcIdentityPublisher {
    IDfSession m_grSession;
    final IPublicIdentity m_publicIdentity;
    private static final Object m_publishMutex;
    private final IDfInterProcessLock m_ipLock;
    private final String m_grName;
    private final String m_grVer;
    private final boolean m_isGrRegistrationSupported;
    private final boolean m_isGrSessionNull;
    private final boolean m_isPrivilegeEnabled;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DfcIdentityPublisher() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_ipLock = DfInterProcessLockFactory.getInstance().getNewLock(IIdentityManager.ipLockName);
            this.m_isPrivilegeEnabled = DfPreferences.getInstance().isPrivilegeEnabled();
            if (this.m_isPrivilegeEnabled) {
                this.m_grSession = ModuleManager.getInstance().getGlobalRegistrySession();
                if (null == this.m_grSession) {
                    this.m_isGrSessionNull = true;
                    String grRep = DfPreferences.getInstance().getGlobalRegistryRepository();
                    if (null != grRep && 0 != grRep.length()) throw new DfException("DFC_BOF_GLOBAL_REGISTRY_UNAVAILABLE", new Object[]{"no session"});
                    throw new DfException("DFC_BOF_GLOBAL_REGISTRY_NOT_CONFIGURED");
                }
                this.m_isGrSessionNull = false;
                this.m_grVer = IpAndRcHelper.getDocbaseVer(this.m_grSession);
                this.m_isGrRegistrationSupported = IpAndRcHelper.initIsPrivilegeRegistrationSupportedFlag(this.m_grSession);
                if (!this.m_isGrRegistrationSupported) throw new DfException("DFC_SECURITY_GR_UNSUPPORTED", new Object[]{this.m_grVer, "session"}, null);
                this.m_grName = this.m_grSession.getDocbaseName();
                this.m_publicIdentity = KeystoreMgr.getDfcPublicIdentity();
                assert (null != this.m_publicIdentity);
            } else {
                this.m_publicIdentity = null;
                this.m_grName = null;
                this.m_grVer = null;
                this.m_isGrRegistrationSupported = false;
                this.m_isGrSessionNull = true;
                DfLogger.info((Object)this, "privilege disabled by configuration, no attempt to register identity made", null, null);
            }
            if (!BaseTracingAspect.ajc$if_0()) return;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
            }
            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            if (!BaseTracingAspect.ajc$if_0()) throw throwable;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
            }
            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            throw throwable;
        }
    }

    public void publish() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.publish(true);
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void publish(boolean bl) throws DfException {
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_isPrivilegeEnabled) {
                if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                    throw new DfCriticalException("should never get here");
                }
                boolean tih = false;
                Object object = m_publishMutex;
                synchronized (object) {
                    try {
                        IClientRegistration reg;
                        this.m_ipLock.acquire();
                        if (!this.m_grSession.isTransactionActive()) {
                            this.m_grSession.beginTrans();
                            tih = true;
                        }
                        if (!this.isRegistration(reg = this.getRegistration(this.m_publicIdentity, this.m_grSession))) {
                            DfLogger.debug((Object)this, "create registration and certificate for dfc {0}with global registry {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_grName}, null);
                            this.createCertificateAndRegistration();
                        } else {
                            DfLogger.debug((Object)this, "registration found for dfc {0}, verify existence of matching certificate on global registry {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_grName}, null);
                            assert (null != reg);
                            IPublicKeyCertificate cert = this.getCertificate(reg, this.m_grSession);
                            if (null == cert) {
                                void selfHeal;
                                if (selfHeal != false) {
                                    DfLogger.warn((Object)this, "DFC_SECURITY_GR_NOCERT", new Object[]{this.m_publicIdentity.getIdentity(), this.m_grName}, null);
                                    DfLogger.debug((Object)this, "destroy stranded registration, then recreate registration and certificate for dfc {0} with global registry {1}", new Object[]{this.m_publicIdentity.getIdentity(), this.m_grName}, null);
                                    reg.destroy();
                                    this.createCertificateAndRegistration();
                                } else {
                                    throw new DfException("DFC_SECURITY_GR_NOCERT", new Object[]{this.m_publicIdentity.getIdentity(), this.m_grName}, null);
                                }
                            }
                        }
                        if (tih) {
                            this.m_grSession.commitTrans();
                        }
                    }
                    catch (DfException e) {
                        if (this.m_grSession.isTransactionActive() && tih) {
                            ((ISession)this.m_grSession).abortTransWithoutException();
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (this.m_grSession.isTransactionActive() && tih) {
                            ((ISession)this.m_grSession).abortTransWithoutException();
                        }
                        throw e;
                    }
                    finally {
                        this.m_ipLock.release();
                    }
                }
            }
            Object var10_12 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_12, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recall() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_isPrivilegeEnabled) {
                if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                    throw new DfCriticalException("should never get here");
                }
                boolean tih = false;
                Object object = m_publishMutex;
                synchronized (object) {
                    block27: {
                        DfLogger.debug((Object)this, "recalling registration from global registry {0}", new Object[]{this.m_grName}, null);
                        try {
                            this.m_ipLock.acquire();
                            if (this.isRegistration(this.m_publicIdentity, this.m_grSession)) {
                                try {
                                    IClientRegistration reg;
                                    if (!this.m_grSession.isTransactionActive()) {
                                        this.m_grSession.beginTrans();
                                        tih = true;
                                    }
                                    if (null != (reg = this.getRegistration(this.m_publicIdentity, this.m_grSession))) {
                                        IPublicKeyCertificate cert = this.getCertificate(reg, this.m_grSession);
                                        if (null != cert) {
                                            cert.destroy();
                                            DfLogger.debug((Object)this, "certificate now destroyed", null, null);
                                        } else {
                                            DfLogger.warn((Object)this, "DFC_SECURITY_GR_NOCERT", new Object[]{"(now recalled)"}, null);
                                        }
                                        reg.destroy();
                                    }
                                    DfLogger.warn((Object)this, "DFC_SECURITY_GR_REGISTRATION_RECALL", null, null);
                                    if (tih) {
                                        this.m_grSession.commitTrans();
                                    }
                                    break block27;
                                }
                                catch (DfException e) {
                                    if (this.m_grSession.isTransactionActive() && tih) {
                                        ((ISession)this.m_grSession).abortTransWithoutException();
                                    }
                                    throw e;
                                }
                                catch (Exception e) {
                                    if (this.m_grSession.isTransactionActive() && tih) {
                                        ((ISession)this.m_grSession).abortTransWithoutException();
                                    }
                                    throw new DfException(e);
                                }
                            }
                            DfLogger.info((Object)this, "DFC_SECURITY_GR_REGISTRATION_NONE", null, null);
                        }
                        finally {
                            this.m_ipLock.release();
                        }
                    }
                }
            }
            Object var8_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var8_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPublished() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isPrivilegeEnabled) {
                bl2 = bl3 = false;
            } else {
                boolean isCertAndReg;
                if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                    throw new DfCriticalException("should never get here");
                }
                boolean tih = false;
                Object object = m_publishMutex;
                synchronized (object) {
                    isCertAndReg = false;
                    DfLogger.debug((Object)this, "test if identity is published on global registry {0}", new Object[]{this.m_grName}, null);
                    try {
                        IClientRegistration reg;
                        IDfId regId;
                        this.m_ipLock.acquire();
                        if (!this.m_grSession.isTransactionActive()) {
                            this.m_grSession.beginTrans();
                            tih = true;
                        }
                        boolean bl4 = isCertAndReg = null != (regId = this.isRegistrationAndCertificate(this.m_publicIdentity, this.m_grSession));
                        if (!isCertAndReg && null != (reg = this.getRegistration(this.m_publicIdentity, this.m_grSession))) {
                            reg.destroy();
                            DfLogger.warn((Object)this, "DFC_SECURITY_GR_NOCERT", new Object[]{"(purged)", this.m_grName}, null);
                            DfLogger.warn((Object)this, "DFC_SECURITY_GR_REGISTRATION_NONE", null, null);
                        }
                        if (tih) {
                            this.m_grSession.commitTrans();
                        }
                    }
                    catch (DfException e) {
                        if (this.m_grSession.isTransactionActive() && tih) {
                            ((ISession)this.m_grSession).abortTransWithoutException();
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.m_grSession.isTransactionActive() && tih) {
                            ((ISession)this.m_grSession).abortTransWithoutException();
                        }
                        throw new DfException(e);
                    }
                    finally {
                        this.m_ipLock.release();
                    }
                    DfLogger.debug((Object)this, "identity {0} published on global registry {1}", new Object[]{isCertAndReg ? "is" : "is not", this.m_grName}, null);
                }
                bl2 = bl3 = isCertAndReg;
            }
            boolean bl5 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRegistrationRecord() throws DfException {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            block17: {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (!this.m_isPrivilegeEnabled) {
                    bl2 = bl3 = false;
                } else {
                    if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                        throw new DfCriticalException("should never get here");
                    }
                    Object object = m_publishMutex;
                    synchronized (object) {
                        this.m_ipLock.acquire();
                        String qual = "dm_client_registration where client_id='" + this.m_publicIdentity.getIdentity() + "'";
                        DfLogger.debug((Object)this, "looking for ID of client registration record", null, null);
                        IDfId id = this.m_grSession.getIdByQualification(qual);
                        DfLogger.info((Object)this, "found ID for client registration: " + (null != id), null, null);
                        boolean bl4 = null != id;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 13] lbl23 : MonitorExitStatement: MONITOREXIT : var1_3
                        bl2 = bl3 = bl4;
                    }
                }
                break block17;
                {
                    finally {
                        this.m_ipLock.release();
                    }
                }
            }
            boolean bl5 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void createCertificateAndRegistration() throws DfException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String publicKeyIdentifier = IpAndRcHelper.createNewCertificateObjectIfNeeded(this.m_publicIdentity, this.m_grSession);
            RegAndItsAcl dbData = this.createNewRegistrationObjectButCleanItUpFirst();
            IpAndRcHelper.fillAndSaveClientRegistration(dbData.reg, this.m_publicIdentity, publicKeyIdentifier, dbData.acl);
            DfLogger.info((Object)this, "DFC_SECURITY_GR_REGISTRATION_PUBLISH", new Object[]{this.m_grName}, null);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isRegistration(IPublicIdentity iPublicIdentity, IDfSession iDfSession) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            void grSession;
            void iks;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.isRegistration(this.getRegistration((IPublicIdentity)iks, (IDfSession)grSession)));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isRegistration(IClientRegistration iClientRegistration) throws DfException {
        IClientRegistration iClientRegistration2 = iClientRegistration;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            void registration;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)iClientRegistration2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfLogger.debug((Object)this, "start isRegistration at {0}", new Object[]{new Date()}, null);
            boolean predicate = null != registration;
            DfLogger.debug((Object)this, "finish isRegistration at {0}, registration {1}", new Object[]{new Date(), predicate ? "found" : "not found"}, null);
            boolean bl3 = bl2 = (bl = predicate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)iClientRegistration2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)iClientRegistration2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isCertificate(IClientRegistration iClientRegistration, IDfSession iDfSession) throws DfException {
        IClientRegistration iClientRegistration2 = iClientRegistration;
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            void reg;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = IpAndRcHelper.isCertificate((IClientRegistration)reg, (IDfSession)session));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IClientRegistration getRegistration(IPublicIdentity iPublicIdentity, IDfSession iDfSession) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            IClientRegistration iClientRegistration;
            IClientRegistration iClientRegistration2;
            IClientRegistration iClientRegistration3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isPrivilegeEnabled) {
                iClientRegistration2 = iClientRegistration3 = null;
            } else {
                void iks;
                void grSession;
                if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                    throw new DfCriticalException("should never get here");
                }
                assert (null != grSession);
                assert (null != iks);
                IClientRegistration reg = IpAndRcHelper.getRegistration((IPublicIdentity)iks, (IDfSession)grSession);
                DfLogger.info((Object)this, "found client registration: " + (null != reg), null, null);
                iClientRegistration2 = iClientRegistration3 = reg;
            }
            IClientRegistration iClientRegistration4 = iClientRegistration = iClientRegistration2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iClientRegistration, joinPoint);
            }
            return iClientRegistration3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IDfId isRegistrationAndCertificate(IPublicIdentity iPublicIdentity, IDfSession iDfSession) throws DfException {
        IPublicIdentity iPublicIdentity2 = iPublicIdentity;
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            DfId dfId;
            DfId dfId2;
            DfId dfId3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.m_isPrivilegeEnabled) {
                dfId2 = dfId3 = null;
            } else {
                void iks;
                void grSession;
                if (this.m_isGrSessionNull || !this.m_isGrRegistrationSupported) {
                    throw new DfCriticalException("should never get here");
                }
                assert (null != grSession);
                assert (null != iks);
                DfLogger.debug((Object)this, "looking for client registration and its certificate", null, null);
                int count = 0;
                String dfId4 = null;
                DfQuery query = new DfQuery();
                String dqls = "select cr.r_object_id from dm_client_registration cr, dm_public_key_certificate pkc where cr.client_id='" + iks.getIdentity() + "'" + " and cr.public_key_identifier = pkc.key_identifier";
                DfLogger.debug((Object)this, "checking with global registry {0}", new Object[]{grSession.getDocbaseName()}, null);
                DfLogger.debug(IpAndRcHelper.class, "dql: {0}", new Object[]{dqls}, null);
                query.setDQL(dqls);
                IDfCollection col = query.execute((IDfSession)grSession, 0);
                if (col == null) {
                    DfLogger.warn(IpAndRcHelper.class, "DFC_SECURITY_QUERY_STATUS", new Object[]{"registration+certificate", grSession.getDocbaseName(), iks.getIdentity()}, null);
                    dfId2 = dfId3 = null;
                } else {
                    while (col.next()) {
                        dfId4 = col.getString("r_object_id");
                        ++count;
                    }
                    col.close();
                    if (1 < count) {
                        throw new DfException("DFC_SECURITY_GR_REGISTRATION_DUPLICATE", new Object[]{grSession.getDocbaseName(), iks.getIdentity()});
                    }
                    if (null == dfId4 || 0 == dfId4.length()) {
                        dfId2 = dfId3 = null;
                    } else {
                        DfLogger.info((Object)this, "found client registration and its certificate: " + (null != dfId4), null, null);
                        dfId2 = dfId3 = new DfId(dfId4);
                    }
                }
            }
            DfId dfId5 = dfId = dfId2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfId, joinPoint);
            }
            return dfId3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)iPublicIdentity2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    IPublicKeyCertificate getCertificate(IClientRegistration iClientRegistration, IDfSession iDfSession) throws DfException {
        IClientRegistration iClientRegistration2 = iClientRegistration;
        IDfSession iDfSession2 = iDfSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            void reg;
            IPublicKeyCertificate iPublicKeyCertificate;
            IPublicKeyCertificate iPublicKeyCertificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            IPublicKeyCertificate iPublicKeyCertificate3 = iPublicKeyCertificate2 = (iPublicKeyCertificate = IpAndRcHelper.getCertificate((IClientRegistration)reg, (IDfSession)session));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(iPublicKeyCertificate2, joinPoint);
            }
            return iPublicKeyCertificate;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)iClientRegistration2, (Object)iDfSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private RegAndItsAcl createNewRegistrationObjectButCleanItUpFirst() throws DfException {
        JoinPoint joinPoint = null;
        try {
            RegAndItsAcl regAndItsAcl;
            RegAndItsAcl regAndItsAcl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            RegAndItsAcl dbData = new RegAndItsAcl();
            dbData.reg = this.getRegistration(this.m_publicIdentity, this.m_grSession);
            if (null != dbData.reg) {
                dbData.reg.destroy();
            }
            dbData.reg = (IClientRegistration)this.m_grSession.newObject("dm_client_registration");
            if (IpAndRcHelper.typeExists("dm_acl_registration", (ISession)this.m_grSession)) {
                dbData.acl = (IDfACL)this.m_grSession.newObject("dm_acl_registration");
            } else {
                dbData.acl = (IDfACL)this.m_grSession.newObject("dm_acl");
                dbData.acl = IpAndRcHelper.fillAndSaveACLForClientRegistration(dbData.acl);
            }
            RegAndItsAcl regAndItsAcl3 = regAndItsAcl2 = (regAndItsAcl = dbData);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(regAndItsAcl2, joinPoint);
            }
            return regAndItsAcl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DfcIdentityPublisher.java", Class.forName("com.documentum.fc.client.security.impl.DfcIdentityPublisher"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publish", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "void"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publish", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "boolean:", "selfHeal:", "com.documentum.fc.common.DfException:", "void"), 116);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isRegistrationAndCertificate", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.security.internal.IPublicIdentity:com.documentum.fc.client.IDfSession:", "iks:grSession:", "com.documentum.fc.common.DfException:", "com.documentum.fc.common.IDfId"), 483);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCertificate", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.privilege.internal.IClientRegistration:com.documentum.fc.client.IDfSession:", "reg:session:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.privilege.internal.IPublicKeyCertificate"), 540);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createNewRegistrationObjectButCleanItUpFirst", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.security.impl.RegAndItsAcl"), 546);
        ajc$tjp_13 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:"), 572);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "recall", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "void"), 214);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPublished", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "boolean"), 297);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRegistrationRecord", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "boolean"), 386);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createCertificateAndRegistration", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "", "", "com.documentum.fc.common.DfException:", "void"), 427);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isRegistration", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.security.internal.IPublicIdentity:com.documentum.fc.client.IDfSession:", "iks:grSession:", "com.documentum.fc.common.DfException:", "boolean"), 443);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isRegistration", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.privilege.internal.IClientRegistration:", "registration:", "com.documentum.fc.common.DfException:", "boolean"), 450);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isCertificate", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.privilege.internal.IClientRegistration:com.documentum.fc.client.IDfSession:", "reg:session:", "com.documentum.fc.common.DfException:", "boolean"), 461);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getRegistration", "com.documentum.fc.client.security.impl.DfcIdentityPublisher", "com.documentum.fc.client.security.internal.IPublicIdentity:com.documentum.fc.client.IDfSession:", "iks:grSession:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.privilege.internal.IClientRegistration"), 466);
        m_publishMutex = new Object();
    }
}

