/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.security;

import com.documentum.fc.client.impl.bof.security.RoleRequestManager;
import com.documentum.fc.client.security.DfRoleSpec;
import com.documentum.fc.common.DfLogger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPrivilegedExceptionActionInRole<T>
implements PrivilegedExceptionAction<T> {
    private final boolean m_propagate;
    private final DfRoleSpec[] m_roleSpecs;
    private final PrivilegedExceptionAction<T> m_targetAction;

    public DfPrivilegedExceptionActionInRole(DfRoleSpec roleSpec, PrivilegedExceptionAction<T> targetAction) {
        this(roleSpec, true, targetAction);
    }

    public DfPrivilegedExceptionActionInRole(DfRoleSpec roleSpec, boolean propagate, PrivilegedExceptionAction<T> targetAction) {
        if (roleSpec == null) {
            throw new NullPointerException("roleSpec");
        }
        if (targetAction == null) {
            throw new NullPointerException("targetAction");
        }
        this.m_roleSpecs = new DfRoleSpec[]{roleSpec};
        this.m_propagate = propagate;
        this.m_targetAction = targetAction;
    }

    public DfPrivilegedExceptionActionInRole(DfRoleSpec[] roleSpecs, boolean propagate, PrivilegedExceptionAction<T> targetAction) {
        if (roleSpecs == null) {
            throw new NullPointerException("roleSpecs");
        }
        if (targetAction == null) {
            throw new NullPointerException("targetAction");
        }
        this.m_roleSpecs = roleSpecs;
        this.m_propagate = propagate;
        this.m_targetAction = targetAction;
    }

    @Override
    public T run() throws Exception {
        if (DfLogger.isInfoEnabled(this)) {
            DfLogger.info((Object)this, "DFC_PRIVILEGE_ASSUME", new Object[]{Arrays.asList(this.m_roleSpecs), this.m_propagate}, null);
        }
        this.pushPermissionRequest();
        try {
            T t = this.m_targetAction.run();
            return t;
        }
        catch (AccessControlException e) {
            DfLogger.error((Object)this, "DFC_PRIVILEGE_ASSUME_ERROR", new Object[]{Arrays.asList(this.m_roleSpecs), this.m_propagate}, (Throwable)e);
            throw e;
        }
        finally {
            this.popPermissionRequest();
        }
    }

    private void pushPermissionRequest() {
        if (this.m_propagate) {
            RoleRequestManager.getInstance().push(this.m_roleSpecs, AccessController.getContext());
        } else {
            RoleRequestManager.getInstance().push(this.m_roleSpecs);
        }
    }

    private void popPermissionRequest() {
        RoleRequestManager.getInstance().pop(this.m_roleSpecs);
    }
}

