/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.IDfSearchSourceMap;
import com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.IDfValue;

public class ResultComparer {
    public static boolean isResultMoreRecent(IDfSearchSourceMap sourceMap, DfResultEntry r1, DfResultEntry r2) throws DfException {
        String source = r1.getSource();
        if (source == null) {
            throw new DfException("Source of reference result is not valid: [" + source + "]");
        }
        int compare = 0;
        String[] attrNames = null;
        DfSearchSource sourceObj = (DfSearchSource)sourceMap.getSource(source);
        if (sourceObj != null && sourceObj.hasCapability("duplicate_removal_support")) {
            attrNames = sourceObj.getModificationKeys();
        }
        if (attrNames == null || attrNames.length == 0) {
            int attrCount = r1.getAttrCount();
            for (int i = 0; i < attrCount && compare == 0; ++i) {
                IDfAttr attr = r1.getAttr(i);
                if (ResultComparer.isInternalAttribute(attr.getName())) continue;
                compare = ResultComparer.compareAttribute(r1, r2, attr);
            }
        } else {
            for (int i = 0; i < attrNames.length && compare == 0; ++i) {
                IDfAttr attr = r1.getAttr(attrNames[i]);
                if (attr == null) {
                    throw new DfException("Failed to compare results according to attribute [" + attrNames[i] + "]");
                }
                compare = ResultComparer.compareAttribute(r1, r2, attr);
            }
        }
        return compare > 0;
    }

    private static int compareAttribute(DfResultEntry r1, DfResultEntry r2, IDfAttr attr) throws DfException {
        int compare;
        String attrName = attr.getName();
        if (DfLogger.isDebugEnabled(ResultComparer.class)) {
            ResultComparer.trace("compareAttribute: [" + attrName + "]");
        }
        if (!r1.hasAttr(attrName)) {
            return -1;
        }
        if (!r2.hasAttr(attrName)) {
            return 1;
        }
        switch (attr.getDataType()) {
            case 4: {
                compare = ResultComparer.compareTime(r1, r2, attrName);
                break;
            }
            case 1: {
                compare = ResultComparer.compareInt(r1, r2, attrName);
                break;
            }
            case 5: {
                compare = ResultComparer.compareDouble(r1, r2, attrName);
                break;
            }
            default: {
                compare = ResultComparer.compareAttributeValues(r1, r2, attrName);
            }
        }
        if (DfLogger.isDebugEnabled(ResultComparer.class) && compare != 0) {
            ResultComparer.trace("compareAttribute: (compare) modification detected on attribute = [" + attrName + "]");
        }
        return compare;
    }

    private static int compareTime(IDfResultEntry r1, IDfResultEntry r2, String chronologicalKey) {
        IDfTime time2;
        int index = r1.findAttrIndex(chronologicalKey);
        IDfTime time1 = index == -1 ? null : r1.getValueAt(index).asTime();
        index = r2.findAttrIndex(chronologicalKey);
        IDfTime iDfTime = time2 = index == -1 ? null : r2.getValueAt(index).asTime();
        if (time2 == null) {
            if (DfLogger.isDebugEnabled(ResultComparer.class)) {
                ResultComparer.trace("isMoreRecentTime: (compare) newer (no date)");
            }
            return 1;
        }
        if (time1 == null) {
            if (DfLogger.isDebugEnabled(ResultComparer.class)) {
                ResultComparer.trace("isMoreRecentTime: (compare) older (no date)");
            }
            return -1;
        }
        int moreRecent = time1.compareTo(time2);
        if (DfLogger.isDebugEnabled(ResultComparer.class)) {
            ResultComparer.trace("isMoreRecentTime: (compare " + time1 + " , " + time2 + " ) " + (moreRecent < 0 ? "newer" : "older") + " Date.");
        }
        return moreRecent;
    }

    private static int compareDouble(IDfResultEntry r1, IDfResultEntry r2, String chronologicalKey) {
        double version2;
        int index = r1.findAttrIndex(chronologicalKey);
        double version1 = index == -1 ? Double.MIN_VALUE : r1.getValueAt(index).asDouble();
        index = r2.findAttrIndex(chronologicalKey);
        double d = version2 = index == -1 ? Double.MIN_VALUE : r2.getValueAt(index).asDouble();
        if (DfLogger.isDebugEnabled(ResultComparer.class)) {
            ResultComparer.trace("isMoreRecentTime: (compare " + version1 + " , " + version2 + " ) " + (version1 > version2 ? "newer" : "older") + " Double.");
        }
        if (version1 > version2) {
            return 1;
        }
        if (version1 < version2) {
            return -1;
        }
        return 0;
    }

    private static int compareInt(IDfResultEntry r1, IDfResultEntry r2, String chronologicalKey) {
        int version2;
        int index = r1.findAttrIndex(chronologicalKey);
        int version1 = index == -1 ? Integer.MIN_VALUE : r1.getValueAt(index).asInteger();
        index = r2.findAttrIndex(chronologicalKey);
        int n = version2 = index == -1 ? Integer.MIN_VALUE : r2.getValueAt(index).asInteger();
        if (DfLogger.isDebugEnabled(ResultComparer.class)) {
            ResultComparer.trace("isMoreRecentTime: (compare " + version1 + " , " + version2 + " ) " + (version1 > version2 ? "newer" : "older") + " Int.");
        }
        if (version1 > version2) {
            return 1;
        }
        if (version1 < version2) {
            return -1;
        }
        return 0;
    }

    private static int compareAttributeValues(IDfResultEntry r1, IDfResultEntry r2, String chronologicalKey) throws DfException {
        IDfValue a1 = r1.getValue(chronologicalKey);
        IDfValue a2 = r2.getValue(chronologicalKey);
        return a1.compareTo(a2);
    }

    private static boolean isInternalAttribute(String attributeName) {
        return attributeName.equals("r_collect_date") || attributeName.equals("r_seqNumber") || attributeName.equals("r_globalSeqNumber") || attributeName.equals("r_source") || attributeName.equals("score");
    }

    private static void trace(String msg) {
        DfLogger.debug(ResultComparer.class, msg, null, null);
    }
}

