/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.DfFacetDefinition;
import com.documentum.fc.client.search.IDfFacet;
import com.documentum.fc.client.search.IDfFacetValue;
import com.documentum.fc.client.search.impl.result.Facet;
import com.documentum.fc.client.search.impl.result.FacetValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetsList {
    private List<IDfFacet> m_facets = new ArrayList<IDfFacet>();

    public List<IDfFacet> getFacets() {
        ArrayList<IDfFacet> copy = new ArrayList<IDfFacet>(this.m_facets.size());
        copy.addAll(this.m_facets);
        return copy;
    }

    public void add(Iterable<IDfFacet> facets) {
        for (IDfFacet facet : facets) {
            int facetIndex = this.m_facets.indexOf(facet);
            if (facetIndex >= 0) {
                IDfFacet previousFacet = this.m_facets.get(facetIndex);
                IDfFacet mergedFacets = FacetsList.merge(previousFacet, facet);
                this.m_facets.set(facetIndex, mergedFacets);
                continue;
            }
            this.m_facets.add(facet);
        }
    }

    private static IDfFacet merge(IDfFacet left, IDfFacet right) {
        DfFacetDefinition definition = left.getDefinition();
        List<IDfFacetValue> leftValues = left.getValues();
        List<IDfFacetValue> rightValues = right.getValues();
        List<IDfFacetValue> mergedList = FacetsList.mergeValueLists(definition, leftValues, rightValues);
        Facet mergedFacet = new Facet(definition);
        mergedFacet.add(mergedList);
        return mergedFacet;
    }

    private static List<IDfFacetValue> mergeValueLists(DfFacetDefinition definition, List<IDfFacetValue> leftValues, List<IDfFacetValue> rightValues) {
        int numberOfValueToKeep;
        List<IDfFacetValue> mergedList = new ArrayList<IDfFacetValue>();
        for (IDfFacetValue value : leftValues) {
            mergedList.add(value);
        }
        for (IDfFacetValue value : rightValues) {
            int previousValueIndex = mergedList.indexOf(value);
            if (previousValueIndex >= 0) {
                IDfFacetValue previousValue = (IDfFacetValue)mergedList.get(previousValueIndex);
                FacetValue mergedValue = FacetsList.mergeValues(definition, previousValue, value);
                mergedList.set(previousValueIndex, mergedValue);
                continue;
            }
            mergedList.add(value);
        }
        Comparator<IDfFacetValue> comparator = FacetsList.getComparator(definition);
        Collections.sort(mergedList, comparator);
        if (definition.hasMax() && definition.getMax() >= 0 && (numberOfValueToKeep = definition.getMax().intValue()) <= mergedList.size()) {
            mergedList = mergedList.subList(0, numberOfValueToKeep);
        }
        return mergedList;
    }

    private static FacetValue mergeValues(DfFacetDefinition definition, IDfFacetValue leftValue, IDfFacetValue rightValue) {
        List<IDfFacetValue> mergedSubFacets;
        FacetValue mergedValue = new FacetValue(leftValue.getValue(), leftValue.getCount() + rightValue.getCount());
        if (leftValue.hasProperties()) {
            Map<String, String> props = leftValue.getProperties();
            for (Map.Entry<String, String> prop : props.entrySet()) {
                mergedValue.addProperty(prop.getKey(), prop.getValue());
            }
        }
        if (leftValue.hasSubFacetValues() && rightValue.hasSubFacetValues()) {
            mergedSubFacets = FacetsList.mergeValueLists(definition.getSubFacetDefinition(), leftValue.getSubFacetValues(), rightValue.getSubFacetValues());
            mergedValue.setSubFacetsValues(mergedSubFacets);
        } else if (leftValue.hasSubFacetValues()) {
            mergedSubFacets = leftValue.getSubFacetValues();
            mergedValue.setSubFacetsValues(mergedSubFacets);
        } else if (rightValue.hasSubFacetValues()) {
            mergedSubFacets = rightValue.getSubFacetValues();
            mergedValue.setSubFacetsValues(mergedSubFacets);
        }
        return mergedValue;
    }

    private static Comparator<IDfFacetValue> getComparator(DfFacetDefinition definition) {
        Serializable comparator = definition.getOrderBy() == DfFacetDefinition.ORDER.VALUE_ASCENDING ? new ValueAscendingComparator() : (definition.getOrderBy() == DfFacetDefinition.ORDER.FREQUENCY ? new FrequencyComparator() : (definition.getOrderBy() == DfFacetDefinition.ORDER.VALUE_DESCENDING ? new ValueDescendingComparator() : (definition.getOrderBy() == DfFacetDefinition.ORDER.NONE ? new NoComparator() : new FrequencyComparator())));
        return comparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoComparator
    implements Comparator<IDfFacetValue>,
    Serializable {
        private NoComparator() {
        }

        @Override
        public int compare(IDfFacetValue left, IDfFacetValue right) {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyComparator
    implements Comparator<IDfFacetValue>,
    Serializable {
        private FrequencyComparator() {
        }

        @Override
        public int compare(IDfFacetValue left, IDfFacetValue right) {
            int leftValue = left.getCount();
            int rightValue = right.getCount();
            return rightValue - leftValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueDescendingComparator
    implements Comparator<IDfFacetValue>,
    Serializable {
        private ValueDescendingComparator() {
        }

        @Override
        public int compare(IDfFacetValue left, IDfFacetValue right) {
            String leftValue = left.getValue();
            String rightValue = right.getValue();
            if (leftValue == null) {
                return 1;
            }
            return rightValue.compareTo(leftValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueAscendingComparator
    implements Comparator<IDfFacetValue>,
    Serializable {
        private ValueAscendingComparator() {
        }

        @Override
        public int compare(IDfFacetValue left, IDfFacetValue right) {
            String leftValue = left.getValue();
            String rightValue = right.getValue();
            if (leftValue == null) {
                return -1;
            }
            return leftValue.compareTo(rightValue);
        }
    }
}

