/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfFacetValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetValue
implements IDfFacetValue {
    private String m_value;
    private int m_count;
    private List<IDfFacetValue> m_subFacetsValues;
    private Map<String, String> m_properties;

    public FacetValue(String value, int count) {
        this.m_value = value;
        this.m_count = count;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    @Override
    public int getCount() {
        return this.m_count;
    }

    public void addSubfacetValue(FacetValue facetValue) {
        this.getSubFacetValues().add(facetValue);
    }

    @Override
    public boolean hasSubFacetValues() {
        return this.m_subFacetsValues != null;
    }

    @Override
    public List<IDfFacetValue> getSubFacetValues() {
        if (this.m_subFacetsValues == null) {
            this.m_subFacetsValues = new ArrayList<IDfFacetValue>();
        }
        return this.m_subFacetsValues;
    }

    public void setSubFacetsValues(List<IDfFacetValue> facetValues) {
        this.m_subFacetsValues = facetValues;
    }

    public void addProperty(String name, String value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, String>(2);
        }
        this.m_properties.put(name, value);
    }

    @Override
    public boolean hasProperties() {
        return this.m_properties != null;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = Collections.emptyMap();
        }
        return this.m_properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacetValue that = (FacetValue)o;
        return !(this.m_value != null ? !this.m_value.equals(that.m_value) : that.m_value != null);
    }

    public int hashCode() {
        return this.m_value != null ? this.m_value.hashCode() : 0;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(this.m_value + "(" + this.m_count + ")");
        if (this.m_subFacetsValues != null) {
            FacetValue.appendListAsString(out, this.m_subFacetsValues);
        }
        if (this.m_properties != null) {
            FacetValue.appendMapWithKeysOrdered(out, this.m_properties);
        }
        return out.toString();
    }

    private static <Key extends Comparable, Value> void appendMapWithKeysOrdered(StringBuilder out, Map<Key, Value> properties) {
        ArrayList<String> orderedProps = new ArrayList<String>();
        Set<Key> keys = properties.keySet();
        ArrayList<Key> keysList = new ArrayList<Key>(keys);
        Collections.sort(keysList);
        for (Comparable key : keysList) {
            orderedProps.add(key + "=" + properties.get(key));
        }
        FacetValue.appendListAsString(out, orderedProps);
    }

    private static void appendListAsString(StringBuilder out, Iterable list) {
        out.append("[");
        boolean isFirst = true;
        for (Object value : list) {
            if (!isFirst) {
                out.append(",");
            }
            out.append(value);
            isFirst = false;
        }
        out.append("]");
    }
}

