/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfPerceptualRaterConfig;
import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.IDfResultRaterConfig;
import com.documentum.fc.client.search.IDfResultRaterFactory;
import com.documentum.fc.client.search.IDfResultsManipulator;
import com.documentum.fc.client.search.IDfResultsSet;
import com.documentum.fc.client.search.impl.rater.PerceptualRaterFactory;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.client.search.impl.result.DfBasicSorter;
import com.documentum.fc.client.search.impl.result.DfBooleanAttributeSorter;
import com.documentum.fc.client.search.impl.result.DfDoubleAttributeSorter;
import com.documentum.fc.client.search.impl.result.DfIntegerAttributeSorter;
import com.documentum.fc.client.search.impl.result.DfStringAttributeSorter;
import com.documentum.fc.client.search.impl.result.DfTimeAttributeSorter;
import com.documentum.fc.common.IDfAttr;
import java.util.Comparator;

public class DfResultsManipulator
implements IDfResultsManipulator {
    public IDfResultsSet sortBy(IDfResultsSet results, String attrName, boolean ascend) {
        if (results == null) {
            return null;
        }
        ADfResultsSorter sorter = null;
        IDfAttr attr = null;
        while (attr == null && results.next()) {
            IDfResultEntry refRes = results.getResult();
            attr = refRes.getAttr(attrName);
        }
        results.reset();
        sorter = DfResultsManipulator.getAttributeSorter(attr, ascend);
        if (sorter == null) {
            return results;
        }
        return sorter.stableSort(results);
    }

    public IDfResultsSet sortBy(IDfResultsSet results, Comparator comparer) {
        DfBasicSorter sorter = new DfBasicSorter(comparer);
        if (sorter == null) {
            return results;
        }
        return sorter.stableSort(results);
    }

    public IDfResultRaterFactory newPerceptualRaterFactory(IDfResultRaterConfig resultRaterConfig, IDfPerceptualRaterConfig perceptualRaterConfig) {
        return new PerceptualRaterFactory(resultRaterConfig, perceptualRaterConfig);
    }

    private static ADfResultsSorter getAttributeSorter(IDfAttr attr, boolean ascend) {
        ADfResultsSorter comp = null;
        if (attr == null) {
            return null;
        }
        switch (attr.getDataType()) {
            case 1: {
                comp = new DfIntegerAttributeSorter(attr.getName(), ascend);
                break;
            }
            case 5: {
                comp = new DfDoubleAttributeSorter(attr.getName(), ascend);
                break;
            }
            case 4: {
                comp = new DfTimeAttributeSorter(attr.getName(), ascend);
                break;
            }
            case 0: {
                comp = new DfBooleanAttributeSorter(attr.getName(), ascend);
                break;
            }
            default: {
                comp = new DfStringAttributeSorter(attr.getName(), ascend);
            }
        }
        return comp;
    }
}

