/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.DfIteratorWrapper;
import com.documentum.fc.client.IDfEnumeration;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.IDfModifiableResultEntry;
import com.documentum.fc.client.search.impl.IDfSearchConstants;
import com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource;
import com.documentum.fc.client.search.impl.result.AttributeCache;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfList;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.IDfValue;
import com.documentum.fc.impl.util.DfSimpleEncoderDecoder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import xtrim.data.DataException;
import xtrim.data.DataFactory;
import xtrim.data.EmbeddedObjectReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfResultEntry
implements IDfModifiableResultEntry {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final int URL_MAX_LENGTH = 1024;
    private static final int ATTR_SOURCE_INDEX = 0;
    private static final int ATTR_SCORE_INDEX = 1;
    private static final int ATTR_SEQ_NUMBER_INDEX = 2;
    private static final int ATTR_GLOBAL_SEQ_NUMBER_INDEX = 3;
    private static final IDfAttr ATTR_SOURCE = new Attribute(0, "r_source", false, 2, 256);
    private static final IDfAttr ATTR_SCORE = new Attribute(1, "score", false, 5, -1);
    private static final IDfAttr ATTR_SEQ_NUMBER = new Attribute(2, "r_seqNumber", false, 1, -1);
    private static final IDfAttr ATTR_GLOBAL_SEQ_NUMBER = new Attribute(3, "r_globalSeqNumber", false, 1, -1);
    private static final IDfValue DEFAULT_SCORE = new DfValue("0", 5);
    private static final IDfValue DEFAULT_SEQ_NUMBER = new DfValue("-1", 1);
    private static final IDfValue DEFAULT_GLOBAL_SEQ_NUMBER = new DfValue("-1", 1);
    private static final Collection<String> EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList(0));
    private List<IDfAttr> m_attrs;
    private List<IDfValue> m_values;
    private int m_status;
    private EmbeddedObjectReference m_ecisObjectRef;
    private String m_key;
    private DfSearchSource m_source;
    private Collection<String> m_matchingTerms;

    private DfResultEntry() {
        this.m_source = null;
        this.m_attrs = new ArrayList<IDfAttr>(25);
        this.m_values = new ArrayList<IDfValue>(25);
        this.m_status = 2;
        this.m_key = null;
        this.m_ecisObjectRef = null;
        this.m_matchingTerms = EMPTY_COLLECTION;
    }

    public DfResultEntry(String key) {
        this();
        this.m_key = key;
    }

    public DfResultEntry(DfSearchSource source) {
        this();
        this.m_source = source;
        this.doAddAttribute(ATTR_SOURCE, AttributeCache.access().getCachedSource(source.getName()));
        this.doAddAttribute(ATTR_SCORE, DEFAULT_SCORE);
        this.doAddAttribute(ATTR_SEQ_NUMBER, DEFAULT_SEQ_NUMBER);
        this.doAddAttribute(ATTR_GLOBAL_SEQ_NUMBER, DEFAULT_GLOBAL_SEQ_NUMBER);
    }

    public DfResultEntry(DfResultEntry oldResult) {
        this.m_attrs = new ArrayList<IDfAttr>(oldResult.m_attrs);
        this.m_values = new ArrayList<IDfValue>(oldResult.m_values);
        this.m_source = oldResult.m_source;
        this.m_status = oldResult.m_status;
        this.m_key = oldResult.m_key;
        this.m_ecisObjectRef = oldResult.m_ecisObjectRef;
        this.m_matchingTerms = oldResult.m_matchingTerms;
    }

    @Override
    public void setMatchingTerms(List matchingTerms) {
        this.m_matchingTerms = matchingTerms;
    }

    public void addMatchingTerms(IDfList matchingTerms) {
        if (DfLogger.isDebugEnabled(this)) {
            DfLogger.debug((Object)this, "Matching terms: " + DfResultEntry.toString(matchingTerms), null, null);
        }
        int count = matchingTerms.getCount();
        if (this.m_matchingTerms == EMPTY_COLLECTION && count > 0) {
            this.m_matchingTerms = new ArrayList<String>(count);
        }
        for (int i = 0; i < count; ++i) {
            String matchingTerm = DfResultEntry.getListValue(matchingTerms, i).asString();
            this.addMatchingTerm(matchingTerm);
        }
    }

    @Override
    public IDfEnumeration getMatchingTerms() {
        return new DfIteratorWrapper(this.m_matchingTerms.iterator());
    }

    @Override
    public boolean isUrlAddressible() {
        return this.hasAttr("url");
    }

    @Override
    public boolean isRepositoryObject() {
        return this.hasAttr(IDfSearchConstants.ATTR_OBJECT_ID);
    }

    @Override
    public String getKey() {
        return this.getDeDuplicationKey();
    }

    @Override
    public String getSource() {
        return this.getString("r_source");
    }

    @Override
    public double getScore() {
        return this.getDouble("score");
    }

    public boolean isDefaultScore() {
        return this.getValue("score") == DEFAULT_SCORE;
    }

    @Override
    public void setScore(double score) {
        assert (score >= 0.0 && score <= 1.0) : "Invalid score=" + score;
        this.setValue("score", (IDfValue)new DfValue(Double.toString(score), 5));
    }

    @Override
    public int getSeqNumber() {
        return this.getInt("r_seqNumber");
    }

    @Override
    public void setSeqNumber(int seqNumber) {
        this.setModified();
        this.setValue("r_seqNumber", (IDfValue)new DfValue(Integer.toString(seqNumber), 1));
    }

    @Override
    public int getGlobalSeqNumber() {
        return this.getInt("r_globalSeqNumber");
    }

    @Override
    public void setGlobalSeqNumber(int globalSeqNumber) {
        this.setModified();
        this.setValue("r_globalSeqNumber", (IDfValue)new DfValue(Integer.toString(globalSeqNumber), 1));
    }

    @Override
    public boolean getBoolean(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asBoolean();
    }

    @Override
    public double getDouble(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asDouble();
    }

    @Override
    public int getInt(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asInteger();
    }

    @Override
    public String getString(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asString();
    }

    @Override
    public IDfTime getTime(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asTime();
    }

    @Override
    public IDfId getId(String attrName) throws IllegalArgumentException {
        return this.getValue(attrName).asId();
    }

    @Override
    public long getLong(String attrName) throws IllegalArgumentException {
        String stringValue = this.getString(attrName);
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public boolean getRepeatingBoolean(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asBoolean();
    }

    @Override
    public double getRepeatingDouble(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asDouble();
    }

    @Override
    public int getRepeatingInt(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asInteger();
    }

    @Override
    public String getRepeatingString(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asString();
    }

    @Override
    public IDfTime getRepeatingTime(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asTime();
    }

    @Override
    public IDfId getRepeatingId(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex).asId();
    }

    @Override
    public IDfValue getRepeatingValue(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        IDfList list = this.getList(attrName);
        return DfResultEntry.getListValue(list, valueIndex);
    }

    @Override
    public long getRepeatingLong(String attrName, int valueIndex) throws IllegalArgumentException, IndexOutOfBoundsException {
        String stringValue = this.getRepeatingString(attrName, valueIndex);
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public String getAllRepeatingStrings(String attrName, String separator) throws IllegalArgumentException {
        int count;
        if (!this.isAttrRepeating(attrName)) {
            return this.getString(attrName);
        }
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        if ((count = this.getValueCount(attrName)) > 0) {
            StringBuffer sb = new StringBuffer(64 * count);
            sb.append(this.getRepeatingString(attrName, 0));
            for (int i = 1; i < count; ++i) {
                sb.append(separator);
                sb.append(this.getRepeatingString(attrName, i));
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public int findBoolean(String attrName, boolean value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            if (value != DfResultEntry.getListValue(list, i).asBoolean()) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int findInt(String attrName, int value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            if (value != DfResultEntry.getListValue(list, i).asInteger()) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int findDouble(String attrName, double value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        for (int i = 0; i < count; ++i) {
            if (value != DfResultEntry.getListValue(list, i).asDouble()) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int findId(String attrName, IDfId value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        if (value != null) {
            for (int i = 0; i < count; ++i) {
                if (!((Object)value).equals(DfResultEntry.getListValue(list, i).asId())) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public int findString(String attrName, String value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        if (value != null) {
            for (int i = 0; i < count; ++i) {
                if (!value.equals(DfResultEntry.getListValue(list, i).asString())) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public int findTime(String attrName, IDfTime value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        if (value != null) {
            for (int i = 0; i < count; ++i) {
                if (!((Object)value).equals(DfResultEntry.getListValue(list, i).asTime())) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public int findValue(String attrName, IDfValue value) throws IllegalArgumentException {
        IDfList list = this.getList(attrName);
        int count = list.getCount();
        int index = -1;
        if (value != null) {
            for (int i = 0; i < count; ++i) {
                if (!((Object)value).equals(DfResultEntry.getListValue(list, i))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public boolean hasAttr(String attrName) {
        return this.findAttrIndex(attrName) != -1;
    }

    @Override
    public IDfAttr getAttr(String attrName) {
        int index = this.findAttrIndex(attrName);
        return index == -1 ? null : this.getAttr(index);
    }

    @Override
    public IDfAttr getAttr(int attrIndex) throws IndexOutOfBoundsException {
        return this.m_attrs.get(attrIndex);
    }

    @Override
    public int findAttrIndex(String attrName) {
        int attrCount = this.m_attrs.size();
        if (attrCount == 0) {
            return -1;
        }
        int index = AttributeCache.access().getAttributeIndexHint(attrName);
        if (index != -1 && index < attrCount && this.getAttr(index).getName().equals(attrName)) {
            return index;
        }
        for (int i = 0; i < attrCount; ++i) {
            IDfAttr attr = this.m_attrs.get(i);
            if (!attr.getName().equals(attrName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IDfEnumeration enumAttrs() {
        return new DfIteratorWrapper(this.m_attrs.iterator());
    }

    @Override
    public int getAttrCount() {
        return this.m_attrs.size();
    }

    @Override
    public int getAttrDataType(String attrName) throws IllegalArgumentException {
        IDfAttr attr = this.getAttr(attrName);
        if (attr == null) {
            throw new IllegalArgumentException(attrName);
        }
        return attr.getDataType();
    }

    @Override
    public boolean isAttrRepeating(String attrName) throws IllegalArgumentException {
        IDfAttr attr = this.getAttr(attrName);
        if (attr == null) {
            throw new IllegalArgumentException(attrName);
        }
        return attr.isRepeating();
    }

    @Override
    public int getValueCount(String attrName) {
        int attrIndex = this.findAttrIndex(attrName);
        if (attrIndex == -1) {
            return 0;
        }
        if (this.getAttr(attrIndex).isRepeating()) {
            DfValue value = (DfValue)this.getValueAt(attrIndex);
            IDfList list = value.asList();
            return list.getCount();
        }
        return 1;
    }

    @Override
    public IDfValue getValueAt(int attrIndex) throws IndexOutOfBoundsException {
        return this.m_values.get(attrIndex);
    }

    @Override
    public IDfValue getValue(String attrName) throws IllegalArgumentException {
        int index = this.findAttrIndex(attrName);
        if (index == -1) {
            throw new IllegalArgumentException(attrName);
        }
        return this.getValueAt(index);
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    public String getDeDuplicationKey() {
        block3: {
            if (this.m_key == null) {
                String key = this.isRepositoryObject() ? "docbase:" + this.getString(IDfSearchConstants.ATTR_OBJECT_ID) : this.getExtDuplKey();
                try {
                    this.m_key = new String(DfSimpleEncoderDecoder.base64Encode(key.getBytes("UTF-8")));
                    this.m_source = null;
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"UTF-8 encoding should always be supported to encode the result entry key.");
                }
            }
        }
        return this.m_key;
    }

    protected String getClearDeDuplKey() {
        String clearKey;
        block3: {
            clearKey = null;
            if (this.m_key != null) {
                try {
                    clearKey = new String(DfSimpleEncoderDecoder.base64Decode(this.m_key.toCharArray()), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"UTF-8 encoding should always be supported to decode the result entry key.");
                }
            }
        }
        return clearKey;
    }

    protected String getDeDuplAttr() {
        if (this.isRepositoryObject()) {
            return "DOCBASE:" + IDfSearchConstants.ATTR_OBJECT_ID;
        }
        if (this.m_source == null) {
            return "EXT";
        }
        String attr = null;
        if (this.m_source.hasCapability("duplicate_removal_support")) {
            IDfAttr deDuplicationAttr;
            block9: {
                deDuplicationAttr = null;
                try {
                    deDuplicationAttr = this.m_source.getDeDuplicationKey();
                }
                catch (DfSearchException de) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)("Exception should not appear because we already checked that capability is supported. " + de.getStackTraceAsString()));
                }
            }
            String attrName = deDuplicationAttr.getName();
            if (this.hasAttr(attrName)) {
                attr = "EXT:" + attrName;
            } else if (attrName.equals("url") && this.getECISObjectReference() != null) {
                attr = "EXT:[object-ref]";
            }
        }
        if (attr == null) {
            attr = "EXT:[" + this.m_source.getName() + ":" + this.getSeqNumber() + "]";
        }
        return attr;
    }

    public EmbeddedObjectReference getECISObjectReference() {
        return this.m_ecisObjectRef;
    }

    public void setECISObjectReference(EmbeddedObjectReference embeddedObjectReference) {
        this.setModified();
        this.m_ecisObjectRef = embeddedObjectReference;
    }

    @Override
    public void setURL(String value) {
        this.setModified();
        if (this.hasAttr("url")) {
            this.setValue("url", (IDfValue)new DfValue(value, 2));
        } else {
            this.addAttribute("url", 2, value, 1024);
        }
    }

    public String getURL() {
        if (this.hasAttr("url")) {
            return this.getString("url");
        }
        return null;
    }

    public void addAttribute(IDfAttr attr, IDfValue value) throws IllegalArgumentException {
        assert (this.checkAttributeNotFound(attr.getName()));
        assert (this.checkTypeCompatibility(attr, value));
        int attrIndex = this.m_attrs.size();
        attr = AttributeCache.access().getCachedAttribute(attr, attrIndex);
        value = AttributeCache.getCachedValue(attr, value);
        this.doAddAttribute(attr, value);
    }

    @Override
    public void addAttribute(String attrName, int value) throws IllegalArgumentException {
        int index = this.getAttrCount();
        int attrType = 1;
        Attribute attrDef = new Attribute(index, attrName, false, attrType, -1);
        DfValue attrValue = new DfValue(Integer.toString(value), attrType);
        this.addAttribute(attrDef, attrValue);
    }

    @Override
    public void addAttribute(String attrName, double value) throws IllegalArgumentException {
        int index = this.getAttrCount();
        int attrType = 5;
        Attribute attrDef = new Attribute(index, attrName, false, attrType, -1);
        DfValue attrValue = new DfValue(Double.toString(value), attrType);
        this.addAttribute(attrDef, attrValue);
    }

    @Override
    public void addDateAttribute(String attrName, String value, String dateFormat) throws IllegalArgumentException {
        int index = this.getAttrCount();
        Attribute attrDef = new Attribute(index, attrName, false, 4, -1);
        DfTime time = new DfTime(value, dateFormat);
        if (!time.isValid()) {
            throw new IllegalArgumentException(value);
        }
        DfValue attrValue = new DfValue(time);
        this.addAttribute(attrDef, attrValue);
    }

    @Override
    public void addAttribute(String attrName, int type, String value) throws IllegalArgumentException {
        this.addAttribute(attrName, type, value, -1);
    }

    @Override
    public void addRepeatingAttribute(String attrName, int type, List values) throws IllegalArgumentException {
        this.addAttribute(attrName, true, type);
        for (int i = 0; i < values.size(); ++i) {
            String value = (String)values.get(i);
            this.appendRepeatingValue(attrName, new DfValue(value));
        }
    }

    public void addRepeatingAttributeValue(String attrName, int type, List<IDfValue> values) throws IllegalArgumentException {
        this.addAttribute(attrName, true, type);
        for (IDfValue value : values) {
            this.appendRepeatingValue(attrName, value);
        }
    }

    @Override
    public void addRepeatingDateAttribute(String attrName, int type, List values, String dateFormat) throws IllegalArgumentException {
        this.addAttribute(attrName, true, 4);
        for (int i = 0; i < values.size(); ++i) {
            String date = (String)values.get(i);
            DfTime time = new DfTime(date, dateFormat);
            if (!time.isValid()) {
                throw new IllegalArgumentException(date);
            }
            DfValue attrValue = new DfValue(time);
            this.appendRepeatingValue(attrName, attrValue);
        }
    }

    @Override
    public void setContentDescriptor(String contentDescriptor) throws DfException {
        try {
            this.setECISObjectReference(DataFactory.unpackageEmbeddedRefFromUrl((String)contentDescriptor));
        }
        catch (DataException e) {
            throw new DfSearchException("INVALID_CONTENT_DESCRIPTOR", (Throwable)e);
        }
    }

    @Override
    public String getContentDescriptor() throws DfException {
        if (this.getECISObjectReference() != null) {
            try {
                xtrim.data.Attribute attribute = DataFactory.createAttribute((String)"ref", (String)"refValue", (EmbeddedObjectReference)this.getECISObjectReference());
                return attribute.packageEmbeddedRefInUrl();
            }
            catch (DataException e) {
                throw new DfSearchException("INVALID_CONTENT_DESCRIPTOR", (Throwable)e);
            }
        }
        return null;
    }

    public void addAttribute(String attrName, int type, String value, int length) throws IllegalArgumentException {
        DfValue attrValue = new DfValue(value, type);
        this.addAttribute(attrName, type, attrValue, length);
    }

    public void addAttribute(String attrName, int type, IDfValue value, int length) throws IllegalArgumentException {
        int index = this.getAttrCount();
        Attribute attrDef = new Attribute(index, attrName, false, type, length);
        this.addAttribute(attrDef, value);
    }

    public void addAttribute(String attrName, boolean repeating, int type) throws IllegalArgumentException {
        this.addAttribute(attrName, repeating, type, -1);
    }

    public void addAttribute(String attrName, boolean repeating, int type, int length) throws IllegalArgumentException {
        int index = this.getAttrCount();
        Attribute attr = new Attribute(index, attrName, repeating, type, length);
        this.addAttribute(attr, null);
    }

    public void setValue(String attrName, IDfValue value) throws IllegalArgumentException {
        int attrIndex = this.findAttrIndex(attrName);
        if (attrIndex == -1) {
            throw new IllegalArgumentException(attrName);
        }
        this.setValue(attrIndex, value);
    }

    public void setValue(int attrIndex, IDfValue value) {
        IDfAttr attr = this.m_attrs.get(attrIndex);
        assert (this.checkTypeCompatibility(attr, value));
        this.m_values.set(attrIndex, AttributeCache.getCachedValue(attr, value));
        this.setModified();
    }

    public void appendRepeatingValue(String attrName, IDfValue value) throws IllegalArgumentException {
        int attrIndex = this.findAttrIndex(attrName);
        IDfAttr attr = this.getAttr(attrIndex);
        if (attr.getDataType() != value.getDataType() || !attr.isRepeating()) {
            throw new IllegalArgumentException("Type mismatch");
        }
        AttributeCache.appendRepeatingValue(this, attrIndex, value);
        this.setModified();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        String eol = System.getProperty("line.separator");
        int attrCount = this.getAttrCount();
        for (int i = 0; i < attrCount; ++i) {
            IDfAttr attr = this.getAttr(i);
            String name = attr.getName();
            out.append(name).append("=");
            String values = this.getAllRepeatingStrings(name, null);
            out.append(values).append(eol);
        }
        out.append("matchingTerms=").append(DfResultEntry.toString(this.getMatchingTerms())).append(eol);
        return out.toString();
    }

    private void doAddAttribute(IDfAttr attr, IDfValue value) {
        this.m_attrs.add(attr);
        this.m_values.add(value);
        this.setModified();
    }

    private void addMatchingTerm(String matchingTerm) {
        if (!this.m_matchingTerms.contains(matchingTerm = matchingTerm.toLowerCase())) {
            this.m_matchingTerms.add(matchingTerm);
        }
    }

    private static String toString(IDfEnumeration en) {
        StringBuffer buf = new StringBuffer(50);
        buf.append('[');
        if (en.hasMoreElements()) {
            buf.append(en.nextElement());
            while (en.hasMoreElements()) {
                buf.append(',').append(en.nextElement());
            }
        }
        buf.append(']');
        return buf.toString();
    }

    private static String toString(IDfList list) {
        StringBuffer buf;
        block4: {
            buf = new StringBuffer(50);
            buf.append('[');
            int size = list.getCount();
            if (size > 0) {
                try {
                    buf.append(list.get(0));
                    for (int i = 1; i < size; ++i) {
                        buf.append(',').append(list.get(i));
                    }
                }
                catch (DfException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        buf.append(']');
        return buf.toString();
    }

    protected IDfList getList(String attrName) throws IllegalArgumentException {
        int attrIndex = this.findAttrIndex(attrName);
        return this.getList(attrIndex);
    }

    protected IDfList getList(int attrIndex) throws IllegalArgumentException {
        if (attrIndex == -1 || !this.getAttr(attrIndex).isRepeating()) {
            throw new IllegalArgumentException(Integer.toString(attrIndex));
        }
        return ((DfValue)this.getValueAt(attrIndex)).asList();
    }

    private static IDfValue getListValue(IDfList list, int index) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            return list.getValue(index);
        }
        catch (DfException de) {
            throw new IllegalArgumentException("The list element must be an IDfValue");
        }
    }

    private boolean checkAttributeNotFound(String name) throws IllegalArgumentException {
        if (this.hasAttr(name)) {
            throw new IllegalArgumentException("Attribute " + name + " already exists");
        }
        return true;
    }

    private boolean checkTypeCompatibility(IDfAttr attr, IDfValue value) throws IllegalArgumentException {
        if (value != null && attr.getDataType() != value.getDataType()) {
            throw new IllegalArgumentException("Type mismatch between attribute and value");
        }
        return true;
    }

    private void setModified() {
    }

    private String getExtDuplKey() {
        String attrVal = null;
        if (this.m_source.hasCapability("duplicate_removal_support")) {
            IDfAttr deDuplicationAttr;
            block8: {
                deDuplicationAttr = null;
                try {
                    deDuplicationAttr = this.m_source.getDeDuplicationKey();
                }
                catch (DfSearchException de) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)("Exception should not appear because we already checked that capability is supported. " + de.getStackTraceAsString()));
                }
            }
            String attrName = deDuplicationAttr.getName();
            if (this.hasAttr(attrName)) {
                attrVal = this.getAllRepeatingStrings(attrName, null);
            } else if (attrName.equals("url") && this.getECISObjectReference() != null) {
                attrVal = this.getExtObjRefKey();
            }
            if (attrVal != null) {
                attrVal = attrVal.toLowerCase(Locale.ENGLISH);
            }
        }
        if (attrVal == null) {
            attrVal = "r_source:" + this.m_source.getName() + ":r_seqNum:" + this.getSeqNumber();
        }
        attrVal = "ext:" + attrVal;
        return attrVal;
    }

    private String getExtObjRefKey() {
        byte[] objRef = this.getECISObjectReference().getSerializedToken();
        return new String(DfSimpleEncoderDecoder.base64Encode(objRef));
    }
}

