/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.impl.result.ADfResultsSorter;
import com.documentum.fc.common.IDfAttr;
import java.util.Comparator;

public class DfIntegerAttributeSorter
extends ADfResultsSorter {
    private String m_criterion = null;
    private boolean m_ascendant = true;

    public DfIntegerAttributeSorter(String name, boolean ascend) {
        this.m_criterion = name;
        this.m_ascendant = ascend;
    }

    public Comparator getComparator() {
        if (this.m_ascendant) {
            return new IntAscendantAttribComparer();
        }
        return new IntDescendantAttribComparer();
    }

    private int getIntValue(IDfResultEntry entry, int index, int defaultValue) {
        int val = defaultValue;
        IDfAttr attr = entry.getAttr(this.m_criterion);
        if (attr != null && attr.getDataType() == 1) {
            if (attr.isRepeating() && index < entry.getValueCount(this.m_criterion)) {
                val = entry.getRepeatingInt(this.m_criterion, index);
            } else if (index == 0) {
                val = entry.getInt(this.m_criterion);
            }
        }
        return val;
    }

    private int compareInt(int value1, int value2) {
        int retval = 0;
        if (value1 < value2) {
            retval = -1;
        } else if (value2 < value1) {
            retval = 1;
        }
        return retval;
    }

    private class IntDescendantAttribComparer
    implements Comparator {
        private IntDescendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            int i = 0;
            while (retval == 0) {
                int val1 = DfIntegerAttributeSorter.this.getIntValue(entry1, i, Integer.MIN_VALUE);
                int val2 = DfIntegerAttributeSorter.this.getIntValue(entry2, i, Integer.MIN_VALUE);
                if (val1 == Integer.MIN_VALUE && val2 == Integer.MIN_VALUE) {
                    return 0;
                }
                retval = DfIntegerAttributeSorter.this.compareInt(val2, val1);
                ++i;
            }
            return retval;
        }
    }

    private class IntAscendantAttribComparer
    implements Comparator {
        private IntAscendantAttribComparer() {
        }

        public int compare(Object o1, Object o2) {
            IDfResultEntry entry1 = (IDfResultEntry)o1;
            IDfResultEntry entry2 = (IDfResultEntry)o2;
            int retval = 0;
            int i = 0;
            while (retval == 0) {
                int val1 = DfIntegerAttributeSorter.this.getIntValue(entry1, i, Integer.MAX_VALUE);
                int val2 = DfIntegerAttributeSorter.this.getIntValue(entry2, i, Integer.MAX_VALUE);
                if (val1 == Integer.MAX_VALUE && val2 == Integer.MAX_VALUE) {
                    return 0;
                }
                retval = DfIntegerAttributeSorter.this.compareInt(val1, val2);
                ++i;
            }
            return retval;
        }
    }
}

