/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.result;

import com.documentum.fc.client.search.IDfResultEntry;
import com.documentum.fc.client.search.IDfSearchSource;
import com.documentum.fc.client.search.IDfSearchSourceMap;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.client.search.impl.result.DfResultsSet;
import com.documentum.fc.client.search.impl.result.ResultComparer;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfList;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.common.IDfValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDuplicateRemover
extends DfResultsSet {
    private static final double EPSILON = 0.001;
    private boolean m_discardResult = false;
    private IDfSearchSourceMap m_sourceMap;

    public DfDuplicateRemover(IDfSearchSourceMap sourceMap) {
        this.m_sourceMap = sourceMap;
    }

    @Override
    public void add(IDfResultEntry result) {
        this.addResult(result);
    }

    public List addResultsGetFiltered(List<DfResultEntry> results) {
        ArrayList<DfResultEntry> filtered = new ArrayList<DfResultEntry>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            DfResultEntry r = results.get(i);
            int status = this.addResult(r);
            if (status == 1) continue;
            filtered.add(r);
        }
        return filtered;
    }

    public int addResult(IDfResultEntry r) {
        int status;
        DfResultEntry res = (DfResultEntry)r;
        this.m_discardResult = false;
        try {
            IDfSearchSource searchSource = this.getSearchSource(r.getSource());
            if (searchSource == null || !searchSource.hasCapability("duplicate_removal_support")) {
                if (DfLogger.isDebugEnabled(this)) {
                    this.trace("addResult - duplicates not supported by " + searchSource.getName(), null, null);
                }
                this.addValidResult(res);
                status = 2;
            } else {
                DfResultEntry old = this.findDuplicate(res);
                if (old == null) {
                    this.addValidResult(res);
                    status = 2;
                } else {
                    DfResultEntry mergedResult = new DfResultEntry(old);
                    boolean merged = this.mergeResults(res, mergedResult);
                    if (merged) {
                        this.setStatus(mergedResult, 3);
                        this.replaceResult(mergedResult);
                    }
                    status = 1;
                }
            }
        }
        catch (DfException e) {
            status = this.treatException(e, res);
        }
        if (DfLogger.isDebugEnabled(this)) {
            this.trace("addResult - [" + res.getClearDeDuplKey() + "](" + res.getDeDuplAttr() + ") => status=" + status, null, null);
        }
        return status;
    }

    private IDfSearchSource getSearchSource(String source) throws DfException {
        IDfSearchSource searchSrc = this.m_sourceMap.getSource(source);
        return searchSrc;
    }

    private void setStatus(DfResultEntry r, int status) {
        if (this.getStatus(r) == 1) {
            r.setStatus(status);
        }
    }

    private int getStatus(DfResultEntry r) {
        return r.getStatus();
    }

    private boolean mergeResults(DfResultEntry currentResult, DfResultEntry oldResult) throws DfException {
        boolean attrChanged;
        boolean sourceChanged = this.mergeSources(currentResult, oldResult);
        try {
            boolean moreRecent = ResultComparer.isResultMoreRecent(this.m_sourceMap, currentResult, oldResult);
            attrChanged = this.merge(currentResult, oldResult, moreRecent);
        }
        catch (DfException e) {
            if (DfLogger.isDebugEnabled(this)) {
                this.trace("mergeResults - failed to merge results", null, e);
            }
            this.m_discardResult = true;
            throw e;
        }
        if (DfLogger.isDebugEnabled(this)) {
            this.trace("mergeResults - [" + currentResult.getClearDeDuplKey() + "] additional source=" + sourceChanged + ", attr changed=" + attrChanged, null, null);
        }
        return sourceChanged || attrChanged;
    }

    private boolean mergeSources(DfResultEntry newResult, DfResultEntry oldResult) throws DfException {
        boolean oldResultChanged = false;
        Set currentSourcesSet = this.getUniqueAdditionalSources(oldResult, newResult);
        if (currentSourcesSet != null && !currentSourcesSet.isEmpty()) {
            this.refreshAdditionalSources(oldResult, currentSourcesSet);
        }
        return oldResultChanged;
    }

    private boolean merge(DfResultEntry newRes, DfResultEntry oldResult, boolean isNewResultMoreRecent) {
        boolean oldResultModified = false;
        double mergedScore = this.computeMergedScore(newRes, oldResult);
        int attrCount = newRes.getAttrCount();
        for (int i = 0; i < attrCount; ++i) {
            IDfAttr newAttr = newRes.getAttr(i);
            String newAttrName = newAttr.getName();
            if (newAttrName.equals("r_source") || newAttrName.equals("r_additional_sources")) continue;
            IDfAttr oldAttr = oldResult.getAttr(newAttrName);
            if (oldAttr == null) {
                oldResult.addAttribute(newAttrName, newAttr.isRepeating(), newAttr.getDataType());
                oldResult.setValue(newAttrName, newRes.getValue(newAttrName));
                oldResultModified = true;
                continue;
            }
            if (!isNewResultMoreRecent) continue;
            oldResult.setValue(newAttrName, newRes.getValue(newAttrName));
            oldResultModified = true;
        }
        if (!isNewResultMoreRecent && this.refreshResultDate(newRes, oldResult)) {
            oldResultModified = true;
        }
        if (this.refreshScore(oldResult, mergedScore)) {
            oldResultModified = true;
        }
        return oldResultModified;
    }

    private double computeMergedScore(DfResultEntry currentResult, DfResultEntry oldResult) {
        return Math.max(currentResult.getScore(), oldResult.getScore());
    }

    private boolean refreshScore(DfResultEntry result, double newScore) {
        double oldScore = result.getScore();
        boolean equal = this.areEqual(oldScore, newScore);
        if (!equal) {
            result.setScore(newScore);
        }
        return !equal;
    }

    private boolean refreshResultDate(DfResultEntry currentResult, DfResultEntry oldResult) {
        IDfTime newDate;
        boolean oldModified = false;
        if (currentResult.hasAttr("r_collect_date") && (newDate = currentResult.getTime("r_collect_date")) != null) {
            if (!oldResult.hasAttr("r_collect_date")) {
                oldResult.addAttribute("r_collect_date", false, 4);
            }
            oldResult.setValue("r_collect_date", (IDfValue)new DfValue(newDate));
            oldModified = true;
        }
        return oldModified;
    }

    private Set getUniqueAdditionalSources(DfResultEntry oldResult, DfResultEntry newResult) {
        HashSet<String> currentSourcesSet = new HashSet<String>(10);
        if (oldResult.hasAttr("r_additional_sources")) {
            this.addAllStringValues(oldResult, "r_additional_sources", currentSourcesSet);
        }
        if (newResult.hasAttr("r_additional_sources")) {
            this.addAllStringValues(newResult, "r_additional_sources", currentSourcesSet);
        }
        String newSourceValue = newResult.getString("r_source");
        this.addValue(newSourceValue, currentSourcesSet);
        String oldSourceValue = oldResult.getString("r_source");
        currentSourcesSet.remove(oldSourceValue);
        return currentSourcesSet;
    }

    private void refreshAdditionalSources(DfResultEntry oldResult, Set currentSourcesSet) throws DfException {
        if (!oldResult.hasAttr("r_additional_sources")) {
            oldResult.addAttribute("r_additional_sources", true, 2);
        }
        DfList sourceList = new DfList(1025);
        for (Object aCurrentSourcesSet : currentSourcesSet) {
            String source = (String)aCurrentSourcesSet;
            sourceList.appendValue(new DfValue(source));
        }
        oldResult.setValue("r_additional_sources", (IDfValue)new DfValue(sourceList, 2));
    }

    private void addValidResult(DfResultEntry r) {
        if (DfLogger.isDebugEnabled(this)) {
            this.trace("addValidResult - [" + r.getClearDeDuplKey() + "]", null, null);
        }
        super.add(r);
    }

    private void replaceResult(DfResultEntry res) {
        String key = res.getDeDuplicationKey();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            IDfResultEntry entry = this.getResultAt(index);
            if (!entry.getKey().equals(key)) continue;
            this.setResultAt(index, res);
            return;
        }
    }

    private DfResultEntry findDuplicate(DfResultEntry res) {
        String key = res.getDeDuplicationKey();
        if (key == null) {
            return null;
        }
        return (DfResultEntry)this.getResultByKey(key);
    }

    private boolean addAllStringValues(DfResultEntry res, String attrName, Set<String> collector) {
        boolean added = false;
        if (res != null) {
            if (res.isAttrRepeating(attrName)) {
                for (int index = 0; index < res.getValueCount(attrName); ++index) {
                    String value = res.getRepeatingString(attrName, index);
                    added = this.addValue(value, collector) || added;
                }
            } else {
                String value = res.getString(attrName);
                added = this.addValue(value, collector);
            }
        }
        return added;
    }

    private boolean addValue(String newValue, Set<String> currentValues) {
        if (newValue == null) {
            return false;
        }
        boolean added = currentValues.add(newValue);
        return added;
    }

    private int treatException(Exception e, DfResultEntry r) {
        String exceptionMessage = e.getMessage();
        int status = 1;
        if (exceptionMessage != null) {
            StringBuffer errorMessage = new StringBuffer("ResultFilterer: " + exceptionMessage + " - ");
            if (this.m_discardResult) {
                status = 1;
                errorMessage.append("discarded");
            } else {
                status = 2;
                this.setStatus(r, 2);
                errorMessage.append("added");
            }
            if (DfLogger.isDebugEnabled(this)) {
                this.trace("treatException - " + errorMessage, null, null);
            }
        }
        return status;
    }

    private void trace(String msg, String[] comp, Throwable ex) {
        DfLogger.debug((Object)this, msg, comp, ex);
    }

    private boolean areEqual(double oldScore, double newScore) {
        return Math.abs(oldScore - newScore) <= 0.001;
    }
}

