/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.rater.config;

import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.IDfPerceptualRaterConfig;
import com.documentum.fc.client.search.IDfResultRaterConfig;
import com.documentum.fc.client.search.impl.rater.config.AttributeSet;
import com.documentum.fc.client.search.impl.rater.config.AttributeSetImpl;
import com.documentum.fc.client.search.impl.rater.config.AttributeWeights;
import com.documentum.fc.client.search.impl.rater.config.AttributeWeightsDefault;
import com.documentum.fc.client.search.impl.rater.config.AttributeWeightsImpl;
import com.documentum.fc.client.search.impl.rater.config.ConfigFactorsAbstract;
import com.documentum.fc.client.search.impl.rater.config.FullTextAttributesImpl;
import com.documentum.fc.client.search.impl.rater.config.PerceptualRaterConfigImpl;
import com.documentum.fc.client.search.impl.rater.config.PerceptualRaterConfigMgr;
import com.documentum.fc.client.search.impl.rater.config.RankConfidences;
import com.documentum.fc.client.search.impl.rater.config.RankConfidencesDefault;
import com.documentum.fc.client.search.impl.rater.config.RankConfidencesImpl;
import com.documentum.fc.client.search.impl.rater.config.RatingWeights;
import com.documentum.fc.client.search.impl.rater.config.RatingWeightsDefault;
import com.documentum.fc.client.search.impl.rater.config.RatingWeightsImpl;
import com.documentum.fc.client.search.impl.rater.config.ResultRaterConfigImpl;
import com.documentum.fc.client.search.impl.rater.config.SourceBonuses;
import com.documentum.fc.client.search.impl.rater.config.SourceBonusesDefault;
import com.documentum.fc.client.search.impl.rater.config.SourceBonusesImpl;
import com.documentum.fc.client.search.impl.util.XMLUtil;
import com.documentum.fc.common.DfFileWatcher;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfFileObserver;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PerceptualRaterConfigReader
implements IDfFileObserver {
    public static final String SEARCH_RANKING_FILE = "dfc-searchranking.xml";
    public static final String DQL_SEARCH_RANKING_PROPERTY = "dfc.searchranking.file";
    public static final String DTD_ID = "dfc-searchranking.dtd";
    public static final String DTD = "<!ELEMENT SearchRanking (SourceBonus*, RankConfidence*, FullText?, AttributeWeight*, RatingWeight*)><!ELEMENT SourceBonus (AttributeQuery?, FullTextQuery?)>  <!ATTLIST SourceBonus source CDATA #IMPLIED>  <!ATTLIST SourceBonus type (any | docbase | external) \"any\"><!ELEMENT AttributeQuery (#PCDATA)><!ELEMENT FullTextQuery (#PCDATA)><!ELEMENT RankConfidence (#PCDATA)>  <!ATTLIST RankConfidence source CDATA #IMPLIED>  <!ATTLIST RankConfidence type (any | docbase | external) \"any\"><!ELEMENT FullText (Attribute+)><!ELEMENT Attribute (#PCDATA)><!ELEMENT AttributeWeight (#PCDATA)>  <!ATTLIST AttributeWeight attribute CDATA #IMPLIED>  <!ATTLIST AttributeWeight value CDATA #IMPLIED><!ELEMENT RatingWeight (#PCDATA)>  <!ATTLIST RatingWeight source CDATA #IMPLIED>  <!ATTLIST RatingWeight type (any | docbase | external) \"any\">";
    public static final String NODE_SEARCH_RANKING = "SearchRanking";
    private static final String NODE_SOURCE_BONUS = "SourceBonus";
    private static final String NODE_RANK_CONFIDENCE = "RankConfidence";
    private static final String NODE_FULL_TEXT = "FullText";
    private static final String NODE_ATTRIBUTE_WEIGHT = "AttributeWeight";
    private static final String NODE_RATING_WEIGHT = "RatingWeight";
    private PerceptualRaterConfigImpl m_perceptualRaterConfig;
    private ResultRaterConfigImpl m_resultRaterConfig;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PerceptualRaterConfigReader() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_perceptualRaterConfig = new PerceptualRaterConfigImpl();
            this.m_resultRaterConfig = new ResultRaterConfigImpl();
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public IDfPerceptualRaterConfig getPerceptualRaterConfig() {
        return this.m_perceptualRaterConfig;
    }

    public IDfResultRaterConfig getResultRaterConfig() {
        return this.m_resultRaterConfig;
    }

    public boolean loadConfigFile() throws IOException, DfSearchException {
        boolean configLoaded = false;
        File configFile = this.locateConfigFile();
        if (configFile != null) {
            this.loadConfigFile(configFile);
            this.monitor(configFile);
            configLoaded = true;
        }
        return configLoaded;
    }

    public void readConfig(InputStream configXmlStream) throws DfSearchException, IOException {
        this.readConfig(configXmlStream, SEARCH_RANKING_FILE);
    }

    public void update(File configFile) {
        try {
            this.loadConfigFile(configFile);
        }
        catch (IOException e) {
            PerceptualRaterConfigMgr.trace(e);
        }
        catch (DfSearchException e) {
            PerceptualRaterConfigMgr.trace(e);
        }
    }

    private File locateConfigFile() throws IOException {
        URL configFileUrl = this.locateConfigUrl();
        return configFileUrl == null ? null : DfUtil.getFileFromUrl(configFileUrl);
    }

    private URL locateConfigUrl() throws IOException {
        String location = DfPreferences.access().getSearchRankingFile();
        PerceptualRaterConfigMgr.trace("Locate perceptual rater config: system property dfc.searchranking.file=" + location);
        if (location != null && location.length() > 0) {
            return new File(location).toURL();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL configFileUrl = loader.getResource(SEARCH_RANKING_FILE);
        PerceptualRaterConfigMgr.trace("Locate perceptual rater config: classpath resource url=" + configFileUrl);
        return configFileUrl;
    }

    private void monitor(File configFile) {
        DfFileWatcher.access().register(configFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile(File configFile) throws IOException, DfSearchException {
        FileInputStream configXmlStream = new FileInputStream(configFile);
        try {
            this.readConfig(configXmlStream, configFile.getName());
        }
        finally {
            ((InputStream)configXmlStream).close();
        }
    }

    private void readConfig(InputStream configXmlStream, String configName) throws IOException, DfSearchException {
        Document configDoc = XMLUtil.read(configXmlStream, true, configName, DTD_ID, DTD);
        Node searchRankingNode = XMLUtil.getNode(configDoc, NODE_SEARCH_RANKING, true);
        this.loadSourceBonuses(searchRankingNode);
        this.loadRankConfidences(searchRankingNode);
        this.loadFullText(searchRankingNode);
        this.loadAttributeWeights(searchRankingNode);
        this.loadRatingWeights(searchRankingNode);
    }

    private void loadSourceBonuses(Node searchRankingNode) throws DfSearchException {
        Node[] nodes = XMLUtil.getChildNodes(searchRankingNode, NODE_SOURCE_BONUS, false);
        ConfigFactorsAbstract sourceBonuses = nodes.length == 0 ? new SourceBonusesDefault() : new SourceBonusesImpl(nodes);
        this.m_resultRaterConfig.setSourceBonuses((SourceBonuses)((Object)sourceBonuses));
    }

    private void loadRankConfidences(Node searchRankingNode) throws DfSearchException {
        Node[] nodes = XMLUtil.getChildNodes(searchRankingNode, NODE_RANK_CONFIDENCE, false);
        ConfigFactorsAbstract rankConfidences = nodes.length == 0 ? new RankConfidencesDefault() : new RankConfidencesImpl(nodes);
        this.m_resultRaterConfig.setRankConfidences((RankConfidences)((Object)rankConfidences));
    }

    private void loadFullText(Node searchRankingNode) throws DfSearchException {
        Node[] nodes = XMLUtil.getChildNodes(searchRankingNode, NODE_FULL_TEXT, false);
        AttributeSet fullTextAttributes = nodes.length == 0 ? new AttributeSetImpl(ResultRaterConfigImpl.FULL_TEXT_ATTRIBUTES_DEFAULT) : new FullTextAttributesImpl(nodes[0]);
        this.m_resultRaterConfig.setFullTextAttributes(fullTextAttributes);
    }

    private void loadAttributeWeights(Node searchRankingNode) throws DfSearchException {
        Node[] nodes = XMLUtil.getChildNodes(searchRankingNode, NODE_ATTRIBUTE_WEIGHT, false);
        ConfigFactorsAbstract attributeWeights = nodes.length == 0 ? new AttributeWeightsDefault() : new AttributeWeightsImpl(nodes);
        this.m_resultRaterConfig.setAttributeWeights((AttributeWeights)((Object)attributeWeights));
    }

    private void loadRatingWeights(Node searchRankingNode) throws DfSearchException {
        Node[] nodes = XMLUtil.getChildNodes(searchRankingNode, NODE_RATING_WEIGHT, false);
        ConfigFactorsAbstract ratingWeights = nodes.length == 0 ? new RatingWeightsDefault() : new RatingWeightsImpl(nodes);
        this.m_perceptualRaterConfig.setRatingWeights((RatingWeights)((Object)ratingWeights));
    }

    static {
        Factory factory = new Factory("PerceptualRaterConfigReader.java", Class.forName("com.documentum.fc.client.search.impl.rater.config.PerceptualRaterConfigReader"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.rater.config.PerceptualRaterConfigReader", "", "", ""), 129);
    }
}

