/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.rater;

import com.documentum.fc.client.IDfEnumeration;
import com.documentum.fc.client.search.IDfAttrExpression;
import com.documentum.fc.client.search.IDfExpression;
import com.documentum.fc.client.search.IDfExpressionSet;
import com.documentum.fc.client.search.IDfResultRaterConfig;
import com.documentum.fc.client.search.impl.definition.expression.DfFullTextExpression;
import com.documentum.fc.client.search.impl.rater.ExprMatcherListener;
import com.documentum.fc.client.search.impl.rater.ExpressionMatcher;
import com.documentum.fc.client.search.impl.rater.PerceptualRater;
import com.documentum.fc.client.search.impl.rater.ResultCache;
import com.documentum.fc.client.search.impl.util.MathUtil;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccuracyValidityRater
implements ExprMatcherListener {
    private static final float ACCURACY_VALIDITY_LOGICAL_OPERATOR_SCORE = 0.8f;
    private static final float ACCURACY_VALIDITY_AND_SCORE_INC = 0.06666666f;
    private static final float ACCURACY_VALIDITY_OR_SCORE_INC = -0.03333333f;
    private static final float ACCURACY_VALIDITY_NEGATION_SCORE = 0.66f;
    private static final float ACCURACY_VALIDITY_FULLTEXT_NEGATION_SCORE = 0.66f;
    private static final float ACCURACY_VALIDITY_TEXT_PART_SCORE = 0.87f;
    private static final float ACCURACY_VALIDITY_TEXT_ENDS_SCORE = 0.9f;
    private static final float ACCURACY_VALIDITY_RANGE_SCORE = 0.95f;
    private static final float ACCURACY_VALIDITY_EQUALITY_SCORE = 1.0f;
    private static final float[][] ACCURACY_VALIDITY_OP_SCORES_LIST;
    private static final Map<Integer, Float> ACCURACY_VALIDITY_OP_SCORES;
    private IDfExpressionSet m_rootExpression;
    private ExpressionMatcher m_expressionMatcher;
    private IDfResultRaterConfig m_resultRaterConfig;
    private ResultCache m_resultCache;
    private float m_matchScore;
    private Map<IDfExpression, ConstraintScore> m_exprAccuracy;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    AccuracyValidityRater(IDfExpressionSet rootExpression, ExpressionMatcher expressionMatcher, IDfResultRaterConfig resultRaterConfig) {
        IDfExpressionSet iDfExpressionSet = rootExpression;
        ExpressionMatcher expressionMatcher2 = expressionMatcher;
        IDfResultRaterConfig iDfResultRaterConfig = resultRaterConfig;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpressionSet, expressionMatcher2, iDfResultRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            JoinPoint joinPoint2 = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint2);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint2);
                }
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint2 == null) {
                        joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint2);
                }
                throw throwable;
            }
            this.m_rootExpression = rootExpression;
            this.m_expressionMatcher = expressionMatcher;
            this.m_resultRaterConfig = resultRaterConfig;
            this.m_exprAccuracy = new HashMap<IDfExpression, ConstraintScore>(20);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpressionSet, expressionMatcher2, iDfResultRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpressionSet, expressionMatcher2, iDfResultRaterConfig};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public float rate(ResultCache resultCache) {
        ResultCache resultCache2 = resultCache;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            void resultCache3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_resultCache = resultCache3;
            this.m_expressionMatcher.setListener(this);
            this.m_matchScore = 0.0f;
            this.m_expressionMatcher.match((IDfExpression)this.m_rootExpression, (ResultCache)resultCache3);
            this.m_exprAccuracy.clear();
            float accuracyValidityScore = this.m_matchScore;
            if (DfLogger.isDebugEnabled(PerceptualRater.class)) {
                PerceptualRater.trace(" accuracy/validity=" + accuracyValidityScore);
            }
            float f3 = f2 = (f = accuracyValidityScore);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)resultCache2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportMatch(IDfExpression iDfExpression, int n, int n2) {
        IDfExpression iDfExpression2 = iDfExpression;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = null;
        try {
            float weight;
            void matchCount;
            void expr;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpression2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (this.m_exprAccuracy.get(expr) == null);
            if (matchCount == false) {
                this.m_matchScore = 0.0f;
                weight = 0.0f;
            } else {
                void attrIndex;
                this.m_matchScore = AccuracyValidityRater.getSearchOpMatchScore((IDfExpression)expr);
                weight = this.getAttributeWeight((IDfExpression)expr, (int)attrIndex);
            }
            this.m_exprAccuracy.put((IDfExpression)expr, new ConstraintScore(this, this.m_matchScore, weight, null));
            Object var11_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpression2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var11_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{iDfExpression2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportVisit(IDfExpressionSet iDfExpressionSet) {
        IDfExpressionSet iDfExpressionSet2 = iDfExpressionSet;
        JoinPoint joinPoint = null;
        try {
            void exprSet;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfExpressionSet2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (this.m_exprAccuracy.get(exprSet) == null);
            float weightedAccuracy = 0.0f;
            float weightSum = 0.0f;
            IDfEnumeration childExprs = exprSet.getExpressions();
            while (childExprs.hasMoreElements()) {
                IDfExpression childExpr = (IDfExpression)childExprs.nextElement();
                ConstraintScore constraintScore = this.m_exprAccuracy.get(childExpr);
                weightedAccuracy += constraintScore.m_weight * constraintScore.m_score;
                weightSum += constraintScore.m_weight;
            }
            float f = this.m_matchScore = MathUtil.isEqual(weightSum, 0.0f) ? 0.0f : weightedAccuracy / weightSum;
            if (this.m_matchScore != 0.0f) {
                int exprCount = exprSet.getExpressionCount();
                this.m_matchScore *= exprSet.getLogicalOperator() == 1 ? AccuracyValidityRater.fAccuracyValidityOr(exprCount) : AccuracyValidityRater.fAccuracyValidityAnd(exprCount);
            }
            this.m_exprAccuracy.put((IDfExpression)exprSet, new ConstraintScore(this, this.m_matchScore, 1.0f, null));
            Object var9_10 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfExpressionSet2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_10, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)iDfExpressionSet2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static Map<Integer, Float> initAccuracyValidityOpScores() {
        JoinPoint joinPoint = null;
        try {
            Map<Integer, Float> map;
            Map<Integer, Float> map2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            HashMap<Integer, Float> opScores = new HashMap<Integer, Float>(ACCURACY_VALIDITY_OP_SCORES_LIST.length * 2);
            for (int i = 0; i < ACCURACY_VALIDITY_OP_SCORES_LIST.length; ++i) {
                opScores.put(new Integer((int)ACCURACY_VALIDITY_OP_SCORES_LIST[i][0]), new Float(ACCURACY_VALIDITY_OP_SCORES_LIST[i][1]));
            }
            Map<Integer, Float> map3 = map2 = (map = Collections.unmodifiableMap(opScores));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(map2, joinPoint);
            }
            return map;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static float getSearchOpMatchScore(IDfExpression iDfExpression) {
        IDfExpression iDfExpression2 = iDfExpression;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            IDfExpression expr;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)iDfExpression2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            float aMatchScore = expr.getExpressionType() == 2 ? (((DfFullTextExpression)expr).isNotOperatorApplied() ? 0.66f : ACCURACY_VALIDITY_OP_SCORES.get(new Integer(8)).floatValue()) : ACCURACY_VALIDITY_OP_SCORES.get(((IDfAttrExpression)expr).getSearchOperationCode()).floatValue();
            float f3 = f2 = (f = aMatchScore);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)iDfExpression2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)iDfExpression2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private float getAttributeWeight(IDfExpression iDfExpression, int n) {
        IDfExpression iDfExpression2 = iDfExpression;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            float f;
            float f2;
            float f3;
            void expr;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iDfExpression2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (expr.getExpressionType() == 2) {
                f2 = f3 = 1.0f;
            } else {
                void attrIndex;
                String attrName = ((IDfAttrExpression)expr).getAttrName();
                String[] attrValues = this.m_resultRaterConfig.isAttributeValueRequired(attrName) ? this.m_resultCache.getValuesAsString((int)attrIndex) : null;
                f2 = f3 = this.m_resultRaterConfig.getAttributeWeight(attrName, attrValues);
            }
            float f4 = f = f2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iDfExpression2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)iDfExpression2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static float fAccuracyValidityAnd(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int constraintCount;
            float f;
            float f2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            float f3 = f2 = (f = MathUtil.linear(0.06666666269302368, constraintCount, 0.7333333492279053));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static float fAccuracyValidityOr(int n) {
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            int constraintCount;
            float f;
            float f2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            float f3 = f2 = (f = MathUtil.linear(-0.03333333134651184, constraintCount, 0.8333333730697632));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.floatObject((float)f2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return f;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("AccuracyValidityRater.java", Class.forName("com.documentum.fc.client.search.impl.rater.AccuracyValidityRater"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.rater.ExprMatcherListener", "", "", ""), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rate", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.impl.rater.ResultCache:", "resultCache:", "", "float"), 117);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reportMatch", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.IDfExpression:int:int:", "expr:attrIndex:matchCount:", "", "void"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reportVisit", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.IDfExpressionSet:", "exprSet:", "", "void"), 152);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initAccuracyValidityOpScores", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "", "", "", "java.util.Map"), 178);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getSearchOpMatchScore", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.IDfExpression:", "expr:", "", "float"), 192);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAttributeWeight", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.IDfExpression:int:", "expr:attrIndex:", "", "float"), 212);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "fAccuracyValidityAnd", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "int:", "constraintCount:", "", "float"), 223);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "fAccuracyValidityOr", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "int:", "constraintCount:", "", "float"), 228);
        ajc$tjp_9 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater", "com.documentum.fc.client.search.IDfExpressionSet:com.documentum.fc.client.search.impl.rater.ExpressionMatcher:com.documentum.fc.client.search.IDfResultRaterConfig:", "rootExpression:expressionMatcher:resultRaterConfig:", ""), 108);
        ACCURACY_VALIDITY_OP_SCORES_LIST = new float[][]{{7.0f, 0.9f}, {13.0f, 0.95f}, {8.0f, 0.87f}, {9.0f, 0.66f}, {10.0f, 0.9f}, {1.0f, 1.0f}, {5.0f, 0.95f}, {3.0f, 0.95f}, {11.0f, 1.0f}, {15.0f, 0.66f}, {14.0f, 0.95f}, {6.0f, 0.95f}, {4.0f, 0.95f}, {2.0f, 0.66f}, {12.0f, 0.87f}};
        ACCURACY_VALIDITY_OP_SCORES = AccuracyValidityRater.initAccuracyValidityOpScores();
        assert (MathUtil.isEqual(AccuracyValidityRater.fAccuracyValidityAnd(1), AccuracyValidityRater.fAccuracyValidityOr(1))) : AccuracyValidityRater.fAccuracyValidityAnd(1) + " != " + AccuracyValidityRater.fAccuracyValidityOr(1);
    }

    static class 1 {
    }

    private class ConstraintScore {
        public float m_score;
        public float m_weight;
        final /* synthetic */ AccuracyValidityRater this$0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        private ConstraintScore(AccuracyValidityRater accuracyValidityRater, float score, float weight) {
            this.this$0 = accuracyValidityRater;
            AccuracyValidityRater accuracyValidityRater2 = accuracyValidityRater;
            float f = score;
            float f2 = weight;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)f), Conversions.floatObject((float)f2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_score = score;
                this.m_weight = weight;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)f), Conversions.floatObject((float)f2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)f), Conversions.floatObject((float)f2)};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ConstraintScore(AccuracyValidityRater x0, float x1, float x2, 1 x3) {
            void weight;
            void score;
            float f = x2;
            float f2 = x1;
            AccuracyValidityRater accuracyValidityRater = x0;
            ConstraintScore constraintScore = this;
            constraintScore.this$0 = accuracyValidityRater;
            AccuracyValidityRater accuracyValidityRater2 = x0;
            void var12_10 = score;
            void var13_11 = weight;
            1 var14_12 = x3;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)var12_10), Conversions.floatObject((float)var13_11), var14_12};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                constraintScore.m_score = f2;
                constraintScore.m_weight = f;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)var12_10), Conversions.floatObject((float)var13_11), var14_12};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{accuracyValidityRater2, Conversions.floatObject((float)var12_10), Conversions.floatObject((float)var13_11), var14_12};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("AccuracyValidityRater.java", Class.forName("com.documentum.fc.client.search.impl.rater.AccuracyValidityRater$ConstraintScore"));
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater$ConstraintScore", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater:float:float:", "arg0:score:weight:", ""), 238);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater$ConstraintScore", "com.documentum.fc.client.search.impl.rater.AccuracyValidityRater:float:float:com.documentum.fc.client.search.impl.rater.AccuracyValidityRater$1:", "x0:x1:x2:x3:", ""), 238);
        }
    }
}

