/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.execution.broker;

import com.documentum.fc.client.search.impl.config.SearchConfigFactory;
import com.documentum.fc.client.search.impl.execution.broker.Action;
import com.documentum.fc.client.search.impl.execution.broker.Scheduler;
import com.documentum.fc.client.search.impl.execution.broker.SearchJob;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class BrokerService {
    private static final String BROKER_THREAD_GROUP_NAME = "Search Brokers";
    private ThreadPoolExecutor m_docbaseExecutor;
    private ThreadPoolExecutor m_ecisExecutor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public BrokerService() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int docbaseBrokersNb = SearchConfigFactory.getConfig().getMaxDocbaseBrokers();
            int ecisBrokersNb = SearchConfigFactory.getConfig().getMaxEcisBrokers();
            BrokerThreadFactory factory = new BrokerThreadFactory();
            this.m_docbaseExecutor = new ThreadPoolExecutor(docbaseBrokersNb, docbaseBrokersNb, 300000000000000000L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
            this.m_ecisExecutor = new ThreadPoolExecutor(ecisBrokersNb, ecisBrokersNb, 300000000000000000L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void submit(Action action, Scheduler scheduler) {
        Action action2 = action;
        Scheduler scheduler2 = scheduler;
        JoinPoint joinPoint = null;
        try {
            void action3;
            void scheduler3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)action2, (Object)scheduler2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            SearchJob broker = new SearchJob((Scheduler)scheduler3, (Action)action3);
            if (action3.isDocbase()) {
                this.m_docbaseExecutor.execute(broker);
            } else {
                this.m_ecisExecutor.execute(broker);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "Docbase active Search threads=" + this.m_docbaseExecutor.getActiveCount() + " pending actions=" + this.m_docbaseExecutor.getQueue().size(), null, null);
                DfLogger.debug((Object)this, "ECIS active Search threads=" + this.m_ecisExecutor.getActiveCount() + " pending actions=" + this.m_ecisExecutor.getQueue().size(), null, null);
            }
            Object var7_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)action2, (Object)scheduler2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var7_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)action2, (Object)scheduler2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public void shutdown() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_docbaseExecutor.shutdownNow();
            this.m_ecisExecutor.shutdownNow();
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAction(Action action) {
        Action action2 = action;
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            void action3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)action2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean removedFromDocbase = this.m_docbaseExecutor.remove(action3.getBroker());
            boolean removedFromEci = this.m_ecisExecutor.remove(action3.getBroker());
            boolean bl2 = removedFromDocbase || removedFromEci;
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)action2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)action2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("BrokerService.java", Class.forName("com.documentum.fc.client.search.impl.execution.broker.BrokerService"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "submit", "com.documentum.fc.client.search.impl.execution.broker.BrokerService", "com.documentum.fc.client.search.impl.execution.broker.Action:com.documentum.fc.client.search.impl.execution.broker.Scheduler:", "action:scheduler:", "", "void"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shutdown", "com.documentum.fc.client.search.impl.execution.broker.BrokerService", "", "", "", "void"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeAction", "com.documentum.fc.client.search.impl.execution.broker.BrokerService", "com.documentum.fc.client.search.impl.execution.broker.Action:", "action:", "", "boolean"), 88);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.execution.broker.BrokerService", "", "", ""), 39);
    }

    private static class BrokerThreadFactory
    implements ThreadFactory {
        private ThreadGroup m_brokerGrp;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        BrokerThreadFactory() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                this.m_brokerGrp = new ThreadGroup(Thread.currentThread().getThreadGroup(), BrokerService.BROKER_THREAD_GROUP_NAME);
                this.m_brokerGrp.setMaxPriority(1);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Thread newThread(Runnable runnable) {
            Runnable runnable2 = runnable;
            JoinPoint joinPoint = null;
            try {
                Thread thread;
                Thread thread2;
                void r;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)runnable2);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                Thread t = new Thread(this.m_brokerGrp, (Runnable)r, "Search Broker:no query to process");
                t.setDaemon(true);
                Thread thread3 = thread2 = (thread = t);
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)runnable2);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(thread2, joinPoint);
                }
                return thread;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)runnable2);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("BrokerService.java", Class.forName("com.documentum.fc.client.search.impl.execution.broker.BrokerService$BrokerThreadFactory"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newThread", "com.documentum.fc.client.search.impl.execution.broker.BrokerService$BrokerThreadFactory", "java.lang.Runnable:", "r:", "", "java.lang.Thread"), 124);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.documentum.fc.client.search.impl.execution.broker.BrokerService$BrokerThreadFactory", "", "", ""), 104);
        }
    }
}

