/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.execution.adapter.remoteeci;

import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.search.DfQueryGenerationException;
import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.IDfSearchMetadataManager;
import com.documentum.fc.client.search.IDfSearchSourceMap;
import com.documentum.fc.client.search.impl.IDfSearchConstants;
import com.documentum.fc.client.search.impl.config.DfSearchMessages;
import com.documentum.fc.client.search.impl.definition.expression.DfAttrExpression;
import com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource;
import com.documentum.fc.client.search.impl.ecis.ECISAttributesMapping;
import com.documentum.fc.client.search.impl.execution.data.ServerQuery;
import com.documentum.fc.client.search.impl.generation.common.DfQueryGenerationUtil;
import com.documentum.fc.client.search.impl.result.DfResultEntry;
import com.documentum.fc.client.search.impl.util.DateUtil;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfValue;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.common.IDfValue;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import xtrim.data.Constraint;
import xtrim.data.DataConstants;
import xtrim.data.DataException;
import xtrim.data.DataFactory;
import xtrim.data.EditableQuery;
import xtrim.data.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECISFilter {
    private static final double ECI_SCORE_RATIO = 100.0;
    public static final int ECI_SIZE_UNIT = 1024;
    private static final String ECI_ATTR_DATE_SUFFIX = "_date";
    private static final String ECI_ATTR_MATCHING_TERMS = "matching_terms";
    public static final String ECI_ATTR_RANK = "rank";
    private static int s_mandatoryAttrIndex;
    private static final IDfAttr DCTM_OBJECT_TYPE_ATTR;
    private static final IDfValue DCTM_OBJECT_TYPE_VALUE;
    private static final IDfAttr DCTM_IS_VIRTUAL_ATTR;
    private static final IDfValue DCTM_IS_VIRTUAL_VALUE;
    private static final IDfAttr DCTM_IS_REFERENCE_ATTR;
    private static final IDfValue DCTM_IS_REFERENCE_VALUE;
    private static final IDfAttr DCTM_IS_REPLICA_ATTR;
    private static final IDfValue DCTM_IS_REPLICA_VALUE;
    private static final IDfAttr DCTM_LINK_CNT_ATTR;
    private static final IDfValue DCTM_LINK_CNT_VALUE;
    private static final IDfAttr DCTM_FRZN_ASSEMBLY_ATTR;
    private static final IDfValue DCTM_FRZN_ASSEMBLY_VALUE;
    private static final IDfAttr[] DCTM_SHARED_ATTRS;
    private static final IDfValue[] DCTM_SHARED_VALUES;
    private ServerQuery m_query;
    private IDfSearchMetadataManager m_metadata;
    private IDfSearchSourceMap m_sourceMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public ECISFilter(ServerQuery query) {
        ServerQuery serverQuery = query;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)serverQuery);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_query = query;
            this.m_metadata = this.m_query.getQuery().getMetadataMgr();
            this.m_sourceMap = this.m_metadata.getSourceMap();
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)serverQuery);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)serverQuery);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String convertToExternalValue(String string, DfAttrExpression dfAttrExpression) throws DfSearchException {
        String string2 = string;
        DfAttrExpression dfAttrExpression2 = dfAttrExpression;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            void expression;
            void value;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2, (Object)dfAttrExpression2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String rVal = value;
            String attrName = expression.getAttrName();
            int dataType = expression.getValueDataType();
            int searchOperationCode = expression.getSearchOperationCode();
            String dateFormat = expression.getDateFormat();
            if (attrName.equals("r_full_content_size")) {
                int intValue = Integer.parseInt((String)value) / 1024;
                rVal = Integer.toString(intValue);
            } else if (dataType == 4) {
                rVal = this.convertToExternalDate((String)value, searchOperationCode, dateFormat);
            } else if (attrName.equals(IDfSearchConstants.ATTR_CONTENT_TYPE)) {
                try {
                    rVal = this.m_metadata.convertDocbaseToMimeFormat((String)value);
                }
                catch (DfException e) {
                    throw new DfSearchException("UNABLE_TO_CONVERT_FORMAT", (Throwable)e);
                }
            }
            String string5 = string4 = (string3 = DfQueryGenerationUtil.escapeExternal(rVal));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2, (Object)dfAttrExpression2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2, (Object)dfAttrExpression2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String convertToExternalDate(String string, int n, String string2) throws DfQueryGenerationException {
        String string3 = string;
        int n2 = n;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            String string5;
            String string6;
            String externalDate;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, Conversions.intObject((int)n2), string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                void dateFormat;
                void date;
                void searchOp;
                if (searchOp == 5 || searchOp == 6) {
                    Date d = DateUtil.parseDate((String)date, (String)dateFormat);
                    int shiftAmount = searchOp == 5 ? -1 : 1;
                    d = DateUtil.shiftDate(d, 6, shiftAmount);
                    externalDate = DateUtil.formatExternalDate(d);
                } else {
                    externalDate = DateUtil.convertToExternalDate((String)date, (String)dateFormat);
                }
            }
            catch (DfSearchException e) {
                throw new DfQueryGenerationException("INVALID_DATE_FORMAT", (Throwable)e);
            }
            String string7 = string6 = (string5 = externalDate);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, Conversions.intObject((int)n2), string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string6, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{string3, Conversions.intObject((int)n2), string4};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public EditableQuery transformQuery(EditableQuery editableQuery) throws DataException {
        EditableQuery editableQuery2 = editableQuery;
        JoinPoint joinPoint = null;
        try {
            EditableQuery editableQuery3;
            EditableQuery editableQuery4;
            void initialQuery;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)editableQuery2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Enumeration cstrs = initialQuery.getConstraints();
            EditableQuery newQuery = DataFactory.createQuery((long)initialQuery.getUid());
            while (cstrs.hasMoreElements()) {
                Constraint ecisConstraint;
                Constraint constraint = (Constraint)cstrs.nextElement();
                try {
                    ecisConstraint = this.mapDFCConstraint(constraint);
                }
                catch (IllegalArgumentException iae) {
                    if (!DfLogger.isWarnEnabled(this)) continue;
                    DfLogger.warn((Object)this, DfSearchMessages.getString("UNABLE_TO_MAP_DFC_ATTR", constraint.getName()), null, (Throwable)iae);
                    continue;
                }
                newQuery.addConstraint(ecisConstraint);
            }
            EditableQuery editableQuery5 = editableQuery4 = (editableQuery3 = newQuery);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)editableQuery2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(editableQuery4, joinPoint);
            }
            return editableQuery3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)editableQuery2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DfResultEntry transformResult(Result result, int n) throws DfException {
        Result result2 = result;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            DfResultEntry dfResultEntry;
            DfResultEntry dfResultEntry2;
            void sequenceNumber;
            void result3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)result2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Enumeration attrs = result3.getAttributes();
            String source = result3.getBackendName();
            DfSearchSource sourceInfo = (DfSearchSource)this.m_sourceMap.getSource(source);
            if (sourceInfo == null) {
                throw new IllegalArgumentException(source);
            }
            DfResultEntry entry = this.createResultEntry(sourceInfo, (int)sequenceNumber);
            boolean matchingTermsAvailable = false;
            while (attrs.hasMoreElements()) {
                xtrim.data.Attribute attr = (xtrim.data.Attribute)attrs.nextElement();
                try {
                    this.mapECISAttribute(entry, attr);
                    if (!ECI_ATTR_MATCHING_TERMS.equals(attr.getName())) continue;
                    matchingTermsAvailable = true;
                }
                catch (IllegalArgumentException iae) {
                    if (!DfLogger.isWarnEnabled(this)) continue;
                    DfLogger.warn((Object)this, DfSearchMessages.getString("UNABLE_TO_MAP_ECI_ATTR", attr.getName()), null, (Throwable)iae);
                }
            }
            if (!matchingTermsAvailable && this.m_query != null) {
                entry.setMatchingTerms(this.m_query.getQueryTerms());
            }
            DfResultEntry dfResultEntry3 = dfResultEntry2 = (dfResultEntry = entry);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)result2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfResultEntry2, joinPoint);
            }
            return dfResultEntry;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)result2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSourceMap(IDfSearchSourceMap iDfSearchSourceMap) {
        IDfSearchSourceMap iDfSearchSourceMap2 = iDfSearchSourceMap;
        JoinPoint joinPoint = null;
        try {
            void sourceMap;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfSearchSourceMap2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_sourceMap = sourceMap;
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfSearchSourceMap2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)iDfSearchSourceMap2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Constraint mapDFCConstraint(Constraint constraint) throws DataException, IllegalArgumentException {
        Constraint constraint2 = constraint;
        JoinPoint joinPoint = null;
        try {
            Constraint constraint3;
            Constraint constraint4;
            void dfcConstraint;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)constraint2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String dfcName = dfcConstraint.getName();
            String ecisAttr = ECISAttributesMapping.dfcToEcis(dfcName);
            String value = dfcConstraint.getValue();
            Constraint constraint5 = constraint4 = (constraint3 = DataFactory.createConstraint((String)ecisAttr, (int)dfcConstraint.getOp(), (String)value));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)constraint2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(constraint4, joinPoint);
            }
            return constraint3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)constraint2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private DfResultEntry createResultEntry(DfSearchSource dfSearchSource, int n) {
        DfSearchSource dfSearchSource2 = dfSearchSource;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            DfResultEntry dfResultEntry;
            DfResultEntry dfResultEntry2;
            void sequenceNumber;
            void sourceInfo;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)dfSearchSource2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            DfResultEntry entry = new DfResultEntry((DfSearchSource)sourceInfo);
            entry.setSeqNumber((int)sequenceNumber);
            for (int i = 0; i < DCTM_SHARED_ATTRS.length; ++i) {
                entry.addAttribute(DCTM_SHARED_ATTRS[i], DCTM_SHARED_VALUES[i]);
            }
            DfResultEntry dfResultEntry3 = dfResultEntry2 = (dfResultEntry = entry);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)dfSearchSource2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(dfResultEntry2, joinPoint);
            }
            return dfResultEntry;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)dfSearchSource2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mapECISAttribute(DfResultEntry dfResultEntry, xtrim.data.Attribute attribute) throws IllegalArgumentException {
        DfResultEntry dfResultEntry2 = dfResultEntry;
        xtrim.data.Attribute attribute2 = attribute;
        JoinPoint joinPoint = null;
        try {
            void entry;
            void ecisAttr;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)dfResultEntry2, (Object)attribute2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String ecisName = ecisAttr.getName();
            String name = ECISAttributesMapping.ecisToDfc(ecisName);
            String value = ecisAttr.getValue();
            this.addECISAttribute((DfResultEntry)entry, name, value, (xtrim.data.Attribute)ecisAttr);
            Object var9_9 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)dfResultEntry2, (Object)attribute2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var9_9, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)dfResultEntry2, (Object)attribute2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addECISAttribute(DfResultEntry dfResultEntry, String string, String string2, xtrim.data.Attribute attribute) throws IllegalArgumentException {
        DfResultEntry dfResultEntry2 = dfResultEntry;
        String string3 = string;
        String string4 = string2;
        xtrim.data.Attribute attribute2 = attribute;
        JoinPoint joinPoint = null;
        try {
            void value;
            void entry;
            void ecisAttr;
            void name;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, attribute2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (name.equals("url")) {
                if (ecisAttr.isObjectReference()) {
                    try {
                        entry.setECISObjectReference(ecisAttr.getEmbeddedObjectReference());
                    }
                    catch (DataException e) {
                        assert (false) : "This should not occur since we verified that this is an embedded object." + e.toString();
                    }
                } else {
                    entry.setURL((String)value);
                }
            } else if (name.equals(DataConstants.IMPORT_URL_ATTRIBUTE_LABEL)) {
                try {
                    entry.setECISObjectReference(ecisAttr.getEmbeddedObjectReference());
                }
                catch (DataException e) {
                    assert (ecisAttr.isObjectReference()) : DataConstants.IMPORT_URL_ATTRIBUTE_LABEL + " should contain an embedded. Caught:" + (Object)((Object)e);
                }
            } else if (name.equals("score")) {
                double dfcScore = (double)ECISFilter.parseInt((String)value) / 100.0;
                entry.setScore(dfcScore);
            } else if (name.equals("authors")) {
                this.addRepeatingStringAttribute((DfResultEntry)entry, (String)name, (String)value, 32);
            } else if (name.equals("keywords")) {
                this.addRepeatingStringAttribute((DfResultEntry)entry, (String)name, (String)value, 32);
            } else if (name.equals("r_full_content_size")) {
                int intValue = ECISFilter.parseInt((String)value) * 1024;
                entry.addAttribute((String)name, intValue);
            } else if (name.equals(ECI_ATTR_RANK)) {
                int intValue = ECISFilter.parseInt((String)value);
                entry.addAttribute((String)name, intValue);
            } else if (name.equals(IDfSearchConstants.ATTR_CONTENT_TYPE)) {
                try {
                    String dctmFormat = this.m_metadata.convertMimeToDocbaseFormat((String)value);
                    this.addSimpleAttribute((DfResultEntry)entry, IDfSearchConstants.ATTR_CONTENT_TYPE, 2, dctmFormat, 255);
                }
                catch (DfException e) {
                    this.addSimpleAttribute((DfResultEntry)entry, (String)name, 2, (String)value, 255);
                }
            } else if (name.equals("object_name")) {
                this.addSimpleAttribute((DfResultEntry)entry, (String)name, 2, (String)value, 255);
            } else if (name.equals("r_modify_date")) {
                entry.addDateAttribute((String)name, (String)value, "yyyy-MM-dd");
            } else if (name.endsWith(ECI_ATTR_DATE_SUFFIX)) {
                entry.addDateAttribute((String)name, (String)value, "yyyy-MM-dd");
            } else if (!name.equals("r_source") && !name.equals(IDfSearchConstants.ATTR_OBJECT_ID)) {
                if (name.equals(ECI_ATTR_MATCHING_TERMS)) {
                    entry.setMatchingTerms(this.tokenizeRepeatingStringValue((String)value));
                } else if (!name.startsWith(DataConstants.HIDDEN_ATTRIBUTE_PREFIX)) {
                    this.addSimpleAttribute((DfResultEntry)entry, (String)name, 2, (String)value, 4096);
                }
            }
            Object var14_18 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, attribute2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var14_18, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, attribute2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private static int parseInt(String string) throws IllegalArgumentException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                String s;
                n2 = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(nfe.getMessage());
            }
            int n3 = n = n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addSimpleAttribute(DfResultEntry dfResultEntry, String string, int n, String string2, int n2) {
        DfResultEntry dfResultEntry2 = dfResultEntry;
        String string3 = string;
        int n3 = n;
        String string4 = string2;
        int n4 = n2;
        JoinPoint joinPoint = null;
        try {
            void attrType;
            void attrName;
            void entry;
            String value;
            void length;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, Conversions.intObject((int)n3), string4, Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (length >= 0 && value.length() > length) {
                value = value.substring(0, (int)length);
            }
            entry.addAttribute((String)attrName, (int)attrType, value, (int)length);
            Object var14_13 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, Conversions.intObject((int)n3), string4, Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var14_13, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, Conversions.intObject((int)n3), string4, Conversions.intObject((int)n4)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addRepeatingStringAttribute(DfResultEntry dfResultEntry, String string, String string2, int n) {
        DfResultEntry dfResultEntry2 = dfResultEntry;
        String string3 = string;
        String string4 = string2;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            void value;
            void length;
            void attrName;
            void entry;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, Conversions.intObject((int)n2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            entry.addAttribute((String)attrName, true, 2, (int)length);
            Iterator<String> i$ = this.tokenizeRepeatingStringValue((String)value).iterator();
            while (i$.hasNext()) {
                String s;
                String token = s = i$.next();
                if (length >= 0 && token.length() > length) {
                    token = token.substring(0, (int)length);
                }
                entry.appendRepeatingValue((String)attrName, new DfValue(token.trim()));
            }
            Object var15_14 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, Conversions.intObject((int)n2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var15_14, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{dfResultEntry2, string3, string4, Conversions.intObject((int)n2)};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<String> tokenizeRepeatingStringValue(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2;
            void value;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            ArrayList<String> tokens = new ArrayList<String>(20);
            StringTokenizer tokenizer = new StringTokenizer((String)value, ",", false);
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            ArrayList<String> arrayList3 = arrayList2 = (arrayList = tokens);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(arrayList2, joinPoint);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ECISFilter.java", Class.forName("com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertToExternalValue", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "java.lang.String:com.documentum.fc.client.search.impl.definition.expression.DfAttrExpression:", "value:expression:", "com.documentum.fc.client.search.DfSearchException:", "java.lang.String"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertToExternalDate", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "java.lang.String:int:java.lang.String:", "date:searchOp:dateFormat:", "com.documentum.fc.client.search.DfQueryGenerationException:", "java.lang.String"), 148);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addSimpleAttribute", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.result.DfResultEntry:java.lang.String:int:java.lang.String:int:", "entry:attrName:attrType:value:length:", "", "void"), 420);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addRepeatingStringAttribute", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.result.DfResultEntry:java.lang.String:java.lang.String:int:", "entry:attrName:value:length:", "", "void"), 432);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "tokenizeRepeatingStringValue", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "java.lang.String:", "value:", "", "java.util.List"), 453);
        ajc$tjp_13 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.execution.data.ServerQuery:", "query:", ""), 96);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transformQuery", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "xtrim.data.EditableQuery:", "initialQuery:", "xtrim.data.DataException:", "xtrim.data.EditableQuery"), 174);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transformResult", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "xtrim.data.Result:int:", "result:sequenceNumber:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.search.impl.result.DfResultEntry"), 202);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSourceMap", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.IDfSearchSourceMap:", "sourceMap:", "", "void"), 247);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mapDFCConstraint", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "xtrim.data.Constraint:", "dfcConstraint:", "xtrim.data.DataException:java.lang.IllegalArgumentException:", "xtrim.data.Constraint"), 260);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createResultEntry", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.definition.metadata.DfSearchSource:int:", "sourceInfo:sequenceNumber:", "", "com.documentum.fc.client.search.impl.result.DfResultEntry"), 271);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mapECISAttribute", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.result.DfResultEntry:xtrim.data.Attribute:", "entry:ecisAttr:", "java.lang.IllegalArgumentException:", "void"), 292);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addECISAttribute", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "com.documentum.fc.client.search.impl.result.DfResultEntry:java.lang.String:java.lang.String:xtrim.data.Attribute:", "entry:name:value:ecisAttr:", "java.lang.IllegalArgumentException:", "void"), 322);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "parseInt", "com.documentum.fc.client.search.impl.execution.adapter.remoteeci.ECISFilter", "java.lang.String:", "s:", "java.lang.IllegalArgumentException:", "int"), 408);
        s_mandatoryAttrIndex = 4;
        DCTM_OBJECT_TYPE_ATTR = new Attribute(s_mandatoryAttrIndex++, IDfSearchConstants.ATTR_OBJECT_TYPE, false, 2, 32);
        DCTM_OBJECT_TYPE_VALUE = new DfValue("dm_document", 2);
        DCTM_IS_VIRTUAL_ATTR = new Attribute(s_mandatoryAttrIndex++, IDfSearchConstants.ATTR_IS_VIRTUAL, false, 0, -1);
        DCTM_IS_VIRTUAL_VALUE = new DfValue("false", 0);
        DCTM_IS_REFERENCE_ATTR = new Attribute(s_mandatoryAttrIndex++, "i_is_reference", false, 0, -1);
        DCTM_IS_REFERENCE_VALUE = new DfValue("false", 0);
        DCTM_IS_REPLICA_ATTR = new Attribute(s_mandatoryAttrIndex++, "i_is_replica", false, 0, -1);
        DCTM_IS_REPLICA_VALUE = new DfValue("false", 0);
        DCTM_LINK_CNT_ATTR = new Attribute(s_mandatoryAttrIndex++, IDfSearchConstants.ATTR_LINK_CNT, false, 1, -1);
        DCTM_LINK_CNT_VALUE = new DfValue("0", 1);
        DCTM_FRZN_ASSEMBLY_ATTR = new Attribute(s_mandatoryAttrIndex++, IDfSearchConstants.ATTR_FRZN_ASSEMBLY, false, 0, -1);
        DCTM_FRZN_ASSEMBLY_VALUE = new DfValue("false", 0);
        DCTM_SHARED_ATTRS = new IDfAttr[]{DCTM_OBJECT_TYPE_ATTR, DCTM_IS_VIRTUAL_ATTR, DCTM_IS_REFERENCE_ATTR, DCTM_IS_REPLICA_ATTR, DCTM_LINK_CNT_ATTR, DCTM_FRZN_ASSEMBLY_ATTR};
        DCTM_SHARED_VALUES = new IDfValue[]{DCTM_OBJECT_TYPE_VALUE, DCTM_IS_VIRTUAL_VALUE, DCTM_IS_REFERENCE_VALUE, DCTM_IS_REPLICA_VALUE, DCTM_LINK_CNT_VALUE, DCTM_FRZN_ASSEMBLY_VALUE};
    }
}

