/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.search.impl.ecis;

import com.documentum.fc.client.search.DfConfigurationException;
import com.documentum.fc.client.search.DfSearchException;
import com.documentum.fc.client.search.impl.config.SearchConfig;
import com.documentum.fc.client.search.impl.config.SearchConfigFactory;
import com.documentum.fc.client.search.impl.ecis.ECISDomainListener;
import com.documentum.fc.client.search.impl.ecis.ECISEventReceiver;
import com.documentum.fc.client.search.impl.ecis.ECISMetadataMgr;
import com.documentum.fc.client.search.impl.ecis.ECISProxyException;
import com.documentum.fc.client.search.impl.ecis.RemoteECISMetadataMgrImpl;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import xtrim.data.BackendSettings;
import xtrim.data.BackendSettingsMap;
import xtrim.data.DataConstants;
import xtrim.data.DataException;
import xtrim.data.Domain;
import xtrim.data.DomainConfig;
import xtrim.data.EditableDomain;
import xtrim.data.EditableQuery;
import xtrim.data.EmbeddedObjectReference;
import xtrim.data.Query;
import xtrim.rmiapi.ECIRmiProperties;
import xtrim.rmiapi.LoginException;
import xtrim.rmiapi.RmiApi;
import xtrim.rmiapi.RmiApiException;
import xtrim.rmiapi.RmiEmbeddedObjReceiver;
import xtrim.rmiapi.RmiResultReceiver;
import xtrim.rmiapi.RmiSession;

public class ECISProxy {
    private static final String RECONNECT_TO_PRIMARY_ECIS_SERVER_LOG = "RECONNECT_TO_PRIMARY_ECIS_SERVER";
    private static final String SWITCH_TO_BACKUP_ECIS_SERVER_LOG = "SWITCH_TO_BACKUP_ECIS_SERVER";
    private static ECISProxy s_ecisProxySingleton;
    private static RmiApi s_rmiApiForTest;
    private RmiApi m_currentRmiApi;
    private boolean m_isCurrentRmiApiBackup;
    private long m_backupRmiApiCreationDate;
    private Domain m_domain;
    private Collection<ECISDomainListener> m_domainListeners;
    private long m_latestDomainLoading;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;

    public static synchronized ECISProxy getECISProxy() {
        JoinPoint joinPoint = null;
        try {
            ECISProxy eCISProxy;
            ECISProxy eCISProxy2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (s_ecisProxySingleton == null) {
                s_ecisProxySingleton = new ECISProxy();
            }
            ECISProxy eCISProxy3 = eCISProxy2 = (eCISProxy = s_ecisProxySingleton);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(eCISProxy2, joinPoint);
            }
            return eCISProxy;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static synchronized void resetECISProxy() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            s_ecisProxySingleton = null;
            s_rmiApiForTest = null;
            Object var1_1 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var1_1, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized RmiApi getRmiApi() throws NotBoundException, RemoteException, AccessException, MalformedURLException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            RmiApi rmiApi;
            RmiApi rmiApi2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_currentRmiApi == null || this.m_isCurrentRmiApiBackup && this.hasRmiApiExpired()) {
                if (this.m_isCurrentRmiApiBackup && this.hasRmiApiExpired()) {
                    if (DfLogger.isWarnEnabled(this)) {
                        SearchConfig searchConfig = SearchConfigFactory.getConfig();
                        DfLogger.warn((Object)this, "[RECONNECT_TO_PRIMARY_ECIS_SERVER]Switch back to primary ecis server :" + searchConfig.getRmiRegistryHost() + ":" + searchConfig.getRmiRegistryPort(), null, null);
                    }
                    this.m_isCurrentRmiApiBackup = false;
                }
                this.connectRMIApi();
            }
            RmiApi rmiApi3 = rmiApi2 = (rmiApi = this.m_currentRmiApi);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rmiApi2, joinPoint);
            }
            return rmiApi;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean hasRmiApiExpired() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean hasExpired = false;
            if (this.m_isCurrentRmiApiBackup && System.currentTimeMillis() - this.m_backupRmiApiCreationDate > SearchConfigFactory.getConfig().getEcisRetryPeriod()) {
                hasExpired = true;
            }
            boolean bl3 = bl2 = (bl = hasExpired);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized Domain getJspDomain() throws DataException, NotBoundException, RemoteException, AccessException, MalformedURLException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            Domain domain;
            Domain domain2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (this.m_domain == null) {
                this.connectRMIApi();
            }
            Domain domain3 = domain2 = (domain = this.m_domain);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(domain2, joinPoint);
            }
            return domain;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public ECISMetadataMgr getECISMetadataMgr() throws DfSearchException {
        JoinPoint joinPoint = null;
        try {
            RemoteECISMetadataMgrImpl remoteECISMetadataMgrImpl;
            RemoteECISMetadataMgrImpl remoteECISMetadataMgrImpl2;
            RemoteECISMetadataMgrImpl remoteECISMetadataMgrImpl3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                this.reloadDomainsIfNeeded();
                remoteECISMetadataMgrImpl2 = remoteECISMetadataMgrImpl3 = new RemoteECISMetadataMgrImpl(this.getJspDomain());
            }
            catch (DataException e) {
                throw new DfConfigurationException(e);
            }
            catch (NotBoundException e) {
                throw new DfConfigurationException(e);
            }
            catch (RemoteException e) {
                throw new DfSearchException("COMMUNICATION_ERROR", (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new DfConfigurationException(e);
            }
            catch (ECISProxyException e) {
                throw new DfConfigurationException(e);
            }
            RemoteECISMetadataMgrImpl remoteECISMetadataMgrImpl4 = remoteECISMetadataMgrImpl = remoteECISMetadataMgrImpl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(remoteECISMetadataMgrImpl, joinPoint);
            }
            return remoteECISMetadataMgrImpl3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addDomainListener(ECISDomainListener eCISDomainListener) {
        ECISDomainListener eCISDomainListener2 = eCISDomainListener;
        JoinPoint joinPoint = null;
        try {
            void listener;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)eCISDomainListener2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_domainListeners.add((ECISDomainListener)listener);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)eCISDomainListener2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)eCISDomainListener2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public synchronized boolean isBackupServer() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = this.m_isCurrentRmiApiBackup);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private ECISProxy() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_isCurrentRmiApiBackup = false;
            this.init();
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void init() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_currentRmiApi = null;
            this.m_domain = null;
            this.m_latestDomainLoading = 0L;
            this.m_domainListeners = new ArrayList<ECISDomainListener>(2);
            Object var2_2 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var2_2, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized void reconnectRMIApi() throws NotBoundException, RemoteException, AccessException, MalformedURLException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "reconnectRMISession", null, null);
            }
            if (this.supportsBackupHost()) {
                if (DfLogger.isWarnEnabled(this)) {
                    SearchConfig searchConfig = SearchConfigFactory.getConfig();
                    DfLogger.warn((Object)this, "[SWITCH_TO_BACKUP_ECIS_SERVER]Switch to backup ecis server : " + searchConfig.getBackupRmiRegistryHost() + ":" + searchConfig.getBackupRmiRegistryPort(), null, null);
                }
                this.m_currentRmiApi = null;
                this.m_currentRmiApi = this.lookupBackupRmiApi();
                this.m_isCurrentRmiApiBackup = true;
                this.m_backupRmiApiCreationDate = System.currentTimeMillis();
            } else {
                if (DfLogger.isWarnEnabled(this)) {
                    SearchConfig searchConfig = SearchConfigFactory.getConfig();
                    DfLogger.warn((Object)this, "Retry connection to ecis server : " + searchConfig.getRmiRegistryHost() + ":" + searchConfig.getRmiRegistryPort(), null, null);
                }
                this.m_currentRmiApi = this.lookupPrimaryRmiApi();
            }
            this.loadDomains();
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "reconnectRMISession: the RmiApi reference is updated", null, null);
            }
            Object var3_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private synchronized void reloadDomainsIfNeeded() throws ECISProxyException, RemoteException, MalformedURLException, NotBoundException {
        JoinPoint joinPoint = null;
        try {
            long latestTimeStamp;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((latestTimeStamp = this.getDomainsTimeStamp()) != this.m_latestDomainLoading) {
                this.loadDomains();
            }
            Object var4_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private RmiApi lookupPrimaryRmiApi() throws NotBoundException, MalformedURLException, RemoteException {
        JoinPoint joinPoint = null;
        try {
            RmiApi rmiApi;
            RmiApi rmiApi2;
            RmiApi aReturnedRmiApi;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((aReturnedRmiApi = s_rmiApiForTest) == null) {
                SearchConfig config = SearchConfigFactory.getConfig();
                aReturnedRmiApi = this.lookupRmiApi(config.getRmiRegistryHost(), config.getRmiRegistryPort());
                if (DfLogger.isInfoEnabled(this)) {
                    DfLogger.info((Object)this, "Primary ECIS Server remote API address is:" + aReturnedRmiApi, null, null);
                }
            }
            RmiApi rmiApi3 = rmiApi2 = (rmiApi = aReturnedRmiApi);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rmiApi2, joinPoint);
            }
            return rmiApi;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private RmiApi lookupBackupRmiApi() throws NotBoundException, MalformedURLException, RemoteException {
        JoinPoint joinPoint = null;
        try {
            RmiApi rmiApi;
            RmiApi rmiApi2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            SearchConfig config = SearchConfigFactory.getConfig();
            RmiApi aReturnedRmiApi = this.lookupRmiApi(config.getBackupRmiRegistryHost(), config.getBackupRmiRegistryPort());
            if (DfLogger.isInfoEnabled(this)) {
                DfLogger.info((Object)this, "Backup ECIS Server remote API address is:" + aReturnedRmiApi, null, null);
            }
            RmiApi rmiApi3 = rmiApi2 = (rmiApi = aReturnedRmiApi);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rmiApi2, joinPoint);
            }
            return rmiApi;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private RmiApi lookupRmiApi(String string, int n) throws NotBoundException, MalformedURLException, RemoteException {
        String string2 = string;
        int n2 = n;
        JoinPoint joinPoint = null;
        try {
            RmiApi rmiApi;
            RmiApi rmiApi2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            SearchConfig config = SearchConfigFactory.getConfig();
            ECIRmiProperties.setRmiSslEnabled((boolean)config.isRmiSslEnabled());
            ECIRmiProperties.setRmiSslKeyStore((String)config.getRmiSslKeyStore());
            ECIRmiProperties.setRmiSslKeyStorePassword((String)config.getRmiSslKeyStorePassword());
            String urlToLookup = null;
            try {
                void rmiRegistryPort;
                void rmiRegistryHost;
                urlToLookup = new URI("rmi", null, (String)rmiRegistryHost, (int)rmiRegistryPort, "/" + config.getECISRmiName(), null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "lookupRmiApi at URL:" + urlToLookup, null, null);
            }
            RmiApi rmiApi3 = rmiApi2 = (rmiApi = (RmiApi)Naming.lookup(urlToLookup));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rmiApi2, joinPoint);
            }
            return rmiApi;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private boolean supportsBackupHost() {
        JoinPoint joinPoint = null;
        try {
            boolean bl;
            SearchConfig config;
            String backupRmiRegistryHost;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl2 = (backupRmiRegistryHost = (config = SearchConfigFactory.getConfig()).getBackupRmiRegistryHost()) != null && backupRmiRegistryHost.length() > 0;
            boolean bl3 = bl = bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static void setRmiApiForTest(RmiApi rmiApi) {
        RmiApi rmiApi2 = rmiApi;
        JoinPoint joinPoint = null;
        try {
            RmiApi testApi;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)rmiApi2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            s_ecisProxySingleton = null;
            s_rmiApiForTest = testApi;
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)rmiApi2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)rmiApi2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void connectRMIApi() throws NotBoundException, RemoteException, AccessException, MalformedURLException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "connectRMISession", null, null);
            }
            if (DfLogger.isInfoEnabled(this)) {
                SearchConfig searchConfig = SearchConfigFactory.getConfig();
                DfLogger.info((Object)this, "Connect to primary ECIS server. RMI Registry address is: " + searchConfig.getRmiRegistryHost() + ":" + searchConfig.getRmiRegistryPort(), null, null);
            }
            this.m_currentRmiApi = this.lookupPrimaryRmiApi();
            this.loadDomains();
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "connectRMISession: successfully looked up RMI api:" + this.m_currentRmiApi, null, null);
            }
            Object var3_3 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var3_3, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private void loadDomains() throws RemoteException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "Load Remote ECIS search sources.", null, null);
            }
            this.m_latestDomainLoading = this.m_currentRmiApi.getDomainsTimeStamp();
            DomainConfig systemDomainConfig = this.m_currentRmiApi.getDomainHierarchy();
            if (systemDomainConfig == null) {
                throw new ECISProxyException("Empty SystemDomain generated in the Controller!");
            }
            Domain allDomain = systemDomainConfig.getRootDomain();
            this.m_domain = allDomain.getSubDomainFromName(SearchConfigFactory.getConfig().getSubDomainName());
            if (this.m_domain == null) {
                throw new ECISProxyException("Subdomain of name " + SearchConfigFactory.getConfig().getSubDomainName() + " not found in the system domain!");
            }
            Iterator<ECISDomainListener> i$ = this.m_domainListeners.iterator();
            while (i$.hasNext()) {
                ECISDomainListener m_domainListener;
                ECISDomainListener listener = m_domainListener = i$.next();
                listener.notifyECISDomainLoaded();
            }
            Object var7_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var7_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RmiSession login(String string, String string2) throws RemoteException, LoginException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = null;
        try {
            RmiSession rmiSession;
            RmiSession rmiSession2;
            void accountPwd;
            void accountName;
            RmiSession rmiSession3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                rmiSession2 = rmiSession3 = this.getRmiApi().login((String)accountName, (String)accountPwd, "DFC", true);
            }
            catch (RemoteException firstException) {
                RmiSession failoverSession = null;
                try {
                    this.reconnectRMIApi();
                    failoverSession = this.getRmiApi().login((String)accountName, (String)accountPwd, "DFC", true);
                }
                catch (RemoteException secondException) {
                    this.handleFailoverException(firstException, secondException);
                }
                rmiSession2 = rmiSession3 = failoverSession;
            }
            RmiSession rmiSession4 = rmiSession = rmiSession2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(rmiSession, joinPoint);
            }
            return rmiSession3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string3, (Object)string4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logout(RmiSession rmiSession) throws RemoteException, RmiApiException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        RmiSession rmiSession2 = rmiSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)rmiSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.getRmiApi().logout((RmiSession)session);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)rmiSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)rmiSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void search(List list, EditableQuery editableQuery, BackendSettingsMap backendSettingsMap, RmiResultReceiver rmiResultReceiver, RmiSession rmiSession, ECISEventReceiver eCISEventReceiver) throws RemoteException, RmiApiException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        List list2 = list;
        EditableQuery editableQuery2 = editableQuery;
        BackendSettingsMap backendSettingsMap2 = backendSettingsMap;
        RmiResultReceiver rmiResultReceiver2 = rmiResultReceiver;
        RmiSession rmiSession2 = rmiSession;
        ECISEventReceiver eCISEventReceiver2 = eCISEventReceiver;
        JoinPoint joinPoint = null;
        try {
            void eventReceiver;
            void session;
            void recipient;
            void bkdSettingsMap;
            void query;
            void sources;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                this.doSearch((List)sources, (EditableQuery)query, (BackendSettingsMap)bkdSettingsMap, (RmiResultReceiver)recipient, (RmiSession)session, (ECISEventReceiver)eventReceiver);
            }
            catch (RemoteException firstException) {
                try {
                    this.reconnectRMIApi();
                    this.doSearch((List)sources, (EditableQuery)query, (BackendSettingsMap)bkdSettingsMap, (RmiResultReceiver)recipient, (RmiSession)session, (ECISEventReceiver)eventReceiver);
                }
                catch (RemoteException secondException) {
                    this.handleFailoverException(firstException, secondException);
                }
            }
            Object var18_17 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var18_17, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stopSearch(long l, RmiSession rmiSession) throws RemoteException, RmiApiException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        long l2 = l;
        RmiSession rmiSession2 = rmiSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            void queryId;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)rmiSession2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                this.getRmiApi().stopSearch((long)queryId, (RmiSession)session);
            }
            catch (RemoteException firstException) {
                try {
                    this.reconnectRMIApi();
                    this.getRmiApi().stopSearch((long)queryId, (RmiSession)session);
                }
                catch (RemoteException secondException) {
                    this.handleFailoverException(firstException, secondException);
                }
            }
            Object var10_8 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)rmiSession2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var10_8, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)rmiSession2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getEmbeddedObject(EmbeddedObjectReference embeddedObjectReference, BackendSettings backendSettings, RmiEmbeddedObjReceiver rmiEmbeddedObjReceiver, RmiSession rmiSession) throws RemoteException, RmiApiException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        EmbeddedObjectReference embeddedObjectReference2 = embeddedObjectReference;
        BackendSettings backendSettings2 = backendSettings;
        RmiEmbeddedObjReceiver rmiEmbeddedObjReceiver2 = rmiEmbeddedObjReceiver;
        RmiSession rmiSession2 = rmiSession;
        JoinPoint joinPoint = null;
        try {
            void session;
            void recipient;
            void bkdSettings;
            void objRef;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{embeddedObjectReference2, backendSettings2, rmiEmbeddedObjReceiver2, rmiSession2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                this.getRmiApi().getEmbeddedObject((EmbeddedObjectReference)objRef, (BackendSettings)bkdSettings, (RmiEmbeddedObjReceiver)recipient, (RmiSession)session);
            }
            catch (RemoteException firstException) {
                try {
                    this.reconnectRMIApi();
                    this.getRmiApi().getEmbeddedObject((EmbeddedObjectReference)objRef, (BackendSettings)bkdSettings, (RmiEmbeddedObjReceiver)recipient, (RmiSession)session);
                }
                catch (RemoteException secondException) {
                    this.handleFailoverException(firstException, secondException);
                }
            }
            Object var14_13 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{embeddedObjectReference2, backendSettings2, rmiEmbeddedObjReceiver2, rmiSession2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var14_13, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{embeddedObjectReference2, backendSettings2, rmiEmbeddedObjReceiver2, rmiSession2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private long getDomainsTimeStamp() throws RemoteException, MalformedURLException, NotBoundException, ECISProxyException {
        JoinPoint joinPoint = null;
        try {
            long l;
            long l2;
            long l3;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                l2 = l3 = this.getRmiApi().getDomainsTimeStamp();
            }
            catch (RemoteException firstException) {
                long failoverTimeStamp = 0L;
                try {
                    this.reconnectRMIApi();
                    failoverTimeStamp = this.getRmiApi().getDomainsTimeStamp();
                }
                catch (RemoteException secondException) {
                    this.handleFailoverException(firstException, secondException);
                }
                l2 = l3 = failoverTimeStamp;
            }
            long l4 = l = l2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.longObject((long)l);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return l3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doSearch(List list, EditableQuery editableQuery, BackendSettingsMap backendSettingsMap, RmiResultReceiver rmiResultReceiver, RmiSession rmiSession, ECISEventReceiver eCISEventReceiver) throws RemoteException, RmiApiException, MalformedURLException, NotBoundException, DataException, ECISProxyException {
        List list2 = list;
        EditableQuery editableQuery2 = editableQuery;
        BackendSettingsMap backendSettingsMap2 = backendSettingsMap;
        RmiResultReceiver rmiResultReceiver2 = rmiResultReceiver;
        RmiSession rmiSession2 = rmiSession;
        ECISEventReceiver eCISEventReceiver2 = eCISEventReceiver;
        JoinPoint joinPoint = null;
        try {
            void eventReceiver;
            void sources;
            Domain transientDomain;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if ((transientDomain = this.createTransientDomain((List)sources, (ECISEventReceiver)eventReceiver)) != null) {
                void session;
                void recipient;
                void bkdSettingsMap;
                void query;
                query.setDomain(transientDomain);
                this.getRmiApi().search((Query)query, (BackendSettingsMap)bkdSettingsMap, (RmiResultReceiver)recipient, true, (RmiSession)session);
            }
            Object var17_16 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var17_16, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{list2, editableQuery2, backendSettingsMap2, rmiResultReceiver2, rmiSession2, eCISEventReceiver2};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Domain createTransientDomain(List list, ECISEventReceiver eCISEventReceiver) throws MalformedURLException, RemoteException, NotBoundException, DataException, ECISProxyException {
        List list2 = list;
        ECISEventReceiver eCISEventReceiver2 = eCISEventReceiver;
        JoinPoint joinPoint = null;
        try {
            EditableDomain editableDomain;
            EditableDomain editableDomain2;
            void eventReceiver;
            void sourcesNames;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)list2, (Object)eCISEventReceiver2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (DfLogger.isDebugEnabled(this)) {
                DfLogger.debug((Object)this, "createTransientDomain", null, null);
            }
            DomainConfig config = DomainConfig.getConfig((long)-4611686018427387904L);
            Domain jspDomains = this.getJspDomain();
            EditableDomain selectedDomain = config.createNewDomain(DataConstants.DEFAULT_CUSTOM_DOMAIN_NAME);
            boolean validDomain = false;
            for (int i = 0; i < sourcesNames.size(); ++i) {
                Domain recoveredBackend;
                String backendName = (String)sourcesNames.get(i);
                if (DfLogger.isDebugEnabled(this)) {
                    DfLogger.debug((Object)this, "createTransientDomain: backendName = " + backendName, null, null);
                }
                if ((recoveredBackend = jspDomains.getSubDomainFromName(backendName)) != null) {
                    try {
                        selectedDomain.addSubDomainAt(recoveredBackend, selectedDomain.getSubDomainsCount());
                        validDomain = true;
                        continue;
                    }
                    catch (DataException dae) {
                        assert (false) : "The query domain selection (i.e. custom domain)  should not refuse to be edited. Source=" + backendName + ". " + dae.toString();
                        continue;
                    }
                }
                eventReceiver.status(7, 72, backendName, "Impossible to recover the ECIS source [" + backendName + "]", null);
            }
            if (!validDomain) {
                eventReceiver.notifyCompletion();
                selectedDomain = null;
            }
            EditableDomain editableDomain3 = editableDomain2 = (editableDomain = selectedDomain);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)list2, (Object)eCISEventReceiver2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(editableDomain2, joinPoint);
            }
            return editableDomain;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)list2, (Object)eCISEventReceiver2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleFailoverException(RemoteException remoteException, RemoteException remoteException2) throws RemoteException {
        RemoteException remoteException3 = remoteException;
        RemoteException remoteException4 = remoteException2;
        JoinPoint joinPoint = null;
        try {
            void firstException;
            void secondException;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)remoteException3, (Object)remoteException4);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (!this.supportsBackupHost()) {
                DfLogger.info((Object)this, "Communication with ECIS Server failed. Retried connection a second time with error:" + secondException, null, null);
                throw this.addHelpfulMessage((RemoteException)firstException);
            }
            DfLogger.error((Object)this, "Try to communicate with ECIS Server. First exception=" + firstException, null, (Throwable)this.addHelpfulMessage((RemoteException)firstException));
            throw this.addHelpfulMessage((RemoteException)secondException);
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)remoteException3, (Object)remoteException4);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private RemoteException addHelpfulMessage(RemoteException remoteException) {
        RemoteException remoteException2 = remoteException;
        JoinPoint joinPoint = null;
        try {
            RemoteException helpfulException;
            RemoteException remoteException3;
            void var7_7;
            void exception;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)remoteException2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            Throwable cause = exception.getCause();
            void v1 = var7_7 = exception instanceof UnmarshalException || cause != null && cause instanceof UnmarshalException ? (remoteException3 = (helpfulException = new RemoteException("Unable to communicate with ECIS Server. This is probably due to an incompatibility with the ECIS Server. You should have the same version for ECIS Server and DFC. You can also try to copy xtrim-api.jar from ECIS Server installation directory to your application classpath. " + exception, (Throwable)exception))) : (remoteException3 = exception);
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)remoteException2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var7_7, joinPoint);
            }
            return remoteException3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)remoteException2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ECISProxy.java", Class.forName("com.documentum.fc.client.search.impl.ecis.ECISProxy"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getECISProxy", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "com.documentum.fc.client.search.impl.ecis.ECISProxy"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "resetECISProxy", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "void"), 110);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "reloadDomainsIfNeeded", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "com.documentum.fc.client.search.impl.ecis.ECISProxyException:java.rmi.RemoteException:java.net.MalformedURLException:java.rmi.NotBoundException:", "void"), 322);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lookupPrimaryRmiApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.NotBoundException:java.net.MalformedURLException:java.rmi.RemoteException:", "xtrim.rmiapi.RmiApi"), 339);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lookupBackupRmiApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.NotBoundException:java.net.MalformedURLException:java.rmi.RemoteException:", "xtrim.rmiapi.RmiApi"), 366);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lookupRmiApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.lang.String:int:", "rmiRegistryHost:rmiRegistryPort:", "java.rmi.NotBoundException:java.net.MalformedURLException:java.rmi.RemoteException:", "xtrim.rmiapi.RmiApi"), 384);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "supportsBackupHost", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "boolean"), 421);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "setRmiApiForTest", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "xtrim.rmiapi.RmiApi:", "testApi:", "", "void"), 435);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "connectRMIApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.NotBoundException:java.rmi.RemoteException:java.rmi.AccessException:java.net.MalformedURLException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 457);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadDomains", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.RemoteException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 489);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "login", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.lang.String:java.lang.String:", "accountName:accountPwd:", "java.rmi.RemoteException:xtrim.rmiapi.LoginException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "xtrim.rmiapi.RmiSession"), 525);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logout", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "xtrim.rmiapi.RmiSession:", "session:", "java.rmi.RemoteException:xtrim.rmiapi.RmiApiException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 544);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "getRmiApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.NotBoundException:java.rmi.RemoteException:java.rmi.AccessException:java.net.MalformedURLException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "xtrim.rmiapi.RmiApi"), 133);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "search", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.util.List:xtrim.data.EditableQuery:xtrim.data.BackendSettingsMap:xtrim.rmiapi.RmiResultReceiver:xtrim.rmiapi.RmiSession:com.documentum.fc.client.search.impl.ecis.ECISEventReceiver:", "sources:query:bkdSettingsMap:recipient:session:eventReceiver:", "java.rmi.RemoteException:xtrim.rmiapi.RmiApiException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 553);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stopSearch", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "long:xtrim.rmiapi.RmiSession:", "queryId:session:", "java.rmi.RemoteException:xtrim.rmiapi.RmiApiException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 573);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEmbeddedObject", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "xtrim.data.EmbeddedObjectReference:xtrim.data.BackendSettings:xtrim.rmiapi.RmiEmbeddedObjReceiver:xtrim.rmiapi.RmiSession:", "objRef:bkdSettings:recipient:session:", "java.rmi.RemoteException:xtrim.rmiapi.RmiApiException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 593);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDomainsTimeStamp", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.RemoteException:java.net.MalformedURLException:java.rmi.NotBoundException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "long"), 612);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doSearch", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.util.List:xtrim.data.EditableQuery:xtrim.data.BackendSettingsMap:xtrim.rmiapi.RmiResultReceiver:xtrim.rmiapi.RmiSession:com.documentum.fc.client.search.impl.ecis.ECISEventReceiver:", "sources:query:bkdSettingsMap:recipient:session:eventReceiver:", "java.rmi.RemoteException:xtrim.rmiapi.RmiApiException:java.net.MalformedURLException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 633);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransientDomain", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.util.List:com.documentum.fc.client.search.impl.ecis.ECISEventReceiver:", "sourcesNames:eventReceiver:", "java.net.MalformedURLException:java.rmi.RemoteException:java.rmi.NotBoundException:xtrim.data.DataException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "xtrim.data.Domain"), 650);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleFailoverException", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.rmi.RemoteException:java.rmi.RemoteException:", "firstException:secondException:", "java.rmi.RemoteException:", "void"), 698);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addHelpfulMessage", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "java.rmi.RemoteException:", "exception:", "", "java.rmi.RemoteException"), 722);
        ajc$tjp_28 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", ""), 71);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "hasRmiApiExpired", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "boolean"), 151);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getJspDomain", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "xtrim.data.DataException:java.rmi.NotBoundException:java.rmi.RemoteException:java.rmi.AccessException:java.net.MalformedURLException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "xtrim.data.Domain"), 182);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getECISMetadataMgr", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "com.documentum.fc.client.search.DfSearchException:", "com.documentum.fc.client.search.impl.ecis.ECISMetadataMgr"), 202);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addDomainListener", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "com.documentum.fc.client.search.impl.ecis.ECISDomainListener:", "listener:", "", "void"), 240);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "isBackupServer", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "boolean"), 246);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "init", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "", "void"), 260);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "reconnectRMIApi", "com.documentum.fc.client.search.impl.ecis.ECISProxy", "", "", "java.rmi.NotBoundException:java.rmi.RemoteException:java.rmi.AccessException:java.net.MalformedURLException:com.documentum.fc.client.search.impl.ecis.ECISProxyException:", "void"), 278);
        s_ecisProxySingleton = null;
        s_rmiApiForTest = null;
    }
}

