/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.privilege.impl;

import com.documentum.fc.client.DfSysObject;
import com.documentum.fc.client.IDfTypedObject;
import com.documentum.fc.client.attributehandler.DfAbstractAttributeFilter;
import com.documentum.fc.client.attributehandler.IDfAttributeHandler;
import com.documentum.fc.client.impl.objectmanager.IntrinsicObject;
import com.documentum.fc.client.privilege.internal.IPublicKeyCertificate;
import com.documentum.fc.client.security.IDfAuthenticationInfo;
import com.documentum.fc.client.security.internal.SimplifiedX500DN;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfRuntimeException;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@IntrinsicObject
public class PublicKeyCertificate
extends DfSysObject
implements IPublicKeyCertificate {
    private static final String FN_KEY_IDENTIFIER = "key_identifier";
    private static final String FN_KEY_TYPE = "key_type";
    private static final String FN_PRIVATE_KEY_IDENTIFIER = "private_key_identifier";
    private static final String FN_CERTIFICATE_VALUE = "certificate_value";
    private static final String FNS_OBJECT_NAME = "object_name";
    protected static final String START_ARMOR = "-----BEGIN CERTIFICATE-----";
    protected static final String END_ARMOR = "-----END CERTIFICATE-----";
    protected static final String NOT_B64_DIGIT_REGEX = "[^A-Za-z0-9+/=]";
    protected static final String NOT_OBJECTNAME_REGEX = "[^A-Za-z0-9]";
    protected static final int IX_VAL = 0;
    protected static final int IX_CN = 1;
    protected static final int IX_KT = 2;
    protected static final Pattern NOT_B64_DIGIT_PATTERN;
    private static Map<String, IDfAttributeHandler> s_handlerMap;
    protected static final Map<String, String> s_keyTypeMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    public PublicKeyCertificate() {
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected IDfAttributeHandler getAttributeHandler(String attributeName) {
        IDfAttributeHandler handler = s_handlerMap.get(attributeName);
        if (handler != null) {
            return handler;
        }
        return super.getAttributeHandler(attributeName);
    }

    public int getKeyType() throws DfException {
        JoinPoint joinPoint = null;
        try {
            int n;
            int n2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            int n3 = n2 = (n = this.getInt(FN_KEY_TYPE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.intObject((int)n2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return n;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getKeyIdentifier() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = this.getString(FN_KEY_IDENTIFIER));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getPrivateKeyIdentifier() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = this.getString(FN_PRIVATE_KEY_IDENTIFIER));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String getCertificateValue() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string3 = string2 = (string = this.getString(FN_CERTIFICATE_VALUE));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string2, joinPoint);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPemCertificate() throws DfException {
        JoinPoint joinPoint = null;
        try {
            String string;
            String string2;
            String string3;
            String charCert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == (charCert = this.getString(FN_CERTIFICATE_VALUE)) || 0 == charCert.length()) {
                string2 = string3 = "";
            } else {
                charCert = charCert.trim();
                String pemCert = null;
                if (charCert.startsWith(START_ARMOR)) {
                    if (!charCert.endsWith(END_ARMOR)) throw new DfRuntimeException("DFC_SECURITY_CERT_ENCODING", new Object[]{this.getObjectId().getId()});
                    pemCert = charCert;
                } else {
                    pemCert = this.packageUnarmoredCharCert(charCert);
                }
                assert (null != pemCert && 0 < pemCert.length());
                string2 = string3 = pemCert;
            }
            String string4 = string = string2;
            if (!BaseTracingAspect.ajc$if_0()) return string3;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
            }
            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            if (!BaseTracingAspect.ajc$if_0()) throw throwable;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
            }
            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            throw throwable;
        }
    }

    public X509Certificate getCertificate() throws DfException {
        JoinPoint joinPoint = null;
        try {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            X509Certificate x509Certificate3 = x509Certificate2 = (x509Certificate = PublicKeyCertificate.sBuildCertObject(this.getPemCertificate()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(x509Certificate2, joinPoint);
            }
            return x509Certificate;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyIdentifier(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void kId;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != kId && 0 < kId.length());
            this.setString(FN_KEY_IDENTIFIER, (String)kId);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPrivateKeyIdentifier(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void pkId;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != pkId && 0 < pkId.length());
            this.setString(FN_PRIVATE_KEY_IDENTIFIER, (String)pkId);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCertificate(X509Certificate x509Certificate) throws DfException {
        X509Certificate x509Certificate2 = x509Certificate;
        JoinPoint joinPoint = null;
        try {
            byte[] derCert;
            void cert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)x509Certificate2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == cert) {
                throw new DfException("DFC_SECURITY_ILLEGAL_PARAMETER", new Object[]{"certificate"});
            }
            try {
                derCert = cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new DfException(e);
            }
            String certificateData = DfUtil.der2pem(derCert);
            this.setString(FN_CERTIFICATE_VALUE, certificateData);
            Object var6_7 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)x509Certificate2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var6_7, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)x509Certificate2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCertificateValue(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            void certificateData;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != certificateData && 0 < certificateData.length());
            this.setString(FN_CERTIFICATE_VALUE, (String)certificateData);
            Object var4_4 = null;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var4_4, joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String packageUnarmoredCharCert(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            void charCert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            assert (null != charCert && 0 < charCert.length());
            try {
                string4 = PublicKeyCertificate.sPackageUnarmoredCharCert((String)charCert, true);
            }
            catch (IllegalArgumentException ex) {
                throw new DfRuntimeException("DFC_SECURITY_BASE64", new Object[]{this.getObjectId().getId()});
            }
            catch (IOException ex) {
                throw new DfRuntimeException("DFC_SECURITY_BASE64", new Object[]{this.getObjectId().getId()});
            }
            String string5 = string3 = string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string3, joinPoint);
            }
            return string4;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static String sPackageUnarmoredCharCert(String string, boolean bl) throws IOException {
        String string2 = string;
        boolean bl2 = bl;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            void makeLines;
            String charCert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            StringBuffer armored = null;
            Matcher m = NOT_B64_DIGIT_PATTERN.matcher(charCert = charCert.replaceAll("\n", ""));
            if (m.find()) {
                throw new IllegalArgumentException("invalid base64 data");
            }
            if (makeLines != false) {
                charCert = DfUtil.makeLines(charCert, 64);
            }
            armored = new StringBuffer(2000);
            armored.append(START_ARMOR);
            armored.append('\n');
            armored.append(charCert.toCharArray());
            if (!charCert.endsWith("\n")) {
                armored.append('\n');
            }
            armored.append(END_ARMOR);
            String string5 = string4 = (string3 = armored.toString());
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static X509Certificate sBuildCertObject(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2;
            X509Certificate x509Certificate3;
            String pemCert;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            CertificateFactory cf = null;
            X509Certificate javaCert = null;
            if (null == pemCert || 0 == pemCert.length()) {
                x509Certificate2 = x509Certificate3 = null;
            } else {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(pemCert.getBytes());
                    cf = CertificateFactory.getInstance("X.509");
                    javaCert = (X509Certificate)cf.generateCertificate(bais);
                }
                catch (CertificateException ex) {
                    throw new DfException(ex);
                }
                x509Certificate2 = x509Certificate3 = javaCert;
            }
            X509Certificate x509Certificate4 = x509Certificate = x509Certificate2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(x509Certificate, joinPoint);
            }
            return x509Certificate3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String[] sValidateValueAndExtractNameAndKeyType(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String[] stringArray;
            X500Principal subject;
            String rawValue;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == rawValue || 0 == rawValue.length()) {
                throw new IllegalArgumentException("certificate data may not be empty");
            }
            int armorIx = rawValue.indexOf(START_ARMOR);
            if (-1 != armorIx && 0 != armorIx) {
                rawValue = rawValue.substring(armorIx);
                armorIx = rawValue.indexOf(START_ARMOR);
            }
            if (0 == armorIx) {
                int dataStartIx = START_ARMOR.length();
                armorIx = rawValue.indexOf(END_ARMOR);
                if (-1 < armorIx && !rawValue.endsWith(END_ARMOR)) {
                    rawValue = rawValue.substring(0, armorIx + END_ARMOR.length());
                }
                if (!rawValue.endsWith(END_ARMOR)) throw new IllegalArgumentException("malformed PEM armor");
                int dataEndIx = armorIx;
                String nakedData = rawValue.substring(dataStartIx, dataEndIx).replaceAll("\n", "");
                if (null == nakedData || 0 == nakedData.length()) {
                    throw new IllegalArgumentException("certificate data may not be empty");
                }
                if (nakedData.matches(NOT_B64_DIGIT_REGEX)) {
                    throw new IllegalArgumentException("certificate data must be Base64 encoded");
                }
            } else {
                if (-1 < rawValue.indexOf(END_ARMOR)) {
                    throw new IllegalArgumentException("malformed PEM armor");
                }
                try {
                    rawValue = PublicKeyCertificate.sPackageUnarmoredCharCert(rawValue, true);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(rawValue.getBytes()));
                subject = cert.getSubjectX500Principal();
            }
            catch (CertificateException e) {
                DfLogger.error(PublicKeyCertificate.class, "raw value prior to exception:{0}{1}", new Object[]{"\n", rawValue}, (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            SimplifiedX500DN dn = new SimplifiedX500DN(subject.getName());
            String commonName = dn.getValueForAttribute("CN");
            assert (null != commonName && 0 < commonName.length());
            if (commonName.matches(NOT_OBJECTNAME_REGEX)) {
                throw new IllegalArgumentException("illegal chars in object name for certificate persistent record");
            }
            String[] stringArray2 = new String[]{rawValue, commonName, PublicKeyCertificate.getKeyTypeFromCommonName(commonName)};
            String[] stringArray3 = stringArray = stringArray2;
            if (!BaseTracingAspect.ajc$if_0()) return stringArray2;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)string2);
            }
            tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(stringArray, joinPoint);
            return stringArray2;
        }
        catch (Throwable throwable) {
            if (!BaseTracingAspect.ajc$if_0()) throw throwable;
            TracingAspect tracingAspect = TracingAspect.aspectOf();
            if (joinPoint == null) {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)string2);
            }
            tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            throw throwable;
        }
    }

    protected static String getKeyTypeFromPrefix(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String cnPrefix;
            String string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            String string5 = string4 = null == cnPrefix || 0 == cnPrefix.length() ? (string3 = IPublicKeyCertificate.KEY_TYPE_UNKNOWN.toString()) : (s_keyTypeMap.containsKey(cnPrefix) ? (string3 = s_keyTypeMap.get(cnPrefix)) : (string3 = IPublicKeyCertificate.KEY_TYPE_UNKNOWN.toString()));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string4, joinPoint);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    protected static String getKeyTypeFromCommonName(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String string3;
            String string4;
            String string5;
            String commonName;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            if (null == commonName || 0 == commonName.length()) {
                string4 = string5 = IPublicKeyCertificate.KEY_TYPE_UNKNOWN.toString();
            } else {
                String keyType;
                String[] prefixId = commonName.split(new String(new char[]{'_'}));
                string4 = string5 = (keyType = PublicKeyCertificate.getKeyTypeFromPrefix(prefixId[0]));
            }
            String string6 = string3 = string4;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(string3, joinPoint);
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PublicKeyCertificate.java", Class.forName("com.documentum.fc.client.privilege.impl.PublicKeyCertificate"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKeyType", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "int"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKeyIdentifier", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 62);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "packageUnarmoredCharCert", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "charCert:", "", "java.lang.String"), 146);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "sPackageUnarmoredCharCert", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:boolean:", "charCert:makeLines:", "java.io.IOException:", "java.lang.String"), 170);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "sBuildCertObject", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "pemCert:", "com.documentum.fc.common.DfException:", "java.security.cert.X509Certificate"), 189);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "sValidateValueAndExtractNameAndKeyType", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "rawValue:", "", "[Ljava.lang.String;"), 277);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getKeyTypeFromPrefix", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "cnPrefix:", "", "java.lang.String"), 373);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "getKeyTypeFromCommonName", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "commonName:", "", "java.lang.String"), 384);
        ajc$tjp_16 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", ""), 245);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrivateKeyIdentifier", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCertificateValue", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 72);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPemCertificate", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "java.lang.String"), 77);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCertificate", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "", "", "com.documentum.fc.common.DfException:", "java.security.cert.X509Certificate"), 104);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKeyIdentifier", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "kId:", "com.documentum.fc.common.DfException:", "void"), 109);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPrivateKeyIdentifier", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "pkId:", "com.documentum.fc.common.DfException:", "void"), 115);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCertificate", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.security.cert.X509Certificate:", "cert:", "com.documentum.fc.common.DfException:", "void"), 121);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCertificateValue", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate", "java.lang.String:", "certificateData:", "com.documentum.fc.common.DfException:", "void"), 139);
        NOT_B64_DIGIT_PATTERN = Pattern.compile(NOT_B64_DIGIT_REGEX);
        s_keyTypeMap = new HashMap<String, String>(IDfAuthenticationInfo.AuthenticationType.values().length);
        s_keyTypeMap.put("dfc_".substring(0, "dfc_".length() - 1), IPublicKeyCertificate.KEY_TYPE_DFC.toString());
        s_keyTypeMap.put("bocs_".substring(0, "bocs_".length() - 1), IPublicKeyCertificate.KEY_TYPE_BOCS.toString());
        s_keyTypeMap.put("acs_".substring(0, "acs_".length() - 1), IPublicKeyCertificate.KEY_TYPE_ACS.toString());
        s_handlerMap = new HashMap<String, IDfAttributeHandler>();
        s_handlerMap.put(FN_CERTIFICATE_VALUE, new CertificateValueHandler(null));
        s_handlerMap.put(FNS_OBJECT_NAME, new ObjectNameHandler(null));
        s_handlerMap.put(FN_KEY_TYPE, new KeyTypeHandler(null));
    }

    static class 1 {
    }

    private static class KeyTypeHandler
    extends DfAbstractAttributeFilter {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private KeyTypeHandler() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void set(IDfTypedObject iDfTypedObject, String string, int n, String string2) throws DfException {
            IDfTypedObject iDfTypedObject2 = iDfTypedObject;
            String string3 = string;
            int n2 = n;
            String string4 = string2;
            JoinPoint joinPoint = null;
            try {
                void valueIndex;
                void attributeName;
                void object;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                X509Certificate cert = null;
                try {
                    cert = ((PublicKeyCertificate)object).getCertificate();
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException(ex);
                }
                assert (cert != null);
                X500Principal principal = cert.getSubjectX500Principal();
                SimplifiedX500DN dn = new SimplifiedX500DN(principal.getName());
                String commonName = dn.getValueForAttribute("CN");
                super.set((IDfTypedObject)object, (String)attributeName, (int)valueIndex, PublicKeyCertificate.getKeyTypeFromCommonName(commonName));
                Object var16_16 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var16_16, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ KeyTypeHandler(1 x0) {
            KeyTypeHandler keyTypeHandler = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PublicKeyCertificate.java", Class.forName("com.documentum.fc.client.privilege.impl.PublicKeyCertificate$KeyTypeHandler"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "set", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$KeyTypeHandler", "com.documentum.fc.client.IDfTypedObject:java.lang.String:int:java.lang.String:", "object:attributeName:valueIndex:value:", "com.documentum.fc.common.DfException:", "void"), 254);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$KeyTypeHandler", "", "", ""), 245);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$KeyTypeHandler", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$1:", "x0:", ""), 245);
        }
    }

    private static class CertificateValueHandler
    extends DfAbstractAttributeFilter {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private CertificateValueHandler() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void set(IDfTypedObject iDfTypedObject, String string, int n, String string2) throws DfException {
            IDfTypedObject iDfTypedObject2 = iDfTypedObject;
            String string3 = string;
            int n2 = n;
            String string4 = string2;
            JoinPoint joinPoint = null;
            try {
                void valueIndex;
                void attributeName;
                void object;
                void value;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                String[] valueNameKey = PublicKeyCertificate.sValidateValueAndExtractNameAndKeyType((String)value);
                assert (3 == valueNameKey.length && null != valueNameKey[0] && null != valueNameKey[1] && null != valueNameKey[2]);
                super.set((IDfTypedObject)object, (String)attributeName, (int)valueIndex, valueNameKey[0]);
                object.setString(PublicKeyCertificate.FN_KEY_TYPE, "dummy");
                DfLogger.info((Object)object, "stored certificate for CN ", new Object[]{valueNameKey[1]}, null);
                Object var13_12 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var13_12, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ CertificateValueHandler(1 x0) {
            CertificateValueHandler certificateValueHandler = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PublicKeyCertificate.java", Class.forName("com.documentum.fc.client.privilege.impl.PublicKeyCertificate$CertificateValueHandler"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "set", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$CertificateValueHandler", "com.documentum.fc.client.IDfTypedObject:java.lang.String:int:java.lang.String:", "object:attributeName:valueIndex:value:", "com.documentum.fc.common.DfException:", "void"), 225);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$CertificateValueHandler", "", "", ""), 221);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$CertificateValueHandler", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$1:", "x0:", ""), 221);
        }
    }

    private static class ObjectNameHandler
    extends DfAbstractAttributeFilter {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private ObjectNameHandler() {
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void set(IDfTypedObject iDfTypedObject, String string, int n, String string2) throws DfException {
            IDfTypedObject iDfTypedObject2 = iDfTypedObject;
            String string3 = string;
            int n2 = n;
            String string4 = string2;
            JoinPoint joinPoint = null;
            try {
                void valueIndex;
                void attributeName;
                void object;
                void value;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (null == value || 0 == value.length()) {
                    throw new IllegalArgumentException("object name may not be empty");
                }
                if (value.matches(PublicKeyCertificate.NOT_OBJECTNAME_REGEX)) {
                    throw new IllegalArgumentException("illegal chars in object name for certificate persistent record");
                }
                super.set((IDfTypedObject)object, (String)attributeName, (int)valueIndex, (String)value);
                Object var12_11 = null;
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(var12_11, joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        Object[] objectArray = new Object[]{iDfTypedObject2, string3, Conversions.intObject((int)n2), string4};
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        /* synthetic */ ObjectNameHandler(1 x0) {
            ObjectNameHandler objectNameHandler = this;
            1 var4_3 = x0;
            JoinPoint joinPoint = null;
            try {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
                }
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BaseTracingAspect.ajc$if_0()) {
                    TracingAspect tracingAspect = TracingAspect.aspectOf();
                    if (joinPoint == null) {
                        joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)var4_3);
                    }
                    tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
                }
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PublicKeyCertificate.java", Class.forName("com.documentum.fc.client.privilege.impl.PublicKeyCertificate$ObjectNameHandler"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "set", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$ObjectNameHandler", "com.documentum.fc.client.IDfTypedObject:java.lang.String:int:java.lang.String:", "object:attributeName:valueIndex:value:", "com.documentum.fc.common.DfException:", "void"), 211);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$ObjectNameHandler", "", "", ""), 207);
            ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$ObjectNameHandler", "com.documentum.fc.client.privilege.impl.PublicKeyCertificate$1:", "x0:", ""), 207);
        }
    }
}

