/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.internal.bof.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static Element createElementWithText(Document doc, String tagName, String text) {
        Element retval = doc.createElement(tagName);
        retval.appendChild(doc.createTextNode(text == null ? "" : text));
        return retval;
    }

    public static String getNodeValue(Node node) {
        String value = null;
        Node elem = node.getFirstChild();
        if (elem != null && (value = node.getFirstChild().getNodeValue()) != null) {
            value = value.trim();
        }
        return value;
    }

    public static String getAttributeValue(Node node, String attrName) {
        Node attrNode;
        String attrValue = null;
        NamedNodeMap nodeMap = node.getAttributes();
        if (nodeMap != null && (attrNode = nodeMap.getNamedItem(attrName)) != null) {
            attrValue = attrNode.getNodeValue().trim();
        }
        return attrValue;
    }

    public static boolean getAttributeValueAsBoolean(NamedNodeMap attributes, String attrName) {
        return Boolean.valueOf(XMLUtils.getAttributeValue(attributes, attrName));
    }

    public static long getAttributeValueAsLong(NamedNodeMap attributes, String attrName) {
        return Long.parseLong(XMLUtils.getAttributeValue(attributes, attrName));
    }

    public static String getAttributeValue(NamedNodeMap attributes, String attrName) {
        return attributes.getNamedItem(attrName).getNodeValue().trim();
    }

    public static void setAttributeValue(NamedNodeMap attributes, String attrName, String value) {
        attributes.getNamedItem(attrName).setNodeValue(value);
    }

    public static Node getFirstElementByTagName(Element parentElement, String elementName) {
        return XMLUtils.getNodeList(parentElement, elementName).item(0);
    }

    public static NodeList getNodeList(Node parentNode, String elementName) {
        return ((Element)parentNode).getElementsByTagName(elementName);
    }
}

