/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueHolder
implements Externalizable {
    private Object m_value;
    private BitSet m_modifiedIndexes;
    private boolean m_modified;
    private boolean m_validated;
    private static final long serialVersionUID = 3909555658483711941L;

    public ValueHolder() {
        this.m_value = null;
        this.m_modified = false;
        this.m_validated = false;
        this.m_modifiedIndexes = null;
    }

    ValueHolder(ValueHolder rhs) {
        this.m_modified = rhs.m_modified;
        this.m_validated = rhs.m_validated;
        if (rhs.m_modifiedIndexes != null) {
            this.m_modifiedIndexes = (BitSet)rhs.m_modifiedIndexes.clone();
        }
        this.m_value = rhs.m_value != null && rhs.m_value instanceof List ? new ArrayList((List)rhs.m_value) : rhs.m_value;
    }

    public List<String> getList() {
        if (this.m_value == null) {
            this.m_value = new ArrayList();
        }
        return (List)this.m_value;
    }

    public String getString() {
        return (String)this.m_value;
    }

    public void setList(List<String> valueList) {
        this.m_value = valueList;
    }

    public void setString(String value) {
        this.m_value = value;
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void setModified(boolean modified) {
        this.setModified(modified, false);
    }

    public void setModified(boolean modified, boolean indicesToo) {
        this.m_modified = modified;
        if (modified) {
            this.m_validated = false;
            if (indicesToo && this.m_value instanceof List) {
                int limit = this.getList().size();
                for (int i = 0; i < limit; ++i) {
                    this.addModifiedIndex(i);
                }
            }
        } else {
            this.m_modifiedIndexes = null;
        }
    }

    public boolean isValidated() {
        return this.m_validated;
    }

    public void setValidated(boolean validated) {
        this.m_validated = validated;
    }

    public void addModifiedIndex(int index) {
        this.m_modified = true;
        this.m_validated = false;
        if (this.m_modifiedIndexes == null) {
            this.m_modifiedIndexes = new BitSet();
        }
        this.m_modifiedIndexes.set(index);
    }

    public void removeModifiedIndex(int index) {
        if (this.m_modifiedIndexes == null) {
            return;
        }
        this.m_modifiedIndexes.clear(index);
    }

    public void removeAllModifiedIndexes() {
        this.m_modifiedIndexes = null;
    }

    public List<Integer> getModifiedIndexes() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.m_modifiedIndexes != null) {
            int i = this.m_modifiedIndexes.nextSetBit(0);
            while (i >= 0) {
                result.add(i);
                i = this.m_modifiedIndexes.nextSetBit(i + 1);
            }
        }
        return result;
    }

    public String toString() {
        return "ValueHolder {value=" + this.m_value + ", modified=" + this.m_modified + ", validated=" + this.m_validated + ", modifiedIndexes=" + this.m_modifiedIndexes + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ValueHolder)) {
            return false;
        }
        ValueHolder that = (ValueHolder)o;
        if (this.isValueEmpty()) {
            return that.isValueEmpty();
        }
        return this.m_value.equals(that.m_value);
    }

    private boolean isValueEmpty() {
        if (this.m_value == null) {
            return true;
        }
        return this.m_value instanceof List && ((List)this.m_value).size() == 0;
    }

    public int hashCode() {
        int result = 44;
        result = 37 * result + (this.m_value != null ? this.m_value.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_value = objectInput.readObject();
    }
}

