/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.ValueLengthException;
import com.documentum.fc.common.IDfAttr;
import com.documentum.fc.impl.util.UTF8Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Attribute
implements IDfAttr,
Externalizable {
    private int m_index;
    private int m_length;
    private String m_name;
    private String m_id;
    private boolean m_repeating;
    private int m_dataType;
    private boolean m_local;
    private int m_restriction;
    private boolean m_isAspectAttr;

    public Attribute() {
    }

    public Attribute(int index, String name, String attrId, boolean repeating, int type, int length, int restriction) {
        this(index, name, repeating, type, length);
        this.m_id = attrId;
        this.m_restriction = restriction;
    }

    public Attribute(int index, String name, boolean repeating, int type, int length) {
        this(name, repeating, type, length);
        this.m_index = index;
    }

    public Attribute(String name, boolean repeating, int type, int length) {
        assert (name != null);
        this.m_index = -1;
        this.m_name = name;
        this.m_repeating = repeating;
        this.m_dataType = type;
        this.m_length = type == 2 ? length : 0;
        this.m_restriction = 0;
        this.m_isAspectAttr = false;
    }

    public Attribute(String name, boolean repeating, int type) {
        this(name, repeating, type, 0);
    }

    public Attribute(Attribute that) {
        this.m_index = that.m_index;
        this.m_name = that.m_name;
        this.m_id = that.m_id;
        this.m_repeating = that.m_repeating;
        this.m_dataType = that.m_dataType;
        this.m_length = that.m_length;
        this.m_restriction = that.m_restriction;
        this.m_isAspectAttr = that.m_isAspectAttr;
    }

    public final int getIndex() {
        return this.m_index;
    }

    final void setIndex(int index) {
        this.m_index = index;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setLocal(boolean local) {
        this.m_local = local;
    }

    public final boolean isLocal() {
        return this.m_local;
    }

    public final boolean isRepeating() {
        return this.m_repeating;
    }

    public final void setRepeating(boolean repeating) {
        this.m_repeating = repeating;
    }

    public final int getDataType() {
        return this.m_dataType;
    }

    public final int getLength() {
        return this.m_length;
    }

    public final int getAllowedLength(String value) {
        if (this.getLength() == 0) {
            return Integer.MAX_VALUE;
        }
        return UTF8Util.calculateMaximumAllowedChars(value, this.getLength());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Attribute)) {
            return false;
        }
        Attribute that = (Attribute)o;
        if (this.m_index != that.m_index) {
            return false;
        }
        if (this.m_length != that.m_length) {
            return false;
        }
        if (this.m_repeating != that.m_repeating) {
            return false;
        }
        if (this.m_dataType != that.m_dataType) {
            return false;
        }
        if (!this.m_name.equals(that.m_name)) {
            return false;
        }
        if (this.m_id != null ? !this.m_id.equals(that.m_id) : that.m_id != null) {
            return false;
        }
        if (this.m_restriction != that.m_restriction) {
            return false;
        }
        return this.m_isAspectAttr == that.m_isAspectAttr;
    }

    public int hashCode() {
        int result = 43;
        result = 37 * result + this.m_index;
        result = 37 * result + this.m_length;
        result = 37 * result + (this.m_repeating ? 0 : 1);
        result = 37 * result + this.m_dataType;
        result = 37 * result + this.m_name.hashCode();
        result = 37 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 37 * result + this.m_restriction;
        result = 37 * result + (this.m_isAspectAttr ? 0 : 1);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + " {" + "name='" + this.m_name + "'" + ", attrId ='" + this.m_id + "'" + ", index='" + this.m_index + "'" + ", repeating='" + this.m_repeating + "'" + ", dataType='" + Attribute.getDataTypeString(this.m_dataType) + "'" + ", length='" + this.m_length + "'" + ", restriction='" + this.m_restriction + "'" + ", aspectAttr='" + this.m_isAspectAttr + "'" + "}";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.m_index);
        objectOutput.writeInt(this.m_length);
        objectOutput.writeInt(this.m_dataType);
        objectOutput.writeObject(this.m_name);
        objectOutput.writeBoolean(this.m_repeating);
        objectOutput.writeObject(this.m_id);
        objectOutput.writeInt(this.m_restriction);
        objectOutput.writeBoolean(this.m_isAspectAttr);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_index = objectInput.readInt();
        this.m_length = objectInput.readInt();
        this.m_dataType = objectInput.readInt();
        this.m_name = (String)objectInput.readObject();
        this.m_repeating = objectInput.readBoolean();
        this.m_id = (String)objectInput.readObject();
        this.m_restriction = objectInput.readInt();
        this.m_isAspectAttr = objectInput.readBoolean();
    }

    public static String getDataTypeString(int dataType) {
        switch (dataType) {
            case 0: {
                return "BOOLEAN";
            }
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "STRING";
            }
            case 3: {
                return "ID";
            }
            case 4: {
                return "TIME";
            }
            case 5: {
                return "DOUBLE";
            }
            case 6: {
                return "UNDEFINED";
            }
        }
        return "UNKNOWN";
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isQualifiable() {
        return (this.m_restriction & 1) == 0;
    }

    public void setRestriction(int restriction) {
        this.m_restriction = restriction;
    }

    public boolean isAspectAttr() {
        return this.m_isAspectAttr;
    }

    public void setAspectAttr(boolean aspectAttr) {
        this.m_isAspectAttr = aspectAttr;
    }

    public String getAspectName() {
        if (this.m_isAspectAttr) {
            return this.m_name.substring(0, this.m_name.indexOf(46));
        }
        return null;
    }

    public void validateValueLength(String value) {
        if (this.getLength() > 0 && value.length() > this.getAllowedLength(value)) {
            throw new ValueLengthException(this.getName(), UTF8Util.calculateEncodedLength(value), this.getLength());
        }
    }
}

