/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.AbstractTypedData;
import com.documentum.fc.client.impl.typeddata.AggregateLiteType;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateTypedData
extends AbstractTypedData
implements ITypedData {
    private ITypedData m_childTypedData;
    private ITypedData m_parentTypedData;
    private static final long serialVersionUID = 5978699260696491993L;
    private IDfId m_parentId;

    public AggregateTypedData() {
        this(null, null, DfId.DF_NULLID, true);
    }

    public AggregateTypedData(AggregateLiteType type, ITypedData parentData, IDfId id, boolean bPreserveModificationStatus) {
        this(type, parentData, type == null ? null : new TypedData(type.getChildType(), id), bPreserveModificationStatus);
    }

    public AggregateTypedData(AggregateLiteType type, ITypedData parentData, ITypedData childData, boolean bPreserveModificationStatus) {
        super(type, childData == null ? null : childData.getObjectId());
        this.m_childTypedData = childData == null ? new TypedData(type.getChildType(), null) : childData;
        this.reparent(parentData);
        if (!bPreserveModificationStatus) {
            this.setModifiedIfExist(false);
        }
    }

    private void setModifiedIfExist(boolean bModified) {
        int attrCount = this.getAttrCount();
        for (int i = 0; i < attrCount; ++i) {
            if (this.isMissing(i)) continue;
            this.setModified(i, bModified);
        }
    }

    public void reparent(ITypedData parentData) {
        AggregateLiteType origAggType = (AggregateLiteType)this.getType();
        if (parentData != null) {
            this.m_parentTypedData = parentData;
            this.m_childTypedData.setId("i_sharing_parent", parentData.getObjectId());
            this.m_parentId = parentData.getObjectId();
            if (!parentData.getType().equals(origAggType.getParentType())) {
                AggregateLiteType newParentType = (AggregateLiteType)origAggType.clone();
                newParentType.reparentType(parentData.getType());
                this.replaceType(newParentType);
            }
        } else {
            this.m_parentTypedData = new TypedData(origAggType.getParentType(), this.getObjectId());
            this.m_childTypedData.setId("i_sharing_parent", this.getObjectId());
            this.m_parentId = this.getObjectId();
        }
    }

    public AggregateTypedData getMaterializedData() {
        AggregateTypedData copy = (AggregateTypedData)super.clone();
        copy.m_childTypedData = (ITypedData)this.m_childTypedData.clone();
        ITypedData newParentTypedData = (ITypedData)this.m_parentTypedData.clone();
        newParentTypedData.setReadOnly(false);
        newParentTypedData.setObjectId(this.getObjectId());
        copy.reparent(newParentTypedData);
        copy.setReadOnly(false);
        return copy;
    }

    @Override
    public synchronized Object clone() {
        AggregateTypedData copy = (AggregateTypedData)super.clone();
        copy.m_childTypedData = (ITypedData)this.m_childTypedData.clone();
        copy.m_parentTypedData = this.isParentShared() ? this.m_parentTypedData : (ITypedData)this.m_parentTypedData.clone();
        return copy;
    }

    private ITypedData getTypedData(int index) {
        if (!this.getAggregateType().isChildAttribute(index)) {
            return this.m_parentTypedData;
        }
        return this.m_childTypedData;
    }

    private AggregateLiteType getAggregateType() {
        return (AggregateLiteType)this.getType();
    }

    public boolean isParentAttribute(int index) {
        return this.getAggregateType().isParentAttribute(index);
    }

    public boolean isChildAttribute(int index) {
        return this.getAggregateType().isChildAttribute(index);
    }

    public boolean isParentAttribute(String attrName) {
        return this.isParentAttribute(this.getAttrIndex(attrName));
    }

    public boolean isChildAttribute(String attrName) {
        return this.isChildAttribute(this.getAttrIndex(attrName));
    }

    private boolean isParentShared() {
        return !this.m_parentId.isNull() && !((Object)this.getObjectId()).equals(this.m_parentId);
    }

    private int getRawIndex(int aggIndex) {
        return this.getAggregateType().getRawIndex(aggIndex);
    }

    @Override
    public int getValueCount(int index) {
        return this.getTypedData(index).getValueCount(this.getRawIndex(index));
    }

    @Override
    public String get(int index) {
        return this.getTypedData(index).get(this.getRawIndex(index));
    }

    @Override
    public final String getRepeating(int index, int valueIndex) {
        return this.getTypedData(index).getRepeating(this.getRawIndex(index), valueIndex);
    }

    @Override
    public final void set(int index, String value) {
        this.verifyWritability(index);
        this.getTypedData(index).set(this.getRawIndex(index), value);
    }

    @Override
    public void setRepeating(int index, int valueIndex, String value) {
        this.verifyWritability(index);
        this.getTypedData(index).setRepeating(this.getRawIndex(index), valueIndex, value);
    }

    @Override
    public void append(int index, String value) {
        this.verifyWritability(index);
        this.getTypedData(index).append(this.getRawIndex(index), value);
    }

    @Override
    public void insert(int index, int valueIndex, String value) {
        this.verifyWritability(index);
        this.getTypedData(index).insert(this.getRawIndex(index), valueIndex, value);
    }

    @Override
    public void remove(int index, int valueIndex) {
        this.verifyWritability(index);
        this.getTypedData(index).remove(this.getRawIndex(index), valueIndex);
    }

    @Override
    public void removeAll(int index) {
        this.verifyWritability(index);
        this.getTypedData(index).removeAll(this.getRawIndex(index));
    }

    @Override
    public int find(int index, String value) {
        return this.getTypedData(index).find(this.getRawIndex(index), value);
    }

    @Override
    public void addAttr(Attribute attribute) {
        this.verifyWritability();
        AggregateLiteType type = (AggregateLiteType)this.getType();
        this.getChildTypedData().addAttr(attribute);
        ILiteType parentType = type.getParentType();
        ILiteType childType = this.getChildTypedData().getType();
        AggregateLiteType superType = (AggregateLiteType)type.getSuperType();
        this.replaceType(new AggregateLiteType(parentType, childType, superType));
    }

    private boolean isReadOnly(int index) {
        return this.isReadOnly() || this.isParentAttribute(index) && this.isParentShared();
    }

    @Override
    public final boolean isMissing(int index) {
        return this.getTypedData(index).isMissing(this.getRawIndex(index));
    }

    @Override
    public final boolean isModified(int index) {
        if (this.isChildAttribute(index) || !this.isParentShared()) {
            return this.getTypedData(index).isModified(this.getRawIndex(index));
        }
        return false;
    }

    @Override
    public void setModified(int index, boolean modified) {
        if (!this.isParentAttribute(index) || !this.isParentShared()) {
            this.getTypedData(index).setModified(this.getRawIndex(index), modified);
        }
    }

    @Override
    public List<Integer> getModifiedIndexes(int index) {
        return this.getTypedData(index).getModifiedIndexes(this.getRawIndex(index));
    }

    @Override
    public final boolean isValidated(int index) {
        if (this.isChildAttribute(index) || !this.isParentShared()) {
            return this.getTypedData(index).isValidated(this.getRawIndex(index));
        }
        return false;
    }

    @Override
    public final void setValidated(int index, boolean validated) {
        if (!this.isParentAttribute(index) || !this.isParentShared()) {
            this.getTypedData(index).setValidated(this.getRawIndex(index), validated);
        }
    }

    @Override
    public final boolean isModifiedButNotValidated(int index) {
        return this.getTypedData(index).isModifiedButNotValidated(this.getRawIndex(index));
    }

    @Override
    protected String getTraceStringDetails(boolean verbose) {
        StringBuilder sb = new StringBuilder(super.getTraceStringDetails(verbose));
        if (verbose) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("child=").append(this.m_childTypedData);
            sb.append(", parent=").append(this.m_parentTypedData);
        }
        return sb.toString();
    }

    ITypedData getChildTypedData() {
        return this.m_childTypedData;
    }

    public ITypedData getParentTypedData() {
        return this.m_parentTypedData;
    }

    private void verifyWritability(int index) {
        if (this.isReadOnly(index)) {
            throw new UnsupportedOperationException("data is read-only");
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.m_childTypedData = (ITypedData)objectInput.readObject();
        this.m_parentTypedData = (ITypedData)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.m_childTypedData);
        objectOutput.writeObject(this.m_parentTypedData);
    }

    public boolean isParentModified() {
        return this.m_parentTypedData.isModified();
    }
}

