/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.typeddata;

import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.client.impl.typeddata.ExtendedLiteType;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.LiteType;
import com.documentum.fc.client.impl.typeddata.NoSuchAttributeException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.IDfId;
import com.documentum.fc.common.IDfTime;
import com.documentum.fc.impl.util.StringUtil;
import com.documentum.fc.tracing.ITraceString;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypedData
implements Externalizable,
Cloneable,
ITypedData,
ITraceString {
    private IDfId m_id;
    private ILiteType m_type;
    private long m_fetchTimestamp;
    private boolean m_readOnly;
    private boolean m_autoFill;
    private static final long serialVersionUID = -3504528089725927331L;

    protected AbstractTypedData(ILiteType type, IDfId id) {
        this.m_id = id != null ? id : DfId.DF_NULLID;
        this.m_readOnly = false;
        this.m_autoFill = true;
        if (type != null) {
            this.m_type = type;
            this.m_type.setReadOnly(true);
        } else {
            this.m_type = new LiteType();
        }
    }

    @Override
    public abstract int getValueCount(int var1);

    @Override
    public abstract String get(int var1);

    @Override
    public abstract String getRepeating(int var1, int var2);

    @Override
    public abstract boolean isMissing(int var1);

    @Override
    public abstract boolean isValidated(int var1);

    @Override
    public abstract boolean isModified(int var1);

    @Override
    public abstract boolean isModifiedButNotValidated(int var1);

    @Override
    public abstract List<Integer> getModifiedIndexes(int var1);

    @Override
    public abstract int find(int var1, String var2);

    @Override
    public abstract void set(int var1, String var2);

    @Override
    public abstract void setRepeating(int var1, int var2, String var3);

    @Override
    public abstract void append(int var1, String var2);

    @Override
    public abstract void insert(int var1, int var2, String var3);

    @Override
    public abstract void remove(int var1, int var2);

    @Override
    public abstract void removeAll(int var1);

    @Override
    public abstract void setModified(int var1, boolean var2);

    @Override
    public abstract void setValidated(int var1, boolean var2);

    @Override
    public final IDfId getObjectId() {
        return this.m_id;
    }

    @Override
    public final void setObjectId(IDfId id) {
        this.m_id = id != null ? id : DfId.DF_NULLID;
    }

    @Override
    public final boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public final void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    @Override
    public final long getFetchTimestamp() {
        return this.m_fetchTimestamp;
    }

    @Override
    public final void setFetchTimestamp(long fetchTimestamp) {
        this.m_fetchTimestamp = fetchTimestamp;
    }

    @Override
    public final boolean isAutoFill() {
        return this.m_autoFill;
    }

    @Override
    public final void setAutoFill(boolean autoFill) {
        this.m_autoFill = autoFill;
    }

    @Override
    public synchronized Object clone() {
        try {
            this.getType().setReadOnly(true);
            return (ITypedData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen since clone is implemented");
        }
    }

    @Override
    public final int getValueCount(String name) {
        return this.getValueCount(this.getAttrIndex(name));
    }

    private String get(String attributeName) {
        return this.get(this.getAttrIndex(attributeName));
    }

    @Override
    public final boolean getBoolean(String name) {
        return DataConverter.convertToBoolean(this.get(name));
    }

    @Override
    public final double getDouble(String name) {
        return DataConverter.convertToDouble(this.get(name));
    }

    @Override
    public final IDfId getId(String name) {
        return DataConverter.convertToId(this.get(name));
    }

    @Override
    public final int getInt(String name) {
        return DataConverter.convertToInt(this.get(name));
    }

    @Override
    public final long getLong(String name) {
        return DataConverter.convertToLong(this.get(name));
    }

    @Override
    public final String getString(String name) {
        return DataConverter.convertToString(this.get(name));
    }

    @Override
    public final IDfTime getTime(String name) {
        return DataConverter.convertToTime(this.get(name));
    }

    @Override
    public final Object getObject(String name) {
        switch (this.getType().getAttr(name).getDataType()) {
            case 0: {
                return this.getBoolean(name);
            }
            case 5: {
                return this.getDouble(name);
            }
            case 3: {
                return this.getId(name);
            }
            case 1: {
                return this.getInt(name);
            }
            case 4: {
                return this.getTime(name);
            }
        }
        return this.getString(name);
    }

    private String getRepeating(String attributeName, int valueIndex) {
        return this.getRepeating(this.getAttrIndex(attributeName), valueIndex);
    }

    @Override
    public final boolean getRepeatingBoolean(String name, int valueIndex) {
        return DataConverter.convertToBoolean(this.getRepeating(name, valueIndex));
    }

    @Override
    public final double getRepeatingDouble(String name, int valueIndex) {
        return DataConverter.convertToDouble(this.getRepeating(name, valueIndex));
    }

    @Override
    public final IDfId getRepeatingId(String name, int valueIndex) {
        return DataConverter.convertToId(this.getRepeating(name, valueIndex));
    }

    @Override
    public final int getRepeatingInt(String name, int valueIndex) {
        return DataConverter.convertToInt(this.getRepeating(name, valueIndex));
    }

    @Override
    public final long getRepeatingLong(String name, int valueIndex) {
        return DataConverter.convertToLong(this.getRepeating(name, valueIndex));
    }

    @Override
    public final String getRepeatingString(String name, int valueIndex) {
        return DataConverter.convertToString(this.getRepeating(name, valueIndex));
    }

    @Override
    public final IDfTime getRepeatingTime(String name, int valueIndex) {
        return DataConverter.convertToTime(this.getRepeating(name, valueIndex));
    }

    @Override
    public void setBoolean(String name, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setDouble(String name, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setId(String name, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setInt(String name, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setLong(String name, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setTime(String name, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            this.set(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.setString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setString(String name, String value) {
        Attribute attribute = this.getType().getAttr(name);
        this.set(attribute.getIndex(), this.validateAndConvertIfNecessary(attribute, value));
    }

    private String validateAndConvertIfNecessary(Attribute attribute, String value) {
        if (value != null && value.startsWith("%")) {
            return value;
        }
        switch (attribute.getDataType()) {
            case 0: {
                return DataConverter.convertToString(DataConverter.convertToBoolean(value));
            }
            case 5: {
                if (StringUtil.isEmptyOrNull(value)) {
                    return "0";
                }
                DataConverter.convertToDouble(value);
                return value;
            }
            case 3: {
                return DataConverter.convertToString(DataConverter.convertToId(value));
            }
            case 1: {
                if (StringUtil.isEmptyOrNull(value)) {
                    return "0";
                }
                DataConverter.convertToInt(value);
                return value;
            }
            case 2: {
                value = DataConverter.convertToString(value);
                attribute.validateValueLength(value);
                return value;
            }
            case 4: {
                String dateValue = DataConverter.convertToString(DataConverter.convertToTime(value));
                if (value == null || value.equalsIgnoreCase("now") || value.equalsIgnoreCase("today") || value.equalsIgnoreCase("tomorrow") || value.equalsIgnoreCase("yesterday") || value.equalsIgnoreCase("")) {
                    return dateValue;
                }
                return value;
            }
        }
        return value;
    }

    @Override
    public final void setObject(String name, Object value) {
        if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof IDfId) {
            this.setId(name, (IDfId)value);
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof IDfTime) {
            this.setTime(name, (IDfTime)value);
        } else {
            this.setString(name, value.toString());
        }
    }

    @Override
    public void setRepeatingBoolean(String name, int valueIndex, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingDouble(String name, int valueIndex, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingId(String name, int valueIndex, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingInt(String name, int valueIndex, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingLong(String name, int valueIndex, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingTime(String name, int valueIndex, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            this.setRepeating(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.setRepeatingString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void setRepeatingString(String name, int valueIndex, String value) {
        Attribute attribute = this.getType().getAttr(name);
        this.setRepeating(attribute.getIndex(), valueIndex, this.validateAndConvertIfNecessary(attribute, value));
    }

    @Override
    public void appendBoolean(String name, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendDouble(String name, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendId(String name, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendInt(String name, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendLong(String name, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendTime(String name, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            this.append(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.appendString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public void appendString(String name, String value) {
        Attribute attribute = this.getType().getAttr(name);
        this.append(attribute.getIndex(), this.validateAndConvertIfNecessary(attribute, value));
    }

    @Override
    public void insertBoolean(String name, int valueIndex, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertDouble(String name, int valueIndex, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertId(String name, int valueIndex, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertInt(String name, int valueIndex, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertLong(String name, int valueIndex, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertTime(String name, int valueIndex, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            this.insert(attribute.getIndex(), valueIndex, DataConverter.convertToString(value));
        } else {
            this.insertString(name, valueIndex, DataConverter.convertToString(value));
        }
    }

    @Override
    public void insertString(String name, int valueIndex, String value) {
        Attribute attribute = this.getType().getAttr(name);
        this.insert(attribute.getIndex(), valueIndex, this.validateAndConvertIfNecessary(attribute, value));
    }

    @Override
    public final int findBoolean(String name, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findDouble(String name, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findId(String name, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findInt(String name, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findLong(String name, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findTime(String name, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            return this.find(attribute.getIndex(), DataConverter.convertToString(value));
        }
        return this.findString(name, DataConverter.convertToString(value));
    }

    @Override
    public final int findString(String name, String value) {
        Attribute attribute = this.getType().getAttr(name);
        return this.find(attribute.getIndex(), this.validateAndConvertIfNecessary(attribute, value));
    }

    @Override
    public final void truncate(String name, int valueIndex) throws NoSuchAttributeException {
        this.truncate(this.getAttrIndex(name), valueIndex);
    }

    private void truncate(int index, int valueIndex) throws NoSuchAttributeException {
        for (int i = this.getValueCount(index) - 1; i >= valueIndex; --i) {
            this.remove(index, i);
        }
    }

    @Override
    public final void remove(String name, int valueIndex) {
        this.remove(this.getAttrIndex(name), valueIndex);
    }

    @Override
    public final void removeAll(String name) {
        this.removeAll(this.getAttrIndex(name));
    }

    private void remove(int index, String value) {
        int valueIndex = this.find(index, value);
        if (valueIndex >= 0) {
            this.remove(index, valueIndex);
        }
    }

    @Override
    public final void removeBoolean(String name, boolean value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 0) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeDouble(String name, double value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeId(String name, IDfId value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 3) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeInt(String name, int value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 1) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeLong(String name, long value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 5) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeTime(String name, IDfTime value) {
        Attribute attribute = this.getType().getAttr(name);
        if (attribute.getDataType() == 4) {
            this.remove(attribute.getIndex(), DataConverter.convertToString(value));
        } else {
            this.removeString(name, DataConverter.convertToString(value));
        }
    }

    @Override
    public final void removeString(String name, String value) {
        Attribute attribute = this.getType().getAttr(name);
        this.remove(attribute.getIndex(), this.validateAndConvertIfNecessary(attribute, value));
    }

    @Override
    public final int getAttrCount() {
        return this.getType().getAttrCount();
    }

    @Override
    public final int getAttrIndex(String name) {
        return this.getType().getAttrIndex(name);
    }

    @Override
    public final String getAttrName(int index) {
        return this.getType().getAttrName(index);
    }

    @Override
    public final boolean hasAttr(String name) {
        return this.getType().hasAttr(name);
    }

    protected final boolean isRepeating(int index) {
        return this.getType().getAttr(index).isRepeating();
    }

    @Override
    public final void addAttr(String name, boolean isRepeating, int dataType, int length) {
        this.addAttr(new Attribute(name, isRepeating, dataType, length));
    }

    @Override
    public void addAttr(Attribute attribute) {
        this.verifyWritability();
        this.m_type = this.getExtendedType(this.m_type);
        this.m_type.addAttr(attribute);
    }

    private ILiteType getExtendedType(ILiteType srcType) {
        ILiteType type = srcType;
        if (srcType.isReadOnly()) {
            type = new ExtendedLiteType(srcType);
        }
        return type;
    }

    protected final void verifyWritability() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("data is read-only");
        }
    }

    @Override
    public final ILiteType getType() {
        return this.m_type;
    }

    @Override
    public void setType(ILiteType type) {
        if (this.getAttrCount() != 0) {
            throw new IllegalStateException("Type has already been set");
        }
        this.m_type = type;
        this.m_type.setReadOnly(true);
    }

    protected void replaceType(ILiteType type) {
        this.m_type = type;
    }

    @Override
    public final boolean isMissing(String name) {
        return this.isMissing(this.getAttrIndex(name));
    }

    @Override
    public final synchronized boolean isModified() {
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (!this.isModified(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isModified(String name) {
        return this.isModified(this.getAttrIndex(name));
    }

    @Override
    public final void setModified(boolean modified) {
        this.verifyWritability();
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            this.setModified(i, modified);
        }
    }

    @Override
    public final void setModified(String name, boolean modified) {
        this.verifyWritability();
        this.setModified(this.getAttrIndex(name), modified);
    }

    @Override
    public final List<Integer> getModifiedIndexes(String name) {
        return this.getModifiedIndexes(this.getAttrIndex(name));
    }

    @Override
    public final synchronized boolean isLocalModified() {
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (!this.isModified(i) || !this.getType().getAttr(i).isLocal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean isGlobalModified() {
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (!this.isModified(i) || this.getType().getAttr(i).isLocal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized boolean isValidated() {
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (this.isValidated(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isValidated(String name) {
        return this.isValidated(this.getAttrIndex(name));
    }

    @Override
    public final void setValidated(boolean validated) {
        this.verifyWritability();
        int limit = this.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            this.setValidated(i, validated);
        }
    }

    @Override
    public final void setValidated(String name, boolean validated) {
        this.verifyWritability();
        this.setValidated(this.getAttrIndex(name), validated);
    }

    @Override
    public final boolean isModifiedButNotValidated(String name) {
        return this.isModifiedButNotValidated(this.getAttrIndex(name));
    }

    @Override
    public final ITypedData newWritableCopy() {
        ITypedData writeableCopy = (ITypedData)this.clone();
        writeableCopy.setReadOnly(false);
        return writeableCopy;
    }

    @Override
    public final void copyModifiedValuesFrom(ITypedData source) {
        this.copyValuesFrom(source, null, false, true, false);
    }

    @Override
    public final void copyValuesFrom(ITypedData source) {
        this.copyValuesFrom(source, null);
    }

    @Override
    public final void copyValuesFrom(ITypedData source, Set namesToExclude) {
        this.copyValuesFrom(source, namesToExclude, false, false, false);
    }

    @Override
    public final void copyValuesFrom(ITypedData source, Set namesToExclude, boolean preserveModificationStatus) {
        this.copyValuesFrom(source, namesToExclude, preserveModificationStatus, false, false);
    }

    @Override
    public void copyGlobalValuesFrom(ITypedData source) {
        this.copyValuesFrom(source, null, false, false, true);
    }

    @Override
    public boolean isLocal(int index) {
        return this.getType().getAttr(index).isLocal();
    }

    private void copyValuesFrom(ITypedData source, Set namesToExclude, boolean preserveModificationStatus, boolean excludeUnmodified, boolean excludeLocal) {
        int limit = source.getAttrCount();
        for (int si = 0; si < limit; ++si) {
            int di;
            if (namesToExclude != null && namesToExclude.contains(source.getAttrName(si)) || excludeUnmodified && !source.isModified(si) || excludeLocal && source.isLocal(si) || (di = AbstractTypedData.getMatchingDestinationIndex(source.getType(), this.getType(), si)) < 0) continue;
            if (this.isRepeating(di)) {
                this.removeAll(di);
                int limit1 = source.getValueCount(si);
                for (int valueIndex = 0; valueIndex < limit1; ++valueIndex) {
                    this.setRepeating(di, valueIndex, source.getRepeating(si, valueIndex));
                }
            } else {
                this.set(di, source.get(si));
            }
            if (!preserveModificationStatus || source.isModified(si)) continue;
            this.setModified(di, false);
        }
    }

    private static int getMatchingDestinationIndex(ILiteType sourceType, ILiteType destinationType, int sourceIndex) {
        if (sourceType == destinationType) {
            return sourceIndex;
        }
        Attribute sourceAttribute = sourceType.getAttr(sourceIndex);
        Attribute destinationAttribute = destinationType.getAttrIfPresent(sourceAttribute.getName());
        if (destinationAttribute != null && sourceAttribute.isRepeating() == destinationAttribute.isRepeating()) {
            return destinationAttribute.getIndex();
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AbstractTypedData)) {
            return false;
        }
        AbstractTypedData that = (AbstractTypedData)o;
        if (!((Object)this.m_id).equals(that.getObjectId())) {
            return false;
        }
        if (!this.m_type.equals(that.getType())) {
            return false;
        }
        int limit = this.m_type.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (this.equals(that, this.getAttrName(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(ITypedData that, String attributeName) {
        Attribute thisAttribute = this.getType().getAttrIfPresent(attributeName);
        Attribute thatAttribute = that.getType().getAttrIfPresent(attributeName);
        if (thisAttribute == null || thatAttribute == null) {
            return thisAttribute == null && thatAttribute == null;
        }
        return this.equals(that, thisAttribute.getIndex(), thatAttribute.getIndex());
    }

    protected boolean equals(ITypedData that, int thisIndex, int thatIndex) {
        if (this.isRepeating(thisIndex)) {
            int valueCount = this.getValueCount(thisIndex);
            if (valueCount == that.getValueCount(thatIndex)) {
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    if (this.getRepeating(thisIndex, valueIndex).equals(that.getRepeating(thatIndex, valueIndex))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.get(thisIndex).equals(that.get(thatIndex));
    }

    public int hashCode() {
        int result = 95;
        result = 37 * result + this.m_id.hashCode();
        result = 37 * result + this.m_type.hashCode();
        int limit = this.m_type.getAttrCount();
        for (int i = 0; i < limit; ++i) {
            if (this.isRepeating(i)) {
                int valueCount = this.getValueCount(i);
                for (int j = 0; j < valueCount; ++j) {
                    result = 37 * result + this.getRepeating(i, j).hashCode();
                }
                continue;
            }
            result = 37 * result + this.get(i).hashCode();
        }
        return result;
    }

    public String toString() {
        return this.toTraceString(true);
    }

    @Override
    public String toTraceString(boolean verbose) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getTraceInstanceId());
        String details = this.getTraceStringDetails(verbose);
        if (details.length() > 0) {
            sb.append('[').append(details).append(']');
        }
        return sb.toString();
    }

    public String getTraceInstanceId() {
        StringBuilder sb = new StringBuilder(64);
        String fullName = this.getClass().getName();
        sb.append(fullName.substring(fullName.lastIndexOf(46) + 1));
        sb.append('@');
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        return sb.toString();
    }

    protected String getTraceStringDetails(boolean verbose) {
        String typeName;
        StringBuilder sb = new StringBuilder(128);
        if (!this.getObjectId().isNull()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("id=").append(this.getObjectId());
        }
        if (!StringUtil.isEmptyOrNull(typeName = this.getType().getName())) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("type=").append(typeName);
        }
        if (verbose) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("readOnly=").append(this.isReadOnly());
            sb.append(", autoFill=").append(this.isAutoFill());
            sb.append(", fetchTimestamp=").append(this.getFetchTimestamp());
        }
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_id = new DfId((String)objectInput.readObject());
        this.m_fetchTimestamp = objectInput.readLong();
        this.m_readOnly = objectInput.readBoolean();
        this.m_autoFill = objectInput.readBoolean();
        this.m_type = (ILiteType)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(((Object)this.m_id).toString());
        objectOutput.writeLong(this.m_fetchTimestamp);
        objectOutput.writeBoolean(this.m_readOnly);
        objectOutput.writeBoolean(this.m_autoFill);
        objectOutput.writeObject(this.m_type);
    }
}

