/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.session.tokendiagnostics;

import com.documentum.fc.client.impl.session.tokendiagnostics.CDataParser;
import com.documentum.fc.client.impl.session.tokendiagnostics.DumpLineAccumulator;
import com.documentum.fc.client.impl.session.tokendiagnostics.InvalidCDataException;
import com.documentum.fc.client.impl.session.tokendiagnostics.TokenDumpUtils;
import com.documentum.fc.common.DfException;
import com.documentum.fc.impl.util.DfSimpleEncoderDecoder;
import com.documentum.fc.tracing.impl.aspects.BaseTracingAspect;
import com.documentum.fc.tracing.impl.aspects.TracingAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ApplicationToken {
    private static final String TOKEN_NAME_FOR_EXCEPTIONS = "Application access control token";
    private static final String ENCODED_FORM_PREFIX = "DM_TOKEN=";
    private static final int DM_CRYPTO_DIGEST_DATA_LENGTH_SHA1 = 20;
    private static final int DM_TOKEN_MACHINE_ID_SIZE = 13;
    private final long m_version;
    private final long m_tokenSize;
    private final long m_flags;
    private final long m_sequenceNumber;
    private final long m_createTime;
    private final long m_expireTime;
    private final long m_signatureLength;
    private final String m_docbaseName;
    private final String m_userName;
    private final String m_domainName;
    private final String m_serverName;
    private final String m_hostName;
    private final String m_appData;
    private final String m_machineId;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public static boolean isEncodedForm(String string) {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            String form;
            boolean bl;
            boolean bl2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            boolean bl3 = bl2 = (bl = form.startsWith(ENCODED_FORM_PREFIX));
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                Object object = Conversions.booleanObject((boolean)bl2);
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(object, joinPoint);
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public static ApplicationToken makeFromEncodedForm(String string) throws DfException {
        String string2 = string;
        JoinPoint joinPoint = null;
        try {
            ApplicationToken applicationToken;
            ApplicationToken applicationToken2;
            ApplicationToken applicationToken3;
            String encodedForm;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            try {
                if (!ApplicationToken.isEncodedForm(encodedForm)) {
                    throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, null);
                }
                byte[] data = DfSimpleEncoderDecoder.base64Decode(encodedForm.substring(ENCODED_FORM_PREFIX.length()).toCharArray());
                CDataParser cdp = new CDataParser(data);
                long version = cdp.getUnsigned();
                if (version != 1L) {
                    throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, null);
                }
                long tokenSize = cdp.getUnsigned();
                long flags = cdp.getUnsigned();
                long sequenceNumber = cdp.getUnsigned();
                long createTime = cdp.getUnsigned() * 1000L;
                long expireTime = cdp.getUnsigned() * 1000L;
                long signatureLength = cdp.getUnsigned();
                String docbaseName = cdp.getName();
                String userName = cdp.getName();
                String domainName = cdp.getName();
                String serverName = cdp.getName();
                String hostName = cdp.getName();
                String appData = cdp.getString(20);
                String machineId = cdp.getString(13);
                applicationToken2 = applicationToken3 = new ApplicationToken(version, tokenSize, flags, sequenceNumber, createTime, expireTime, signatureLength, docbaseName, userName, domainName, serverName, hostName, appData, machineId);
            }
            catch (InvalidCDataException icde) {
                throw DfException.newDecodingFailedException(TOKEN_NAME_FOR_EXCEPTIONS, encodedForm, icde);
            }
            ApplicationToken applicationToken4 = applicationToken = applicationToken2;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$9$b2797f1(applicationToken, joinPoint);
            }
            return applicationToken3;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    private ApplicationToken(long version, long tokenSize, long flags, long sequenceNumber, long createTime, long expireTime, long signatureLength, String docbaseName, String userName, String domainName, String serverName, String hostName, String appData, String machineId) {
        long l = version;
        long l2 = tokenSize;
        long l3 = flags;
        long l4 = sequenceNumber;
        long l5 = createTime;
        long l6 = expireTime;
        long l7 = signatureLength;
        String string = docbaseName;
        String string2 = userName;
        String string3 = domainName;
        String string4 = serverName;
        String string5 = hostName;
        String string6 = appData;
        String string7 = machineId;
        JoinPoint joinPoint = null;
        try {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5, string6, string7};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$before$com_documentum_fc_tracing_impl_aspects_TracingAspect$3$cbec3e36(joinPoint);
            }
            this.m_version = version;
            this.m_tokenSize = tokenSize;
            this.m_flags = flags;
            this.m_sequenceNumber = sequenceNumber;
            this.m_createTime = createTime;
            this.m_expireTime = expireTime;
            this.m_signatureLength = signatureLength;
            this.m_docbaseName = docbaseName;
            this.m_userName = userName;
            this.m_domainName = domainName;
            this.m_serverName = serverName;
            this.m_hostName = hostName;
            this.m_appData = appData;
            this.m_machineId = machineId;
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5, string6, string7};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterReturning$com_documentum_fc_tracing_impl_aspects_TracingAspect$6$509ea924(joinPoint);
            }
            return;
        }
        catch (Throwable throwable) {
            if (BaseTracingAspect.ajc$if_0()) {
                TracingAspect tracingAspect = TracingAspect.aspectOf();
                if (joinPoint == null) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), Conversions.longObject((long)l2), Conversions.longObject((long)l3), Conversions.longObject((long)l4), Conversions.longObject((long)l5), Conversions.longObject((long)l6), Conversions.longObject((long)l7), string, string2, string3, string4, string5, string6, string7};
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
                }
                tracingAspect.ajc$afterThrowing$com_documentum_fc_tracing_impl_aspects_TracingAspect$12$cbec3e36(throwable, joinPoint);
            }
            throw throwable;
        }
    }

    public String toString() {
        DumpLineAccumulator dla = new DumpLineAccumulator();
        dla.addLine("APPLICATION ACCESS CONTROL TOKEN DUMP");
        dla.addLine("==========================================");
        dla.addLine("Version         : 5.3");
        dla.addLine("Scope           : ", (this.m_flags & 2L) == 0L ? "global" : "docbase");
        dla.addLine("Machine Only    : ", (this.m_flags & 4L) == 0L ? "No" : "Yes");
        dla.addLine("Create Time     : ", TokenDumpUtils.getTimeString(this.m_createTime));
        dla.addLine("Expiration Time : ", TokenDumpUtils.getTimeString(this.m_expireTime));
        dla.addLine("User            : ", this.m_userName);
        dla.addLine("Domain          : ", this.m_domainName);
        dla.addLine("Server          : ", this.m_serverName);
        dla.addLine("Docbase         : ", this.m_docbaseName);
        dla.addLine("Host            : ", this.m_hostName);
        dla.addLine("Machine ID      : ", this.m_machineId);
        dla.addLine("Application ID  : **********");
        return dla.toString();
    }

    static {
        Factory factory = new Factory("ApplicationToken.java", Class.forName("com.documentum.fc.client.impl.session.tokendiagnostics.ApplicationToken"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isEncodedForm", "com.documentum.fc.client.impl.session.tokendiagnostics.ApplicationToken", "java.lang.String:", "form:", "", "boolean"), 17);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "makeFromEncodedForm", "com.documentum.fc.client.impl.session.tokendiagnostics.ApplicationToken", "java.lang.String:", "encodedForm:", "com.documentum.fc.common.DfException:", "com.documentum.fc.client.impl.session.tokendiagnostics.ApplicationToken"), 23);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "com.documentum.fc.client.impl.session.tokendiagnostics.ApplicationToken", "long:long:long:long:long:long:long:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "version:tokenSize:flags:sequenceNumber:createTime:expireTime:signatureLength:docbaseName:userName:domainName:serverName:hostName:appData:machineId:", ""), 56);
    }
}

