/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.client.impl.connection.LiteTypeManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.objectprotocol.AbstractObjectProtocol;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolException;
import com.documentum.fc.client.impl.objectprotocol.Tokenizer;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.impl.typeddata.LiteType;
import com.documentum.fc.client.impl.typeddata.TypedData;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfId;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.IDfAttr;

public class ObjectProtocolV0
extends AbstractObjectProtocol {
    public ObjectProtocolV0() {
    }

    public ObjectProtocolV0(IDocbaseConnection connection, LiteTypeManager typeManager) {
        this.m_connection = connection;
        this.m_typeManager = typeManager;
    }

    public ITypedData[] deserializeObjects(String serializedObjects, ILiteType type, int count) throws DfException {
        Tokenizer tokenizer = new Tokenizer(serializedObjects);
        ITypedData[] objects = new ITypedData[count];
        for (int i = 0; i < count; ++i) {
            objects[i] = this.deserializeObject(tokenizer, type);
        }
        return objects;
    }

    public ITypedData deserializeObject(String serializedObject, ILiteType type) throws DfException {
        return this.deserializeObject(new Tokenizer(serializedObject), type);
    }

    public ILiteType[] deserializePersistentTypes(String serializedTypes, int count) throws DfException {
        return this.deserializePersistentTypes(new Tokenizer(serializedTypes), count);
    }

    public ILiteType deserializeType(String serializedType) throws DfException {
        return this.deserializeType(new Tokenizer(serializedType));
    }

    protected ITypedData deserializeObject(Tokenizer tokenizer, ILiteType type) throws DfException {
        if (!tokenizer.nextToken().equals("OBJ") && !tokenizer.nextToken().equals("OBJ")) {
            throw ObjectProtocolException.newMissingObjTokenException(tokenizer);
        }
        String typeName = tokenizer.nextToken();
        if (typeName.equals("NULL")) {
            type = new LiteType();
        } else {
            if (type == null) {
                throw ObjectProtocolException.newUnknownTypeException(tokenizer);
            }
            if (!typeName.equals(type.getUnextendedType().getName())) {
                throw ObjectProtocolException.newTypeMismatchException(typeName, type.getUnextendedType().getName());
            }
        }
        TypedData object = new TypedData(type);
        int staticAttributeCount = ObjectProtocolV0.deserializeInteger(tokenizer, "static attribute count");
        for (int i = 0; i < staticAttributeCount; ++i) {
            this.deserializeValue(tokenizer, type.getAttr(i), object);
        }
        int extendedAttributeCount = ObjectProtocolV0.deserializeInteger(tokenizer, "extended attribute count");
        for (int i = 0; i < extendedAttributeCount; ++i) {
            this.deserializeValue(tokenizer, ObjectProtocolV0.resolveAttribute(object, ObjectProtocolV0.deserializeAttribute(tokenizer)), object);
        }
        object.setModified(false);
        return object;
    }

    public ITypedData deserializeObjectWithPreamble(String serializedObject) throws DfException {
        Tokenizer tokenizer = new Tokenizer(serializedObject);
        if (serializedObject.startsWith("TYPE")) {
            ILiteType type = this.deserializeType(tokenizer);
            return this.deserializeObject(tokenizer, type);
        }
        if (!serializedObject.startsWith("OBJ")) {
            String typeName = tokenizer.nextToken();
            DfId id = new DfId(tokenizer.nextToken());
            ILiteType type = this.getLastKnownExtendedType(typeName, null);
            ITypedData object = this.deserializeObjectWithPossiblyExtendedType(tokenizer, type);
            object.setObjectId(id);
            if (object.getType() != type) {
                ILiteType newType = object.getType();
                this.m_typeManager.registerExtendedType(newType.getUnextendedType().getName(), null, newType);
            }
            return object;
        }
        throw new DfCriticalException("An object without preamble was not expected");
    }

    protected ITypedData deserializeObjectWithPossiblyExtendedType(Tokenizer tokenizer, ILiteType type) throws DfException {
        tokenizer.mark();
        try {
            return this.deserializeObject(tokenizer, type);
        }
        catch (AbstractObjectProtocol.AttributeMismatchException e) {
            DfLogger.debug(ObjectProtocolV0.class, "Extended attributes changed for type {0}, attribute {1}", new String[]{type.getUnextendedType().getName(), e.getAttributeName()}, null);
            tokenizer.reset();
            return this.deserializeObject(tokenizer, type.getUnextendedType());
        }
    }

    private static Attribute deserializeAttribute(Tokenizer tokenizer) throws DfException {
        String name = tokenizer.nextToken();
        int dataType = ObjectProtocolV0.deserializeDataType(tokenizer);
        boolean isRepeating = ObjectProtocolV0.deserializeRepeatingIndicator(tokenizer);
        int length = ObjectProtocolV0.deserializeInteger(tokenizer, "attribute length");
        return new Attribute(name, isRepeating, dataType, length);
    }

    protected ILiteType deserializeType(Tokenizer tokenizer, ILiteType superType) throws DfException {
        if (!tokenizer.nextToken().equals("TYPE")) {
            throw ObjectProtocolException.newMissingTypeTokenException(tokenizer);
        }
        String typeName = tokenizer.nextToken(' ');
        tokenizer.nextToken();
        String superTypeName = tokenizer.nextToken();
        ObjectProtocolV0.verifySuperNameMatchesExpectations(superTypeName, superType);
        int attributeCount = ObjectProtocolV0.deserializeInteger(tokenizer, "attribute count");
        LiteType type = new LiteType(typeName, superType);
        for (int i = 0; i < attributeCount; ++i) {
            type.addAttr(ObjectProtocolV0.deserializeAttribute(tokenizer));
        }
        return type;
    }

    private static void serializeAttribute(StringBuilder sb, IDfAttr attribute) {
        sb.append(attribute.getName());
        sb.append(' ');
        sb.append(s_dataTypeNames[attribute.getDataType()]);
        sb.append(' ');
        sb.append(attribute.isRepeating() ? (char)'R' : 'S');
        sb.append(' ');
        sb.append(Integer.toString(attribute.getLength()));
        sb.append('\n');
    }

    public void serializeObject(StringBuilder sb, ITypedData typedData) {
        ILiteType type = typedData.getType();
        ILiteType originalNamedType = null;
        if (type.getUnextendedType().getName().length() > 0) {
            originalNamedType = type.getUnextendedType();
        }
        sb.append("OBJ ");
        sb.append(originalNamedType != null ? originalNamedType.getName() : "NULL");
        sb.append(' ');
        int staticAttributeCount = originalNamedType != null ? originalNamedType.getAttrCount() : 0;
        sb.append(Integer.toString(staticAttributeCount));
        sb.append('\n');
        for (int i = 0; i < staticAttributeCount; ++i) {
            this.serializeValue(sb, type.getAttr(i), typedData);
        }
        int totalAttributeCount = type.getAttrCount();
        sb.append(Integer.toString(totalAttributeCount - staticAttributeCount));
        sb.append('\n');
        for (int i = staticAttributeCount; i < totalAttributeCount; ++i) {
            Attribute attribute = type.getAttr(i);
            ObjectProtocolV0.serializeAttribute(sb, attribute);
            this.serializeValue(sb, attribute, typedData);
        }
    }

    public void receiveOutOfBandData(int outOfBandData) {
    }
}

