/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.objectprotocol;

import com.documentum.fc.client.DfRestrictedAccessException;
import com.documentum.fc.client.impl.connection.LiteTypeManager;
import com.documentum.fc.client.impl.connection.docbase.IDocbaseConnection;
import com.documentum.fc.client.impl.objectprotocol.IObjectProtocol;
import com.documentum.fc.client.impl.objectprotocol.LocalAttributeRegistry;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolException;
import com.documentum.fc.client.impl.objectprotocol.Tokenizer;
import com.documentum.fc.client.impl.typeddata.Attribute;
import com.documentum.fc.client.impl.typeddata.DataConverter;
import com.documentum.fc.client.impl.typeddata.ILiteType;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.impl.util.UTF8Util;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractObjectProtocol
implements IObjectProtocol {
    protected LiteTypeManager m_typeManager = null;
    protected IDocbaseConnection m_connection = null;
    protected static final String[] s_dataTypeNames = new String[]{"BOOL", "INT", "STRING", "ID", "TIME", "DOUBLE", "UNDEFINED"};
    private static final String REPOSITORY_DATE_PATTERN = "MMM dd HH:mm:ss yyyy";
    private static Map<String, Integer> s_dataTypeNameMap;
    protected static final Locale s_englishLocale;
    private static ThreadLocal<SimpleDateFormat> s_dateFormat;

    AbstractObjectProtocol() {
    }

    protected abstract ILiteType deserializeType(Tokenizer var1, ILiteType var2) throws DfException;

    protected ILiteType[] deserializePersistentTypes(Tokenizer tokenizer, int count) throws DfException {
        ILiteType[] types = new ILiteType[count];
        for (int i = 0; i < count; ++i) {
            types[i] = this.deserializeType(tokenizer, i > 0 ? types[i - 1] : null);
            ILiteType ot = types[i].getUnextendedType();
            LocalAttributeRegistry localAttributeRegistry = LocalAttributeRegistry.getInstance(ot);
            for (int ix = ot.getAttrCount() - 1; ix >= 0; --ix) {
                Attribute a = ot.getAttr(ix);
                a.setLocal(localAttributeRegistry.isLocal(a.getName()));
            }
        }
        return types;
    }

    public ILiteType deserializeType(Tokenizer tokenizer) throws DfException {
        return this.deserializeType(tokenizer, null);
    }

    protected static Attribute resolveAttribute(ITypedData object, Attribute attribute) throws DfException {
        Attribute existingAttribute = object.getType().getAttrIfPresent(attribute.getName());
        if (existingAttribute != null) {
            if (existingAttribute.isRepeating() != attribute.isRepeating()) {
                throw new AttributeMismatchException(attribute.getName());
            }
            if (existingAttribute.getDataType() != attribute.getDataType()) {
                throw new AttributeMismatchException(attribute.getName());
            }
            return existingAttribute;
        }
        object.addAttr(attribute);
        return object.getType().getAttr(attribute.getName());
    }

    protected static long deserializeLong(Tokenizer tokenizer, String description) throws DfException {
        try {
            return Long.parseLong(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            throw ObjectProtocolException.newBadNumberFormatException(tokenizer, description);
        }
    }

    protected static int deserializeInteger(Tokenizer tokenizer, String description) throws DfException {
        try {
            return Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            throw ObjectProtocolException.newBadNumberFormatException(tokenizer, description);
        }
    }

    protected String deserializeSingleValue(Tokenizer tokenizer, Attribute attribute) throws DfException {
        switch (attribute.getDataType()) {
            case 2: {
                return AbstractObjectProtocol.deserializeStringValue(tokenizer);
            }
            case 4: {
                return this.deserializeTimeValue(tokenizer);
            }
            case 5: {
                double value = DataConverter.convertToDouble(tokenizer.nextToken());
                return DataConverter.convertToString(value);
            }
        }
        return tokenizer.nextToken();
    }

    protected static String deserializeStringValue(Tokenizer tokenizer) throws DfException {
        char c = tokenizer.nextToken().charAt(0);
        switch (c) {
            case 'A': {
                return AbstractObjectProtocol.deserializeAsciiStringValue(tokenizer);
            }
            case 'H': {
                return AbstractObjectProtocol.deserializeHexStringValue(tokenizer);
            }
        }
        throw ObjectProtocolException.newBadStringFormatException(tokenizer);
    }

    protected static String deserializeAsciiStringValue(Tokenizer tokenizer) throws DfException {
        int length = AbstractObjectProtocol.deserializeInteger(tokenizer, "string length");
        tokenizer.skipChar();
        if (length == 127 && tokenizer.peek() == '\n') {
            return "";
        }
        return new String(tokenizer.nextToken(length));
    }

    protected static String deserializeHexStringValue(Tokenizer tokenizer) throws DfException {
        int length = AbstractObjectProtocol.deserializeInteger(tokenizer, "string length");
        String hexString = tokenizer.nextToken();
        if (hexString.length() != length * 2) {
            throw ObjectProtocolException.newBadStringLengthException(tokenizer);
        }
        try {
            return new String(AbstractObjectProtocol.convertHexStringToBytes(tokenizer, hexString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException("UTF-8 should always be supported", e);
        }
    }

    protected static byte[] convertHexStringToBytes(Tokenizer tokenizer, String hexString) throws DfException {
        byte[] bytes = new byte[hexString.length() / 2];
        int limit = bytes.length;
        for (int i = 0; i < limit; ++i) {
            int offset = i * 2;
            int high = Character.digit(hexString.charAt(offset), 16);
            int low = Character.digit(hexString.charAt(offset + 1), 16);
            if (high < 0 || low < 0) {
                throw ObjectProtocolException.newBadHexStringException(tokenizer, hexString);
            }
            bytes[i] = (byte)((high << 4) + low);
        }
        return bytes;
    }

    protected String deserializeTimeValue(Tokenizer tokenizer) throws DfException {
        String timeString = tokenizer.nextToken('\n');
        if (timeString.equals("nulldate") || timeString.equals("invaliddate")) {
            return timeString;
        }
        if (timeString.startsWith("xxx ")) {
            timeString = timeString.substring(4);
        }
        try {
            Date time = this.getDateFormat().parse(timeString);
            return DataConverter.convertToString(time);
        }
        catch (ParseException e) {
            throw ObjectProtocolException.newBadTimeStringException(tokenizer, timeString);
        }
    }

    protected void deserializeValue(Tokenizer tokenizer, Attribute attribute, ITypedData object) throws DfException {
        if (attribute.isRepeating()) {
            List<String> values = this.deserializeRepeatingValue(tokenizer, attribute);
            for (String value : values) {
                object.append(attribute.getIndex(), value);
            }
        } else {
            object.set(attribute.getIndex(), this.deserializeSingleValue(tokenizer, attribute));
        }
    }

    protected List<String> deserializeRepeatingValue(Tokenizer tokenizer, Attribute attribute) throws DfException {
        ArrayList<String> valueList = new ArrayList<String>();
        int count = AbstractObjectProtocol.deserializeInteger(tokenizer, "value count");
        for (int i = 0; i < count; ++i) {
            valueList.add(this.deserializeSingleValue(tokenizer, attribute));
        }
        return valueList;
    }

    protected static int deserializeDataType(Tokenizer tokenizer) throws DfException {
        Integer entry = s_dataTypeNameMap.get(tokenizer.nextToken());
        if (entry == null) {
            throw ObjectProtocolException.newBadDatatypeException(tokenizer);
        }
        return entry;
    }

    protected static boolean deserializeRepeatingIndicator(Tokenizer tokenizer) throws DfException {
        String token = tokenizer.nextToken();
        if (token.equals("R")) {
            return true;
        }
        if (token.equals("S")) {
            return false;
        }
        throw ObjectProtocolException.newBadSRIndicatorException(tokenizer);
    }

    protected void serializeValue(StringBuilder sb, Attribute attribute, ITypedData typedData) {
        if (attribute.isRepeating()) {
            this.serializeRepeatingValue(sb, attribute, AbstractObjectProtocol.getRepeatingAsList(typedData, attribute.getIndex()));
        } else {
            this.serializeSingleValue(sb, attribute, typedData.get(attribute.getIndex()));
        }
    }

    protected void serializeSingleValue(StringBuilder sb, Attribute attribute, String value) {
        switch (attribute.getDataType()) {
            case 2: {
                AbstractObjectProtocol.serializeStringValue(sb, value);
                break;
            }
            case 4: {
                this.serializeTimeValue(sb, value);
                break;
            }
            default: {
                sb.append(value);
                sb.append('\n');
            }
        }
    }

    protected static void serializeStringValue(StringBuilder sb, String value) {
        sb.append("A ");
        sb.append(UTF8Util.calculateEncodedLength(value));
        sb.append(' ');
        sb.append(value);
        sb.append('\n');
    }

    protected void serializeTimeValue(StringBuilder sb, String value) {
        if (value.length() == 0) {
            sb.append("nulldate");
        } else if (value.equals("nulldate") || value.equals("invaliddate")) {
            sb.append(value);
        } else {
            sb.append("xxx ");
            sb.append(this.getDateFormat().format(DataConverter.convertToDate(value)));
        }
        sb.append('\n');
    }

    protected void serializeRepeatingValue(StringBuilder sb, Attribute attribute, List<String> values) {
        int count = values.size();
        sb.append(Integer.toString(count));
        sb.append('\n');
        for (int i = 0; i < count; ++i) {
            this.serializeSingleValue(sb, attribute, values.get(i));
        }
    }

    protected static List<String> getRepeatingAsList(ITypedData typedData, int attributeIndex) {
        int count = typedData.getValueCount(attributeIndex);
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(typedData.getRepeating(attributeIndex, i));
        }
        return result;
    }

    protected static void verifySuperNameMatchesExpectations(String superName, ILiteType superType) throws DfException {
        if (!(superType != null && superType.getName().equals(superName) || superType == null && (superName.equals("NULL") || superName.length() == 0))) {
            throw ObjectProtocolException.newSupertypeMismatchException(superName, superType != null ? superType.getName() : null);
        }
    }

    protected ILiteType getLastKnownExtendedType(String typeName, List<String> aspectList) throws DfException {
        try {
            ILiteType type = this.m_typeManager.getExtendedType(typeName, aspectList);
            if (type != null) {
                return type;
            }
            return this.m_typeManager.getType(typeName, aspectList, this.m_connection);
        }
        catch (DfRestrictedAccessException e) {
            throw e;
        }
        catch (DfException e) {
            throw ObjectProtocolException.newTypeManagerFailedException(e);
        }
    }

    protected SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = s_dateFormat.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(REPOSITORY_DATE_PATTERN, s_englishLocale);
            s_dateFormat.set(dateFormat);
        }
        return dateFormat;
    }

    @Override
    public ILiteType getType(String typeName) throws DfException {
        return this.m_typeManager.getType(typeName, this.m_connection);
    }

    static {
        s_englishLocale = new Locale("en", "US");
        s_dateFormat = new ThreadLocal();
        s_dataTypeNameMap = new HashMap<String, Integer>();
        int limit = s_dataTypeNames.length;
        for (int i = 0; i < limit; ++i) {
            s_dataTypeNameMap.put(s_dataTypeNames[i], i);
        }
    }

    protected static class AttributeMismatchException
    extends ObjectProtocolException {
        private String m_attributeName;

        public AttributeMismatchException(String attributeName) {
            super("DFC_OBJPROTO_ATTRIBUTE_MISMATCH", null, new Object[]{attributeName});
            this.m_attributeName = attributeName;
        }

        protected void optionallyLogException() {
        }

        public String getAttributeName() {
            return this.m_attributeName;
        }
    }
}

