/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DocbaseDateFormat {
    private static Map<String, DateInfo> m_dateInfoMap = new HashMap<String, DateInfo>();
    private static Map<String, TimeInfo> m_timeInfoMap;
    private String m_pattern;
    private int m_customDateOrder;
    private int m_customScanFields;
    private int m_dateOrder;
    private String m_dateSeparator;
    private boolean m_dayLeadingZero;
    private boolean m_monthLeadingZero;
    private boolean m_fourDigitYear;
    private String m_timeSeparator;
    private boolean m_hours24;
    private boolean m_hourLeadingZero;
    private boolean m_noonIsZero;
    private String[] m_amPmStrings;
    private static final String DEFAULT_DATE_PART = "yyyy/MM/dd";
    private static final String DEFAULT_TIME_PART = "HH:mm:ss";
    private static final char DEFAULT_DATE_SEPARATOR = '/';
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final int DATE_ORDER_MDY = 0;
    private static final int DATE_ORDER_YMD = 1;
    private static final int DATE_ORDER_DMY = 2;
    private static final int DATE_ORDER_YDM = 3;
    private static final int DATE_ORDER_CUSTOM = 4;

    public DocbaseDateFormat(SimpleDateFormat dateFormat, Locale locale) {
        this(dateFormat.toPattern(), locale);
    }

    public DocbaseDateFormat(String pattern, Locale locale) {
        this.m_pattern = pattern;
        this.m_customDateOrder = 0;
        this.m_customScanFields = 0;
        SimpleDateFormat format = new SimpleDateFormat("a", locale);
        this.m_amPmStrings = format.getDateFormatSymbols().getAmPmStrings();
        String[] dateAndTimeParts = this.getDateAndTimeParts(pattern);
        if (dateAndTimeParts[1] == null) {
            this.m_pattern = this.m_pattern + ' ' + DEFAULT_TIME_PART;
            dateAndTimeParts[1] = DEFAULT_TIME_PART;
        }
        this.parseDatePart(dateAndTimeParts[0]);
        this.parseTimePart(dateAndTimeParts[1]);
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public int getCustomDateOrder() {
        return this.m_customDateOrder;
    }

    public int getCustomScanFields() {
        return this.m_customScanFields;
    }

    public int getDateOrder() {
        return this.m_dateOrder;
    }

    public String getDateSeparator() {
        return this.m_dateSeparator;
    }

    public boolean getDayLeadingZero() {
        return this.m_dayLeadingZero;
    }

    public boolean getMonthLeadingZero() {
        return this.m_monthLeadingZero;
    }

    public boolean getFourDigitYear() {
        return this.m_fourDigitYear;
    }

    public String getTimeSeparator() {
        return this.m_timeSeparator;
    }

    public boolean getHours24() {
        return this.m_hours24;
    }

    public boolean getHourLeadingZero() {
        return this.m_hourLeadingZero;
    }

    public boolean getNoonIsZero() {
        return this.m_noonIsZero;
    }

    public String getAm() {
        return this.m_amPmStrings[0];
    }

    public String getPm() {
        return this.m_amPmStrings[1];
    }

    private String getSeparator(String patternPart) {
        int limit = patternPart.length();
        for (int i = 0; i < limit; ++i) {
            char c = patternPart.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) continue;
            return patternPart.substring(i, i + 1);
        }
        return new String(new char[]{':'});
    }

    private String normalizeSeparator(String patternPart, char separator) {
        char[] ca = new char[patternPart.length()];
        patternPart.getChars(0, ca.length, ca, 0);
        for (int i = 0; i < ca.length; ++i) {
            if (Character.isLetterOrDigit(ca[i]) || Character.isSpaceChar(ca[i])) continue;
            ca[i] = separator;
        }
        return new String(ca);
    }

    private String[] getDateAndTimeParts(String pattern) {
        boolean inQuote = false;
        char[] chars = pattern.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'') {
                chars[i] = 32;
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && "GazZ".indexOf(chars[i]) < 0) continue;
            chars[i] = 32;
        }
        String temp = new String(chars);
        String[] pieces = temp.split(" ");
        String[] result = new String[2];
        for (String piece : pieces) {
            if (piece.contains("y") || piece.contains("M") || piece.contains("d")) {
                if (result[0] == null) {
                    result[0] = piece;
                    continue;
                }
                result[0] = result[0] + piece;
                continue;
            }
            if (!piece.contains("h") && !piece.contains("H")) continue;
            result[1] = piece;
        }
        return result;
    }

    private void parseDatePart(String datePart) {
        this.m_dateSeparator = this.getSeparator(datePart);
        DateInfo dateInfo = m_dateInfoMap.get(datePart = this.normalizeSeparator(datePart, '/'));
        if (dateInfo == null) {
            throw new IllegalArgumentException("Unrecognized or unsupported date format - " + datePart);
        }
        this.m_dateOrder = dateInfo.m_dateOrder;
        this.m_dayLeadingZero = dateInfo.m_dayLeadingZero;
        this.m_monthLeadingZero = dateInfo.m_monthLeadingZero;
        this.m_fourDigitYear = dateInfo.m_fourDigitYear;
    }

    private void parseTimePart(String timePart) {
        this.m_timeSeparator = this.getSeparator(timePart);
        TimeInfo timeInfo = m_timeInfoMap.get(timePart = this.normalizeSeparator(timePart, ':'));
        if (timeInfo == null) {
            throw new IllegalArgumentException("Unrecognized or unsupported time format - " + timePart);
        }
        this.m_noonIsZero = false;
        this.m_hours24 = timeInfo.m_hours24;
        this.m_hourLeadingZero = timeInfo.m_hourLeadingZero;
    }

    static {
        m_dateInfoMap.put(DEFAULT_DATE_PART, new DateInfo(1, true, true, true));
        m_dateInfoMap.put("yyyy/MM/d", new DateInfo(1, true, false, true));
        m_dateInfoMap.put("yyyy/M/dd", new DateInfo(1, false, true, true));
        m_dateInfoMap.put("yyyy/M/d", new DateInfo(1, false, false, true));
        m_dateInfoMap.put("yy/MM/dd", new DateInfo(1, true, true, false));
        m_dateInfoMap.put("yy/MM/d", new DateInfo(1, true, false, false));
        m_dateInfoMap.put("yy/M/dd", new DateInfo(1, false, true, false));
        m_dateInfoMap.put("yy/M/d", new DateInfo(1, false, false, false));
        m_dateInfoMap.put("yyyy/dd/MM", new DateInfo(3, true, true, true));
        m_dateInfoMap.put("yyyy/dd/M", new DateInfo(3, false, true, true));
        m_dateInfoMap.put("yyyy/d/MM", new DateInfo(3, true, false, true));
        m_dateInfoMap.put("yyyy/d/M", new DateInfo(3, false, false, true));
        m_dateInfoMap.put("yy/dd/MM", new DateInfo(3, true, true, false));
        m_dateInfoMap.put("yy/dd/M", new DateInfo(3, false, true, false));
        m_dateInfoMap.put("yy/d/MM", new DateInfo(3, true, false, false));
        m_dateInfoMap.put("yy/d/M", new DateInfo(3, false, false, false));
        m_dateInfoMap.put("MM/dd/yyyy", new DateInfo(0, true, true, true));
        m_dateInfoMap.put("MM/d/yyyy", new DateInfo(0, true, false, true));
        m_dateInfoMap.put("M/dd/yyyy", new DateInfo(0, false, true, true));
        m_dateInfoMap.put("M/d/yyyy", new DateInfo(0, false, false, true));
        m_dateInfoMap.put("MM/dd/yy", new DateInfo(0, true, true, false));
        m_dateInfoMap.put("MM/d/yy", new DateInfo(0, true, false, false));
        m_dateInfoMap.put("M/dd/yy", new DateInfo(0, false, true, false));
        m_dateInfoMap.put("M/d/yy", new DateInfo(0, false, false, false));
        m_dateInfoMap.put("dd/MM/yyyy", new DateInfo(2, true, true, true));
        m_dateInfoMap.put("d/MM/yyyy", new DateInfo(2, true, false, true));
        m_dateInfoMap.put("dd/M/yyyy", new DateInfo(2, false, true, true));
        m_dateInfoMap.put("d/M/yyyy", new DateInfo(2, false, false, true));
        m_dateInfoMap.put("dd/MM/yy", new DateInfo(2, true, true, false));
        m_dateInfoMap.put("d/MM/yy", new DateInfo(2, true, false, false));
        m_dateInfoMap.put("dd/M/yy", new DateInfo(2, false, true, false));
        m_dateInfoMap.put("d/M/yy", new DateInfo(2, false, false, false));
        m_timeInfoMap = new HashMap<String, TimeInfo>();
        m_timeInfoMap.put("hh:mm:ss", new TimeInfo(false, true));
        m_timeInfoMap.put("h:mm:ss", new TimeInfo(false, false));
        m_timeInfoMap.put("hh:mm", new TimeInfo(false, true));
        m_timeInfoMap.put("h:mm", new TimeInfo(false, false));
        m_timeInfoMap.put(DEFAULT_TIME_PART, new TimeInfo(true, true));
        m_timeInfoMap.put("H:mm:ss", new TimeInfo(true, false));
        m_timeInfoMap.put("HH:mm", new TimeInfo(true, true));
        m_timeInfoMap.put("H:mm", new TimeInfo(true, false));
    }

    private static class TimeInfo {
        public boolean m_hours24;
        public boolean m_hourLeadingZero;

        public TimeInfo(boolean hours24, boolean hourLeadingZero) {
            this.m_hours24 = hours24;
            this.m_hourLeadingZero = hourLeadingZero;
        }
    }

    private static class DateInfo {
        public int m_dateOrder;
        public boolean m_monthLeadingZero;
        public boolean m_dayLeadingZero;
        public boolean m_fourDigitYear;

        public DateInfo(int dateOrder, boolean monthLeadingZero, boolean dayLeadingZero, boolean century) {
            this.m_dateOrder = dateOrder;
            this.m_monthLeadingZero = monthLeadingZero;
            this.m_dayLeadingZero = dayLeadingZero;
            this.m_fourDigitYear = century;
        }
    }
}

