/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.docbase;

import java.util.HashMap;
import java.util.Map;

public class DocbaseCharSetUtility {
    private static final int CHARSET_UNKNOWN = 0;
    private static final int CHARSET_US_ASCII = 1;
    private static final int CHARSET_ISO_8859_1 = 2;
    private static final int CHARSET_MACINTOSH = 3;
    private static final int CHARSET_Shift_JIS = 4;
    private static final int CHARSET_EUC_JP = 5;
    private static final int CHARSET_UNICODE = 6;
    private static final int CHARSET_ISO_8859_2 = 7;
    private static final int CHARSET_ISO_8859_3 = 8;
    private static final int CHARSET_ISO_8859_4 = 9;
    private static final int CHARSET_ISO_8859_5 = 10;
    private static final int CHARSET_ISO_8859_6 = 11;
    private static final int CHARSET_ISO_8859_7 = 12;
    private static final int CHARSET_ISO_8859_8 = 13;
    private static final int CHARSET_ISO_8859_9 = 14;
    private static final int CHARSET_ISO_8859_10 = 15;
    private static final int CHARSET_UTF_8 = 16;
    private static final int CHARSET_EUC_TW = 17;
    private static final int CHARSET_ISO_8859_15 = 18;
    private static final int CHARSET_MS874 = 19;
    private static final int CHARSET_IBM930 = 20;
    private static final int CHARSET_IBM935 = 21;
    private static final int CHARSET_MS936 = 22;
    private static final int CHARSET_IBM937 = 23;
    private static final int CHARSET_MS949 = 24;
    private static final int CHARSET_MS950 = 25;
    private static final int CHARSET_MS1361 = 26;
    private static final int CHARSET_MS932 = 27;
    private static final int CHARSET_IBM037 = 28;
    private static final int CHARSET_IBM273 = 29;
    private static final int CHARSET_IBM280 = 30;
    private static final int CHARSET_IBM285 = 31;
    private static final int CHARSET_IBM297 = 32;
    private static final int CHARSET_IBM500 = 33;
    private static final int CHARSET_MS1250 = 34;
    private static final int CHARSET_MS1251 = 35;
    private static final int CHARSET_MS1252 = 36;
    private static final int CHARSET_MS1253 = 37;
    private static final int CHARSET_MS1254 = 38;
    private static final int CHARSET_MS1255 = 39;
    private static final int CHARSET_MS1256 = 40;
    private static final int CHARSET_MS1257 = 41;
    private static final int CHARSET_MS1258 = 42;
    private static final int CHARSET_JEF = 43;
    private static final int CHARSET_EuroShift_JIS = 44;
    private static Map<String, Integer> s_charsetIdMap = new HashMap<String, Integer>();
    private static Map<String, String> s_charsetNameMap;

    public static boolean isValidCharSetName(String name) {
        return s_charsetIdMap.containsKey(name);
    }

    public static int getCharSetId(String name) {
        String comparisonName = name.replace("_", "-").toUpperCase();
        Integer mapping = s_charsetIdMap.get(comparisonName);
        if (mapping != null) {
            return mapping;
        }
        return 0;
    }

    public static String getJavaCharSetName(String name) {
        String result = s_charsetNameMap.get(name = name.replace("_", "-").toUpperCase());
        if (result != null) {
            return result;
        }
        return name;
    }

    static {
        s_charsetIdMap.put("EUC-JP", 5);
        s_charsetIdMap.put("EUC-KR", 24);
        s_charsetIdMap.put("EUC-TW", 17);
        s_charsetIdMap.put("EUROSHIFT-JIS", 44);
        s_charsetIdMap.put("IBM037", 28);
        s_charsetIdMap.put("IBM273", 29);
        s_charsetIdMap.put("IBM280", 30);
        s_charsetIdMap.put("IBM285", 31);
        s_charsetIdMap.put("IBM297", 32);
        s_charsetIdMap.put("IBM500", 33);
        s_charsetIdMap.put("IBM930", 20);
        s_charsetIdMap.put("IBM935", 21);
        s_charsetIdMap.put("IBM937", 23);
        s_charsetIdMap.put("ISO-10646-UCS-2", 6);
        s_charsetIdMap.put("ISO-8859-1", 2);
        s_charsetIdMap.put("ISO_8859-2", 7);
        s_charsetIdMap.put("ISO-8859-3", 8);
        s_charsetIdMap.put("ISO-8859-4", 9);
        s_charsetIdMap.put("ISO-8859-5", 10);
        s_charsetIdMap.put("ISO-8859-6", 11);
        s_charsetIdMap.put("ISO-8859-7", 12);
        s_charsetIdMap.put("ISO-8859-8", 13);
        s_charsetIdMap.put("ISO-8859-9", 14);
        s_charsetIdMap.put("ISO-8859-10", 15);
        s_charsetIdMap.put("ISO-8859-15", 18);
        s_charsetIdMap.put("JEF", 43);
        s_charsetIdMap.put("LATIN-1", 2);
        s_charsetIdMap.put("MACINTOSH", 3);
        s_charsetIdMap.put("MS1250", 34);
        s_charsetIdMap.put("MS1251", 35);
        s_charsetIdMap.put("MS1252", 36);
        s_charsetIdMap.put("MS1253", 37);
        s_charsetIdMap.put("MS1254", 38);
        s_charsetIdMap.put("MS1255", 39);
        s_charsetIdMap.put("MS1256", 40);
        s_charsetIdMap.put("MS1257", 41);
        s_charsetIdMap.put("MS1258", 42);
        s_charsetIdMap.put("MS1361", 26);
        s_charsetIdMap.put("MS874", 19);
        s_charsetIdMap.put("MS932", 27);
        s_charsetIdMap.put("MS936", 22);
        s_charsetIdMap.put("MS949", 24);
        s_charsetIdMap.put("MS950", 25);
        s_charsetIdMap.put("SHIFT-JIS", 4);
        s_charsetIdMap.put("US-ASCII", 1);
        s_charsetIdMap.put("UTF-8", 16);
        s_charsetNameMap = new HashMap<String, String>();
        s_charsetNameMap.put("EUC-TW", "x-EUC-TW");
        s_charsetNameMap.put("LATIN-1", "ISO-8859-1");
        s_charsetNameMap.put("MS1250", "windows-1250");
        s_charsetNameMap.put("MS1251", "windows-1251");
        s_charsetNameMap.put("MS1252", "windows-1252");
        s_charsetNameMap.put("MS1253", "windows-1253");
        s_charsetNameMap.put("MS1254", "windows-1254");
        s_charsetNameMap.put("MS1255", "windows-1255");
        s_charsetNameMap.put("MS1256", "windows-1256");
        s_charsetNameMap.put("MS1257", "windows-1257");
        s_charsetNameMap.put("MS1258", "windows-1258");
        s_charsetNameMap.put("MS874", "x-windows-874");
        s_charsetNameMap.put("MS936", "x-mswin-936");
        s_charsetNameMap.put("MS949", "x-windows-949");
        s_charsetNameMap.put("MS950", "x-windows-950");
        s_charsetNameMap.put("SHIFT-JIS", "Shift_JIS");
    }
}

