/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.crypto;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.IDfClient;
import com.documentum.fc.client.IDfSessionManager;
import com.documentum.fc.client.impl.crypto.AEKFile;
import com.documentum.fc.client.impl.session.ISession;
import com.documentum.fc.common.DfCriticalException;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.IDfLoginInfo;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import com.documentum.fc.impl.security.action.GetPropertyAction;
import com.documentum.fc.impl.util.DfSimpleEncoderDecoder;
import com.documentum.fc.impl.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final char[] ENCODED_PASSPHRASE = new char[]{'Z', 'G', '1', 'f', 'd', 'H', 'l', 'w', 'Z', 'T', 'p', 'w', 'N', 'm', 'x', 'v', 'M', '2', 'x', '5', 'M', 'W', '9', 'q', 'N', 'W', '5', 'l', 'J', 'j', 'p', 'k', 'b', 'W', 'l', 'f', 'b', '2', 'J', 'q', 'Z', 'W', 'N', '0', 'X', '3', 'R', '5', 'c', 'G', 'U', 'A'};
    private static final String TRANSFORMATION = "DESede/CBC/PKCS5Padding";
    private static final String KEY_TYPE = "DESede";
    private static final byte[] AEK_IV = new byte[]{23, 125, 101, -74, 112, -7, -30, -18};
    private static final byte[] CRYPTO_IV = new byte[]{118, 16, 91, 96, 27, -16, 84, -58};
    private static final byte[] CRYPTO_SALT = CRYPTO_IV;
    private static final int TRIPLE_DES_KEY_LENGTH = 24;
    private static final int ITERATION_COUNT = 1024;
    private static final String ENCRYPTED_PASSWORD_PREFIX = "DM_ENCR_PASS=";
    private static final String ENCRYPTED_TEXT_PREFIX = "DM_ENCR_TEXT=";
    private static final String PASSWORD_PREFIX = "DM_EP_AEK=";
    private static final String TEXT_PREFIX_AEK = "DM_ET_AEK=";
    private static final String TEXT_PREFIX_PASS = "DM_ET_PASS=";
    private static final String TIME_SUFFIX = "=DM_ENCR_TIME|";
    private static final String CHARSET_NAME = "UTF8";
    private static CryptoUtils s_cryptoUtils;
    private static String s_cryptoRepository;
    private SecretKey m_aek;
    private String m_aekLocation;

    public static synchronized CryptoUtils getInstance() {
        if (s_cryptoUtils == null) {
            s_cryptoUtils = new CryptoUtils();
        }
        return s_cryptoUtils;
    }

    public synchronized void initCrypto(String location) throws DfException {
        this.initCryptoEx(location, null);
    }

    public synchronized void initCryptoEx(String location, String passphrase) throws DfException {
        if (this.m_aek != null) {
            if (location.equalsIgnoreCase(this.m_aekLocation)) {
                throw new DfException("DM_CRYPTO_W_KEYSTORE_ALREADY_INITIALIZED", new Object[]{this.m_aekLocation});
            }
            throw new DfException("DM_CRYPTO_E_KEYSTORE_ALREADY_INITIALIZED_WITH_DIFFERENT_LOCATION", new Object[]{this.m_aekLocation});
        }
        AEKFile aekFile = new AEKFile(location);
        this.m_aekLocation = aekFile.getAEKLocation();
        byte[] data = aekFile.getEncryptedAEK();
        byte[] salt = aekFile.getSalt();
        int iterationCount = aekFile.getIterationCount();
        byte[] passphraseBytes = null;
        passphraseBytes = passphrase != null && passphrase.length() != 0 ? passphrase.getBytes() : this.getDefaultPassphrase();
        byte[] keyBytes = this.passphraseToKey(passphraseBytes, salt, iterationCount, 24);
        SecretKey key = this.createSecretKey(keyBytes);
        byte[] decryptedSaltAndAEK = this.decrypt(data, key, AEK_IV);
        byte[] decryptedSalt = new byte[salt.length];
        System.arraycopy(decryptedSaltAndAEK, 0, decryptedSalt, 0, salt.length);
        if (!Arrays.equals(decryptedSalt, salt)) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{location});
        }
        int aekLength = decryptedSaltAndAEK.length - salt.length;
        byte[] aekBytes = new byte[aekLength];
        System.arraycopy(decryptedSaltAndAEK, salt.length, aekBytes, 0, aekLength);
        this.m_aek = this.createSecretKey(aekBytes);
    }

    public synchronized String encryptPassword(String password) throws DfException {
        byte[] encryptedPassword;
        if (password == null || password.length() == 0) {
            throw new DfException("DM_CRYPTO_E_NULL_PASSWORD");
        }
        if (password.startsWith(ENCRYPTED_PASSWORD_PREFIX)) {
            throw new DfException("DM_CRYPTO_W_DATA_ALREADY_ENCRYPTED");
        }
        if (!StringUtil.isEmptyOrNull(s_cryptoRepository)) {
            return this.encryptPassword(password, s_cryptoRepository);
        }
        if ((password = this.normalizeData(password)).length() == 0) {
            throw new DfException("DM_CRYPTO_E_ENCRYPTPASS_FAILED");
        }
        try {
            this.checkForAEK();
        }
        catch (DfException e) {
            throw new DfException("DM_CRYPTO_E_ENCRYPTPASS_FAILED", (Throwable)e);
        }
        password = this.padData(password, PASSWORD_PREFIX);
        try {
            encryptedPassword = this.encrypt(this.appendNullByte(password.getBytes(CHARSET_NAME)), this.m_aek, CRYPTO_IV);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        char[] buf = DfSimpleEncoderDecoder.base64Encode(encryptedPassword);
        return ENCRYPTED_PASSWORD_PREFIX + new String(buf);
    }

    public synchronized String decryptPassword(String encryptedPassword) throws DfException {
        String decryptedPassword;
        if (encryptedPassword == null) {
            throw new NullPointerException("encryptedPassword");
        }
        if (!encryptedPassword.startsWith(ENCRYPTED_PASSWORD_PREFIX)) {
            return encryptedPassword;
        }
        this.checkAccess();
        encryptedPassword = encryptedPassword.substring(ENCRYPTED_PASSWORD_PREFIX.length());
        this.checkForAEK();
        byte[] data = DfSimpleEncoderDecoder.base64Decode(encryptedPassword.toCharArray());
        byte[] buf = this.stripNullByte(this.decrypt(data, this.m_aek, CRYPTO_IV));
        try {
            decryptedPassword = new String(buf, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        decryptedPassword = this.unpadData(decryptedPassword, PASSWORD_PREFIX);
        return decryptedPassword;
    }

    public synchronized String encryptText(String text, String passphrase) throws DfException {
        byte[] encryptedText;
        byte[] iv;
        SecretKey encryptionKey;
        if (text == null || text.length() == 0) {
            throw new DfException("DM_CRYPTO_E_NULL_TEXT");
        }
        if (text.startsWith(ENCRYPTED_TEXT_PREFIX)) {
            throw new DfException("DM_CRYPTO_W_DATA_ALREADY_ENCRYPTED");
        }
        if (!StringUtil.isEmptyOrNull(s_cryptoRepository)) {
            return this.encryptText(text, passphrase, s_cryptoRepository);
        }
        text = this.normalizeData(text);
        if (passphrase != null && passphrase.length() != 0) {
            byte[] keyBytes;
            try {
                keyBytes = this.passphraseToKey(passphrase.getBytes(CHARSET_NAME), CRYPTO_SALT, 1024, 24);
            }
            catch (UnsupportedEncodingException e) {
                throw new DfCriticalException(e);
            }
            encryptionKey = this.createSecretKey(keyBytes);
            iv = AEK_IV;
            text = this.padData(text, TEXT_PREFIX_PASS);
        } else {
            try {
                this.checkForAEK();
            }
            catch (DfException e) {
                throw new DfException("DM_CRYPTO_E_ENCRYPTTEXT_FAILED", (Throwable)e);
            }
            encryptionKey = this.m_aek;
            iv = CRYPTO_IV;
            text = this.padData(text, TEXT_PREFIX_AEK);
        }
        try {
            encryptedText = this.encrypt(this.appendNullByte(text.getBytes(CHARSET_NAME)), encryptionKey, iv);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        char[] buf = DfSimpleEncoderDecoder.base64Encode(encryptedText);
        return ENCRYPTED_TEXT_PREFIX + new String(buf);
    }

    public synchronized String decryptText(String encryptedText, String passphrase) throws DfException {
        String decryptedText;
        byte[] buf;
        String textPrefix;
        byte[] iv;
        SecretKey decryptionKey;
        if (encryptedText == null || encryptedText.length() == 0) {
            throw new DfException("DM_CRYPTO_E_NULL_TEXT");
        }
        if (!encryptedText.startsWith(ENCRYPTED_TEXT_PREFIX)) {
            return encryptedText;
        }
        if (!StringUtil.isEmptyOrNull(s_cryptoRepository)) {
            return this.decryptText(encryptedText, passphrase, s_cryptoRepository);
        }
        encryptedText = encryptedText.substring(ENCRYPTED_TEXT_PREFIX.length());
        if (passphrase != null && passphrase.length() != 0) {
            byte[] keyBytes;
            try {
                keyBytes = this.passphraseToKey(passphrase.getBytes(CHARSET_NAME), CRYPTO_SALT, 1024, 24);
            }
            catch (UnsupportedEncodingException e) {
                throw new DfCriticalException(e);
            }
            decryptionKey = this.createSecretKey(keyBytes);
            iv = AEK_IV;
            textPrefix = TEXT_PREFIX_PASS;
        } else {
            try {
                this.checkForAEK();
            }
            catch (DfException e) {
                throw new DfException("DM_CRYPTO_E_DECRYPTTEXT_FAILED", (Throwable)e);
            }
            decryptionKey = this.m_aek;
            iv = CRYPTO_IV;
            textPrefix = TEXT_PREFIX_AEK;
        }
        byte[] data = DfSimpleEncoderDecoder.base64Decode(encryptedText.toCharArray());
        try {
            buf = this.stripNullByte(this.decrypt(data, decryptionKey, iv));
        }
        catch (Exception e) {
            throw new DfException("DM_CRYPTO_E_DECRYPTTEXT_FAILED", (Throwable)e);
        }
        try {
            decryptedText = new String(buf, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        decryptedText = this.unpadData(decryptedText, textPrefix);
        return decryptedText;
    }

    private ISession getTrustedSession(String docbaseName) throws DfException {
        DfClientX clientX = new DfClientX();
        IDfClient client = clientX.getLocalClient();
        IDfSessionManager sMgr = client.newSessionManager();
        IDfLoginInfo login = clientX.getLoginInfo();
        login.setUser(AccessController.doPrivileged(new GetPropertyAction("user.name")));
        sMgr.setIdentity(docbaseName, login);
        return (ISession)sMgr.getSession(docbaseName);
    }

    public String encryptPassword(String password, String docbaseName) throws DfException {
        if (StringUtil.isEmptyOrNull(password)) {
            throw new IllegalArgumentException("DFC_INVALID_PASSWORD");
        }
        if (StringUtil.isEmptyOrNull(docbaseName)) {
            throw new IllegalArgumentException("DFC_INVALID_DOCBASE_NAME");
        }
        ISession session = this.getTrustedSession(docbaseName);
        String encryptedPassword = session.getDocbaseApi().encryptPassword(password);
        session.getSessionManager().release(session);
        return encryptedPassword;
    }

    public String encryptText(String text, String passPhrase, String docbaseName) throws DfException {
        if (StringUtil.isEmptyOrNull(text)) {
            throw new IllegalArgumentException("DFC_INVALID_TEXT_TO_ENCRYPT");
        }
        if (StringUtil.isEmptyOrNull(docbaseName)) {
            throw new IllegalArgumentException("DFC_INVALID_DOCBASE_NAME");
        }
        ISession session = this.getTrustedSession(docbaseName);
        String encryptedText = session.getDocbaseApi().encryptText(text);
        session.getSessionManager().release(session);
        return encryptedText;
    }

    public String decryptText(String encryptedText, String passPhrase, String docbaseName) throws DfException {
        if (StringUtil.isEmptyOrNull(encryptedText)) {
            throw new IllegalArgumentException("DFC_INVALID_ENCRYPTED_TEXT");
        }
        if (StringUtil.isEmptyOrNull(docbaseName)) {
            throw new IllegalArgumentException("DFC_INVALID_DOCBASE_NAME");
        }
        ISession session = this.getTrustedSession(docbaseName);
        String decryptedText = session.getDocbaseApi().decryptText(encryptedText);
        session.getSessionManager().release(session);
        return DfUtil.unObfuscate(decryptedText);
    }

    String normalizeData(String data) {
        if ((data = data.replaceFirst("[ ]*", "")).length() == 0 || data.equals("'") || data.equals("''")) {
            data = "";
        } else if (data.startsWith("'")) {
            String tempData = (data = data.substring(1)).replaceFirst("(?<!')'[^'].*$", "");
            if (tempData.equals(data)) {
                tempData = data.replaceFirst("'$", "");
            }
            data = tempData.replaceAll("''", "'");
        } else {
            data = data.trim();
        }
        return data;
    }

    private void checkForAEK() throws DfException {
        if (this.m_aek == null) {
            this.initCrypto(null);
        }
    }

    private String padData(String data, String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(System.currentTimeMillis());
        buf.append(TIME_SUFFIX);
        buf.append(data);
        return buf.toString();
    }

    private String unpadData(String data, String expectedPrefix) throws DfException {
        if (!data.startsWith(expectedPrefix)) {
            throw new DfException("DM_CRYPTO_E_STRING_NOT_ENCRYPTED_USING_THIS_METHOD");
        }
        int timePos = (data = data.substring(expectedPrefix.length())).indexOf(TIME_SUFFIX);
        if (timePos != -1) {
            data = data.substring(timePos + TIME_SUFFIX.length());
        }
        return data;
    }

    private byte[] encrypt(byte[] data, SecretKey key, byte[] iv) {
        byte[] encryptedData;
        try {
            Cipher c = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec p = new IvParameterSpec(iv);
            c.init(1, (Key)key, p);
            encryptedData = c.doFinal(data);
        }
        catch (Exception e) {
            throw new DfCriticalException("Unexpected problem with encryption", e);
        }
        return encryptedData;
    }

    private byte[] decrypt(byte[] data, SecretKey key, byte[] iv) throws DfException {
        byte[] decryptedData;
        try {
            Cipher c = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec p = new IvParameterSpec(iv);
            c.init(2, (Key)key, p);
            decryptedData = c.doFinal(data);
        }
        catch (Exception e) {
            throw new DfException("DM_CRYPTO_F_KEYSTORE_INIT", new Object[]{this.m_aekLocation}, e);
        }
        return decryptedData;
    }

    private byte[] getDefaultPassphrase() {
        byte[] passphraseBytes;
        String tempString;
        byte[] decodedPassphrase = DfSimpleEncoderDecoder.base64Decode(ENCODED_PASSPHRASE);
        try {
            tempString = new String(decodedPassphrase, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        String[] passphraseParts = tempString.split(":");
        if (passphraseParts.length != 3) {
            throw new DfCriticalException("Unexpected problem with crypto initialization");
        }
        String prefix = passphraseParts[0];
        String passphrase = passphraseParts[1];
        String suffix = passphraseParts[2];
        if (!prefix.equals("dm_type") || !suffix.startsWith("dmi_object_type") || passphrase.length() < 1) {
            throw new DfCriticalException("Unexpected problem with crypto initialization");
        }
        try {
            passphraseBytes = passphrase.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new DfCriticalException(e);
        }
        return passphraseBytes;
    }

    private byte[] stripNullByte(byte[] data) {
        if (data == null) {
            throw new DfCriticalException("Unexpected problem with decryption");
        }
        int dataLength = data.length;
        int copyLength = data[dataLength - 1] == 0 ? dataLength - 1 : dataLength;
        byte[] fixedData = new byte[copyLength];
        System.arraycopy(data, 0, fixedData, 0, copyLength);
        return fixedData;
    }

    private byte[] appendNullByte(byte[] data) {
        if (data == null) {
            throw new DfCriticalException("Unexpected problem with encryption");
        }
        byte[] fixedData = new byte[data.length + 1];
        System.arraycopy(data, 0, fixedData, 0, data.length);
        return fixedData;
    }

    private SecretKey createSecretKey(byte[] keyBytes) {
        SecretKey key;
        try {
            DESedeKeySpec spec = new DESedeKeySpec(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_TYPE);
            key = keyFactory.generateSecret(spec);
        }
        catch (Exception e) {
            throw new DfCriticalException("Unexpected problem with key generation");
        }
        return key;
    }

    private byte[] passphraseToKey(byte[] passphrase, byte[] salt, int iterationCount, int keyLength) {
        int hLen = 20;
        int l = (int)Math.ceil((double)keyLength / (double)hLen);
        int r = keyLength - (l - 1) * hLen;
        byte[] derivedKey = new byte[keyLength];
        int copyLength = hLen;
        for (int i = 1; i <= l; ++i) {
            byte[] out = this.xorSum(passphrase, salt, iterationCount, i);
            if (i == l) {
                copyLength = r;
            }
            System.arraycopy(out, 0, derivedKey, (i - 1) * hLen, copyLength);
        }
        return derivedKey;
    }

    private byte[] xorSum(byte[] passphrase, byte[] salt, int iterationCount, int blockIndex) {
        byte[] encodedBlockIndex = new byte[]{0, 0, 0, new Integer(blockIndex).byteValue()};
        byte[] firstPassSalt = new byte[salt.length + encodedBlockIndex.length];
        System.arraycopy(salt, 0, firstPassSalt, 0, salt.length);
        System.arraycopy(encodedBlockIndex, 0, firstPassSalt, salt.length, encodedBlockIndex.length);
        byte[] localSalt = firstPassSalt;
        byte[] xorOut = null;
        for (int i = 0; i < iterationCount; ++i) {
            byte[] out = this.pseudoRandomFunction(passphrase, localSalt);
            xorOut = i == 0 ? out : this.xorByteArray(xorOut, out);
            localSalt = out;
        }
        return xorOut;
    }

    private byte[] pseudoRandomFunction(byte[] passphrase, byte[] salt) {
        byte[] bytes;
        String alg = "HmacSHA1";
        try {
            Mac m = Mac.getInstance(alg);
            SecretKeySpec ks = new SecretKeySpec(passphrase, alg);
            m.init(ks);
            bytes = m.doFinal(salt);
        }
        catch (Exception e) {
            throw new DfCriticalException("Unexpected problem with key generation");
        }
        return bytes;
    }

    private byte[] xorByteArray(byte[] arr1, byte[] arr2) {
        byte[] xorArr = new byte[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            xorArr[i] = (byte)(arr1[i] ^ arr2[i]);
        }
        return xorArr;
    }

    private void checkAccess() throws SecurityException {
        StackTraceElement[] ste = new Exception().getStackTrace();
        int outerMethodIndex = 2;
        String packagePrefix = "com.documentum.fc.client.";
        if (!ste[outerMethodIndex].getClassName().startsWith(packagePrefix)) {
            throw new SecurityException();
        }
    }

    static {
        new CryptoDocbaseObserver();
    }

    private static final class CryptoDocbaseObserver
    implements IPreferencesObserver {
        CryptoDocbaseObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            s_cryptoRepository = ((DfPreferences)preferences).getCryptoRepository();
        }
    }
}

