/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.netwise;

import com.documentum.fc.client.DfIOException;
import com.documentum.fc.common.DfException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class StringBuilderSerializer {
    private CharBuffer m_charBuffer;
    private boolean m_isInUse;
    private boolean m_isInitial;
    private static final Charset s_charset = Charset.forName("UTF-8");

    public void initialize(StringBuilder stringBuilder) {
        int inputLength = stringBuilder.length();
        if (this.m_charBuffer == null || this.m_charBuffer.capacity() < inputLength) {
            this.m_charBuffer = CharBuffer.wrap(new char[inputLength], 0, inputLength);
        }
        char[] ca = this.m_charBuffer.array();
        stringBuilder.getChars(0, inputLength, ca, 0);
        this.m_charBuffer.position(0);
        this.m_charBuffer.limit(inputLength);
        this.m_isInUse = true;
        this.m_isInitial = true;
    }

    public void release() {
        this.m_isInUse = false;
    }

    public boolean serialize(ByteBuffer buffer) throws DfException {
        try {
            this.m_isInitial = false;
            CharBuffer cb = this.getCharBuffer();
            int inputLength = cb.remaining();
            boolean bufferOverlow = false;
            if (buffer.remaining() < 10) {
                throw new IllegalArgumentException("Buffer contains insufficient space to searialize a StringBuilder");
            }
            if (inputLength == 0) {
                buffer.put((byte)5);
                buffer.put((byte)0);
            } else {
                CoderResult r2;
                buffer.put((byte)22);
                buffer.put((byte)-125);
                buffer.put((byte)0);
                buffer.put((byte)0);
                buffer.put((byte)0);
                int beginPosition = buffer.position();
                CharsetEncoder encoder = s_charset.newEncoder();
                ByteBuffer slice = buffer.slice();
                slice.limit(slice.limit() - 1);
                CoderResult r1 = encoder.encode(cb, slice, true);
                if (r1.isOverflow()) {
                    bufferOverlow = true;
                }
                if (r1.isError()) {
                    r1.throwException();
                }
                if ((r2 = encoder.flush(slice)).isOverflow()) {
                    bufferOverlow = true;
                }
                if (r2.isError()) {
                    r2.throwException();
                }
                buffer.position(buffer.position() + slice.position());
                buffer.put((byte)0);
                int endPosition = buffer.position();
                int length = endPosition - beginPosition;
                buffer.put(beginPosition - 3, (byte)(length >> 16));
                buffer.put(beginPosition - 2, (byte)(length >> 8));
                buffer.put(beginPosition - 1, (byte)length);
            }
            return bufferOverlow;
        }
        catch (CharacterCodingException e) {
            throw DfIOException.newCommunicationFailureException(e);
        }
    }

    public boolean isMore() {
        CharBuffer cb = this.getCharBuffer();
        return this.m_isInitial || cb.remaining() > 0;
    }

    private CharBuffer getCharBuffer() {
        if (this.m_charBuffer == null || !this.m_isInUse) {
            throw new IllegalStateException("m_charBuffer has not been initialized");
        }
        return this.m_charBuffer;
    }
}

