/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbroker.netwise;

import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.impl.connection.docbase.netwise.IBMX509TrustManager;
import com.documentum.fc.client.impl.connection.docbroker.IDocbrokerRpcClient;
import com.documentum.fc.client.impl.connection.docbroker.IDocbrokerRpcClientFactory;
import com.documentum.fc.client.impl.connection.docbroker.netwise.NetwiseDocbrokerRpcClient;
import com.documentum.fc.client.impl.docbroker.DocbrokerMap;
import com.documentum.fc.client.impl.docbroker.DocbrokerMapHelper;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfLogger;
import com.documentum.fc.common.DfPreferences;
import com.documentum.fc.common.DfUtil;
import com.documentum.fc.common.impl.preferences.IPreferencesObserver;
import com.documentum.fc.common.impl.preferences.TypedPreferences;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class NetwiseDocbrokerRpcClientFactory
implements IDocbrokerRpcClientFactory {
    private static String[] s_cipherSuitesToEnable = null;
    private static TrustManager[] s_trustManager = null;
    private final Object m_syncObject = new Object();
    private static Map<DocBrokerIdentity, Integer> s_docbrokerFailureCount = new HashMap<DocBrokerIdentity, Integer>();
    private static int s_docbrokerExcludeFailureThreshold;
    private static long s_retryTimer;
    private static final int s_failedConnectionResponseTimeThreshold = 10;

    public IDocbrokerRpcClient newDocbrokerRpcClient(DocbrokerMap docbrokerMap, int index) throws DfException {
        try {
            return new NetwiseDocbrokerRpcClient(this.openSocket(docbrokerMap, index));
        }
        catch (IOException e) {
            throw DfIOException.newCommunicationFailureException(e);
        }
    }

    public IDocbrokerRpcClient newDocbrokerRpcClient(String host, int port, int timeoutSecs) throws DfException {
        DocbrokerMap tempMap = DocbrokerMapHelper.createDocbrokerMap();
        DocbrokerMapHelper.addDocbrokerEntry(tempMap, host, port, null, timeoutSecs);
        return this.newDocbrokerRpcClient(tempMap, 0);
    }

    private Socket openSocket(DocbrokerMap docbrokerMap, int index) throws IOException {
        String host = docbrokerMap.getHostName(index);
        int port = docbrokerMap.getPortNumber(index);
        int timeoutSecs = docbrokerMap.getTimeOut(index);
        Socket socket = null;
        int connectMode = docbrokerMap.getSecureConnectMode(index);
        boolean isSecure = true;
        try {
            switch (connectMode) {
                case 2: {
                    socket = this.connect(host, port, !isSecure, timeoutSecs);
                    break;
                }
                case 3: {
                    socket = this.connect(host, port, isSecure, timeoutSecs);
                    break;
                }
                case 0: {
                    socket = this.connect(host, port, isSecure, timeoutSecs);
                    docbrokerMap.setSecureConnectMode(index, 3);
                    break;
                }
                case 1: {
                    isSecure = false;
                    socket = this.connect(host, port, isSecure, timeoutSecs);
                    docbrokerMap.setSecureConnectMode(index, 2);
                }
            }
        }
        catch (IOException e) {
            if (connectMode == 2 || connectMode == 3) {
                throw e;
            }
            socket = this.connect(host, port, !isSecure, timeoutSecs);
            if (isSecure) {
                docbrokerMap.setSecureConnectMode(index, 2);
            }
            docbrokerMap.setSecureConnectMode(index, 3);
        }
        return socket;
    }

    private Socket connect(String host, int port, boolean secure, int timeoutSecs) throws IOException {
        int connectPort = secure ? port + 1 : port;
        ResolvedIPAddress resolvedIPAddress = this.resolveHostNameCorrectly(host);
        DocBrokerIdentity docBrokerIdentity = new DocBrokerIdentity(resolvedIPAddress.getPrimary(), connectPort, secure);
        if (this.isBlackListed(docBrokerIdentity)) {
            throw new IOException("DFC_DOCBROKER_EXCLUDED");
        }
        try {
            return NetwiseDocbrokerRpcClientFactory.openSocket(docBrokerIdentity, timeoutSecs);
        }
        catch (IOException ioEx) {
            this.updateDocBrokerExcludedList(docBrokerIdentity, ioEx);
            if (resolvedIPAddress.getSecondary() != null && !resolvedIPAddress.getPrimary().equals(resolvedIPAddress.getSecondary())) {
                try {
                    docBrokerIdentity = new DocBrokerIdentity(resolvedIPAddress.getSecondary(), connectPort, secure);
                    if (this.isBlackListed(docBrokerIdentity)) {
                        throw new IOException("DFC_DOCBROKER_EXCLUDED");
                    }
                    return NetwiseDocbrokerRpcClientFactory.openSocket(docBrokerIdentity, timeoutSecs);
                }
                catch (IOException ex) {
                    this.updateDocBrokerExcludedList(docBrokerIdentity, ex);
                    throw ex;
                }
            }
            throw ioEx;
        }
    }

    private static Socket openSocket(final DocBrokerIdentity docBrokerIdentity, final int timeoutSecs) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Socket run() throws Exception {
                    final Socket m_newSocket = docBrokerIdentity.getSecure() ? NetwiseDocbrokerRpcClientFactory.openSSLSocket() : NetwiseDocbrokerRpcClientFactory.openNormalSocket();
                    Timer timer = new Timer();
                    try {
                        if (timeoutSecs > 0) {
                            final Thread socketThread = Thread.currentThread();
                            timer.schedule(new TimerTask(){

                                public void run() {
                                    if (!m_newSocket.isConnected()) {
                                        socketThread.interrupt();
                                        try {
                                            m_newSocket.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }, timeoutSecs * 1000);
                        }
                        m_newSocket.connect(new InetSocketAddress(docBrokerIdentity.getHost(), docBrokerIdentity.getPort()));
                    }
                    finally {
                        timer.cancel();
                        Thread.interrupted();
                    }
                    return m_newSocket;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static Socket openNormalSocket() throws IOException {
        return SocketFactory.getDefault().createSocket();
    }

    private static Socket openSSLSocket() throws Exception {
        SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM")) {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, NetwiseDocbrokerRpcClientFactory.getTrustManager(), null);
            socket = (SSLSocket)ctx.getSocketFactory().createSocket();
        }
        socket.setEnabledCipherSuites(NetwiseDocbrokerRpcClientFactory.getCipherSuitesToEnable());
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedIPAddress resolveHostNameCorrectly(String host) throws IOException {
        if (!this.isHostName(host)) {
            InetAddress addressToUse = InetAddress.getByName(host);
            return new ResolvedIPAddress(addressToUse, addressToUse);
        }
        try {
            InetAddress v4Address = null;
            InetAddress v6Address = null;
            IPV6AddressType lastIPV6AddressType = null;
            InetAddress[] addrs = InetAddress.getAllByName(host);
            Object object = this.m_syncObject;
            synchronized (object) {
                for (InetAddress addr : addrs) {
                    if (addr instanceof Inet6Address && DfUtil.canUseIPV6()) {
                        DfLogger.debug((Object)this, "IPV6 Address is: " + addr.getHostAddress(), null, null);
                        IPV6AddressType addressType = this.getIPV6AddressType((Inet6Address)addr);
                        if (lastIPV6AddressType == null && addressType != IPV6AddressType.DONT_USE) {
                            v6Address = addr;
                            lastIPV6AddressType = addressType;
                            continue;
                        }
                        switch (addressType) {
                            case LINK_LOCAL: {
                                if (lastIPV6AddressType.ordinal() >= IPV6AddressType.LINK_LOCAL.ordinal()) break;
                                lastIPV6AddressType = IPV6AddressType.LINK_LOCAL;
                                v6Address = addr;
                                break;
                            }
                            case SITE_LOCAL: {
                                if (lastIPV6AddressType.ordinal() >= IPV6AddressType.SITE_LOCAL.ordinal()) break;
                                lastIPV6AddressType = IPV6AddressType.SITE_LOCAL;
                                v6Address = addr;
                                break;
                            }
                            case GLOBAL: {
                                if (lastIPV6AddressType.ordinal() >= IPV6AddressType.GLOBAL.ordinal()) break;
                                lastIPV6AddressType = IPV6AddressType.GLOBAL;
                                v6Address = addr;
                            }
                        }
                        continue;
                    }
                    if (!(addr instanceof Inet4Address)) continue;
                    if (v4Address == null) {
                        v4Address = addr;
                    }
                    DfLogger.debug((Object)this, "IPV4 Address is: " + addr.getHostAddress(), null, null);
                }
                return new ResolvedIPAddress(v6Address, v4Address);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private IPV6AddressType getIPV6AddressType(Inet6Address ipv6addr) {
        if (ipv6addr.isSiteLocalAddress()) {
            return IPV6AddressType.SITE_LOCAL;
        }
        if (ipv6addr.isLinkLocalAddress()) {
            return IPV6AddressType.LINK_LOCAL;
        }
        if (this.isUnicastGlobal(ipv6addr)) {
            return IPV6AddressType.GLOBAL;
        }
        return IPV6AddressType.DONT_USE;
    }

    private boolean isHostName(String host) {
        boolean isHost = false;
        if (host.contains(":")) {
            return isHost;
        }
        String[] hostComponents = host.split("[\\p{Punct}.]");
        try {
            for (String component : hostComponents) {
                int ipPart = Integer.parseInt(component);
                if (ipPart <= 255 && ipPart >= 1) continue;
                isHost = true;
                break;
            }
        }
        catch (NumberFormatException numEx) {
            isHost = true;
        }
        return isHost;
    }

    private boolean isUnicastGlobal(Inet6Address ipv6Addr) {
        return (ipv6Addr.getHostAddress().charAt(0) & 2) == 2;
    }

    private static synchronized TrustManager[] getTrustManager() throws Exception {
        if (s_trustManager == null) {
            s_trustManager = new TrustManager[]{new IBMX509TrustManager()};
        }
        return s_trustManager;
    }

    private static synchronized String[] getCipherSuitesToEnable() {
        if (s_cipherSuitesToEnable == null) {
            SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            ArrayList<String> cipherSuites = new ArrayList<String>(Arrays.asList(socketFactory.getDefaultCipherSuites()));
            cipherSuites.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
            s_cipherSuitesToEnable = cipherSuites.toArray(new String[0]);
        }
        return s_cipherSuitesToEnable;
    }

    private synchronized void updateDocBrokerExcludedList(DocBrokerIdentity docBrokerIdentity, Exception e) {
        DfLogger.debug((Object)this, "Docbroker request failed at " + docBrokerIdentity.getHost() + ":" + docBrokerIdentity.getPort() + " due to Exception " + e.getMessage(), null, (Throwable)e);
        Integer count = s_docbrokerFailureCount.get(docBrokerIdentity);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        s_docbrokerFailureCount.put(docBrokerIdentity, count);
        if (s_docbrokerFailureCount.get(docBrokerIdentity) >= s_docbrokerExcludeFailureThreshold) {
            DfLogger.warn((Object)this, "DFC_DOCBROKER_EXCLUDED", new Object[]{docBrokerIdentity.getHost(), docBrokerIdentity.getPort(), s_docbrokerExcludeFailureThreshold, e.getMessage()}, (Throwable)e);
        }
    }

    private static synchronized void removeDocBrokerFromExcludedList(DocBrokerIdentity docBrokerIdentity) {
        s_docbrokerFailureCount.remove(docBrokerIdentity);
        DfLogger.info(NetwiseDocbrokerRpcClientFactory.class, "DFC_DOCBROKER_EXCLUDE_RESET", new Object[]{docBrokerIdentity.getHost(), docBrokerIdentity.getPort()}, null);
    }

    private synchronized boolean isBlackListed(DocBrokerIdentity docBrokerIdentity) {
        Integer count = s_docbrokerFailureCount.get(docBrokerIdentity);
        return count != null && count >= s_docbrokerExcludeFailureThreshold;
    }

    static {
        s_retryTimer = 120000L;
        new PreferencesObserver();
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)new DocBrokerResetThread(), 1L, s_retryTimer);
    }

    private static class DocBrokerResetThread
    extends TimerTask {
        private DocBrokerResetThread() {
        }

        public void run() {
            try {
                if (!s_docbrokerFailureCount.isEmpty()) {
                    ArrayList currentIdentities = new ArrayList(s_docbrokerFailureCount.keySet());
                    for (DocBrokerIdentity docBrokerIdentity : currentIdentities) {
                        if ((Integer)s_docbrokerFailureCount.get(docBrokerIdentity) < s_docbrokerExcludeFailureThreshold) continue;
                        DfLogger.debug((Object)this, "Trying to recconnect to excluded docbroker at " + docBrokerIdentity.getHost() + " and port " + docBrokerIdentity.getPort(), null, null);
                        try {
                            Socket socket = NetwiseDocbrokerRpcClientFactory.openSocket(docBrokerIdentity, 10);
                            if (socket == null) continue;
                            NetwiseDocbrokerRpcClientFactory.removeDocBrokerFromExcludedList(docBrokerIdentity);
                            socket.close();
                        }
                        catch (Exception io) {
                            DfLogger.debug((Object)this, "Excluded docbroker still unreachable at host " + docBrokerIdentity.getHost() + " and port " + docBrokerIdentity.getPort() + " with Exception " + io.getMessage(), null, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                DfLogger.warn((Object)this, "Error occured while resetting the docbroker excluded list", null, (Throwable)e);
            }
        }
    }

    private static class DocBrokerIdentity {
        private final InetAddress host;
        private final int port;
        private final boolean secure;

        public DocBrokerIdentity(InetAddress host, int port, boolean secure) {
            this.host = host;
            this.port = port;
            this.secure = secure;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocBrokerIdentity that = (DocBrokerIdentity)o;
            if (this.port != that.port) {
                return false;
            }
            if (this.secure != that.secure) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            result = 31 * result + (this.secure ? 1 : 0);
            return result;
        }

        public InetAddress getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean getSecure() {
            return this.secure;
        }
    }

    private static class ResolvedIPAddress {
        private final InetAddress primary;
        private final InetAddress secondary;

        ResolvedIPAddress(InetAddress v6Address, InetAddress v4Address) {
            this.primary = v6Address == null ? v4Address : v6Address;
            this.secondary = v4Address;
        }

        InetAddress getPrimary() {
            return this.primary;
        }

        InetAddress getSecondary() {
            return this.secondary;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IPV6AddressType {
        DONT_USE,
        LINK_LOCAL,
        SITE_LOCAL,
        GLOBAL;

    }

    private static final class PreferencesObserver
    implements IPreferencesObserver {
        PreferencesObserver() {
            DfPreferences.getInstance().addObserver(this);
            this.update(DfPreferences.getInstance(), null);
        }

        public void update(TypedPreferences preferences, String preferenceName) {
            DfPreferences p = DfPreferences.getInstance();
            s_docbrokerExcludeFailureThreshold = p.getDocBrokerExcludeFailureThreshold();
        }
    }
}

