/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbroker.netwise;

import com.documentum.fc.client.impl.connection.docbroker.IDocbrokerRpcClient;
import com.documentum.fc.client.impl.connection.netwise.AbstractNetwiseRpcClient;
import com.documentum.fc.client.impl.connection.netwise.ConnectionBufferOverflowException;
import com.documentum.fc.client.impl.connection.netwise.NetwiseProtocol;
import com.documentum.fc.client.impl.connection.netwise.StringBuilderManager;
import com.documentum.fc.client.impl.connection.netwise.StringBuilderSerializer;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.common.DfException;
import java.net.Socket;
import java.nio.ByteBuffer;

public class NetwiseDocbrokerRpcClient
extends AbstractNetwiseRpcClient
implements IDocbrokerRpcClient {
    private static final int NETWISE_VERSION = 1;
    private static final int NETWISE_RELEASE = 0;
    private static final int NETWISE_INUMBER = 1094;
    private static int RPC_REQUEST_OBJECT = 1;

    NetwiseDocbrokerRpcClient(Socket socket) {
        super(socket);
    }

    public synchronized void quiesce() {
        super.quiesce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ITypedData requestObject(ITypedData arguments) throws DfException {
        ByteBuffer buffer = this.getByteBuffer();
        int sequenceNumber = this.getNextSequenceNumber();
        NetwiseDocbrokerRpcClient.serializeRequestHeader(buffer, sequenceNumber, RPC_REQUEST_OBJECT);
        StringBuilder stringBuilder = StringBuilderManager.getInstance().getStringBuilder();
        try {
            this.serializeObjectToStringBuilder(stringBuilder, arguments);
            StringBuilderSerializer stringBuilderSerializer = this.getStringBuilderSerializer();
            try {
                stringBuilderSerializer.initialize(stringBuilder);
                stringBuilderSerializer.serialize(buffer);
                if (stringBuilderSerializer.isMore()) {
                    throw ConnectionBufferOverflowException.newConnectionBufferOverflowException();
                }
            }
            finally {
                stringBuilderSerializer.release();
            }
        }
        finally {
            StringBuilderManager.getInstance().releaseStringBuilder(stringBuilder);
        }
        this.sendMessage(buffer);
        this.receiveMessage(buffer);
        NetwiseDocbrokerRpcClient.validateResponseHeader(buffer, sequenceNumber);
        String result = NetwiseProtocol.deserializeString(buffer);
        this.releaseByteBuffer(buffer);
        return this.getObjectProtocol().deserializeObject(result, null);
    }

    private static void serializeRequestHeader(ByteBuffer buffer, int sequenceNumber, int rpcId) {
        NetwiseProtocol.serializeRequestHeader(buffer, sequenceNumber, rpcId, 1, 0, 1094);
    }
}

