/*
 * Decompiled with CFR 0.152.
 */
package com.documentum.fc.client.impl.connection.docbroker;

import com.documentum.fc.client.DfDocbrokerException;
import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.impl.connection.docbroker.IDocbrokerRpcClient;
import com.documentum.fc.client.impl.connection.docbroker.IDocbrokerRpcClientFactory;
import com.documentum.fc.client.impl.docbroker.DocbrokerMap;
import com.documentum.fc.client.impl.objectprotocol.ObjectProtocolV0;
import com.documentum.fc.client.impl.typeddata.ITypedData;
import com.documentum.fc.client.internal.connection.docbroker.IDocbrokerConnection;
import com.documentum.fc.common.DfException;

final class DocbrokerConnection
implements IDocbrokerConnection {
    private IDocbrokerRpcClient m_rpcClient;

    DocbrokerConnection(IDocbrokerRpcClientFactory rpcClientFactory, DocbrokerMap docbrokerMap, int index) throws DfException {
        try {
            this.m_rpcClient = rpcClientFactory.newDocbrokerRpcClient(docbrokerMap, index);
            this.m_rpcClient.setObjectProtocol(new ObjectProtocolV0());
        }
        catch (DfIOException e) {
            throw DfDocbrokerException.newRequestFailedException(docbrokerMap.getHostName(index), docbrokerMap.getPortNumber(index), e);
        }
    }

    DocbrokerConnection(IDocbrokerRpcClientFactory rpcClientFactory, String hostAddress, int port, int timeout) throws DfException {
        try {
            this.m_rpcClient = rpcClientFactory.newDocbrokerRpcClient(hostAddress, port, timeout);
            this.m_rpcClient.setObjectProtocol(new ObjectProtocolV0());
        }
        catch (DfIOException e) {
            throw DfDocbrokerException.newRequestFailedException(hostAddress, port, e);
        }
    }

    public void close() {
        this.m_rpcClient.close();
    }

    public void quiesce() {
        this.m_rpcClient.quiesce();
    }

    public int getNumberOfSends() {
        return this.m_rpcClient.getNumberOfSends();
    }

    public int getNumberOfBytesSent() {
        return this.m_rpcClient.getNumberOfBytesSent();
    }

    public int getNumberOfReceives() {
        return this.m_rpcClient.getNumberOfReceives();
    }

    public int getNumberOfBytesReceived() {
        return this.m_rpcClient.getNumberOfBytesReceived();
    }

    public ITypedData requestObject(ITypedData arguments) throws DfException {
        return this.m_rpcClient.requestObject(arguments);
    }
}

